export default class Device {
    private device;
    private _definition;
    get endpoints(): ZHEndpoint[];
    get zhDevice(): ZHDevice;
    get ieeeAddr(): string;
    get ID(): string;
    get settings(): DeviceSettings;
    get name(): string;
    get lastSeen(): number;
    get modelID(): string;
    get softwareBuildID(): string;
    get dateCode(): string;
    get interviewCompleted(): boolean;
    get networkAddress(): number;
    get manufacturerName(): string;
    get interviewing(): boolean;
    get type(): 'Coordinator' | 'Router' | 'EndDevice' | 'Unknown' | 'GreenPower';
    get powerSource(): string;
    get definition(): Definition | undefined;
    constructor(device: ZHDevice);
    ping(disableRecovery: boolean): Promise<void>;
    removeFromNetwork(): Promise<void>;
    endpoint(key?: string): ZHEndpoint;
    isXiaomiDevice(): boolean;
    isRouter(): boolean;
    lqi(): Promise<LQI>;
    routingTable(): Promise<RoutingTable>;
}
//# sourceMappingURL=device.d.ts.map