"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateIfChanged = exports.writeIfChanged = exports.readIfExists = exports.read = void 0;
const js_yaml_1 = __importDefault(require("js-yaml"));
const fs_1 = __importDefault(require("fs"));
const es6_1 = __importDefault(require("fast-deep-equal/es6"));
function read(file) {
    try {
        /* eslint-disable-line */ // @ts-ignore
        return js_yaml_1.default.load(fs_1.default.readFileSync(file, 'utf8'));
    }
    catch (error) {
        if (error.name === 'YAMLException') {
            error.file = file;
        }
        throw error;
    }
}
exports.read = read;
function readIfExists(file, default_) {
    return fs_1.default.existsSync(file) ? read(file) : default_;
}
exports.readIfExists = readIfExists;
function writeIfChanged(file, content) {
    const before = readIfExists(file);
    if (!(0, es6_1.default)(before, content)) {
        fs_1.default.writeFileSync(file, js_yaml_1.default.dump(content));
    }
}
exports.writeIfChanged = writeIfChanged;
function updateIfChanged(file, key, value) {
    const content = read(file);
    if (content[key] !== value) {
        content[key] = value;
        writeIfChanged(file, content);
    }
}
exports.updateIfChanged = updateIfChanged;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoieWFtbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi91dGlsL3lhbWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsc0RBQTJCO0FBQzNCLDRDQUFvQjtBQUNwQiw4REFBeUM7QUFFekMsU0FBZ0IsSUFBSSxDQUFDLElBQVk7SUFDN0IsSUFBSTtRQUNBLHlCQUF5QixDQUFDLGFBQWE7UUFDdkMsT0FBTyxpQkFBSSxDQUFDLElBQUksQ0FBQyxZQUFFLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDO0tBQ25EO0lBQUMsT0FBTyxLQUFLLEVBQUU7UUFDWixJQUFJLEtBQUssQ0FBQyxJQUFJLEtBQUssZUFBZSxFQUFFO1lBQ2hDLEtBQUssQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1NBQ3JCO1FBRUQsTUFBTSxLQUFLLENBQUM7S0FDZjtBQUNMLENBQUM7QUFYRCxvQkFXQztBQUVELFNBQWdCLFlBQVksQ0FBQyxJQUFZLEVBQUUsUUFBbUI7SUFDMUQsT0FBTyxZQUFFLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQztBQUN2RCxDQUFDO0FBRkQsb0NBRUM7QUFFRCxTQUFnQixjQUFjLENBQUMsSUFBWSxFQUFFLE9BQWlCO0lBQzFELE1BQU0sTUFBTSxHQUFHLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNsQyxJQUFJLENBQUMsSUFBQSxhQUFNLEVBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxFQUFFO1FBQzFCLFlBQUUsQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLGlCQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7S0FDOUM7QUFDTCxDQUFDO0FBTEQsd0NBS0M7QUFFRCxTQUFnQixlQUFlLENBQUMsSUFBWSxFQUFFLEdBQVcsRUFBRSxLQUFlO0lBQ3RFLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMzQixJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxLQUFLLEVBQUU7UUFDeEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLEtBQUssQ0FBQztRQUNyQixjQUFjLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQ2pDO0FBQ0wsQ0FBQztBQU5ELDBDQU1DIn0=