"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ExtensionTS {
    /**
     * Besides intializing variables, the constructor should do nothing!
     *
     * @param {Zigbee} zigbee Zigbee controller
     * @param {MQTT} mqtt MQTT controller
     * @param {State} state State controller
     * @param {Function} publishEntityState Method to publish device state to MQTT.
     * @param {EventBus} eventBus The event bus
     */
    constructor(zigbee, mqtt, state, publishEntityState, eventBus) {
        this.zigbee = zigbee;
        this.mqtt = mqtt;
        this.state = state;
        this.publishEntityState = publishEntityState;
        this.eventBus = eventBus;
    }
    /**
     * This method is called by the controller once Zigbee has been started.
     */
    /* istanbul ignore next */
    onZigbeeStarted() { }
    /**
     * This method is called by the controller once connected to the MQTT server.
     */
    /* istanbul ignore next */
    onMQTTConnected() { }
    /**
     * Is called when a Zigbee message from a device is received.
     * @param {string} type Type of the message
     * @param {Object} data Data of the message
     * @param {Object?} resolvedEntity Resolved entity returned from this.zigbee.resolveEntity()
     * @param {Object?} settingsDevice Device settings
     */
    /* istanbul ignore next */
    /* eslint-disable-next-line @typescript-eslint/no-unused-vars */
    onZigbeeEvent(type, data, resolvedEntity) { }
    /**
     * Is called when a MQTT message is received
     * @param {string} topic Topic on which the message was received
     * @param {Object} message The received message
     * @return {boolean} if the message was handled
     */
    /* istanbul ignore next */
    /* eslint-disable-next-line @typescript-eslint/no-unused-vars */
    onMQTTMessage(topic, message) {
        return false;
    }
    /**
     * Is called once the extension has to stop
     */
    stop() {
        this.eventBus.removeListenersExtension(this.constructor.name);
    }
}
exports.default = ExtensionTS;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0ZW5zaW9udHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9saWIvZXh0ZW5zaW9uL2V4dGVuc2lvbnRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsTUFBZSxXQUFXO0lBT3RCOzs7Ozs7OztPQVFHO0lBQ0gsWUFBWSxNQUFrQixFQUFFLElBQWMsRUFBRSxLQUFnQixFQUM1RCxrQkFBMEMsRUFBRSxRQUFzQjtRQUNsRSxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUNyQixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsa0JBQWtCLENBQUM7UUFDN0MsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7SUFDN0IsQ0FBQztJQUVEOztPQUVHO0lBQ0gsMEJBQTBCO0lBQzFCLGVBQWUsS0FBVSxDQUFDO0lBRTFCOztPQUVHO0lBQ0gsMEJBQTBCO0lBQzFCLGVBQWUsS0FBVSxDQUFDO0lBRTFCOzs7Ozs7T0FNRztJQUNILDBCQUEwQjtJQUMxQixnRUFBZ0U7SUFDaEUsYUFBYSxDQUFDLElBQXFCLEVBQUUsSUFBcUIsRUFBRSxjQUE4QixJQUFTLENBQUM7SUFFcEc7Ozs7O09BS0c7SUFDSCwwQkFBMEI7SUFDMUIsZ0VBQWdFO0lBQ2hFLGFBQWEsQ0FBQyxLQUFhLEVBQUUsT0FBZTtRQUN4QyxPQUFPLEtBQUssQ0FBQztJQUNqQixDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFJO1FBQ0EsSUFBSSxDQUFDLFFBQVEsQ0FBQyx3QkFBd0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ2xFLENBQUM7Q0FDSjtBQUVELGtCQUFlLFdBQVcsQ0FBQyJ9