"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const extensionts_1 = __importDefault(require("./extensionts"));
const logger_1 = __importDefault(require("../util/logger"));
const utils_1 = require("../util/utils");
const settings = __importStar(require("../util/settings"));
const debounce_1 = __importDefault(require("debounce"));
// TODO
// - Enable for HA addon
// - Add to setting schema (when old availability is removed)
class AvailabilityNew extends extensionts_1.default {
    constructor(zigbee, mqtt, state, publishEntityState, eventBus) {
        super(zigbee, mqtt, state, publishEntityState, eventBus);
        this.timers = {};
        this.availabilityCache = {};
        this.retrieveStateDebouncers = {};
        this.pingQueue = [];
        this.pingQueueExecuting = false;
        this.lastSeenChanged = this.lastSeenChanged.bind(this);
        logger_1.default.warn('Using experimental new availability feature');
    }
    getTimeout(rd) {
        var _a, _b, _c;
        if (typeof rd.settings.availability === 'object' && ((_a = rd.settings.availability) === null || _a === void 0 ? void 0 : _a.timeout) != null) {
            return (0, utils_1.minutes)(rd.settings.availability.timeout);
        }
        const key = this.isActiveDevice(rd) ? 'active' : 'passive';
        const availabilitySettings = settings.get().availability;
        if (typeof availabilitySettings === 'object' && ((_b = availabilitySettings[key]) === null || _b === void 0 ? void 0 : _b.timeout) != null) {
            return (0, utils_1.minutes)((_c = availabilitySettings[key]) === null || _c === void 0 ? void 0 : _c.timeout);
        }
        return key === 'active' ? (0, utils_1.minutes)(10) : (0, utils_1.hours)(25);
    }
    isActiveDevice(rd) {
        return (rd.device.type === 'Router' && rd.device.powerSource !== 'Battery') ||
            rd.device.powerSource === 'Mains (single phase)';
    }
    isAvailable(rd) {
        const ago = Date.now() - rd.device.lastSeen;
        return ago < this.getTimeout(rd);
    }
    resetTimer(rd) {
        clearTimeout(this.timers[rd.device.ieeeAddr]);
        // If the timer triggers, the device is not avaiable anymore otherwise resetTimer already have been called
        if (this.isActiveDevice(rd)) {
            // If device did not check in, ping it, if that fails it will be marked as offline
            this.timers[rd.device.ieeeAddr] = setTimeout(() => this.addToPingQueue(rd), this.getTimeout(rd) + (0, utils_1.seconds)(1));
        }
        else {
            this.timers[rd.device.ieeeAddr] = setTimeout(() => this.publishAvailability(rd, true), this.getTimeout(rd) + (0, utils_1.seconds)(1));
        }
    }
    addToPingQueue(rd) {
        this.pingQueue.push(rd);
        this.pingQueueExecuteNext();
    }
    removeFromPingQueue(rd) {
        const index = this.pingQueue.findIndex((r) => r.device.ieeeAddr === rd.device.ieeeAddr);
        index != -1 && this.pingQueue.splice(index, 1);
    }
    async pingQueueExecuteNext() {
        if (this.pingQueue.length === 0 || this.pingQueueExecuting)
            return;
        this.pingQueueExecuting = true;
        const rd = this.pingQueue[0];
        let pingedSuccessfully = false;
        const available = this.availabilityCache[rd.device.ieeeAddr] || this.isAvailable(rd);
        const attempts = available ? 2 : 1;
        for (let i = 0; i < attempts; i++) {
            try {
                // Enable recovery if device is marked as available and first ping fails.
                const disableRecovery = !(i == 1 && available);
                await rd.device.ping(disableRecovery);
                pingedSuccessfully = true;
                logger_1.default.debug(`Succesfully pinged '${rd.name}' (attempt ${i + 1}/${attempts})`);
                break;
            }
            catch (error) {
                logger_1.default.error(`Failed to ping '${rd.name}' (attempt ${i + 1}/${attempts}, ${error.message})`);
                // Try again in 3 seconds.
                const lastAttempt = i - 1 === attempts;
                !lastAttempt && await (0, utils_1.sleep)(3);
            }
        }
        this.publishAvailability(rd, !pingedSuccessfully);
        this.resetTimer(rd);
        this.removeFromPingQueue(rd);
        // Sleep 2 seconds before executing next ping
        await (0, utils_1.sleep)(2);
        this.pingQueueExecuting = false;
        this.pingQueueExecuteNext();
    }
    onMQTTConnected() {
        for (const device of this.zigbee.getClients()) {
            const rd = this.zigbee.resolveEntity(device);
            if ((0, utils_1.isAvailabilityEnabledForDevice)(rd, settings.get())) {
                // Publish initial availablility
                this.publishAvailability(rd, true);
                this.resetTimer(rd);
                // If an active device is initially unavailable, ping it.
                if (this.isActiveDevice(rd) && !this.isAvailable(rd)) {
                    this.addToPingQueue(rd);
                }
            }
        }
    }
    onZigbeeStarted() {
        this.zigbee.on('lastSeenChanged', this.lastSeenChanged);
    }
    onZigbeeEvent(type, data, re) {
        /* istanbul ignore else */
        if (type === 'deviceLeave') {
            clearTimeout(this.timers[data.ieeeAddr]);
        }
        else if (type === 'deviceAnnounce') {
            this.retrieveState(re);
        }
    }
    publishAvailability(rd, logLastSeen) {
        if (logLastSeen) {
            const ago = Date.now() - rd.device.lastSeen;
            if (this.isActiveDevice(rd)) {
                logger_1.default.debug(`Active device '${rd.name}' was last seen '${(ago / (0, utils_1.minutes)(1)).toFixed(2)}' minutes ago.`);
            }
            else {
                logger_1.default.debug(`Passive device '${rd.name}' was last seen '${(ago / (0, utils_1.hours)(1)).toFixed(2)}' hours ago.`);
            }
        }
        const available = this.isAvailable(rd);
        if (this.availabilityCache[rd.device.ieeeAddr] == available) {
            return;
        }
        if (rd.device.ieeeAddr in this.availabilityCache && available &&
            this.availabilityCache[rd.device.ieeeAddr] === false) {
            logger_1.default.debug(`Device '${rd.name}' reconnected`);
            this.retrieveState(rd);
        }
        const topic = `${rd.name}/availability`;
        const payload = available ? 'online' : 'offline';
        this.availabilityCache[rd.device.ieeeAddr] = available;
        this.mqtt.publish(topic, payload, { retain: true, qos: 0 });
    }
    lastSeenChanged(data) {
        const rd = this.zigbee.resolveEntity(data.device);
        if ((0, utils_1.isAvailabilityEnabledForDevice)(rd, settings.get())) {
            // Remove from ping queue, not necessary anymore since we know the device is online.
            this.removeFromPingQueue(rd);
            this.resetTimer(rd);
            this.publishAvailability(rd, false);
        }
    }
    stop() {
        Object.values(this.timers).forEach((t) => clearTimeout(t));
        this.zigbee.removeListener('lastSeenChanged', this.lastSeenChanged);
        super.stop();
    }
    retrieveState(rd) {
        var _a, _b;
        /**
         * Retrieve state of a device in a debounced manner, this function is called on a 'deviceAnnounce' which a
         * device can send multiple times after each other.
         */
        if (rd.definition && !rd.device.interviewing && !this.retrieveStateDebouncers[rd.device.ieeeAddr]) {
            this.retrieveStateDebouncers[rd.device.ieeeAddr] = (0, debounce_1.default)(async () => {
                var _a;
                try {
                    logger_1.default.debug(`Retrieving state of '${rd.name}' after reconnect`);
                    // Color and color temperature converters do both, only needs to be called once.
                    const keySet = [['state'], ['brightness'], ['color', 'color_temp']];
                    for (const keys of keySet) {
                        const converter = rd.definition.toZigbee.find((c) => c.key.find((k) => keys.includes(k)));
                        await ((_a = converter === null || converter === void 0 ? void 0 : converter.convertGet) === null || _a === void 0 ? void 0 : _a.call(converter, rd.endpoint, keys[0], { message: this.state.get(rd.device.ieeeAddr) || {}, mapped: rd.definition }));
                    }
                }
                catch (error) {
                    logger_1.default.error(`Failed to read state of '${rd.name}' after reconnect (${error.message})`);
                }
            }, (0, utils_1.seconds)(2));
        }
        (_b = (_a = this.retrieveStateDebouncers)[rd.device.ieeeAddr]) === null || _b === void 0 ? void 0 : _b.call(_a);
    }
}
module.exports = AvailabilityNew;
//# sourceMappingURL=data:application/json;base64,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