"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateIfChanged = exports.writeIfChanged = exports.readIfExists = exports.read = void 0;
const js_yaml_1 = __importDefault(require("js-yaml"));
const fs_1 = __importDefault(require("fs"));
const es6_1 = __importDefault(require("fast-deep-equal/es6"));
require("source-map-support/register");
function read(file) {
    try {
        /* eslint-disable-line */ // @ts-ignore
        return js_yaml_1.default.load(fs_1.default.readFileSync(file, 'utf8'));
    }
    catch (error) {
        if (error.name === 'YAMLException') {
            error.file = file;
        }
        throw error;
    }
}
exports.read = read;
function readIfExists(file, default_) {
    return fs_1.default.existsSync(file) ? read(file) : default_;
}
exports.readIfExists = readIfExists;
function writeIfChanged(file, content) {
    const before = readIfExists(file);
    if (!es6_1.default(before, content)) {
        fs_1.default.writeFileSync(file, js_yaml_1.default.dump(content));
    }
}
exports.writeIfChanged = writeIfChanged;
function updateIfChanged(file, key, value) {
    const content = read(file);
    if (content[key] !== value) {
        content[key] = value;
        writeIfChanged(file, content);
    }
}
exports.updateIfChanged = updateIfChanged;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoieWFtbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi91dGlsL3lhbWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsc0RBQTJCO0FBQzNCLDRDQUFvQjtBQUNwQiw4REFBeUM7QUFDekMsdUNBQXFDO0FBRXJDLFNBQWdCLElBQUksQ0FBQyxJQUFZO0lBQzdCLElBQUk7UUFDQSx5QkFBeUIsQ0FBQyxhQUFhO1FBQ3ZDLE9BQU8saUJBQUksQ0FBQyxJQUFJLENBQUMsWUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztLQUNuRDtJQUFDLE9BQU8sS0FBSyxFQUFFO1FBQ1osSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLGVBQWUsRUFBRTtZQUNoQyxLQUFLLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztTQUNyQjtRQUVELE1BQU0sS0FBSyxDQUFDO0tBQ2Y7QUFDTCxDQUFDO0FBWEQsb0JBV0M7QUFFRCxTQUFnQixZQUFZLENBQUMsSUFBWSxFQUFFLFFBQW1CO0lBQzFELE9BQU8sWUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUM7QUFDdkQsQ0FBQztBQUZELG9DQUVDO0FBRUQsU0FBZ0IsY0FBYyxDQUFDLElBQVksRUFBRSxPQUFpQjtJQUMxRCxNQUFNLE1BQU0sR0FBRyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbEMsSUFBSSxDQUFDLGFBQU0sQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLEVBQUU7UUFDMUIsWUFBRSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsaUJBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztLQUM5QztBQUNMLENBQUM7QUFMRCx3Q0FLQztBQUVELFNBQWdCLGVBQWUsQ0FBQyxJQUFZLEVBQUUsR0FBVyxFQUFFLEtBQWU7SUFDdEUsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzNCLElBQUksT0FBTyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEtBQUssRUFBRTtRQUN4QixPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBSyxDQUFDO1FBQ3JCLGNBQWMsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7S0FDakM7QUFDTCxDQUFDO0FBTkQsMENBTUMifQ==