import { WebUSB, getWebUsb } from './webusb';
import { WebUSBDevice } from './webusb/webusb-device';
import * as usb from './usb';
declare const webusb: WebUSB;
declare const getDeviceList: typeof usb.getDeviceList;
declare const useUsbDkBackend: typeof usb.useUsbDkBackend;
/**
 * Convenience method to get the first device with the specified VID and PID, or `undefined` if no such device is present.
 * @param vid
 * @param pid
 */
declare const findByIds: (vid: number, pid: number) => usb.Device | undefined;
/**
 * Convenience method to get the device with the specified serial number, or `undefined` if no such device is present.
 * @param serialNumber
 */
declare const findBySerialNumber: (serialNumber: string) => Promise<usb.Device | undefined>;
export { usb, useUsbDkBackend, getDeviceList, findByIds, findBySerialNumber, getWebUsb, webusb, WebUSB, WebUSBDevice };
