/* * Copyright (c) 2012 The Linux Foundation. All rights reserved.* */

#ifndef _NSS_REG_H_
#define _NSS_REG_H_

#define IPQ806X_NSS_TCM_PHYS			(0x39000000)
#define MSM_NSS_TCM_BASE			(0xFB700000)       /* 128K */
#define MSM_NSS_FPB_BASE			(0xFB720000)       /*  4K  */
#define MSM_UBI32_0_CSM_BASE			(0xFB721000)       /*  4K  */
#define MSM_UBI32_1_CSM_BASE			(0xFB722000)       /*  4K  */
#define NSS_RESET_ADDR				(0x40000000)


#define NSS_REGS_CORE_ID_OFFSET			0x0000
#define NSS_REGS_RESET_CTRL_OFFSET		0x0004
#define NSS_REGS_CORE_BAR_OFFSET		0x0008
#define NSS_REGS_CORE_AMC_OFFSET		0x000c
#define NSS_REGS_CORE_BOOT_ADDR_OFFSET		0x0010
#define NSS_REGS_C2C_INTR_STATUS_OFFSET		0x0014
#define NSS_REGS_C2C_INTR_SET_OFFSET		0x0018
#define NSS_REGS_C2C_INTR_CLR_OFFSET		0x001c
#define NSS_REGS_N2H_INTR_STATUS_OFFSET		0x0020
#define NSS_REGS_N2H_INTR_SET_OFFSET		0x0024
#define NSS_REGS_N2H_INTR_CLR_OFFSET		0x0028
#define NSS_REGS_N2H_INTR_MASK_OFFSET		0x002c
#define NSS_REGS_N2H_INTR_MASK_SET_OFFSET	0x0030
#define NSS_REGS_N2H_INTR_MASK_CLR_OFFSET	0x0034
#define NSS_REGS_CORE_INT_STAT0_TYPE_OFFSET	0x0038
#define NSS_REGS_CORE_INT_STAT1_TYPE_OFFSET	0x003c
#define NSS_REGS_CORE_INT_STAT2_TYPE_OFFSET	0x0040
#define NSS_REGS_CORE_INT_STAT3_TYPE_OFFSET	0x0044
#define NSS_REGS_CORE_IFETCH_RANGE_OFFSET	0x0048

/*
 * Defines for N2H interrupts
 */
#define NSS_REGS_N2H_INTR_STATUS_EMPTY_BUFFER_QUEUE	0x0001
#define NSS_REGS_N2H_INTR_STATUS_DATA_COMMAND_QUEUE	0x0002
#define NSS_REGS_N2H_INTR_STATUS_EMPTY_BUFFERS_SOS	0x0400
#define NSS_REGS_N2H_INTR_STATUS_TX_UNBLOCKED		0x0800

/*
 * Defines for H2N interrupts
 */
#define NSS_REGS_H2N_INTR_STATUS_EMPTY_BUFFER_QUEUE	0x0001
#define NSS_REGS_H2N_INTR_STATUS_DATA_COMMAND_QUEUE	0x0002
#define NSS_REGS_H2N_INTR_STATUS_RESET			0x0400	/** Unused */
#define NSS_REGS_H2N_INTR_STATUS_TX_UNBLOCKED		0x0800

#endif /* _NSS_REG_H_  */
