"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeedbackSummaryListInstance = exports.FeedbackSummaryInstance = exports.FeedbackSummaryContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../../../base/deserialize");
const serialize = require("../../../../../base/serialize");
const utility_1 = require("../../../../../base/utility");
class FeedbackSummaryContextImpl {
    constructor(_version, accountSid, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(accountSid)) {
            throw new Error("Parameter 'accountSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { accountSid, sid };
        this._uri = `/Accounts/${accountSid}/Calls/FeedbackSummary/${sid}.json`;
    }
    remove(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new FeedbackSummaryInstance(operationVersion, payload, instance._solution.accountSid, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FeedbackSummaryContextImpl = FeedbackSummaryContextImpl;
class FeedbackSummaryInstance {
    constructor(_version, payload, accountSid, sid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.callCount = deserialize.integer(payload.call_count);
        this.callFeedbackCount = deserialize.integer(payload.call_feedback_count);
        this.dateCreated = deserialize.rfc2822DateTime(payload.date_created);
        this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated);
        this.endDate = deserialize.iso8601Date(payload.end_date);
        this.includeSubaccounts = payload.include_subaccounts;
        this.issues = payload.issues;
        this.qualityScoreAverage = payload.quality_score_average;
        this.qualityScoreMedian = payload.quality_score_median;
        this.qualityScoreStandardDeviation =
            payload.quality_score_standard_deviation;
        this.sid = payload.sid;
        this.startDate = deserialize.iso8601Date(payload.start_date);
        this.status = payload.status;
        this._solution = { accountSid, sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new FeedbackSummaryContextImpl(this._version, this._solution.accountSid, this._solution.sid);
        return this._context;
    }
    /**
     * Remove a FeedbackSummaryInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a FeedbackSummaryInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed FeedbackSummaryInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            callCount: this.callCount,
            callFeedbackCount: this.callFeedbackCount,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            endDate: this.endDate,
            includeSubaccounts: this.includeSubaccounts,
            issues: this.issues,
            qualityScoreAverage: this.qualityScoreAverage,
            qualityScoreMedian: this.qualityScoreMedian,
            qualityScoreStandardDeviation: this.qualityScoreStandardDeviation,
            sid: this.sid,
            startDate: this.startDate,
            status: this.status,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.FeedbackSummaryInstance = FeedbackSummaryInstance;
function FeedbackSummaryListInstance(version, accountSid) {
    if (!(0, utility_1.isValidPathParam)(accountSid)) {
        throw new Error("Parameter 'accountSid' is not valid.");
    }
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new FeedbackSummaryContextImpl(version, accountSid, sid);
    };
    instance._version = version;
    instance._solution = { accountSid };
    instance._uri = `/Accounts/${accountSid}/Calls/FeedbackSummary.json`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["startDate"] === null || params["startDate"] === undefined) {
            throw new Error("Required parameter \"params['startDate']\" missing.");
        }
        if (params["endDate"] === null || params["endDate"] === undefined) {
            throw new Error("Required parameter \"params['endDate']\" missing.");
        }
        let data = {};
        data["StartDate"] = serialize.iso8601Date(params["startDate"]);
        data["EndDate"] = serialize.iso8601Date(params["endDate"]);
        if (params["includeSubaccounts"] !== undefined)
            data["IncludeSubaccounts"] = serialize.bool(params["includeSubaccounts"]);
        if (params["statusCallback"] !== undefined)
            data["StatusCallback"] = params["statusCallback"];
        if (params["statusCallbackMethod"] !== undefined)
            data["StatusCallbackMethod"] = params["statusCallbackMethod"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new FeedbackSummaryInstance(operationVersion, payload, instance._solution.accountSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.FeedbackSummaryListInstance = FeedbackSummaryListInstance;
