/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { AnonymizeList } from './roomParticipant/roomParticipantAnonymize';
import { AnonymizeListInstance } from './roomParticipant/roomParticipantAnonymize';
import { PublishedTrackList } from './roomParticipant/roomParticipantPublishedTrack';
import { PublishedTrackListInstance } from './roomParticipant/roomParticipantPublishedTrack';
import { SerializableClass } from '../../../../interfaces';
import { SubscribeRulesList } from './roomParticipant/roomParticipantSubscribeRule';
import { SubscribeRulesListInstance } from './roomParticipant/roomParticipantSubscribeRule';
import { SubscribedTrackList } from './roomParticipant/roomParticipantSubscribedTrack';
import { SubscribedTrackListInstance } from './roomParticipant/roomParticipantSubscribedTrack';

type ParticipantStatus = 'connected'|'disconnected';

/**
 * Initialize the ParticipantList
 *
 * @param version - Version of the resource
 * @param roomSid - The SID of the participant's room
 */
declare function ParticipantList(version: V1, roomSid: string): ParticipantListInstance;

/**
 * Options to pass to update
 *
 * @property status - The new status of the resource
 */
interface ParticipantInstanceUpdateOptions {
  status?: ParticipantStatus;
}

interface ParticipantListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ParticipantContext;
  /**
   * Streams ParticipantInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ParticipantInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ParticipantInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ParticipantListInstanceEachOptions, callback?: (item: ParticipantInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a participant
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): ParticipantContext;
  /**
   * Retrieve a single target page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Retrieve a single target page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Lists ParticipantInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ParticipantInstance[]) => any): Promise<ParticipantInstance[]>;
  /**
   * Lists ParticipantInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ParticipantListInstanceOptions, callback?: (error: Error | null, items: ParticipantInstance[]) => any): Promise<ParticipantInstance[]>;
  /**
   * Retrieve a single page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Retrieve a single page of ParticipantInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ParticipantListInstancePageOptions, callback?: (error: Error | null, items: ParticipantPage) => any): Promise<ParticipantPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property dateCreatedAfter - Read only Participants that started after this date in UTC ISO 8601 format
 * @property dateCreatedBefore - Read only Participants that started before this date in ISO 8601 format
 * @property done - Function to be called upon completion of streaming
 * @property identity - Read only the Participants with this user identity value
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property status - Read only the participants with this status
 */
interface ParticipantListInstanceEachOptions {
  callback?: (item: ParticipantInstance, done: (err?: Error) => void) => void;
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  done?: Function;
  identity?: string;
  limit?: number;
  pageSize?: number;
  status?: ParticipantStatus;
}

/**
 * Options to pass to list
 *
 * @property dateCreatedAfter - Read only Participants that started after this date in UTC ISO 8601 format
 * @property dateCreatedBefore - Read only Participants that started before this date in ISO 8601 format
 * @property identity - Read only the Participants with this user identity value
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property status - Read only the participants with this status
 */
interface ParticipantListInstanceOptions {
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  identity?: string;
  limit?: number;
  pageSize?: number;
  status?: ParticipantStatus;
}

/**
 * Options to pass to page
 *
 * @property dateCreatedAfter - Read only Participants that started after this date in UTC ISO 8601 format
 * @property dateCreatedBefore - Read only Participants that started before this date in ISO 8601 format
 * @property identity - Read only the Participants with this user identity value
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property status - Read only the participants with this status
 */
interface ParticipantListInstancePageOptions {
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  identity?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  status?: ParticipantStatus;
}

interface ParticipantPayload extends ParticipantResource, Page.TwilioResponsePayload {
}

interface ParticipantResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  duration: number;
  end_time: Date;
  identity: string;
  links: string;
  room_sid: string;
  sid: string;
  start_time: Date;
  status: ParticipantStatus;
  url: string;
}

interface ParticipantSolution {
  roomSid?: string;
}


declare class ParticipantContext {
  /**
   * Initialize the ParticipantContext
   *
   * @param version - Version of the resource
   * @param roomSid - The SID of the room with the Participant resource to fetch
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, roomSid: string, sid: string);

  anonymize: AnonymizeListInstance;
  /**
   * fetch a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  publishedTracks: PublishedTrackListInstance;
  subscribeRules: SubscribeRulesListInstance;
  subscribedTracks: SubscribedTrackListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * update a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ParticipantInstanceUpdateOptions, callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
}


declare class ParticipantInstance extends SerializableClass {
  /**
   * Initialize the ParticipantContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param roomSid - The SID of the participant's room
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: ParticipantPayload, roomSid: string, sid: string);

  private _proxy: ParticipantContext;
  accountSid: string;
  /**
   * Access the anonymize
   */
  anonymize(): AnonymizeListInstance;
  dateCreated: Date;
  dateUpdated: Date;
  duration: number;
  endTime: Date;
  /**
   * fetch a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  identity: string;
  links: string;
  /**
   * Access the publishedTracks
   */
  publishedTracks(): PublishedTrackListInstance;
  roomSid: string;
  sid: string;
  startTime: Date;
  status: ParticipantStatus;
  /**
   * Access the subscribeRules
   */
  subscribeRules(): SubscribeRulesListInstance;
  /**
   * Access the subscribedTracks
   */
  subscribedTracks(): SubscribedTrackListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ParticipantInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  /**
   * update a ParticipantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ParticipantInstanceUpdateOptions, callback?: (error: Error | null, items: ParticipantInstance) => any): Promise<ParticipantInstance>;
  url: string;
}


declare class ParticipantPage extends Page<V1, ParticipantPayload, ParticipantResource, ParticipantInstance> {
  /**
   * Initialize the ParticipantPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ParticipantSolution);

  /**
   * Build an instance of ParticipantInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ParticipantPayload): ParticipantInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ParticipantContext, ParticipantInstance, ParticipantInstanceUpdateOptions, ParticipantList, ParticipantListInstance, ParticipantListInstanceEachOptions, ParticipantListInstanceOptions, ParticipantListInstancePageOptions, ParticipantPage, ParticipantPayload, ParticipantResource, ParticipantSolution, ParticipantStatus }
