/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

type VerificationAttemptsSummaryChannels = 'sms'|'call'|'email'|'whatsapp';

/**
 * Initialize the VerificationAttemptsSummaryList
 *
 * @param version - Version of the resource
 */
declare function VerificationAttemptsSummaryList(version: V2): VerificationAttemptsSummaryListInstance;

/**
 * Options to pass to fetch
 *
 * @property channel - Filter verification attempts considered on the summary by communication channel.
 * @property country - Filter verification attempts considered on the summary by destination country.
 * @property dateCreatedAfter - Consider verification attempts create after this date on the summary.
 * @property dateCreatedBefore - Consider verification attempts created before this date on the summary.
 * @property destinationPrefix - Filters the attempts considered on the summary by destination prefix.
 * @property verifyServiceSid - Filter the verification attempts considered on the summary by verify service.
 */
interface VerificationAttemptsSummaryInstanceFetchOptions {
  channel?: VerificationAttemptsSummaryChannels;
  country?: string;
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  destinationPrefix?: string;
  verifyServiceSid?: string;
}

interface VerificationAttemptsSummaryListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): VerificationAttemptsSummaryContext;
  /**
   * Constructs a verification_attempts_summary
   */
  get(): VerificationAttemptsSummaryContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface VerificationAttemptsSummaryPayload extends VerificationAttemptsSummaryResource, Page.TwilioResponsePayload {
}

interface VerificationAttemptsSummaryResource {
  conversion_rate_percentage: number;
  total_attempts: number;
  total_converted: number;
  total_unconverted: number;
  url: string;
}

interface VerificationAttemptsSummarySolution {
}


declare class VerificationAttemptsSummaryContext {
  /**
   * Initialize the VerificationAttemptsSummaryContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V2);

  /**
   * fetch a VerificationAttemptsSummaryInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: VerificationAttemptsSummaryInstance) => any): Promise<VerificationAttemptsSummaryInstance>;
  /**
   * fetch a VerificationAttemptsSummaryInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: VerificationAttemptsSummaryInstanceFetchOptions, callback?: (error: Error | null, items: VerificationAttemptsSummaryInstance) => any): Promise<VerificationAttemptsSummaryInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class VerificationAttemptsSummaryInstance extends SerializableClass {
  /**
   * Initialize the VerificationAttemptsSummaryContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V2, payload: VerificationAttemptsSummaryPayload);

  private _proxy: VerificationAttemptsSummaryContext;
  conversionRatePercentage: number;
  /**
   * fetch a VerificationAttemptsSummaryInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: VerificationAttemptsSummaryInstance) => any): Promise<VerificationAttemptsSummaryInstance>;
  /**
   * fetch a VerificationAttemptsSummaryInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: VerificationAttemptsSummaryInstanceFetchOptions, callback?: (error: Error | null, items: VerificationAttemptsSummaryInstance) => any): Promise<VerificationAttemptsSummaryInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  totalAttempts: number;
  totalConverted: number;
  totalUnconverted: number;
  url: string;
}


declare class VerificationAttemptsSummaryPage extends Page<V2, VerificationAttemptsSummaryPayload, VerificationAttemptsSummaryResource, VerificationAttemptsSummaryInstance> {
  /**
   * Initialize the VerificationAttemptsSummaryPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: VerificationAttemptsSummarySolution);

  /**
   * Build an instance of VerificationAttemptsSummaryInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: VerificationAttemptsSummaryPayload): VerificationAttemptsSummaryInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { VerificationAttemptsSummaryChannels, VerificationAttemptsSummaryContext, VerificationAttemptsSummaryInstance, VerificationAttemptsSummaryInstanceFetchOptions, VerificationAttemptsSummaryList, VerificationAttemptsSummaryListInstance, VerificationAttemptsSummaryPage, VerificationAttemptsSummaryPayload, VerificationAttemptsSummaryResource, VerificationAttemptsSummarySolution }
