/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the OpenidDiscoveryList
 *
 * @param version - Version of the resource
 */
declare function OpenidDiscoveryList(version: V1): OpenidDiscoveryListInstance;

interface OpenidDiscoveryListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): OpenidDiscoveryContext;
  /**
   * Constructs a openid_discovery
   */
  get(): OpenidDiscoveryContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface OpenidDiscoveryPayload extends OpenidDiscoveryResource, Page.TwilioResponsePayload {
}

interface OpenidDiscoveryResource {
  authorization_endpoint: string;
  claims_supported: string[];
  device_authorization_endpoint: string;
  id_token_signing_alg_values_supported: string[];
  issuer: string;
  jwk_uri: string;
  response_type_supported: string[];
  revocation_endpoint: string;
  scopes_supported: string[];
  subject_type_supported: string[];
  token_endpoint: string;
  url: string;
  userinfo_endpoint: string;
}

interface OpenidDiscoverySolution {
}


declare class OpenidDiscoveryContext {
  /**
   * Initialize the OpenidDiscoveryContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * fetch a OpenidDiscoveryInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: OpenidDiscoveryInstance) => any): Promise<OpenidDiscoveryInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class OpenidDiscoveryInstance extends SerializableClass {
  /**
   * Initialize the OpenidDiscoveryContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: OpenidDiscoveryPayload);

  private _proxy: OpenidDiscoveryContext;
  authorizationEndpoint: string;
  claimsSupported: string[];
  deviceAuthorizationEndpoint: string;
  /**
   * fetch a OpenidDiscoveryInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: OpenidDiscoveryInstance) => any): Promise<OpenidDiscoveryInstance>;
  idTokenSigningAlgValuesSupported: string[];
  issuer: string;
  jwkUri: string;
  responseTypeSupported: string[];
  revocationEndpoint: string;
  scopesSupported: string[];
  subjectTypeSupported: string[];
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  tokenEndpoint: string;
  url: string;
  userinfoEndpoint: string;
}


declare class OpenidDiscoveryPage extends Page<V1, OpenidDiscoveryPayload, OpenidDiscoveryResource, OpenidDiscoveryInstance> {
  /**
   * Initialize the OpenidDiscoveryPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: OpenidDiscoverySolution);

  /**
   * Build an instance of OpenidDiscoveryInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: OpenidDiscoveryPayload): OpenidDiscoveryInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { OpenidDiscoveryContext, OpenidDiscoveryInstance, OpenidDiscoveryList, OpenidDiscoveryListInstance, OpenidDiscoveryPage, OpenidDiscoveryPayload, OpenidDiscoveryResource, OpenidDiscoverySolution }
