/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2 = require('../../../V2');
import { SerializableClass } from '../../../../../interfaces';

type ReplaceItemsEndUserType = 'individual'|'business';

type ReplaceItemsStatus = 'draft'|'pending-review'|'in-review'|'twilio-rejected'|'twilio-approved'|'provisionally-approved';

/**
 * Initialize the ReplaceItemsList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param bundleSid - The unique string that identifies the resource.
 */
declare function ReplaceItemsList(version: V2, bundleSid: string): ReplaceItemsListInstance;

interface ReplaceItemsListInstance {
  /**
   * create a ReplaceItemsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ReplaceItemsListInstanceCreateOptions, callback?: (error: Error | null, item: ReplaceItemsInstance) => any): Promise<ReplaceItemsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property fromBundleSid - The source bundle sid to copy the item assignments from
 */
interface ReplaceItemsListInstanceCreateOptions {
  fromBundleSid: string;
}

interface ReplaceItemsPayload extends ReplaceItemsResource, Page.TwilioResponsePayload {
}

interface ReplaceItemsResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  email: string;
  friendly_name: string;
  regulation_sid: string;
  sid: string;
  status: ReplaceItemsStatus;
  status_callback: string;
  valid_until: Date;
}

interface ReplaceItemsSolution {
  bundleSid?: string;
}


declare class ReplaceItemsInstance extends SerializableClass {
  /**
   * Initialize the ReplaceItemsContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param bundleSid - The unique string that identifies the resource.
   */
  constructor(version: V2, payload: ReplaceItemsPayload, bundleSid: string);

  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  email: string;
  friendlyName: string;
  regulationSid: string;
  sid: string;
  status: ReplaceItemsStatus;
  statusCallback: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  validUntil: Date;
}


declare class ReplaceItemsPage extends Page<V2, ReplaceItemsPayload, ReplaceItemsResource, ReplaceItemsInstance> {
  /**
   * Initialize the ReplaceItemsPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: ReplaceItemsSolution);

  /**
   * Build an instance of ReplaceItemsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ReplaceItemsPayload): ReplaceItemsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ReplaceItemsEndUserType, ReplaceItemsInstance, ReplaceItemsList, ReplaceItemsListInstance, ReplaceItemsListInstanceCreateOptions, ReplaceItemsPage, ReplaceItemsPayload, ReplaceItemsResource, ReplaceItemsSolution, ReplaceItemsStatus }
