'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var PhoneNumberList = require('./v2/phoneNumber').PhoneNumberList;
var Version = require('../../base/Version');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize the V2 version of Lookups
 *
 * @constructor Twilio.Lookups.V2
 *
 * @property {Twilio.Lookups.V2.PhoneNumberList} phoneNumbers -
 *          phoneNumbers resource
 *
 * @param {Twilio.Lookups} domain - The twilio domain
 */
/* jshint ignore:end */
function V2(domain) {
  Version.prototype.constructor.call(this, domain, 'v2');

  // Resources
  this._phoneNumbers = undefined;
}

_.extend(V2.prototype, Version.prototype);
V2.prototype.constructor = V2;

Object.defineProperty(V2.prototype,
  'phoneNumbers', {
    get: function() {
      this._phoneNumbers = this._phoneNumbers || new PhoneNumberList(this);
      return this._phoneNumbers;
    }
});

module.exports = V2;
