/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the UserRolesList
 *
 * @param version - Version of the resource
 */
declare function UserRolesList(version: V1): UserRolesListInstance;

/**
 * Options to pass to fetch
 *
 * @property token - The Token HTTP request header
 */
interface UserRolesInstanceFetchOptions {
  token?: string;
}

interface UserRolesListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): UserRolesContext;
  /**
   * Constructs a user_roles
   */
  get(): UserRolesContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface UserRolesPayload extends UserRolesResource, Page.TwilioResponsePayload {
}

interface UserRolesResource {
  roles: string[];
  url: string;
}

interface UserRolesSolution {
}


declare class UserRolesContext {
  /**
   * Initialize the UserRolesContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * fetch a UserRolesInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UserRolesInstance) => any): Promise<UserRolesInstance>;
  /**
   * fetch a UserRolesInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: UserRolesInstanceFetchOptions, callback?: (error: Error | null, items: UserRolesInstance) => any): Promise<UserRolesInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class UserRolesInstance extends SerializableClass {
  /**
   * Initialize the UserRolesContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: UserRolesPayload);

  private _proxy: UserRolesContext;
  /**
   * fetch a UserRolesInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UserRolesInstance) => any): Promise<UserRolesInstance>;
  /**
   * fetch a UserRolesInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: UserRolesInstanceFetchOptions, callback?: (error: Error | null, items: UserRolesInstance) => any): Promise<UserRolesInstance>;
  roles: string[];
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class UserRolesPage extends Page<V1, UserRolesPayload, UserRolesResource, UserRolesInstance> {
  /**
   * Initialize the UserRolesPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: UserRolesSolution);

  /**
   * Build an instance of UserRolesInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UserRolesPayload): UserRolesInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UserRolesContext, UserRolesInstance, UserRolesInstanceFetchOptions, UserRolesList, UserRolesListInstance, UserRolesPage, UserRolesPayload, UserRolesResource, UserRolesSolution }
