'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var ChannelList = require('./v3/channel').ChannelList;
var Version = require('../../base/Version');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize the V3 version of Chat
 *
 * @constructor Twilio.Chat.V3
 *
 * @property {Twilio.Chat.V3.ChannelList} channels - channels resource
 *
 * @param {Twilio.Chat} domain - The twilio domain
 */
/* jshint ignore:end */
function V3(domain) {
  Version.prototype.constructor.call(this, domain, 'v3');

  // Resources
  this._channels = undefined;
}

_.extend(V3.prototype, Version.prototype);
V3.prototype.constructor = V3;

Object.defineProperty(V3.prototype,
  'channels', {
    get: function() {
      this._channels = this._channels || new ChannelList(this);
      return this._channels;
    }
});

module.exports = V3;
