/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the AlphaSenderList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the resource is associated with
 */
declare function AlphaSenderList(version: V1, serviceSid: string): AlphaSenderListInstance;

interface AlphaSenderListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AlphaSenderContext;
  /**
   * create a AlphaSenderInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: AlphaSenderListInstanceCreateOptions, callback?: (error: Error | null, item: AlphaSenderInstance) => any): Promise<AlphaSenderInstance>;
  /**
   * Streams AlphaSenderInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: AlphaSenderInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams AlphaSenderInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: AlphaSenderListInstanceEachOptions, callback?: (item: AlphaSenderInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a alpha_sender
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): AlphaSenderContext;
  /**
   * Retrieve a single target page of AlphaSenderInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: AlphaSenderPage) => any): Promise<AlphaSenderPage>;
  /**
   * Retrieve a single target page of AlphaSenderInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: AlphaSenderPage) => any): Promise<AlphaSenderPage>;
  /**
   * Lists AlphaSenderInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: AlphaSenderInstance[]) => any): Promise<AlphaSenderInstance[]>;
  /**
   * Lists AlphaSenderInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: AlphaSenderListInstanceOptions, callback?: (error: Error | null, items: AlphaSenderInstance[]) => any): Promise<AlphaSenderInstance[]>;
  /**
   * Retrieve a single page of AlphaSenderInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: AlphaSenderPage) => any): Promise<AlphaSenderPage>;
  /**
   * Retrieve a single page of AlphaSenderInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: AlphaSenderListInstancePageOptions, callback?: (error: Error | null, items: AlphaSenderPage) => any): Promise<AlphaSenderPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property alphaSender - The Alphanumeric Sender ID string
 */
interface AlphaSenderListInstanceCreateOptions {
  alphaSender: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface AlphaSenderListInstanceEachOptions {
  callback?: (item: AlphaSenderInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface AlphaSenderListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface AlphaSenderListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface AlphaSenderPayload extends AlphaSenderResource, Page.TwilioResponsePayload {
}

interface AlphaSenderResource {
  account_sid: string;
  alpha_sender: string;
  capabilities: string[];
  date_created: Date;
  date_updated: Date;
  service_sid: string;
  sid: string;
  url: string;
}

interface AlphaSenderSolution {
  serviceSid?: string;
}


declare class AlphaSenderContext {
  /**
   * Initialize the AlphaSenderContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Messaging Service to fetch the resource from
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, serviceSid: string, sid: string);

  /**
   * fetch a AlphaSenderInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AlphaSenderInstance) => any): Promise<AlphaSenderInstance>;
  /**
   * remove a AlphaSenderInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AlphaSenderInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class AlphaSenderInstance extends SerializableClass {
  /**
   * Initialize the AlphaSenderContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: AlphaSenderPayload, serviceSid: string, sid: string);

  private _proxy: AlphaSenderContext;
  accountSid: string;
  alphaSender: string;
  capabilities: string[];
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a AlphaSenderInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AlphaSenderInstance) => any): Promise<AlphaSenderInstance>;
  /**
   * remove a AlphaSenderInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AlphaSenderInstance) => any): Promise<boolean>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class AlphaSenderPage extends Page<V1, AlphaSenderPayload, AlphaSenderResource, AlphaSenderInstance> {
  /**
   * Initialize the AlphaSenderPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AlphaSenderSolution);

  /**
   * Build an instance of AlphaSenderInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AlphaSenderPayload): AlphaSenderInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AlphaSenderContext, AlphaSenderInstance, AlphaSenderList, AlphaSenderListInstance, AlphaSenderListInstanceCreateOptions, AlphaSenderListInstanceEachOptions, AlphaSenderListInstanceOptions, AlphaSenderListInstancePageOptions, AlphaSenderPage, AlphaSenderPayload, AlphaSenderResource, AlphaSenderSolution }
