/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { DocumentPermissionList } from './document/documentPermission';
import { DocumentPermissionListInstance } from './document/documentPermission';
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the DocumentList
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Sync Service that the resource is associated with
 */
declare function DocumentList(version: V1, serviceSid: string): DocumentListInstance;

/**
 * Options to pass to update
 *
 * @property data - A JSON string that represents an arbitrary, schema-less object that the Sync Document stores
 * @property ifMatch - The If-Match HTTP request header
 * @property ttl - How long, in seconds, before the Document resource expires and is deleted
 */
interface DocumentInstanceUpdateOptions {
  data?: object;
  ifMatch?: string;
  ttl?: number;
}

interface DocumentListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): DocumentContext;
  /**
   * create a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: DocumentInstance) => any): Promise<DocumentInstance>;
  /**
   * create a DocumentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: DocumentListInstanceCreateOptions, callback?: (error: Error | null, item: DocumentInstance) => any): Promise<DocumentInstance>;
  /**
   * Streams DocumentInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: DocumentInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams DocumentInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: DocumentListInstanceEachOptions, callback?: (item: DocumentInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a document
   *
   * @param sid - The SID of the Document resource to fetch
   */
  get(sid: string): DocumentContext;
  /**
   * Retrieve a single target page of DocumentInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: DocumentPage) => any): Promise<DocumentPage>;
  /**
   * Retrieve a single target page of DocumentInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: DocumentPage) => any): Promise<DocumentPage>;
  /**
   * Lists DocumentInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: DocumentInstance[]) => any): Promise<DocumentInstance[]>;
  /**
   * Lists DocumentInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: DocumentListInstanceOptions, callback?: (error: Error | null, items: DocumentInstance[]) => any): Promise<DocumentInstance[]>;
  /**
   * Retrieve a single page of DocumentInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: DocumentPage) => any): Promise<DocumentPage>;
  /**
   * Retrieve a single page of DocumentInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: DocumentListInstancePageOptions, callback?: (error: Error | null, items: DocumentPage) => any): Promise<DocumentPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property data - A JSON string that represents an arbitrary, schema-less object that the Sync Document stores
 * @property ttl - How long, in seconds, before the Sync Document expires and is deleted
 * @property uniqueName - An application-defined string that uniquely identifies the Sync Document
 */
interface DocumentListInstanceCreateOptions {
  data?: object;
  ttl?: number;
  uniqueName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface DocumentListInstanceEachOptions {
  callback?: (item: DocumentInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface DocumentListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface DocumentListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface DocumentPayload extends DocumentResource, Page.TwilioResponsePayload {
}

interface DocumentResource {
  account_sid: string;
  created_by: string;
  data: object;
  date_created: Date;
  date_expires: Date;
  date_updated: Date;
  links: string;
  revision: string;
  service_sid: string;
  sid: string;
  unique_name: string;
  url: string;
}

interface DocumentSolution {
  serviceSid?: string;
}


declare class DocumentContext {
  /**
   * Initialize the DocumentContext
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Sync Service with the Document resource to fetch
   * @param sid - The SID of the Document resource to fetch
   */
  constructor(version: V1, serviceSid: string, sid: string);

  documentPermissions: DocumentPermissionListInstance;
  /**
   * fetch a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DocumentInstance) => any): Promise<DocumentInstance>;
  /**
   * remove a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: DocumentInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: DocumentInstance) => any): Promise<DocumentInstance>;
  /**
   * update a DocumentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: DocumentInstanceUpdateOptions, callback?: (error: Error | null, items: DocumentInstance) => any): Promise<DocumentInstance>;
}


declare class DocumentInstance extends SerializableClass {
  /**
   * Initialize the DocumentContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Sync Service that the resource is associated with
   * @param sid - The SID of the Document resource to fetch
   */
  constructor(version: V1, payload: DocumentPayload, serviceSid: string, sid: string);

  private _proxy: DocumentContext;
  accountSid: string;
  createdBy: string;
  data: any;
  dateCreated: Date;
  dateExpires: Date;
  dateUpdated: Date;
  /**
   * Access the documentPermissions
   */
  documentPermissions(): DocumentPermissionListInstance;
  /**
   * fetch a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DocumentInstance) => any): Promise<DocumentInstance>;
  links: string;
  /**
   * remove a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: DocumentInstance) => any): Promise<boolean>;
  revision: string;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  /**
   * update a DocumentInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: DocumentInstance) => any): Promise<DocumentInstance>;
  /**
   * update a DocumentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: DocumentInstanceUpdateOptions, callback?: (error: Error | null, items: DocumentInstance) => any): Promise<DocumentInstance>;
  url: string;
}


declare class DocumentPage extends Page<V1, DocumentPayload, DocumentResource, DocumentInstance> {
  /**
   * Initialize the DocumentPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: DocumentSolution);

  /**
   * Build an instance of DocumentInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: DocumentPayload): DocumentInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { DocumentContext, DocumentInstance, DocumentInstanceUpdateOptions, DocumentList, DocumentListInstance, DocumentListInstanceCreateOptions, DocumentListInstanceEachOptions, DocumentListInstanceOptions, DocumentListInstancePageOptions, DocumentPage, DocumentPayload, DocumentResource, DocumentSolution }
