/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type AnnotationAnsweredBy = 'unknown_answered_by'|'human'|'machine';

type AnnotationConnectivityIssue = 'unknown_connectivity_issue'|'no_connectivity_issue'|'invalid_number'|'caller_id'|'dropped_call'|'number_reachability';

type AnnotationQualityIssues = 'unknown_quality_issue'|'no_quality_issue'|'low_volume'|'choppy_robotic'|'echo'|'dtmf'|'latency'|'owa'|'static_noise';

/**
 * Initialize the AnnotationList
 *
 * @param version - Version of the resource
 */
declare function AnnotationList(version: V1): AnnotationListInstance;

/**
 * Options to pass to update
 *
 * @property answeredBy - The answered_by
 * @property callScore - The call_score
 * @property comment - The comment
 * @property connectivityIssue - The connectivity_issue
 * @property incident - The incident
 * @property qualityIssues - The quality_issues
 * @property spam - The spam
 */
interface AnnotationInstanceUpdateOptions {
  answeredBy?: AnnotationAnsweredBy;
  callScore?: number;
  comment?: string;
  connectivityIssue?: AnnotationConnectivityIssue;
  incident?: string;
  qualityIssues?: string;
  spam?: boolean;
}

interface AnnotationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AnnotationContext;
  /**
   * Constructs a annotation
   *
   * @param callSid - The call_sid
   */
  get(callSid: string): AnnotationContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface AnnotationPayload extends AnnotationResource, Page.TwilioResponsePayload {
}

interface AnnotationResource {
  account_sid: string;
  answered_by: AnnotationAnsweredBy;
  call_score: number;
  call_sid: string;
  comment: string;
  connectivity_issue: AnnotationConnectivityIssue;
  incident: string;
  quality_issues: string[];
  spam: boolean;
  url: string;
}

interface AnnotationSolution {
}


declare class AnnotationContext {
  /**
   * Initialize the AnnotationContext
   *
   * @param version - Version of the resource
   * @param callSid - The call_sid
   */
  constructor(version: V1, callSid: string);

  /**
   * fetch a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  /**
   * update a AnnotationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AnnotationInstanceUpdateOptions, callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
}


declare class AnnotationInstance extends SerializableClass {
  /**
   * Initialize the AnnotationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param callSid - The call_sid
   */
  constructor(version: V1, payload: AnnotationPayload, callSid: string);

  private _proxy: AnnotationContext;
  accountSid: string;
  answeredBy: AnnotationAnsweredBy;
  callScore: number;
  callSid: string;
  comment: string;
  connectivityIssue: AnnotationConnectivityIssue;
  /**
   * fetch a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  incident: string;
  qualityIssues: string[];
  spam: boolean;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AnnotationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  /**
   * update a AnnotationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AnnotationInstanceUpdateOptions, callback?: (error: Error | null, items: AnnotationInstance) => any): Promise<AnnotationInstance>;
  url: string;
}


declare class AnnotationPage extends Page<V1, AnnotationPayload, AnnotationResource, AnnotationInstance> {
  /**
   * Initialize the AnnotationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AnnotationSolution);

  /**
   * Build an instance of AnnotationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AnnotationPayload): AnnotationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AnnotationAnsweredBy, AnnotationConnectivityIssue, AnnotationContext, AnnotationInstance, AnnotationInstanceUpdateOptions, AnnotationList, AnnotationListInstance, AnnotationPage, AnnotationPayload, AnnotationQualityIssues, AnnotationResource, AnnotationSolution }
