'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var UsAppToPersonList;
var UsAppToPersonPage;
var UsAppToPersonInstance;
var UsAppToPersonContext;

/* jshint ignore:start */
/**
 * Initialize the UsAppToPersonList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceContext.UsAppToPersonList
 *
 * @param {Twilio.Messaging.V1} version - Version of the resource
 * @param {string} messagingServiceSid -
 *          The SID of the Messaging Service the resource is associated with
 */
/* jshint ignore:end */
UsAppToPersonList = function UsAppToPersonList(version, messagingServiceSid) {
  /* jshint ignore:start */
  /**
   * @function usAppToPerson
   * @memberof Twilio.Messaging.V1.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Messaging.V1.ServiceContext.UsAppToPersonContext}
   */
  /* jshint ignore:end */
  function UsAppToPersonListInstance(sid) {
    return UsAppToPersonListInstance.get(sid);
  }

  UsAppToPersonListInstance._version = version;
  // Path Solution
  UsAppToPersonListInstance._solution = {messagingServiceSid: messagingServiceSid};
  UsAppToPersonListInstance._uri = `/Services/${messagingServiceSid}/Compliance/Usa2p`;
  /* jshint ignore:start */
  /**
   * create a UsAppToPersonInstance
   *
   * @function create
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.brandRegistrationSid - A2P Brand Registration SID
   * @param {string} opts.description -
   *          A short description of what this SMS campaign does
   * @param {string|list} opts.messageSamples - Message samples
   * @param {string} opts.usAppToPersonUsecase - A2P Campaign Use Case.
   * @param {boolean} opts.hasEmbeddedLinks -
   *          Indicates that this SMS campaign will send messages that contain links
   * @param {boolean} opts.hasEmbeddedPhone -
   *          Indicates that this SMS campaign will send messages that contain phone numbers
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed UsAppToPersonInstance
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['brandRegistrationSid'])) {
      throw new Error('Required parameter "opts[\'brandRegistrationSid\']" missing.');
    }
    if (_.isUndefined(opts['description'])) {
      throw new Error('Required parameter "opts[\'description\']" missing.');
    }
    if (_.isUndefined(opts['messageSamples'])) {
      throw new Error('Required parameter "opts[\'messageSamples\']" missing.');
    }
    if (_.isUndefined(opts['usAppToPersonUsecase'])) {
      throw new Error('Required parameter "opts[\'usAppToPersonUsecase\']" missing.');
    }
    if (_.isUndefined(opts['hasEmbeddedLinks'])) {
      throw new Error('Required parameter "opts[\'hasEmbeddedLinks\']" missing.');
    }
    if (_.isUndefined(opts['hasEmbeddedPhone'])) {
      throw new Error('Required parameter "opts[\'hasEmbeddedPhone\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'BrandRegistrationSid': _.get(opts, 'brandRegistrationSid'),
      'Description': _.get(opts, 'description'),
      'MessageSamples': serialize.map(_.get(opts, 'messageSamples'), function(e) { return e; }),
      'UsAppToPersonUsecase': _.get(opts, 'usAppToPersonUsecase'),
      'HasEmbeddedLinks': serialize.bool(_.get(opts, 'hasEmbeddedLinks')),
      'HasEmbeddedPhone': serialize.bool(_.get(opts, 'hasEmbeddedPhone'))
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new UsAppToPersonInstance(
        this._version,
        payload,
        this._solution.messagingServiceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams UsAppToPersonInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists UsAppToPersonInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of UsAppToPersonInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new UsAppToPersonPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of UsAppToPersonInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new UsAppToPersonPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a us_app_to_person
   *
   * @function get
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @param {string} sid -
   *          The SID that identifies the US A2P Compliance resource to fetch
   *
   * @returns {Twilio.Messaging.V1.ServiceContext.UsAppToPersonContext}
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.get = function get(sid) {
    return new UsAppToPersonContext(this._version, this._solution.messagingServiceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  UsAppToPersonListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  UsAppToPersonListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return UsAppToPersonListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the UsAppToPersonPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceContext.UsAppToPersonPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {UsAppToPersonSolution} solution - Path solution
 *
 * @returns UsAppToPersonPage
 */
/* jshint ignore:end */
UsAppToPersonPage = function UsAppToPersonPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(UsAppToPersonPage.prototype, Page.prototype);
UsAppToPersonPage.prototype.constructor = UsAppToPersonPage;

/* jshint ignore:start */
/**
 * Build an instance of UsAppToPersonInstance
 *
 * @function getInstance
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonPage#
 *
 * @param {UsAppToPersonPayload} payload - Payload response from the API
 *
 * @returns UsAppToPersonInstance
 */
/* jshint ignore:end */
UsAppToPersonPage.prototype.getInstance = function getInstance(payload) {
  return new UsAppToPersonInstance(this._version, payload, this._solution.messagingServiceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsAppToPersonPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UsAppToPersonPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UsAppToPersonContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceContext.UsAppToPersonInstance
 *
 * @property {string} sid -
 *          The unique string that identifies a US A2P Compliance resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} brandRegistrationSid - A2P Brand Registration SID
 * @property {string} messagingServiceSid -
 *          The SID of the Messaging Service the resource is associated with
 * @property {string} description -
 *          A short description of what this SMS campaign does
 * @property {string} messageSamples - Message samples
 * @property {string} usAppToPersonUsecase - A2P Campaign Use Case.
 * @property {boolean} hasEmbeddedLinks -
 *          Indicate that this SMS campaign will send messages that contain links
 * @property {boolean} hasEmbeddedPhone -
 *          Indicates that this SMS campaign will send messages that contain phone numbers
 * @property {string} campaignStatus - Campaign status
 * @property {string} campaignId - The Campaign Registry (TCR) Campaign ID.
 * @property {boolean} isExternallyRegistered -
 *          Indicates whether the campaign was registered externally or not
 * @property {object} rateLimits -
 *          Rate limit and/or classification set by each carrier
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the US App to Person resource
 * @property {boolean} mock -
 *          A boolean that specifies whether campaign is a mock or not.
 *
 * @param {V1} version - Version of the resource
 * @param {UsAppToPersonPayload} payload - The instance payload
 * @param {sid} messagingServiceSid -
 *          The SID of the Messaging Service the resource is associated with
 * @param {sid} sid -
 *          The SID that identifies the US A2P Compliance resource to fetch
 */
/* jshint ignore:end */
UsAppToPersonInstance = function UsAppToPersonInstance(version, payload,
                                                        messagingServiceSid,
                                                        sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.brandRegistrationSid = payload.brand_registration_sid; // jshint ignore:line
  this.messagingServiceSid = payload.messaging_service_sid; // jshint ignore:line
  this.description = payload.description; // jshint ignore:line
  this.messageSamples = payload.message_samples; // jshint ignore:line
  this.usAppToPersonUsecase = payload.us_app_to_person_usecase; // jshint ignore:line
  this.hasEmbeddedLinks = payload.has_embedded_links; // jshint ignore:line
  this.hasEmbeddedPhone = payload.has_embedded_phone; // jshint ignore:line
  this.campaignStatus = payload.campaign_status; // jshint ignore:line
  this.campaignId = payload.campaign_id; // jshint ignore:line
  this.isExternallyRegistered = payload.is_externally_registered; // jshint ignore:line
  this.rateLimits = payload.rate_limits; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.mock = payload.mock; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {messagingServiceSid: messagingServiceSid, sid: sid || this.sid, };
};

Object.defineProperty(UsAppToPersonInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new UsAppToPersonContext(
          this._version,
          this._solution.messagingServiceSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * remove a UsAppToPersonInstance
 *
 * @function remove
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UsAppToPersonInstance
 */
/* jshint ignore:end */
UsAppToPersonInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * fetch a UsAppToPersonInstance
 *
 * @function fetch
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UsAppToPersonInstance
 */
/* jshint ignore:end */
UsAppToPersonInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsAppToPersonInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UsAppToPersonInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UsAppToPersonContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceContext.UsAppToPersonContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} messagingServiceSid -
 *          The SID of the Messaging Service to fetch the resource from
 * @param {sid} sid -
 *          The SID that identifies the US A2P Compliance resource to fetch
 */
/* jshint ignore:end */
UsAppToPersonContext = function UsAppToPersonContext(version,
                                                      messagingServiceSid, sid)
                                                      {
  this._version = version;

  // Path Solution
  this._solution = {messagingServiceSid: messagingServiceSid, sid: sid, };
  this._uri = `/Services/${messagingServiceSid}/Compliance/Usa2p/${sid}`;
};

/* jshint ignore:start */
/**
 * remove a UsAppToPersonInstance
 *
 * @function remove
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UsAppToPersonInstance
 */
/* jshint ignore:end */
UsAppToPersonContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a UsAppToPersonInstance
 *
 * @function fetch
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed UsAppToPersonInstance
 */
/* jshint ignore:end */
UsAppToPersonContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new UsAppToPersonInstance(
      this._version,
      payload,
      this._solution.messagingServiceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Messaging.V1.ServiceContext.UsAppToPersonContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsAppToPersonContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

UsAppToPersonContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  UsAppToPersonList: UsAppToPersonList,
  UsAppToPersonPage: UsAppToPersonPage,
  UsAppToPersonInstance: UsAppToPersonInstance,
  UsAppToPersonContext: UsAppToPersonContext
};
