'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V2 = require('./numbers/V2');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize numbers domain
 *
 * @constructor Twilio.Numbers
 *
 * @property {Twilio.Numbers.V2} v2 - v2 version
 * @property {Twilio.Numbers.V2.RegulatoryComplianceList} regulatoryCompliance -
 *          regulatoryCompliance resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Numbers(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://numbers.twilio.com');

  // Versions
  this._v2 = undefined;
}

_.extend(Numbers.prototype, Domain.prototype);
Numbers.prototype.constructor = Numbers;

Object.defineProperty(Numbers.prototype,
  'v2', {
    get: function() {
      this._v2 = this._v2 || new V2(this);
      return this._v2;
    }
});

Object.defineProperty(Numbers.prototype,
  'regulatoryCompliance', {
    get: function() {
      return this.v2.regulatoryCompliance;
    }
});

module.exports = Numbers;
