'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var ModelBuildList;
var ModelBuildPage;
var ModelBuildInstance;
var ModelBuildContext;

/* jshint ignore:start */
/**
 * Initialize the ModelBuildList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.ModelBuildList
 *
 * @param {Twilio.Preview.Understand} version - Version of the resource
 * @param {string} assistantSid - The unique ID of the parent Assistant.
 */
/* jshint ignore:end */
ModelBuildList = function ModelBuildList(version, assistantSid) {
  /* jshint ignore:start */
  /**
   * @function modelBuilds
   * @memberof Twilio.Preview.Understand.AssistantContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Understand.AssistantContext.ModelBuildContext}
   */
  /* jshint ignore:end */
  function ModelBuildListInstance(sid) {
    return ModelBuildListInstance.get(sid);
  }

  ModelBuildListInstance._version = version;
  // Path Solution
  ModelBuildListInstance._solution = {assistantSid: assistantSid};
  ModelBuildListInstance._uri = `/Assistants/${assistantSid}/ModelBuilds`;
  /* jshint ignore:start */
  /**
   * Streams ModelBuildInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  ModelBuildListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists ModelBuildInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ModelBuildListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of ModelBuildInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ModelBuildListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ModelBuildPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of ModelBuildInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ModelBuildListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new ModelBuildPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a ModelBuildInstance
   *
   * @function create
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.statusCallback] - The status_callback
   * @param {string} [opts.uniqueName] -
   *          A user-provided string that uniquely identifies this resource as an alternative to the sid. Unique up to 64 characters long. For example: v0.1
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed ModelBuildInstance
   */
  /* jshint ignore:end */
  ModelBuildListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'StatusCallback': _.get(opts, 'statusCallback'),
      'UniqueName': _.get(opts, 'uniqueName')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ModelBuildInstance(
        this._version,
        payload,
        this._solution.assistantSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a model_build
   *
   * @function get
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @param {string} sid - The sid
   *
   * @returns {Twilio.Preview.Understand.AssistantContext.ModelBuildContext}
   */
  /* jshint ignore:end */
  ModelBuildListInstance.get = function get(sid) {
    return new ModelBuildContext(this._version, this._solution.assistantSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  ModelBuildListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  ModelBuildListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return ModelBuildListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the ModelBuildPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.ModelBuildPage
 *
 * @param {Understand} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {ModelBuildSolution} solution - Path solution
 *
 * @returns ModelBuildPage
 */
/* jshint ignore:end */
ModelBuildPage = function ModelBuildPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(ModelBuildPage.prototype, Page.prototype);
ModelBuildPage.prototype.constructor = ModelBuildPage;

/* jshint ignore:start */
/**
 * Build an instance of ModelBuildInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildPage#
 *
 * @param {ModelBuildPayload} payload - Payload response from the API
 *
 * @returns ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildPage.prototype.getInstance = function getInstance(payload) {
  return new ModelBuildInstance(this._version, payload, this._solution.assistantSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
ModelBuildPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ModelBuildPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ModelBuildContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.ModelBuildInstance
 *
 * @property {string} accountSid -
 *          The unique ID of the Account that created this Model Build.
 * @property {Date} dateCreated - The date that this resource was created
 * @property {Date} dateUpdated - The date that this resource was last updated
 * @property {string} assistantSid - The unique ID of the parent Assistant.
 * @property {string} sid -
 *          A 34 character string that uniquely identifies this resource.
 * @property {model_build.status} status -
 *          A string that described the model build status. The values can be: enqueued, building, completed, failed
 * @property {string} uniqueName -
 *          A user-provided string that uniquely identifies this resource as an alternative to the sid. Unique up to 64 characters long.
 * @property {string} url - The url
 * @property {number} buildDuration -
 *          The time in seconds it took to build the model.
 * @property {number} errorCode - The error_code
 *
 * @param {Understand} version - Version of the resource
 * @param {ModelBuildPayload} payload - The instance payload
 * @param {sid} assistantSid - The unique ID of the parent Assistant.
 * @param {sid_like} sid - The sid
 */
/* jshint ignore:end */
ModelBuildInstance = function ModelBuildInstance(version, payload, assistantSid,
                                                  sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.assistantSid = payload.assistant_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.buildDuration = deserialize.integer(payload.build_duration); // jshint ignore:line
  this.errorCode = deserialize.integer(payload.error_code); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {assistantSid: assistantSid, sid: sid || this.sid, };
};

Object.defineProperty(ModelBuildInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new ModelBuildContext(
          this._version,
          this._solution.assistantSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a ModelBuildInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a ModelBuildInstance
 *
 * @function update
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.uniqueName] -
 *          A user-provided string that uniquely identifies this resource as an alternative to the sid. Unique up to 64 characters long. For example: v0.1
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a ModelBuildInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
ModelBuildInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ModelBuildInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ModelBuildContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.ModelBuildContext
 *
 * @param {Understand} version - Version of the resource
 * @param {sid_like} assistantSid - The assistant_sid
 * @param {sid_like} sid - The sid
 */
/* jshint ignore:end */
ModelBuildContext = function ModelBuildContext(version, assistantSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {assistantSid: assistantSid, sid: sid, };
  this._uri = `/Assistants/${assistantSid}/ModelBuilds/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a ModelBuildInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new ModelBuildInstance(
      this._version,
      payload,
      this._solution.assistantSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a ModelBuildInstance
 *
 * @function update
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.uniqueName] -
 *          A user-provided string that uniquely identifies this resource as an alternative to the sid. Unique up to 64 characters long. For example: v0.1
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'UniqueName': _.get(opts, 'uniqueName')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new ModelBuildInstance(
      this._version,
      payload,
      this._solution.assistantSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a ModelBuildInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ModelBuildInstance
 */
/* jshint ignore:end */
ModelBuildContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.ModelBuildContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
ModelBuildContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

ModelBuildContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  ModelBuildList: ModelBuildList,
  ModelBuildPage: ModelBuildPage,
  ModelBuildInstance: ModelBuildInstance,
  ModelBuildContext: ModelBuildContext
};
