'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var VerificationCheckList;
var VerificationCheckPage;
var VerificationCheckInstance;

/* jshint ignore:start */
/**
 * Initialize the VerificationCheckList
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationCheckList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
VerificationCheckList = function VerificationCheckList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function verificationChecks
   * @memberof Twilio.Verify.V2.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext.VerificationCheckContext}
   */
  /* jshint ignore:end */
  function VerificationCheckListInstance(sid) {
    return VerificationCheckListInstance.get(sid);
  }

  VerificationCheckListInstance._version = version;
  // Path Solution
  VerificationCheckListInstance._solution = {serviceSid: serviceSid};
  VerificationCheckListInstance._uri = `/Services/${serviceSid}/VerificationCheck`;
  /* jshint ignore:start */
  /**
   * create a VerificationCheckInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceContext.VerificationCheckList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.code - The verification string
   * @param {string} [opts.to] - The phone number or email to verify
   * @param {string} [opts.verificationSid] -
   *          A SID that uniquely identifies the Verification Check
   * @param {string} [opts.amount] -
   *          The amount of the associated PSD2 compliant transaction.
   * @param {string} [opts.payee] -
   *          The payee of the associated PSD2 compliant transaction
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed VerificationCheckInstance
   */
  /* jshint ignore:end */
  VerificationCheckListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.code)) {
      throw new Error('Required parameter "opts.code" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Code': _.get(opts, 'code'),
      'To': _.get(opts, 'to'),
      'VerificationSid': _.get(opts, 'verificationSid'),
      'Amount': _.get(opts, 'amount'),
      'Payee': _.get(opts, 'payee')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new VerificationCheckInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceContext.VerificationCheckList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  VerificationCheckListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  VerificationCheckListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return VerificationCheckListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the VerificationCheckPage
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationCheckPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {VerificationCheckSolution} solution - Path solution
 *
 * @returns VerificationCheckPage
 */
/* jshint ignore:end */
VerificationCheckPage = function VerificationCheckPage(version, response,
                                                        solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(VerificationCheckPage.prototype, Page.prototype);
VerificationCheckPage.prototype.constructor = VerificationCheckPage;

/* jshint ignore:start */
/**
 * Build an instance of VerificationCheckInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationCheckPage#
 *
 * @param {VerificationCheckPayload} payload - Payload response from the API
 *
 * @returns VerificationCheckInstance
 */
/* jshint ignore:end */
VerificationCheckPage.prototype.getInstance = function getInstance(payload) {
  return new VerificationCheckInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationCheckPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationCheckPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationCheckPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationCheckContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationCheckInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} to - The phone number or email being verified
 * @property {verification_check.channel} channel - The verification method to use
 * @property {string} status - The status of the verification resource
 * @property {boolean} valid - Whether the verification was successful
 * @property {string} amount -
 *          The amount of the associated PSD2 compliant transaction.
 * @property {string} payee -
 *          The payee of the associated PSD2 compliant transaction
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the Verification Check resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the Verification Check resource was last updated
 *
 * @param {V2} version - Version of the resource
 * @param {VerificationCheckPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
VerificationCheckInstance = function VerificationCheckInstance(version, payload,
    serviceSid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.to = payload.to; // jshint ignore:line
  this.channel = payload.channel; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.valid = payload.valid; // jshint ignore:line
  this.amount = payload.amount; // jshint ignore:line
  this.payee = payload.payee; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationCheckInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationCheckInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationCheckInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  VerificationCheckList: VerificationCheckList,
  VerificationCheckPage: VerificationCheckPage,
  VerificationCheckInstance: VerificationCheckInstance
};
