/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2 = require('../../../V2');
import { SerializableClass } from '../../../../../interfaces';

type EvaluationStatus = 'compliant'|'noncompliant';

/**
 * Initialize the EvaluationList
 *
 * @param version - Version of the resource
 * @param bundleSid - The unique string that identifies the resource
 */
declare function EvaluationList(version: V2, bundleSid: string): EvaluationListInstance;

interface EvaluationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): EvaluationContext;
  /**
   * create a EvaluationInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: EvaluationInstance) => any): Promise<EvaluationInstance>;
  /**
   * Streams EvaluationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: EvaluationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams EvaluationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: EvaluationListInstanceEachOptions, callback?: (item: EvaluationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a evaluation
   *
   * @param sid - The unique string that identifies the Evaluation resource
   */
  get(sid: string): EvaluationContext;
  /**
   * Retrieve a single target page of EvaluationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: EvaluationPage) => any): Promise<EvaluationPage>;
  /**
   * Retrieve a single target page of EvaluationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: EvaluationPage) => any): Promise<EvaluationPage>;
  /**
   * Lists EvaluationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: EvaluationInstance[]) => any): Promise<EvaluationInstance[]>;
  /**
   * Lists EvaluationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: EvaluationListInstanceOptions, callback?: (error: Error | null, items: EvaluationInstance[]) => any): Promise<EvaluationInstance[]>;
  /**
   * Retrieve a single page of EvaluationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: EvaluationPage) => any): Promise<EvaluationPage>;
  /**
   * Retrieve a single page of EvaluationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: EvaluationListInstancePageOptions, callback?: (error: Error | null, items: EvaluationPage) => any): Promise<EvaluationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface EvaluationListInstanceEachOptions {
  callback?: (item: EvaluationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface EvaluationListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface EvaluationListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface EvaluationPayload extends EvaluationResource, Page.TwilioResponsePayload {
}

interface EvaluationResource {
  account_sid: string;
  bundle_sid: string;
  date_created: Date;
  regulation_sid: string;
  results: object[];
  sid: string;
  status: EvaluationStatus;
  url: string;
}

interface EvaluationSolution {
  bundleSid?: string;
}


declare class EvaluationContext {
  /**
   * Initialize the EvaluationContext
   *
   * @param version - Version of the resource
   * @param bundleSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the Evaluation resource
   */
  constructor(version: V2, bundleSid: string, sid: string);

  /**
   * fetch a EvaluationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EvaluationInstance) => any): Promise<EvaluationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class EvaluationInstance extends SerializableClass {
  /**
   * Initialize the EvaluationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param bundleSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the Evaluation resource
   */
  constructor(version: V2, payload: EvaluationPayload, bundleSid: string, sid: string);

  private _proxy: EvaluationContext;
  accountSid: string;
  bundleSid: string;
  dateCreated: Date;
  /**
   * fetch a EvaluationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EvaluationInstance) => any): Promise<EvaluationInstance>;
  regulationSid: string;
  results: object[];
  sid: string;
  status: EvaluationStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class EvaluationPage extends Page<V2, EvaluationPayload, EvaluationResource, EvaluationInstance> {
  /**
   * Initialize the EvaluationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: EvaluationSolution);

  /**
   * Build an instance of EvaluationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: EvaluationPayload): EvaluationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { EvaluationContext, EvaluationInstance, EvaluationList, EvaluationListInstance, EvaluationListInstanceEachOptions, EvaluationListInstanceOptions, EvaluationListInstancePageOptions, EvaluationPage, EvaluationPayload, EvaluationResource, EvaluationSolution, EvaluationStatus }
