/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2 = require('../../../V2');
import { SerializableClass } from '../../../../../interfaces';

type BundleCopyEndUserType = 'individual'|'business';

type BundleCopyStatus = 'draft'|'pending-review'|'in-review'|'twilio-rejected'|'twilio-approved'|'provisionally-approved';

/**
 * Initialize the BundleCopyList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param bundleSid - The unique string that identifies the resource.
 */
declare function BundleCopyList(version: V2, bundleSid: string): BundleCopyListInstance;

interface BundleCopyListInstance {
  /**
   * create a BundleCopyInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: BundleCopyInstance) => any): Promise<BundleCopyInstance>;
  /**
   * create a BundleCopyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: BundleCopyListInstanceCreateOptions, callback?: (error: Error | null, item: BundleCopyInstance) => any): Promise<BundleCopyInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property friendlyName - The string that you assigned to describe the copied bundle
 */
interface BundleCopyListInstanceCreateOptions {
  friendlyName?: string;
}

interface BundleCopyPayload extends BundleCopyResource, Page.TwilioResponsePayload {
}

interface BundleCopyResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  email: string;
  friendly_name: string;
  regulation_sid: string;
  sid: string;
  status: BundleCopyStatus;
  status_callback: string;
  valid_until: Date;
}

interface BundleCopySolution {
  bundleSid?: string;
}


declare class BundleCopyInstance extends SerializableClass {
  /**
   * Initialize the BundleCopyContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param bundleSid - The unique string that identifies the resource.
   */
  constructor(version: V2, payload: BundleCopyPayload, bundleSid: string);

  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  email: string;
  friendlyName: string;
  regulationSid: string;
  sid: string;
  status: BundleCopyStatus;
  statusCallback: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  validUntil: Date;
}


declare class BundleCopyPage extends Page<V2, BundleCopyPayload, BundleCopyResource, BundleCopyInstance> {
  /**
   * Initialize the BundleCopyPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: BundleCopySolution);

  /**
   * Build an instance of BundleCopyInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BundleCopyPayload): BundleCopyInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BundleCopyEndUserType, BundleCopyInstance, BundleCopyList, BundleCopyListInstance, BundleCopyListInstanceCreateOptions, BundleCopyPage, BundleCopyPayload, BundleCopyResource, BundleCopySolution, BundleCopyStatus }
