'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var FeedbackSummaryList;
var FeedbackSummaryPage;
var FeedbackSummaryInstance;
var FeedbackSummaryContext;

/* jshint ignore:start */
/**
 * Initialize the FeedbackSummaryList
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created this resource
 */
/* jshint ignore:end */
FeedbackSummaryList = function FeedbackSummaryList(version, accountSid) {
  /* jshint ignore:start */
  /**
   * @function feedbackSummaries
   * @memberof Twilio.Api.V2010.AccountContext.CallContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryContext}
   */
  /* jshint ignore:end */
  function FeedbackSummaryListInstance(sid) {
    return FeedbackSummaryListInstance.get(sid);
  }

  FeedbackSummaryListInstance._version = version;
  // Path Solution
  FeedbackSummaryListInstance._solution = {accountSid: accountSid};
  FeedbackSummaryListInstance._uri = `/Accounts/${accountSid}/Calls/FeedbackSummary.json`;
  /* jshint ignore:start */
  /**
   * create a FeedbackSummaryInstance
   *
   * @function create
   * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryList#
   *
   * @param {object} opts - Options for request
   * @param {Date} opts.startDate - Only include feedback given on or after this date
   * @param {Date} opts.endDate - Only include feedback given on or before this date
   * @param {boolean} [opts.includeSubaccounts] -
   *          `true` includes feedback from the specified account and its subaccounts
   * @param {string} [opts.statusCallback] -
   *          The URL that we will request when the feedback summary is complete
   * @param {string} [opts.statusCallbackMethod] -
   *          The HTTP method we use to make requests to the StatusCallback URL
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed FeedbackSummaryInstance
   */
  /* jshint ignore:end */
  FeedbackSummaryListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.startDate)) {
      throw new Error('Required parameter "opts.startDate" missing.');
    }
    if (_.isUndefined(opts.endDate)) {
      throw new Error('Required parameter "opts.endDate" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'StartDate': serialize.iso8601Date(_.get(opts, 'startDate')),
      'EndDate': serialize.iso8601Date(_.get(opts, 'endDate')),
      'IncludeSubaccounts': serialize.bool(_.get(opts, 'includeSubaccounts')),
      'StatusCallback': _.get(opts, 'statusCallback'),
      'StatusCallbackMethod': _.get(opts, 'statusCallbackMethod')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FeedbackSummaryInstance(
        this._version,
        payload,
        this._solution.accountSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a feedback_summary
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryList#
   *
   * @param {string} sid -
   *          A string that uniquely identifies this feedback summary resource
   *
   * @returns {Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryContext}
   */
  /* jshint ignore:end */
  FeedbackSummaryListInstance.get = function get(sid) {
    return new FeedbackSummaryContext(this._version, this._solution.accountSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FeedbackSummaryListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FeedbackSummaryListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return FeedbackSummaryListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FeedbackSummaryPage
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FeedbackSummarySolution} solution - Path solution
 *
 * @returns FeedbackSummaryPage
 */
/* jshint ignore:end */
FeedbackSummaryPage = function FeedbackSummaryPage(version, response, solution)
                                                    {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FeedbackSummaryPage.prototype, Page.prototype);
FeedbackSummaryPage.prototype.constructor = FeedbackSummaryPage;

/* jshint ignore:start */
/**
 * Build an instance of FeedbackSummaryInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryPage#
 *
 * @param {FeedbackSummaryPayload} payload - Payload response from the API
 *
 * @returns FeedbackSummaryInstance
 */
/* jshint ignore:end */
FeedbackSummaryPage.prototype.getInstance = function getInstance(payload) {
  return new FeedbackSummaryInstance(this._version, payload, this._solution.accountSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FeedbackSummaryPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FeedbackSummaryPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FeedbackSummaryContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryInstance
 *
 * @property {string} accountSid - The unique sid that identifies this account
 * @property {number} callCount - The total number of calls
 * @property {number} callFeedbackCount -
 *          The total number of calls with a feedback entry
 * @property {Date} dateCreated - The date this resource was created
 * @property {Date} dateUpdated - The date this resource was last updated
 * @property {Date} endDate - The latest feedback entry date in the summary
 * @property {boolean} includeSubaccounts -
 *          Whether the feedback summary includes subaccounts
 * @property {object} issues - Issues experienced during the call
 * @property {number} qualityScoreAverage -
 *          The average QualityScore of the feedback entries
 * @property {number} qualityScoreMedian -
 *          The median QualityScore of the feedback entries
 * @property {number} qualityScoreStandardDeviation -
 *          The standard deviation of the quality scores
 * @property {string} sid - A string that uniquely identifies this feedback entry
 * @property {Date} startDate - The earliest feedback entry date in the summary
 * @property {feedback_summary.status} status - The status of the feedback summary
 *
 * @param {V2010} version - Version of the resource
 * @param {FeedbackSummaryPayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created this resource
 * @param {sid} sid -
 *          A string that uniquely identifies this feedback summary resource
 */
/* jshint ignore:end */
FeedbackSummaryInstance = function FeedbackSummaryInstance(version, payload,
                                                            accountSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.callCount = deserialize.integer(payload.call_count); // jshint ignore:line
  this.callFeedbackCount = deserialize.integer(payload.call_feedback_count); // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.endDate = deserialize.iso8601Date(payload.end_date); // jshint ignore:line
  this.includeSubaccounts = payload.include_subaccounts; // jshint ignore:line
  this.issues = payload.issues; // jshint ignore:line
  this.qualityScoreAverage = deserialize.decimal(payload.quality_score_average); // jshint ignore:line
  this.qualityScoreMedian = deserialize.decimal(payload.quality_score_median); // jshint ignore:line
  this.qualityScoreStandardDeviation = deserialize.decimal(payload.quality_score_standard_deviation); // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.startDate = deserialize.iso8601Date(payload.start_date); // jshint ignore:line
  this.status = payload.status; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, sid: sid || this.sid, };
};

Object.defineProperty(FeedbackSummaryInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new FeedbackSummaryContext(
          this._version,
          this._solution.accountSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a FeedbackSummaryInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FeedbackSummaryInstance
 */
/* jshint ignore:end */
FeedbackSummaryInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a FeedbackSummaryInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FeedbackSummaryInstance
 */
/* jshint ignore:end */
FeedbackSummaryInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FeedbackSummaryInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FeedbackSummaryInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FeedbackSummaryContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryContext
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid - The unique sid that identifies this account
 * @param {sid} sid -
 *          A string that uniquely identifies this feedback summary resource
 */
/* jshint ignore:end */
FeedbackSummaryContext = function FeedbackSummaryContext(version, accountSid,
                                                          sid) {
  this._version = version;

  // Path Solution
  this._solution = {accountSid: accountSid, sid: sid, };
  this._uri = `/Accounts/${accountSid}/Calls/FeedbackSummary/${sid}.json`;
};

/* jshint ignore:start */
/**
 * fetch a FeedbackSummaryInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FeedbackSummaryInstance
 */
/* jshint ignore:end */
FeedbackSummaryContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new FeedbackSummaryInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a FeedbackSummaryInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FeedbackSummaryInstance
 */
/* jshint ignore:end */
FeedbackSummaryContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.CallContext.FeedbackSummaryContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
FeedbackSummaryContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

FeedbackSummaryContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FeedbackSummaryList: FeedbackSummaryList,
  FeedbackSummaryPage: FeedbackSummaryPage,
  FeedbackSummaryInstance: FeedbackSummaryInstance,
  FeedbackSummaryContext: FeedbackSummaryContext
};
