/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';
import { SyncMapItemList } from './syncMap/syncMapItem';
import { SyncMapItemListInstance } from './syncMap/syncMapItem';
import { SyncMapPermissionList } from './syncMap/syncMapPermission';
import { SyncMapPermissionListInstance } from './syncMap/syncMapPermission';

/**
 * Initialize the SyncMapList
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Sync Service that the resource is associated with
 */
declare function SyncMapList(version: V1, serviceSid: string): SyncMapListInstance;

/**
 * Options to pass to update
 *
 * @property collectionTtl - How long, in seconds, before the Sync Map expires and is deleted
 * @property ttl - An alias for collection_ttl
 */
interface SyncMapInstanceUpdateOptions {
  collectionTtl?: number;
  ttl?: number;
}

interface SyncMapListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SyncMapContext;
  /**
   * create a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: SyncMapInstance) => any): Promise<SyncMapInstance>;
  /**
   * create a SyncMapInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: SyncMapListInstanceCreateOptions, callback?: (error: Error | null, item: SyncMapInstance) => any): Promise<SyncMapInstance>;
  /**
   * Streams SyncMapInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: SyncMapInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams SyncMapInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SyncMapListInstanceEachOptions, callback?: (item: SyncMapInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a sync_map
   *
   * @param sid - The SID of the Sync Map resource to fetch
   */
  get(sid: string): SyncMapContext;
  /**
   * Retrieve a single target page of SyncMapInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: SyncMapPage) => any): Promise<SyncMapPage>;
  /**
   * Retrieve a single target page of SyncMapInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SyncMapPage) => any): Promise<SyncMapPage>;
  /**
   * Lists SyncMapInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: SyncMapInstance[]) => any): Promise<SyncMapInstance[]>;
  /**
   * Lists SyncMapInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SyncMapListInstanceOptions, callback?: (error: Error | null, items: SyncMapInstance[]) => any): Promise<SyncMapInstance[]>;
  /**
   * Retrieve a single page of SyncMapInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: SyncMapPage) => any): Promise<SyncMapPage>;
  /**
   * Retrieve a single page of SyncMapInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SyncMapListInstancePageOptions, callback?: (error: Error | null, items: SyncMapPage) => any): Promise<SyncMapPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property collectionTtl - How long, in seconds, before the Sync Map expires and is deleted
 * @property ttl - An alias for collection_ttl
 * @property uniqueName - An application-defined string that uniquely identifies the resource
 */
interface SyncMapListInstanceCreateOptions {
  collectionTtl?: number;
  ttl?: number;
  uniqueName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface SyncMapListInstanceEachOptions {
  callback?: (item: SyncMapInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface SyncMapListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface SyncMapListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface SyncMapPayload extends SyncMapResource, Page.TwilioResponsePayload {
}

interface SyncMapResource {
  account_sid: string;
  created_by: string;
  date_created: Date;
  date_expires: Date;
  date_updated: Date;
  links: string;
  revision: string;
  service_sid: string;
  sid: string;
  unique_name: string;
  url: string;
}

interface SyncMapSolution {
  serviceSid?: string;
}


declare class SyncMapContext {
  /**
   * Initialize the SyncMapContext
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Sync Service with the Sync Map resource to fetch
   * @param sid - The SID of the Sync Map resource to fetch
   */
  constructor(version: V1, serviceSid: string, sid: string);

  /**
   * fetch a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<SyncMapInstance>;
  /**
   * remove a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<boolean>;
  syncMapItems: SyncMapItemListInstance;
  syncMapPermissions: SyncMapPermissionListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<SyncMapInstance>;
  /**
   * update a SyncMapInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SyncMapInstanceUpdateOptions, callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<SyncMapInstance>;
}


declare class SyncMapInstance extends SerializableClass {
  /**
   * Initialize the SyncMapContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Sync Service that the resource is associated with
   * @param sid - The SID of the Sync Map resource to fetch
   */
  constructor(version: V1, payload: SyncMapPayload, serviceSid: string, sid: string);

  private _proxy: SyncMapContext;
  accountSid: string;
  createdBy: string;
  dateCreated: Date;
  dateExpires: Date;
  dateUpdated: Date;
  /**
   * fetch a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<SyncMapInstance>;
  links: string;
  /**
   * remove a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<boolean>;
  revision: string;
  serviceSid: string;
  sid: string;
  /**
   * Access the syncMapItems
   */
  syncMapItems(): SyncMapItemListInstance;
  /**
   * Access the syncMapPermissions
   */
  syncMapPermissions(): SyncMapPermissionListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  /**
   * update a SyncMapInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<SyncMapInstance>;
  /**
   * update a SyncMapInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SyncMapInstanceUpdateOptions, callback?: (error: Error | null, items: SyncMapInstance) => any): Promise<SyncMapInstance>;
  url: string;
}


declare class SyncMapPage extends Page<V1, SyncMapPayload, SyncMapResource, SyncMapInstance> {
  /**
   * Initialize the SyncMapPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SyncMapSolution);

  /**
   * Build an instance of SyncMapInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SyncMapPayload): SyncMapInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SyncMapContext, SyncMapInstance, SyncMapInstanceUpdateOptions, SyncMapList, SyncMapListInstance, SyncMapListInstanceCreateOptions, SyncMapListInstanceEachOptions, SyncMapListInstanceOptions, SyncMapListInstancePageOptions, SyncMapPage, SyncMapPayload, SyncMapResource, SyncMapSolution }
