/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the WorkerStatisticsList
 *
 * @param version - Version of the resource
 * @param workspaceSid - The SID of the Workspace that contains the WorkerChannel
 * @param workerSid - The SID of the Worker that contains the WorkerChannel
 */
declare function WorkerStatisticsList(version: V1, workspaceSid: string, workerSid: string): WorkerStatisticsListInstance;

/**
 * Options to pass to fetch
 *
 * @property endDate - Only include usage that occurred on or before this date
 * @property minutes - Only calculate statistics since this many minutes in the past
 * @property startDate - Only calculate statistics from on or after this date
 * @property taskChannel - Only calculate statistics on this TaskChannel
 */
interface WorkerStatisticsInstanceFetchOptions {
  endDate?: Date;
  minutes?: number;
  startDate?: Date;
  taskChannel?: string;
}

interface WorkerStatisticsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): WorkerStatisticsContext;
  /**
   * Constructs a worker_statistics
   */
  get(): WorkerStatisticsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface WorkerStatisticsPayload extends WorkerStatisticsResource, Page.TwilioResponsePayload {
}

interface WorkerStatisticsResource {
  account_sid: string;
  cumulative: object;
  url: string;
  worker_sid: string;
  workspace_sid: string;
}

interface WorkerStatisticsSolution {
  workerSid?: string;
  workspaceSid?: string;
}


declare class WorkerStatisticsContext {
  /**
   * Initialize the WorkerStatisticsContext
   *
   * @param version - Version of the resource
   * @param workspaceSid - The SID of the Workspace with the WorkerChannel to fetch
   * @param workerSid - The SID of the Worker with the WorkerChannel to fetch
   */
  constructor(version: V1, workspaceSid: string, workerSid: string);

  /**
   * fetch a WorkerStatisticsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: WorkerStatisticsInstance) => any): Promise<WorkerStatisticsInstance>;
  /**
   * fetch a WorkerStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkerStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkerStatisticsInstance) => any): Promise<WorkerStatisticsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class WorkerStatisticsInstance extends SerializableClass {
  /**
   * Initialize the WorkerStatisticsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param workspaceSid - The SID of the Workspace that contains the WorkerChannel
   * @param workerSid - The SID of the Worker that contains the WorkerChannel
   */
  constructor(version: V1, payload: WorkerStatisticsPayload, workspaceSid: string, workerSid: string);

  private _proxy: WorkerStatisticsContext;
  accountSid: string;
  cumulative: any;
  /**
   * fetch a WorkerStatisticsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: WorkerStatisticsInstance) => any): Promise<WorkerStatisticsInstance>;
  /**
   * fetch a WorkerStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkerStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkerStatisticsInstance) => any): Promise<WorkerStatisticsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  workerSid: string;
  workspaceSid: string;
}


declare class WorkerStatisticsPage extends Page<V1, WorkerStatisticsPayload, WorkerStatisticsResource, WorkerStatisticsInstance> {
  /**
   * Initialize the WorkerStatisticsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: WorkerStatisticsSolution);

  /**
   * Build an instance of WorkerStatisticsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: WorkerStatisticsPayload): WorkerStatisticsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { WorkerStatisticsContext, WorkerStatisticsInstance, WorkerStatisticsInstanceFetchOptions, WorkerStatisticsList, WorkerStatisticsListInstance, WorkerStatisticsPage, WorkerStatisticsPayload, WorkerStatisticsResource, WorkerStatisticsSolution }
