/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

type DeliveryReceiptDeliveryStatus = 'read'|'failed'|'delivered'|'undelivered'|'sent';

/**
 * Initialize the DeliveryReceiptList
 *
 * @param version - Version of the resource
 * @param conversationSid - The unique ID of the Conversation for this message.
 * @param messageSid - The SID of the message the delivery receipt belongs to
 */
declare function DeliveryReceiptList(version: V1, conversationSid: string, messageSid: string): DeliveryReceiptListInstance;

interface DeliveryReceiptListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): DeliveryReceiptContext;
  /**
   * Streams DeliveryReceiptInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: DeliveryReceiptInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams DeliveryReceiptInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: DeliveryReceiptListInstanceEachOptions, callback?: (item: DeliveryReceiptInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a delivery_receipt
   *
   * @param sid - A 34 character string that uniquely identifies this resource.
   */
  get(sid: string): DeliveryReceiptContext;
  /**
   * Retrieve a single target page of DeliveryReceiptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: DeliveryReceiptPage) => any): Promise<DeliveryReceiptPage>;
  /**
   * Retrieve a single target page of DeliveryReceiptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: DeliveryReceiptPage) => any): Promise<DeliveryReceiptPage>;
  /**
   * Lists DeliveryReceiptInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: DeliveryReceiptInstance[]) => any): Promise<DeliveryReceiptInstance[]>;
  /**
   * Lists DeliveryReceiptInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: DeliveryReceiptListInstanceOptions, callback?: (error: Error | null, items: DeliveryReceiptInstance[]) => any): Promise<DeliveryReceiptInstance[]>;
  /**
   * Retrieve a single page of DeliveryReceiptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: DeliveryReceiptPage) => any): Promise<DeliveryReceiptPage>;
  /**
   * Retrieve a single page of DeliveryReceiptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: DeliveryReceiptListInstancePageOptions, callback?: (error: Error | null, items: DeliveryReceiptPage) => any): Promise<DeliveryReceiptPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface DeliveryReceiptListInstanceEachOptions {
  callback?: (item: DeliveryReceiptInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface DeliveryReceiptListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface DeliveryReceiptListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface DeliveryReceiptPayload extends DeliveryReceiptResource, Page.TwilioResponsePayload {
}

interface DeliveryReceiptResource {
  account_sid: string;
  channel_message_sid: string;
  conversation_sid: string;
  date_created: Date;
  date_updated: Date;
  error_code: number;
  message_sid: string;
  participant_sid: string;
  sid: string;
  status: DeliveryReceiptDeliveryStatus;
  url: string;
}

interface DeliveryReceiptSolution {
  conversationSid?: string;
  messageSid?: string;
}


declare class DeliveryReceiptContext {
  /**
   * Initialize the DeliveryReceiptContext
   *
   * @param version - Version of the resource
   * @param conversationSid - The unique ID of the Conversation for this delivery receipt.
   * @param messageSid - The SID of the message the delivery receipt belongs to.
   * @param sid - A 34 character string that uniquely identifies this resource.
   */
  constructor(version: V1, conversationSid: string, messageSid: string, sid: string);

  /**
   * fetch a DeliveryReceiptInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DeliveryReceiptInstance) => any): Promise<DeliveryReceiptInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class DeliveryReceiptInstance extends SerializableClass {
  /**
   * Initialize the DeliveryReceiptContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param conversationSid - The unique ID of the Conversation for this message.
   * @param messageSid - The SID of the message the delivery receipt belongs to
   * @param sid - A 34 character string that uniquely identifies this resource.
   */
  constructor(version: V1, payload: DeliveryReceiptPayload, conversationSid: string, messageSid: string, sid: string);

  private _proxy: DeliveryReceiptContext;
  accountSid: string;
  channelMessageSid: string;
  conversationSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  errorCode: number;
  /**
   * fetch a DeliveryReceiptInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DeliveryReceiptInstance) => any): Promise<DeliveryReceiptInstance>;
  messageSid: string;
  participantSid: string;
  sid: string;
  status: DeliveryReceiptDeliveryStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class DeliveryReceiptPage extends Page<V1, DeliveryReceiptPayload, DeliveryReceiptResource, DeliveryReceiptInstance> {
  /**
   * Initialize the DeliveryReceiptPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: DeliveryReceiptSolution);

  /**
   * Build an instance of DeliveryReceiptInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: DeliveryReceiptPayload): DeliveryReceiptInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { DeliveryReceiptContext, DeliveryReceiptDeliveryStatus, DeliveryReceiptInstance, DeliveryReceiptList, DeliveryReceiptListInstance, DeliveryReceiptListInstanceEachOptions, DeliveryReceiptListInstanceOptions, DeliveryReceiptListInstancePageOptions, DeliveryReceiptPage, DeliveryReceiptPayload, DeliveryReceiptResource, DeliveryReceiptSolution }
