'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var WorkspaceStatisticsList;
var WorkspaceStatisticsPage;
var WorkspaceStatisticsInstance;
var WorkspaceStatisticsContext;

/* jshint ignore:start */
/**
 * Initialize the WorkspaceStatisticsList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 * @param {string} workspaceSid - The SID of the Workspace
 */
/* jshint ignore:end */
WorkspaceStatisticsList = function WorkspaceStatisticsList(version,
                                                            workspaceSid) {
  /* jshint ignore:start */
  /**
   * @function statistics
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsContext}
   */
  /* jshint ignore:end */
  function WorkspaceStatisticsListInstance(sid) {
    return WorkspaceStatisticsListInstance.get(sid);
  }

  WorkspaceStatisticsListInstance._version = version;
  // Path Solution
  WorkspaceStatisticsListInstance._solution = {workspaceSid: workspaceSid};
  /* jshint ignore:start */
  /**
   * Constructs a workspace_statistics
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsList#
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsContext}
   */
  /* jshint ignore:end */
  WorkspaceStatisticsListInstance.get = function get() {
    return new WorkspaceStatisticsContext(this._version, this._solution.workspaceSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WorkspaceStatisticsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WorkspaceStatisticsListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return WorkspaceStatisticsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WorkspaceStatisticsPage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WorkspaceStatisticsSolution} solution - Path solution
 *
 * @returns WorkspaceStatisticsPage
 */
/* jshint ignore:end */
WorkspaceStatisticsPage = function WorkspaceStatisticsPage(version, response,
                                                            solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WorkspaceStatisticsPage.prototype, Page.prototype);
WorkspaceStatisticsPage.prototype.constructor = WorkspaceStatisticsPage;

/* jshint ignore:start */
/**
 * Build an instance of WorkspaceStatisticsInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsPage#
 *
 * @param {WorkspaceStatisticsPayload} payload - Payload response from the API
 *
 * @returns WorkspaceStatisticsInstance
 */
/* jshint ignore:end */
WorkspaceStatisticsPage.prototype.getInstance = function getInstance(payload) {
  return new WorkspaceStatisticsInstance(this._version, payload, this._solution.workspaceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkspaceStatisticsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkspaceStatisticsPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkspaceStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsInstance
 *
 * @property {object} realtime -
 *          n object that contains the real-time statistics for the Workspace
 * @property {object} cumulative -
 *          An object that contains the cumulative statistics for the Workspace
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} workspaceSid - The SID of the Workspace
 * @property {string} url - The absolute URL of the Workspace statistics resource
 *
 * @param {V1} version - Version of the resource
 * @param {WorkspaceStatisticsPayload} payload - The instance payload
 * @param {sid} workspaceSid - The SID of the Workspace
 */
/* jshint ignore:end */
WorkspaceStatisticsInstance = function WorkspaceStatisticsInstance(version,
    payload, workspaceSid) {
  this._version = version;

  // Marshaled Properties
  this.realtime = payload.realtime; // jshint ignore:line
  this.cumulative = payload.cumulative; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.workspaceSid = payload.workspace_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {workspaceSid: workspaceSid, };
};

Object.defineProperty(WorkspaceStatisticsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WorkspaceStatisticsContext(this._version, this._solution.workspaceSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a WorkspaceStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from this date and time and earlier
 * @param {string} [opts.taskChannel] -
 *          Only calculate statistics on this TaskChannel.
 * @param {string} [opts.splitByWaitTime] -
 *          A comma separated list of values that describes the thresholds to calculate statistics on
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceStatisticsInstance
 */
/* jshint ignore:end */
WorkspaceStatisticsInstance.prototype.fetch = function fetch(opts, callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkspaceStatisticsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkspaceStatisticsInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkspaceStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} workspaceSid - The SID of the Workspace to fetch
 */
/* jshint ignore:end */
WorkspaceStatisticsContext = function WorkspaceStatisticsContext(version,
    workspaceSid) {
  this._version = version;

  // Path Solution
  this._solution = {workspaceSid: workspaceSid, };
  this._uri = `/Workspaces/${workspaceSid}/Statistics`;
};

/* jshint ignore:start */
/**
 * fetch a WorkspaceStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from this date and time and earlier
 * @param {string} [opts.taskChannel] -
 *          Only calculate statistics on this TaskChannel.
 * @param {string} [opts.splitByWaitTime] -
 *          A comma separated list of values that describes the thresholds to calculate statistics on
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkspaceStatisticsInstance
 */
/* jshint ignore:end */
WorkspaceStatisticsContext.prototype.fetch = function fetch(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Minutes': _.get(opts, 'minutes'),
    'StartDate': serialize.iso8601DateTime(_.get(opts, 'startDate')),
    'EndDate': serialize.iso8601DateTime(_.get(opts, 'endDate')),
    'TaskChannel': _.get(opts, 'taskChannel'),
    'SplitByWaitTime': _.get(opts, 'splitByWaitTime')
  });

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WorkspaceStatisticsInstance(
      this._version,
      payload,
      this._solution.workspaceSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkspaceStatisticsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkspaceStatisticsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WorkspaceStatisticsContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WorkspaceStatisticsList: WorkspaceStatisticsList,
  WorkspaceStatisticsPage: WorkspaceStatisticsPage,
  WorkspaceStatisticsInstance: WorkspaceStatisticsInstance,
  WorkspaceStatisticsContext: WorkspaceStatisticsContext
};
