'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var WorkersStatisticsList;
var WorkersStatisticsPage;
var WorkersStatisticsInstance;
var WorkersStatisticsContext;

/* jshint ignore:start */
/**
 * Initialize the WorkersStatisticsList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 * @param {string} workspaceSid - The SID of the Workspace that contains the Worker
 */
/* jshint ignore:end */
WorkersStatisticsList = function WorkersStatisticsList(version, workspaceSid) {
  /* jshint ignore:start */
  /**
   * @function statistics
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsContext}
   */
  /* jshint ignore:end */
  function WorkersStatisticsListInstance(sid) {
    return WorkersStatisticsListInstance.get(sid);
  }

  WorkersStatisticsListInstance._version = version;
  // Path Solution
  WorkersStatisticsListInstance._solution = {workspaceSid: workspaceSid};
  /* jshint ignore:start */
  /**
   * Constructs a workers_statistics
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsList#
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsContext}
   */
  /* jshint ignore:end */
  WorkersStatisticsListInstance.get = function get() {
    return new WorkersStatisticsContext(this._version, this._solution.workspaceSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WorkersStatisticsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WorkersStatisticsListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return WorkersStatisticsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WorkersStatisticsPage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WorkersStatisticsSolution} solution - Path solution
 *
 * @returns WorkersStatisticsPage
 */
/* jshint ignore:end */
WorkersStatisticsPage = function WorkersStatisticsPage(version, response,
                                                        solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WorkersStatisticsPage.prototype, Page.prototype);
WorkersStatisticsPage.prototype.constructor = WorkersStatisticsPage;

/* jshint ignore:start */
/**
 * Build an instance of WorkersStatisticsInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsPage#
 *
 * @param {WorkersStatisticsPayload} payload - Payload response from the API
 *
 * @returns WorkersStatisticsInstance
 */
/* jshint ignore:end */
WorkersStatisticsPage.prototype.getInstance = function getInstance(payload) {
  return new WorkersStatisticsInstance(this._version, payload, this._solution.workspaceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkersStatisticsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkersStatisticsPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkersStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsInstance
 *
 * @property {object} realtime -
 *          An object that contains the real-time statistics for the Worker
 * @property {object} cumulative -
 *          An object that contains the cumulative statistics for the Worker
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} workspaceSid -
 *          The SID of the Workspace that contains the Worker
 * @property {string} url - The absolute URL of the Worker statistics resource
 *
 * @param {V1} version - Version of the resource
 * @param {WorkersStatisticsPayload} payload - The instance payload
 * @param {sid} workspaceSid - The SID of the Workspace that contains the Worker
 */
/* jshint ignore:end */
WorkersStatisticsInstance = function WorkersStatisticsInstance(version, payload,
    workspaceSid) {
  this._version = version;

  // Marshaled Properties
  this.realtime = payload.realtime; // jshint ignore:line
  this.cumulative = payload.cumulative; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.workspaceSid = payload.workspace_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {workspaceSid: workspaceSid, };
};

Object.defineProperty(WorkersStatisticsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WorkersStatisticsContext(this._version, this._solution.workspaceSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a WorkersStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from this date and time and earlier
 * @param {string} [opts.taskQueueSid] -
 *          The SID of the TaskQueue for which to fetch Worker statistics
 * @param {string} [opts.taskQueueName] -
 *          The friendly_name of the TaskQueue for which to fetch Worker statistics
 * @param {string} [opts.friendlyName] -
 *          Only include Workers with `friendly_name` values that match this parameter
 * @param {string} [opts.taskChannel] -
 *          Only calculate statistics on this TaskChannel
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkersStatisticsInstance
 */
/* jshint ignore:end */
WorkersStatisticsInstance.prototype.fetch = function fetch(opts, callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkersStatisticsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkersStatisticsInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkersStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} workspaceSid - The SID of the Workspace with the Worker to fetch
 */
/* jshint ignore:end */
WorkersStatisticsContext = function WorkersStatisticsContext(version,
    workspaceSid) {
  this._version = version;

  // Path Solution
  this._solution = {workspaceSid: workspaceSid, };
  this._uri = `/Workspaces/${workspaceSid}/Workers/Statistics`;
};

/* jshint ignore:start */
/**
 * fetch a WorkersStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from this date and time and earlier
 * @param {string} [opts.taskQueueSid] -
 *          The SID of the TaskQueue for which to fetch Worker statistics
 * @param {string} [opts.taskQueueName] -
 *          The friendly_name of the TaskQueue for which to fetch Worker statistics
 * @param {string} [opts.friendlyName] -
 *          Only include Workers with `friendly_name` values that match this parameter
 * @param {string} [opts.taskChannel] -
 *          Only calculate statistics on this TaskChannel
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkersStatisticsInstance
 */
/* jshint ignore:end */
WorkersStatisticsContext.prototype.fetch = function fetch(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Minutes': _.get(opts, 'minutes'),
    'StartDate': serialize.iso8601DateTime(_.get(opts, 'startDate')),
    'EndDate': serialize.iso8601DateTime(_.get(opts, 'endDate')),
    'TaskQueueSid': _.get(opts, 'taskQueueSid'),
    'TaskQueueName': _.get(opts, 'taskQueueName'),
    'FriendlyName': _.get(opts, 'friendlyName'),
    'TaskChannel': _.get(opts, 'taskChannel')
  });

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WorkersStatisticsInstance(
      this._version,
      payload,
      this._solution.workspaceSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkerContext.WorkersStatisticsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkersStatisticsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WorkersStatisticsContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WorkersStatisticsList: WorkersStatisticsList,
  WorkersStatisticsPage: WorkersStatisticsPage,
  WorkersStatisticsInstance: WorkersStatisticsInstance,
  WorkersStatisticsContext: WorkersStatisticsContext
};
