---
title: "启用多路复用提升网络并发性能"
draft: false
weight: 1
---

### 注意，Trojan不支持这个特性

Trojan-Go支持使用多路复用提升网络并发性能。

Trojan协议基于TLS。在一个TLS安全连接建立之前，连接双方需要进行密钥协商和交换等步骤确保后续通讯的安全性。这个过程即为TLS握手。

目前GFW对于TLS握手存在审查和干扰，同时由于出口网络拥塞的原因，普通的线路完成TLS握手通常需要将近一秒甚至更长的时间。这可能导致浏览网页和观看视频的延迟提高。

Trojan-Go使用多路复用的方式解决这一问题。每个建立的TLS连接将承载多个TCP连接。当新的代理请求到来时，不需要和服务器握手发起一个新的TLS连接，而是尽可能重复使用已有的TLS连接。以此减少频繁TLS握手和TCP握手的带来的延迟。

启用多路复用不会增加你的链路速度（甚至会有所减少），而且可能会增加服务器和客户端的计算负担。可以粗略地理解为，多路复用牺牲网络吞吐和CPU功耗，换取更低的延迟。在高并发的情景下，如浏览含有大量图片的网页时，或者发送大量UDP请求时，可以提升使用体验。

激活```mux```模块，只需要将```mux```选项中```enabled```字段设为true即可，下面是一个客户端的例子

```json
...
"mux" :{
    "enabled": true
}
```

只需要配置客户端即可，服务端可以自动适配，无需配置```mux```选项。

完整的mux配置如下

```json
"mux": {
    "enabled": false,
    "concurrency": 8,
    "idle_timeout": 60
}
```

```concurrency```是每个TLS连接最多可以承载的TCP连接数。这个数值越大，每个TLS连接被复用的程度就更高，握手导致的延迟越低。但服务器和客户端的计算负担也会越大，这有可能使你的网络吞吐量降低。如果你的线路的TLS握手极端缓慢，你可以将这个数值设置为-1，Trojan-Go将只进行一次TLS握手，只使用唯一的一条TLS连接进行传输。

```idle_timeout```指的是每个TLS连接空闲多长时间后关闭。设置超时时间，**可能**有助于减少不必要的长连接存活确认(Keep Alive)流量传输引发GFW的探测。你可以将这个数值设置为-1，TLS连接在空闲时将被立即关闭。
