/*
 * VRT RULES
 *
 * Copyright (C) 2014-2020 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule1939eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
// content:"|01|", depth 1;
static ContentInfo rule1939content0 =
{
    (u_int8_t *)("|01|"), /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule1939option0 =
{
    OPTION_TYPE_CONTENT,
    { &rule1939content0 }
};
/* byte_test:size 1, value 6, operator >, offset 2; */
static ByteData rule1939byte_test1 =
{
    1, /* size */
    CHECK_GT, /* operator */
    6, /* value */
    2, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule1939option1 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule1939byte_test1 }
};

/* references for sid 1939 */
/* reference: cve "1999-0798"; */
static RuleReference rule1939ref1 =
{
    "cve", /* type */
    "1999-0798" /* value */
};

static RuleReference *rule1939refs[] =
{
    &rule1939ref1,
    NULL
};
RuleOption *rule1939options[] =
{
    &rule1939option0,
    &rule1939option1,
    NULL
};

Rule rule1939 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_UDP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "67", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       1939, /* sigid */
       4, /* revision */

       "misc-activity", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "MISC bootp hardware address length overflow",     /* message */
       rule1939refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule1939options, /* ptr to rule options */
   &rule1939eval, /* ptr to rule detection function */
   0, /* am I initialized yet? */
   0,                                  /* Rule option count, used internally */
   0,                                  /* Flag with no alert, used internally */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int rule1939eval(void *p) {
    //const u_int8_t *cursor_uri = 0;
    //const u_int8_t *cursor_raw = 0;
    const u_int8_t *cursor_normal = 0;


    // content:"|01|", depth 1;
    if (contentMatch(p, rule1939options[0]->option_u.content, &cursor_normal) > 0) {
        // byte_test:size 1, value 6, operator >, offset 2;
        if (byteTest(p, rule1939options[1]->option_u.byte, cursor_normal) > 0) {
            return RULE_MATCH;
        }
    }
    return RULE_NOMATCH;
}

