# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_paging_request_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.10 Packet Paging Request
# top-level object: Packet Paging Request message content

# external references
from pycrate_csn1dir.mbms_sessions_list_ie import mbms_sessions_list_ie
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.mbms_channel_parameters_ie import mbms_channel_parameters_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

etws_primary_notification_struct = CSN1List(name='etws_primary_notification_struct', list=[
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='total_no_of_segments_for_etws_primary_notification', bit=4)]),
    '1': ('', [
    CSN1Bit(name='segment_number', bit=4)])}),
  CSN1Bit(name='pni'),
  CSN1Bit(name='length_of_segment', bit=7),
  CSN1Bit(name='etws_primary_notification_data', bit=([2], lambda x: x))])

repeated_page_info_struct = CSN1Alt(name='repeated_page_info_struct', alt={
  '0': ('', [
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='ptmsi', bit=32)]),
    '1': ('', [
    CSN1Bit(name='length_of_mobile_identity_contents', bit=4),
    CSN1Bit(name='mobile_identity', bit=8, num=([1], lambda x: x))])})]),
  '1': ('', [
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='tmsi', bit=32)]),
    '1': ('', [
    CSN1Bit(name='length_of_mobile_identity_contents', bit=4),
    CSN1Bit(name='mobile_identity', bit=8, num=([1], lambda x: x))])}),
  CSN1Bit(name='channel_needed', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='emlpp_priority', bit=3)])})])})

mbms_information = CSN1List(name='mbms_information', list=[
  CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='mbms_channel_parameters', obj=mbms_channel_parameters_ie),
    CSN1Ref(name='mbms_sessions_list', obj=mbms_sessions_list_ie)]),
  CSN1Val(name='', val='0')])

page_info_struct = CSN1List(name='page_info_struct', list=[
  CSN1Bit(name='paging_cause', bit=3),
  CSN1Bit(name='cn_domain_identity', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='paging_record_type_identifier', bit=2)])})])

repeated_iu_page_info_struct = CSN1Alt(name='repeated_iu_page_info_struct', alt={
  '0': ('', [
  CSN1Bit(name='g_rnti', bit=32)]),
  '1': ('', [
  CSN1Alt(alt={
    '00': ('', [
    CSN1Bit(name='tmsi', bit=32)]),
    '01': ('', [
    CSN1Bit(name='ptmsi', bit=32)]),
    '11': ('', [
    CSN1List(list=[
      CSN1Bit(name='length_of_mobile_identity_contents', bit=4),
      CSN1Bit(name='mobile_identity', bit=8, num=([0], lambda x: x))]),
    CSN1Ref(name='page_info_struct', obj=page_info_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='emlpp_priority', bit=3)])})])})

packet_paging_request_message_content = CSN1List(name='packet_paging_request_message_content', trunc=True, list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='persistence_level', bit=16)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='nln_ppch', bit=2)])}),
  CSN1List(list=[
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='repeated_page_info', obj=repeated_page_info_struct)]),
    CSN1Val(name='', val='0'),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(bit=-1)]),
      '1': ('', [
      CSN1List(num=-1, list=[
        CSN1Val(name='', val='1'),
        CSN1Ref(name='repeated_iu_page_info', obj=repeated_iu_page_info_struct)]),
      CSN1Val(name='', val='0'),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Bit(bit=-1)]),
        '1': ('', [
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(obj=mbms_information)])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='nln_status_ppch')])}),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Bit(bit=-1)]),
          '1': ('', [
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='etws_primary_notification', obj=etws_primary_notification_struct)])}),
          CSN1Ref(obj=padding_bits)]),
          None: ('', [])})]),
        None: ('', [])})]),
      None: ('', [])})])])

