# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/packet_measurement_order_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.9b Packet Measurement Order
# top-level object: Packet Measurement Order message content

# table 11.2.9b.2.a
_TransP = {
    0 : 0,
    1 : 10,
    2 : 19,
    3 : 28,
    4 : 36,
    5 : 44,
    6 : 52,
    7 : 60,
    8 : 67,
    9 : 74,
    10: 81,
    11: 88,
    12: 95,
    13: 102,
    14: 109,
    15: 116,
    16: 122
    }

def trans_p(n):
    try:
        return _TransP[n]
    except:
        return 0

# table 11.2.9b.2.b
_TransQ = {
    0 : 0,
    1 : 9,
    2 : 17,
    3 : 25,
    4 : 32,
    5 : 39,
    6 : 46,
    7 : 53,
    8 : 59,
    9 : 65,
    10: 71,
    11: 77,
    12: 83,
    13: 89,
    14: 95,
    15: 101,
    16: 106,
    17: 111,
    18: 116,
    19: 121,
    20: 126
    }

def trans_q(n):
    try:
        return _TransQ[n]
    except:
        return 0


# external references
from pycrate_csn1dir.lsa_parameters_ie import lsa_parameters_ie
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir._3g_priority_parameters_ie import _3g_priority_parameters_ie
from pycrate_csn1dir.e_utran_csg_description_ie import e_utran_csg_description_ie
from pycrate_csn1dir.individual_priorities_ie import individual_priorities_ie
from pycrate_csn1dir.measurement_control_parameters_description import measurement_control_parameters_description
from pycrate_csn1dir.e_utran_ipp_with_extended_earfcns_ie import e_utran_ipp_with_extended_earfcns_ie
from pycrate_csn1dir.gsm_priority_parameters_ie import gsm_priority_parameters_ie
from pycrate_csn1dir.enhanced_cell_reselection_parameters_ie import enhanced_cell_reselection_parameters_ie
from pycrate_csn1dir.global_tfi_ie import global_tfi_ie
from pycrate_csn1dir.e_utran_parameters_ie import e_utran_parameters_ie
from pycrate_csn1dir.e_utran_nc_with_extended_earfcns_ie import e_utran_nc_with_extended_earfcns_ie
from pycrate_csn1dir._3g_csg_description_ie import _3g_csg_description_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

priority_and_e_utran_parameters_description_struct = CSN1List(name='priority_and_e_utran_parameters_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='serving_cell_priority_parameters_description', obj=gsm_priority_parameters_ie)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='_3g_priority_parameters_description', obj=_3g_priority_parameters_ie)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='e_utran_parameters_description', obj=e_utran_parameters_ie)])})])

repeated_utran_fdd_neighbour_cells_struct = CSN1List(name='repeated_utran_fdd_neighbour_cells_struct', list=[
  CSN1Val(name='', val='0'),
  CSN1Bit(name='fdd_arfcn', bit=14),
  CSN1Bit(name='fdd_indic0'),
  CSN1Bit(name='nr_of_fdd_cells', bit=5),
  #CSN1Bit(name='fdd_cell_information_field', bit=('# unprocessed: (p(NR_OF_FDD_CELLS))', lambda: 0))])
  CSN1Bit(name='fdd_cell_information_field', bit=([3], trans_p))])

gprs_measurement_parameters_description_struct = CSN1List(name='gprs_measurement_parameters_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='multiband_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='serving_band_reporting', bit=2)])}),
  CSN1Bit(name='scale_ord', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_900_reporting_offset', bit=3),
    CSN1Bit(name='_900_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_1800_reporting_offset', bit=3),
    CSN1Bit(name='_1800_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_400_reporting_offset', bit=3),
    CSN1Bit(name='_400_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_1900_reporting_offset', bit=3),
    CSN1Bit(name='_1900_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_850_reporting_offset', bit=3),
    CSN1Bit(name='_850_reporting_threshold', bit=3)])})])

utran_fdd_description_struct = CSN1List(name='utran_fdd_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='bandwidth_fdd', bit=3)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='repeated_utran_fdd_neighbour_cells', obj=repeated_utran_fdd_neighbour_cells_struct)]),
  CSN1Val(name='', val='0')])

e_utran_csg_cells_reporting_description_struct = CSN1List(name='e_utran_csg_cells_reporting_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='e_utran_csg_fdd_reporting_threshold', bit=3),
    CSN1Bit(name='e_utran_csg_fdd_reporting_threshold_2', bit=6)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='e_utran_csg_tdd_reporting_threshold', bit=3),
    CSN1Bit(name='e_utran_csg_tdd_reporting_threshold_2', bit=6)])})])

removed_3gcell_description_struct = CSN1List(name='removed_3gcell_description_struct', list=[
  CSN1Bit(name='n1', bit=2),
  CSN1List(num=([0], lambda x: x + 1), list=[
    CSN1Bit(name='n2', bit=5),
    CSN1List(num=([0], lambda x: x + 1), list=[
      CSN1Bit(name='removed_3gcell_index', bit=7),
      CSN1Bit(name='_3g_cell_diff_length', bit=3),
      CSN1Bit(name='_3gcell_diff', bit=([1], lambda x: x))])])])

si13_pbcch_location_struct = CSN1Alt(name='si13_pbcch_location_struct', alt={
  '0': ('', [
  CSN1Bit(name='si13_location')]),
  '1': ('', [
  CSN1Bit(name='pbcch_location', bit=2),
  CSN1Bit(name='psi1_repeat_period', bit=4)])})

repeated_utran_tdd_neighbour_cells_struct = CSN1List(name='repeated_utran_tdd_neighbour_cells_struct', list=[
  CSN1Bit(name='tdd_indic0'),
  CSN1Val(name='', val='0'),
  CSN1Bit(name='tdd_arfcn', bit=14),
  CSN1Bit(name='nr_of_tdd_cells', bit=5),
  #CSN1Bit(name='tdd_cell_information_field', bit=('# unprocessed: (q(NR_OF_TDD_CELLS))', lambda: 0))])
  CSN1Bit(name='tdd_cell_information_field', bit=([3], trans_q))])

hcs_struct = CSN1List(name='hcs_struct', list=[
  CSN1Bit(name='priority_class', bit=3),
  CSN1Bit(name='hcs_thr', bit=5)])

ccn_support_description_struct = CSN1List(name='ccn_support_description_struct', list=[
  CSN1Bit(name='number_cells', bit=7),
  CSN1Bit(name='ccn_supported', num=([0], lambda x: x))])

gprs_rep_priority_description_struct = CSN1List(name='gprs_rep_priority_description_struct', list=[
  CSN1Bit(name='number_cells', bit=7),
  CSN1Bit(name='rep_priority', num=([0], lambda x: x))])

cell_selection_struct = CSN1List(name='cell_selection_struct', list=[
  CSN1Bit(name='cell_bar_access_2'),
  CSN1Bit(name='exc_acc'),
  CSN1Bit(name='same_ra_as_serving_cell'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_rxlev_access_min', bit=6),
    CSN1Bit(name='gprs_ms_txpwr_max_cch', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_temporary_offset', bit=3),
    CSN1Bit(name='gprs_penalty_time', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_reselect_offset', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='hcs_params', obj=hcs_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='si13_pbcch_location', obj=si13_pbcch_location_struct)])})])

utran_csg_cells_reporting_description_struct = CSN1List(name='utran_csg_cells_reporting_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='utran_csg_fdd_reporting_threshold', bit=3),
    CSN1Bit(name='utran_csg_fdd_reporting_threshold_2', bit=6)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='utran_csg_tdd_reporting_threshold', bit=3)])})])

gprs_3g_additional_measurement_parameters_description_2_struct = CSN1Alt(name='gprs_3g_additional_measurement_parameters_description_2_struct', alt={
  '0': ('', []),
  '1': ('', [
  CSN1Bit(name='fdd_reporting_threshold_2', bit=6)])})

gprs_3g_measurement_parameters_bis_description_struct = CSN1List(name='gprs_3g_measurement_parameters_bis_description_struct', list=[
  CSN1Bit(name='qsearch_p', bit=4),
  CSN1Val(name='', val='1'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='fdd_rep_quant'),
    CSN1Bit(name='fdd_multirat_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='fdd_reporting_offset', bit=3),
    CSN1Bit(name='fdd_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='tdd_multirat_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='tdd_reporting_offset', bit=3),
    CSN1Bit(name='tdd_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cdma2000_multirat_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cdma2000_reporting_offset', bit=3),
    CSN1Bit(name='cdma2000_reporting_threshold', bit=3)])})])

utran_tdd_description_struct = CSN1List(name='utran_tdd_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='bandwidth_tdd', bit=3)])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='repeated_utran_tdd_neighbour_cells', obj=repeated_utran_tdd_neighbour_cells_struct)]),
  CSN1Val(name='', val='0')])

cdma_2000_description_struct = CSN1List(name='cdma_2000_description_struct', list=[
  CSN1Bit(name='cdma2000_frequency_band', bit=5),
  CSN1Bit(name='cdma2000_frequency', bit=11),
  CSN1Bit(name='number_cdma2000_cells', bit=5),
  CSN1List(num=([2], lambda x: x), list=[
    CSN1Bit(name='pilot_pn_offset', bit=9),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '000': ('', [
        CSN1List(list=[
          CSN1Bit(name='td_mode', bit=2),
          CSN1Bit(name='td_power_level', bit=3)])]),
        '001': ('', [
        CSN1List(list=[
          CSN1Bit(name='qof', bit=2),
          CSN1Bit(name='walsh_len_a', bit=3),
          CSN1Bit(name='aux_pilot_walsh', bit=([1], lambda x: x + 6))])]),
        '010': ('', [
        CSN1List(list=[
          CSN1Bit(name='qof', bit=2),
          CSN1Bit(name='walsh_len_b', bit=3),
          CSN1Bit(name='aux_td_walsh', bit=([1], lambda x: x + 6)),
          CSN1Bit(name='aux_td_power_level', bit=2),
          CSN1Bit(name='td_mode', bit=2)])]),
        '011': ('', [
        CSN1List(list=[
          CSN1Bit(name='sr3_prim_pilot', bit=2),
          CSN1Bit(name='sr3_pilot_power1', bit=3),
          CSN1Bit(name='sr3_pilot_power2', bit=3)])]),
        '110': ('', [
        CSN1List(list=[
          CSN1Bit(name='sr3_prim_pilot', bit=2),
          CSN1Bit(name='sr3_pilot_power1', bit=3),
          CSN1Bit(name='sr3_pilot_power2', bit=3),
          CSN1Bit(name='qof', bit=2),
          CSN1Bit(name='walsh_len_c', bit=3),
          CSN1Bit(name='aux_walsh_len', bit=([4], lambda x: x + 6)),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='qof1', bit=2),
            CSN1Bit(name='walsh_length1', bit=3),
            CSN1Bit(name='aux_pilot_walsh1', bit=([2], lambda x: x + 6))])}),
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='qof2', bit=2),
            CSN1Bit(name='walsh_length2', bit=3),
            CSN1Bit(name='aux_pilot_walsh2', bit=([2], lambda x: x + 6))])})])])})])})])])

iu_mode_only_cell_selection_struct = CSN1List(name='iu_mode_only_cell_selection_struct', list=[
  CSN1Bit(name='cell_bar_qualify_3', bit=2),
  CSN1Bit(name='same_ra_as_serving_cell'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_rxlev_access_min', bit=6),
    CSN1Bit(name='gprs_ms_txpwr_max_cch', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_temporary_offset', bit=3),
    CSN1Bit(name='gprs_penalty_time', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gprs_reselect_offset', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='hcs_params', obj=hcs_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='si13alt_pbcch_location', obj=si13_pbcch_location_struct)])})])

add_frequency_list_struct = CSN1List(name='add_frequency_list_struct', list=[
  CSN1Bit(name='start_frequency', bit=10),
  CSN1Bit(name='bsic', bit=6),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='cell_selection_params', obj=cell_selection_struct)])}),
  CSN1Bit(name='nr_of_frequencies', bit=5),
  CSN1Bit(name='freq_diff_length', bit=3),
  CSN1List(num=([3], lambda x: x), list=[
    CSN1Bit(name='frequency_diff', bit=([-1, 4], lambda x: x + 1)),
    CSN1Bit(name='bsic', bit=6),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='cell_selection_params', obj=cell_selection_struct)])})])])

add_iu_mode_only_cell_list_struct = CSN1List(name='add_iu_mode_only_cell_list_struct', list=[
  CSN1Bit(name='start_frequency', bit=10),
  CSN1Bit(name='bsic', bit=6),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='cell_selection_params', obj=iu_mode_only_cell_selection_struct)])}),
  CSN1Bit(name='nr_of_frequencies', bit=5),
  CSN1Bit(name='freq_diff_length', bit=3),
  CSN1List(num=([3], lambda x: x), list=[
    CSN1Bit(name='frequency_diff', bit=([-1, 4], lambda x: x)),
    CSN1Bit(name='bsic', bit=6),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='cell_selection_params', obj=iu_mode_only_cell_selection_struct)])})])])

iu_mode_cell_selection_struct = CSN1List(name='iu_mode_cell_selection_struct', list=[
  CSN1Bit(name='cell_bar_qualify_3', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='si13alt_pbcch_location', obj=si13_pbcch_location_struct)])})])

csg_cells_reporting_description_struct = CSN1List(name='csg_cells_reporting_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='utran_csg_cells_reporting_description', obj=utran_csg_cells_reporting_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='e_utran_csg_cells_reporting_description', obj=e_utran_csg_cells_reporting_description_struct)])})])

nc_iu_mode_only_cell_list_struct = CSN1List(name='nc_iu_mode_only_cell_list_struct', list=[
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='list_of_added_cells', obj=add_iu_mode_only_cell_list_struct)]),
  CSN1Val(name='', val='0')])

_3g_neighbour_cell_description_struct = CSN1List(name='_3g_neighbour_cell_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='index_start_3g', bit=7)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='absolute_index_start_emr', bit=7)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='utran_fdd_description', obj=utran_fdd_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='utran_tdd_description', obj=utran_tdd_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='cdma2000_description', obj=cdma_2000_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='removed_3gcell_description', obj=removed_3gcell_description_struct)])})])

enh_measurement_parameters_struct = CSN1List(name='enh_measurement_parameters_struct', list=[
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='ba_ind'),
    CSN1Bit(name='_3g_ba_ind')]),
    '1': ('', [
    CSN1Bit(name='psi3_change_mark', bit=2)])}),
  CSN1Bit(name='pmo_ind'),
  CSN1Bit(name='report_type'),
  CSN1Bit(name='reporting_rate'),
  CSN1Bit(name='invalid_bsic_reporting'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='_3g_neighbour_cell_description', obj=_3g_neighbour_cell_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='gprs_rep_priority_description', obj=gprs_rep_priority_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='gprs_measurement_parameters_description', obj=gprs_measurement_parameters_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='gprs_3g_measurement_parameters_description', obj=gprs_3g_measurement_parameters_bis_description_struct)])})])

nc_frequency_list_struct = CSN1List(name='nc_frequency_list_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1List(list=[
      CSN1Bit(name='nr_of_removed_freq', bit=5),
      CSN1Bit(name='removed_freq_index', bit=6, num=([0], lambda x: x + 1))])])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='list_of_added_frequency_struct', obj=add_frequency_list_struct)]),
  CSN1Val(name='', val='0')])

iu_mode_neighbour_cell_params_struct = CSN1List(name='iu_mode_neighbour_cell_params_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='iu_mode_cell_selection_params', obj=iu_mode_cell_selection_struct)])}),
  CSN1Bit(name='nr_of_frequencies', bit=5),
  CSN1Alt(num=([1], lambda x: x), alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='iu_mode_cell_selection_params', obj=iu_mode_cell_selection_struct)])})])

nc_measurement_parameters_struct = CSN1List(name='nc_measurement_parameters_struct', list=[
  CSN1Bit(name='network_control_order', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='nc__non_drx_period', bit=3),
    CSN1Bit(name='nc_reporting_period_i', bit=3),
    CSN1Bit(name='nc_reporting_period_t', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='nc_frequency_list', obj=nc_frequency_list_struct)])})])

packet_measurement_order_message_content = CSN1List(name='packet_measurement_order_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1List(list=[
    CSN1Alt(alt={
      '0': ('', [
      CSN1Ref(name='global_tfi', obj=global_tfi_ie)]),
      '10': ('', [
      CSN1Bit(name='tlli_g_rnti', bit=32)])}),
    CSN1List(list=[
      CSN1Bit(name='pmo_index', bit=3),
      CSN1Bit(name='pmo_count', bit=3),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='nc_measurement_parameters', obj=nc_measurement_parameters_struct)])}),
      CSN1Val(name='', val='0'),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Bit(bit=-1)]),
        '1': ('', [
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(name='lsa_parameters', obj=lsa_parameters_ie)])}),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Bit(bit=-1)]),
          '1': ('', [
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Ref(name='enh_measurement_parameters', obj=enh_measurement_parameters_struct)])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1Bit(name='ccn_active'),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Ref(name='ccn_support_description', obj=ccn_support_description_struct)])}),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(bit=-1)]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='g_rnti_extension', bit=4)])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1List(name='iu_mode_neighbour_cell_parameters', list=[
                  CSN1List(num=-1, list=[
                    CSN1Val(name='', val='1'),
                    CSN1Ref(obj=iu_mode_neighbour_cell_params_struct)]),
                  CSN1Val(name='', val='0')])])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Ref(name='nc_iu_mode_only_capable_cell_list', obj=nc_iu_mode_only_cell_list_struct)])}),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Ref(name='gprs_3g_additional_measurement_parameters_description_2', obj=gprs_3g_additional_measurement_parameters_description_2_struct)])}),
              CSN1Alt(alt={
                '0': ('', [
                CSN1Bit(bit=-1)]),
                '1': ('', [
                CSN1Bit(name='_3g_ccn_active'),
                CSN1Alt(alt={
                  '0': ('', [
                  CSN1Bit(bit=-1)]),
                  '1': ('', [
                  CSN1Alt(alt={
                    '0': ('', []),
                    '1': ('', [
                    CSN1Bit(name='_700_reporting_offset', bit=3),
                    CSN1Bit(name='_700_reporting_threshold', bit=3)])}),
                  CSN1Alt(alt={
                    '0': ('', []),
                    '1': ('', [
                    CSN1Bit(name='_810_reporting_offset', bit=3),
                    CSN1Bit(name='_810_reporting_threshold', bit=3)])}),
                  CSN1Alt(alt={
                    '0': ('', [
                    CSN1Bit(bit=-1)]),
                    '1': ('', [
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Bit(name='_3g_ba_ind'),
                      CSN1Bit(name='pmo_ind')])}),
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Ref(name='priority_and_e_utran_parameters_description', obj=priority_and_e_utran_parameters_description_struct)])}),
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Ref(name='individual_priorities', obj=individual_priorities_ie)])}),
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Ref(name='_3g_csg_description', obj=_3g_csg_description_ie)])}),
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Ref(name='e_utran_csg_description', obj=e_utran_csg_description_ie)])}),
                    CSN1Alt(alt={
                      '0': ('', []),
                      '1': ('', [
                      CSN1Ref(name='measurement_control_parameters_description', obj=measurement_control_parameters_description)])}),
                    CSN1Alt(alt={
                      '0': ('', [
                      CSN1Bit(bit=-1)]),
                      '1': ('', [
                      CSN1Alt(alt={
                        '0': ('', []),
                        '1': ('', [
                        CSN1Ref(name='enhanced_cell_reselection_parameters_description', obj=enhanced_cell_reselection_parameters_ie)])}),
                      CSN1Alt(alt={
                        '0': ('', []),
                        '1': ('', [
                        CSN1Ref(name='csg_cells_reporting_description', obj=csg_cells_reporting_description_struct)])}),
                      CSN1Alt(alt={
                        '0': ('', [
                        CSN1Bit(bit=-1)]),
                        '1': ('', [
                        CSN1Alt(alt={
                          '0': ('', []),
                          '1': ('', [
                          CSN1Ref(name='e_utran_ipp_with_extended_earfcns', obj=e_utran_ipp_with_extended_earfcns_ie)])}),
                        CSN1Alt(alt={
                          '0': ('', []),
                          '1': ('', [
                          CSN1Ref(name='e_utran_nc_with_extended_earfcns', obj=e_utran_nc_with_extended_earfcns_ie)])}),
                        CSN1Ref(obj=padding_bits)]),
                        None: ('', [])})]),
                      None: ('', [])})]),
                    None: ('', [])})]),
                  None: ('', [])})]),
                None: ('', [])})]),
              None: ('', [])})]),
            None: ('', [])})]),
          None: ('', [])})]),
        None: ('', [])})])])])

