# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ec_packet_uplink_ack_nack_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.57 EC Packet Uplink Ack/Nack
# top-level object: EC Packet Uplink Ack/Nack message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.ec_primary_ack_nack_description_ie import ec_primary_ack_nack_description_ie
from pycrate_csn1dir.ec_packet_timing_advance_ie import ec_packet_timing_advance_ie
from pycrate_csn1dir.used_dl_coverage_class_ie import used_dl_coverage_class_ie
from pycrate_csn1dir.ec_ack_nack_description_ie import ec_ack_nack_description_ie
from pycrate_csn1dir.egprs_modulation_and_coding_scheme_ie import egprs_modulation_and_coding_scheme_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

puan_fixed_uplink_allocation_struct = CSN1List(name='puan_fixed_uplink_allocation_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='bsn_offset', bit=2)])}),
  CSN1Bit(name='start_first_ul_rlc_data_block', bit=4),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(name='delay_next_ul_rlc_data_block', bit=3)]),
      '1': ('', [])})]),
  CSN1Val(name='', val='0')])

ec_packet_uplink_ack_nack_message_content = CSN1List(name='ec_packet_uplink_ack_nack_message_content', list=[
  CSN1Ref(name='used_dl_coverage_class', obj=used_dl_coverage_class_ie),
  CSN1List(list=[
    CSN1Bit(name='uplink_tfi', bit=5),
    CSN1Alt(alt={
      '0': ('', [
      CSN1List(list=[
        CSN1Alt(alt={
          '00': ('', [
          CSN1Ref(name='ec_ack_nack_description', obj=ec_ack_nack_description_ie)]),
          '01': ('', [
          CSN1List(list=[
            CSN1Bit(name='contention_resolution_tlli', bit=32),
            CSN1Ref(name='ec_primary_ack_nack_description', obj=ec_primary_ack_nack_description_ie)])]),
          '10': ('', [
          CSN1List(list=[
            CSN1Bit(name='contention_resolution_rtlli', bit=4),
            CSN1Ref(name='ec_primary_ack_nack_description', obj=ec_primary_ack_nack_description_ie)])])}),
        CSN1Ref(name='puan_fixed_uplink_allocation', obj=puan_fixed_uplink_allocation_struct),
        CSN1Bit(name='resegment'),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie)])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='ul_coverage_class', bit=2),
          CSN1Bit(name='starting_ul_timeslot', bit=3),
          CSN1Bit(name='dl_coverage_class', bit=2),
          CSN1Bit(name='starting_dl_timeslot_offset', bit=2),
          CSN1Bit(name='timeslot_multiplicator', bit=3)])})])]),
      '1': ('', [
      CSN1List(list=[
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='contention_resolution_tlli', bit=32)])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1List(list=[
            CSN1Bit(name='t3238', bit=3),
            CSN1Bit(name='initial_waiting_time', bit=2),
            CSN1Bit(name='ec_pacch_monitoring_pattern', bit=2)])])})]),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='ec_packet_timing_advance', obj=ec_packet_timing_advance_ie)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='gamma', bit=5),
        CSN1Bit(name='alpha_enable')])}),
      CSN1Ref(obj=padding_bits)])})])])

