# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/channel_request_description_2_value_part.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.8b Channel Request Description 2
# top-level object: Channel Request Description 2 value part

# external references
from pycrate_csn1dir.channel_request_description_ie import channel_request_description_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

channel_request_description_2_value_part = CSN1List(name='channel_request_description_2_value_part', list=[
  CSN1Bit(name='packet_establishment_cause', bit=2),
  CSN1Ref(name='channel_request_description', obj=channel_request_description_ie),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='pfi', bit=7)])}),
  CSN1Bit(name='multiple_tbf_capability'),
  CSN1Alt(alt={
    'H': ('', [
    CSN1List(list=[
      CSN1Bit(name='rlc_non_persistent_mode_capability'),
      CSN1Bit(name='reduced_latency_capability'),
      CSN1Bit(name='uplink_egprs2', bit=2),
      CSN1Bit(name='downlink_egprs2', bit=2)]),
    CSN1Alt(alt={
      'H': ('', [
      CSN1Bit(name='emst_ms_capability'),
      CSN1Alt(alt={
        'H': ('', [
        CSN1Bit(name='emsr_ms_capability'),
        CSN1Alt(alt={
          'H': ('', [
          CSN1Bit(name='fanr_capability')]),
          'L': ('', []),
          None: ('', [])})]),
        'L': ('', []),
        None: ('', [])})]),
      'L': ('', []),
      None: ('', [])})]),
    'L': ('', []),
    None: ('', [])}),
  CSN1Ref(obj=spare_padding)])

