# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class DialoguePDUs:

    _name_  = u'DialoguePDUs'
    _oid_   = [0, 0, 17, 773, 2, 2, 1]
    
    _obj_ = [
        u'dialogue-as-id',
        u'DialoguePDU',
        u'AARQ-apdu',
        u'AARE-apdu',
        u'RLRQ-apdu',
        u'RLRE-apdu',
        u'ABRT-apdu',
        u'ABRT-source',
        u'Associate-result',
        u'Associate-source-diagnostic',
        u'Release-request-reason',
        u'Release-response-reason',
        ]
    _type_ = [
        u'DialoguePDU',
        u'AARQ-apdu',
        u'AARE-apdu',
        u'RLRQ-apdu',
        u'RLRE-apdu',
        u'ABRT-apdu',
        u'ABRT-source',
        u'Associate-result',
        u'Associate-source-diagnostic',
        u'Release-request-reason',
        u'Release-response-reason',
        ]
    _set_ = [
        ]
    _val_ = [
        u'dialogue-as-id',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< dialogue-as-id >-----#
    dialogue_as_id = OID(name=u'dialogue-as-id', mode=MODE_VALUE)
    dialogue_as_id._val = (0, 0, 17, 773, 1, 1, 1)
    
    #-----< DialoguePDU >-----#
    DialoguePDU = CHOICE(name=u'DialoguePDU', mode=MODE_TYPE)
    _DialoguePDU_dialogueRequest = SEQ(name=u'dialogueRequest', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'AARQ-apdu')))
    _DialoguePDU_dialogueResponse = SEQ(name=u'dialogueResponse', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'AARE-apdu')))
    _DialoguePDU_dialogueAbort = SEQ(name=u'dialogueAbort', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'ABRT-apdu')))
    DialoguePDU._cont = ASN1Dict([
        (u'dialogueRequest', _DialoguePDU_dialogueRequest),
        (u'dialogueResponse', _DialoguePDU_dialogueResponse),
        (u'dialogueAbort', _DialoguePDU_dialogueAbort),
        ])
    DialoguePDU._ext = None
    
    #-----< AARQ-apdu >-----#
    AARQ_apdu = SEQ(name=u'AARQ-apdu', mode=MODE_TYPE, tag=(0, TAG_APPLICATION, TAG_IMPLICIT))
    _AARQ_apdu_protocol_version = BIT_STR(name=u'protocol-version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=(1, 1))
    _AARQ_apdu_protocol_version._cont = ASN1Dict([(u'version1', 0)])
    _AARQ_apdu_application_context_name = OID(name=u'application-context-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AARQ_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AARQ_apdu_user_information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    _AARQ_apdu_user_information._cont = __AARQ_apdu_user_information__item_
    AARQ_apdu._cont = ASN1Dict([
        (u'protocol-version', _AARQ_apdu_protocol_version),
        (u'application-context-name', _AARQ_apdu_application_context_name),
        (u'user-information', _AARQ_apdu_user_information),
        ])
    AARQ_apdu._ext = None
    
    #-----< AARE-apdu >-----#
    AARE_apdu = SEQ(name=u'AARE-apdu', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_IMPLICIT))
    _AARE_apdu_protocol_version = BIT_STR(name=u'protocol-version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=(1, 1))
    _AARE_apdu_protocol_version._cont = ASN1Dict([(u'version1', 0)])
    _AARE_apdu_application_context_name = OID(name=u'application-context-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AARE_apdu_result = INT(name=u'result', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Associate-result')))
    _AARE_apdu_result_source_diagnostic = CHOICE(name=u'result-source-diagnostic', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Associate-source-diagnostic')))
    _AARE_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AARE_apdu_user_information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    _AARE_apdu_user_information._cont = __AARE_apdu_user_information__item_
    AARE_apdu._cont = ASN1Dict([
        (u'protocol-version', _AARE_apdu_protocol_version),
        (u'application-context-name', _AARE_apdu_application_context_name),
        (u'result', _AARE_apdu_result),
        (u'result-source-diagnostic', _AARE_apdu_result_source_diagnostic),
        (u'user-information', _AARE_apdu_user_information),
        ])
    AARE_apdu._ext = None
    
    #-----< RLRQ-apdu >-----#
    RLRQ_apdu = SEQ(name=u'RLRQ-apdu', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_IMPLICIT))
    _RLRQ_apdu_reason = INT(name=u'reason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Release-request-reason')), opt=True)
    _RLRQ_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RLRQ_apdu_user_information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    _RLRQ_apdu_user_information._cont = __RLRQ_apdu_user_information__item_
    RLRQ_apdu._cont = ASN1Dict([
        (u'reason', _RLRQ_apdu_reason),
        (u'user-information', _RLRQ_apdu_user_information),
        ])
    RLRQ_apdu._ext = None
    
    #-----< RLRE-apdu >-----#
    RLRE_apdu = SEQ(name=u'RLRE-apdu', mode=MODE_TYPE, tag=(3, TAG_APPLICATION, TAG_IMPLICIT))
    _RLRE_apdu_reason = INT(name=u'reason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Release-response-reason')), opt=True)
    _RLRE_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RLRE_apdu_user_information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    _RLRE_apdu_user_information._cont = __RLRE_apdu_user_information__item_
    RLRE_apdu._cont = ASN1Dict([
        (u'reason', _RLRE_apdu_reason),
        (u'user-information', _RLRE_apdu_user_information),
        ])
    RLRE_apdu._ext = None
    
    #-----< ABRT-apdu >-----#
    ABRT_apdu = SEQ(name=u'ABRT-apdu', mode=MODE_TYPE, tag=(4, TAG_APPLICATION, TAG_IMPLICIT))
    _ABRT_apdu_abort_source = INT(name=u'abort-source', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'ABRT-source')))
    _ABRT_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ABRT_apdu_user_information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    _ABRT_apdu_user_information._cont = __ABRT_apdu_user_information__item_
    ABRT_apdu._cont = ASN1Dict([
        (u'abort-source', _ABRT_apdu_abort_source),
        (u'user-information', _ABRT_apdu_user_information),
        ])
    ABRT_apdu._ext = None
    
    #-----< ABRT-source >-----#
    ABRT_source = INT(name=u'ABRT-source', mode=MODE_TYPE)
    ABRT_source._cont = ASN1Dict([(u'dialogue-service-user', 0), (u'dialogue-service-provider', 1)])
    
    #-----< Associate-result >-----#
    Associate_result = INT(name=u'Associate-result', mode=MODE_TYPE)
    Associate_result._cont = ASN1Dict([(u'accepted', 0), (u'reject-permanent', 1)])
    
    #-----< Associate-source-diagnostic >-----#
    Associate_source_diagnostic = CHOICE(name=u'Associate-source-diagnostic', mode=MODE_TYPE)
    _Associate_source_diagnostic_dialogue_service_user = INT(name=u'dialogue-service-user', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _Associate_source_diagnostic_dialogue_service_user._cont = ASN1Dict([(u'null', 0), (u'no-reason-given', 1), (u'application-context-name-not-supported', 2)])
    _Associate_source_diagnostic_dialogue_service_provider = INT(name=u'dialogue-service-provider', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _Associate_source_diagnostic_dialogue_service_provider._cont = ASN1Dict([(u'null', 0), (u'no-reason-given', 1), (u'no-common-dialogue-portion', 2)])
    Associate_source_diagnostic._cont = ASN1Dict([
        (u'dialogue-service-user', _Associate_source_diagnostic_dialogue_service_user),
        (u'dialogue-service-provider', _Associate_source_diagnostic_dialogue_service_provider),
        ])
    Associate_source_diagnostic._ext = None
    
    #-----< Release-request-reason >-----#
    Release_request_reason = INT(name=u'Release-request-reason', mode=MODE_TYPE)
    Release_request_reason._cont = ASN1Dict([(u'normal', 0), (u'urgent', 1), (u'user-defined', 30)])
    
    #-----< Release-response-reason >-----#
    Release_response_reason = INT(name=u'Release-response-reason', mode=MODE_TYPE)
    Release_response_reason._cont = ASN1Dict([(u'normal', 0), (u'not-finished', 1), (u'user-defined', 30)])
    
    _all_ = [
        dialogue_as_id,
        _DialoguePDU_dialogueRequest,
        _DialoguePDU_dialogueResponse,
        _DialoguePDU_dialogueAbort,
        DialoguePDU,
        _AARQ_apdu_protocol_version,
        _AARQ_apdu_application_context_name,
        __AARQ_apdu_user_information__item_,
        _AARQ_apdu_user_information,
        AARQ_apdu,
        _AARE_apdu_protocol_version,
        _AARE_apdu_application_context_name,
        _AARE_apdu_result,
        _AARE_apdu_result_source_diagnostic,
        __AARE_apdu_user_information__item_,
        _AARE_apdu_user_information,
        AARE_apdu,
        _RLRQ_apdu_reason,
        __RLRQ_apdu_user_information__item_,
        _RLRQ_apdu_user_information,
        RLRQ_apdu,
        _RLRE_apdu_reason,
        __RLRE_apdu_user_information__item_,
        _RLRE_apdu_user_information,
        RLRE_apdu,
        _ABRT_apdu_abort_source,
        __ABRT_apdu_user_information__item_,
        _ABRT_apdu_user_information,
        ABRT_apdu,
        ABRT_source,
        Associate_result,
        _Associate_source_diagnostic_dialogue_service_user,
        _Associate_source_diagnostic_dialogue_service_provider,
        Associate_source_diagnostic,
        Release_request_reason,
        Release_response_reason,
    ]

class UnidialoguePDUs:

    _name_  = u'UnidialoguePDUs'
    _oid_   = [0, 0, 17, 773, 2, 3, 1]
    
    _obj_ = [
        u'uniDialogue-as-id',
        u'UniDialoguePDU',
        u'AUDT-apdu',
        ]
    _type_ = [
        u'UniDialoguePDU',
        u'AUDT-apdu',
        ]
    _set_ = [
        ]
    _val_ = [
        u'uniDialogue-as-id',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< uniDialogue-as-id >-----#
    uniDialogue_as_id = OID(name=u'uniDialogue-as-id', mode=MODE_VALUE)
    uniDialogue_as_id._val = (0, 0, 17, 773, 1, 2, 1)
    
    #-----< UniDialoguePDU >-----#
    UniDialoguePDU = CHOICE(name=u'UniDialoguePDU', mode=MODE_TYPE)
    _UniDialoguePDU_unidialoguePDU = SEQ(name=u'unidialoguePDU', mode=MODE_TYPE, typeref=ASN1RefType(('UnidialoguePDUs', 'AUDT-apdu')))
    UniDialoguePDU._cont = ASN1Dict([
        (u'unidialoguePDU', _UniDialoguePDU_unidialoguePDU),
        ])
    UniDialoguePDU._ext = None
    
    #-----< AUDT-apdu >-----#
    AUDT_apdu = SEQ(name=u'AUDT-apdu', mode=MODE_TYPE, tag=(0, TAG_APPLICATION, TAG_IMPLICIT))
    _AUDT_apdu_protocol_version = BIT_STR(name=u'protocol-version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=(1, 1))
    _AUDT_apdu_protocol_version._cont = ASN1Dict([(u'version1', 0)])
    _AUDT_apdu_application_context_name = OID(name=u'application-context-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AUDT_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AUDT_apdu_user_information__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    _AUDT_apdu_user_information._cont = __AUDT_apdu_user_information__item_
    AUDT_apdu._cont = ASN1Dict([
        (u'protocol-version', _AUDT_apdu_protocol_version),
        (u'application-context-name', _AUDT_apdu_application_context_name),
        (u'user-information', _AUDT_apdu_user_information),
        ])
    AUDT_apdu._ext = None
    
    _all_ = [
        uniDialogue_as_id,
        _UniDialoguePDU_unidialoguePDU,
        UniDialoguePDU,
        _AUDT_apdu_protocol_version,
        _AUDT_apdu_application_context_name,
        __AUDT_apdu_user_information__item_,
        _AUDT_apdu_user_information,
        AUDT_apdu,
    ]

class Remote_Operations_Generic_ROS_PDUs:

    _name_  = u'Remote-Operations-Generic-ROS-PDUs'
    _oid_   = [2, 4, 6, 0]
    
    _obj_ = [
        u'ROS',
        u'Invoke',
        u'ReturnResult',
        u'ReturnError',
        u'Reject',
        u'GeneralProblem',
        u'InvokeProblem',
        u'ReturnResultProblem',
        u'ReturnErrorProblem',
        u'RejectProblem',
        u'InvokeId',
        u'noInvokeId',
        u'NoInvokeId',
        u'Errors',
        u'Bind',
        u'Unbind',
        ]
    _type_ = [
        u'ROS',
        u'Invoke',
        u'ReturnResult',
        u'ReturnError',
        u'Reject',
        u'GeneralProblem',
        u'InvokeProblem',
        u'ReturnResultProblem',
        u'ReturnErrorProblem',
        u'RejectProblem',
        u'InvokeId',
        u'Bind',
        u'Unbind',
        ]
    _set_ = [
        u'NoInvokeId',
        u'Errors',
        ]
    _val_ = [
        u'noInvokeId',
        ]
    _class_ = [
        u'Errors',
        ]
    _param_ = [
        u'ROS',
        u'Invoke',
        u'ReturnResult',
        u'ReturnError',
        u'Errors',
        u'Bind',
        u'Unbind',
        ]
    
    #-----< ROS >-----#
    ROS = CHOICE(name=u'ROS', mode=MODE_TYPE, param=True)
    
    #-----< Invoke >-----#
    Invoke = SEQ(name=u'Invoke', mode=MODE_TYPE, param=True)
    
    #-----< ReturnResult >-----#
    ReturnResult = SEQ(name=u'ReturnResult', mode=MODE_TYPE, param=True)
    
    #-----< ReturnError >-----#
    ReturnError = SEQ(name=u'ReturnError', mode=MODE_TYPE, param=True)
    
    #-----< Reject >-----#
    Reject = SEQ(name=u'Reject', mode=MODE_TYPE)
    _Reject_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    _Reject_problem = CHOICE(name=u'problem', mode=MODE_TYPE)
    __Reject_problem_general = INT(name=u'general', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'GeneralProblem')))
    __Reject_problem_invoke = INT(name=u'invoke', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeProblem')))
    __Reject_problem_returnResult = INT(name=u'returnResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnResultProblem')))
    __Reject_problem_returnError = INT(name=u'returnError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnErrorProblem')))
    _Reject_problem._cont = ASN1Dict([
        (u'general', __Reject_problem_general),
        (u'invoke', __Reject_problem_invoke),
        (u'returnResult', __Reject_problem_returnResult),
        (u'returnError', __Reject_problem_returnError),
        ])
    _Reject_problem._ext = None
    Reject._cont = ASN1Dict([
        (u'invokeId', _Reject_invokeId),
        (u'problem', _Reject_problem),
        ])
    Reject._ext = None
    
    #-----< GeneralProblem >-----#
    GeneralProblem = INT(name=u'GeneralProblem', mode=MODE_TYPE)
    GeneralProblem._cont = ASN1Dict([(u'unrecognizedPDU', 0), (u'mistypedPDU', 1), (u'badlyStructuredPDU', 2)])
    
    #-----< InvokeProblem >-----#
    InvokeProblem = INT(name=u'InvokeProblem', mode=MODE_TYPE)
    InvokeProblem._cont = ASN1Dict([(u'duplicateInvocation', 0), (u'unrecognizedOperation', 1), (u'mistypedArgument', 2), (u'resourceLimitation', 3), (u'releaseInProgress', 4), (u'unrecognizedLinkedId', 5), (u'linkedResponseUnexpected', 6), (u'unexpectedLinkedOperation', 7)])
    
    #-----< ReturnResultProblem >-----#
    ReturnResultProblem = INT(name=u'ReturnResultProblem', mode=MODE_TYPE)
    ReturnResultProblem._cont = ASN1Dict([(u'unrecognizedInvocation', 0), (u'resultResponseUnexpected', 1), (u'mistypedResult', 2)])
    
    #-----< ReturnErrorProblem >-----#
    ReturnErrorProblem = INT(name=u'ReturnErrorProblem', mode=MODE_TYPE)
    ReturnErrorProblem._cont = ASN1Dict([(u'unrecognizedInvocation', 0), (u'errorResponseUnexpected', 1), (u'unrecognizedError', 2), (u'unexpectedError', 3), (u'mistypedParameter', 4)])
    
    #-----< RejectProblem >-----#
    RejectProblem = INT(name=u'RejectProblem', mode=MODE_TYPE)
    RejectProblem._cont = ASN1Dict([(u'general-unrecognizedPDU', 0), (u'general-mistypedPDU', 1), (u'general-badlyStructuredPDU', 2), (u'invoke-duplicateInvocation', 10), (u'invoke-unrecognizedOperation', 11), (u'invoke-mistypedArgument', 12), (u'invoke-resourceLimitation', 13), (u'invoke-releaseInProgress', 14), (u'invoke-unrecognizedLinkedId', 15), (u'invoke-linkedResponseUnexpected', 16), (u'invoke-unexpectedLinkedOperation', 17), (u'returnResult-unrecognizedInvocation', 20), (u'returnResult-resultResponseUnexpected', 21), (u'returnResult-mistypedResult', 22), (u'returnError-unrecognizedInvocation', 30), (u'returnError-errorResponseUnexpected', 31), (u'returnError-unrecognizedError', 32), (u'returnError-unexpectedError', 33), (u'returnError-mistypedParameter', 34)])
    
    #-----< InvokeId >-----#
    InvokeId = CHOICE(name=u'InvokeId', mode=MODE_TYPE)
    _InvokeId_present = INT(name=u'present', mode=MODE_TYPE)
    _InvokeId_absent = NULL(name=u'absent', mode=MODE_TYPE)
    InvokeId._cont = ASN1Dict([
        (u'present', _InvokeId_present),
        (u'absent', _InvokeId_absent),
        ])
    InvokeId._ext = None
    
    #-----< noInvokeId >-----#
    noInvokeId = CHOICE(name=u'noInvokeId', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    noInvokeId._val = (u'absent', 0)
    
    #-----< NoInvokeId >-----#
    NoInvokeId = CHOICE(name=u'NoInvokeId', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    NoInvokeId._val = ASN1Set(rv=[(u'absent', 0)], rr=[], ev=None, er=[])
    
    #-----< Errors >-----#
    Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')), param=True)
    
    #-----< Bind >-----#
    Bind = CHOICE(name=u'Bind', mode=MODE_TYPE, param=True)
    
    #-----< Unbind >-----#
    Unbind = CHOICE(name=u'Unbind', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _Reject_invokeId,
        __Reject_problem_general,
        __Reject_problem_invoke,
        __Reject_problem_returnResult,
        __Reject_problem_returnError,
        _Reject_problem,
        Reject,
        GeneralProblem,
        InvokeProblem,
        ReturnResultProblem,
        ReturnErrorProblem,
        RejectProblem,
        _InvokeId_present,
        _InvokeId_absent,
        InvokeId,
        noInvokeId,
        NoInvokeId,
    ]

class Remote_Operations_Information_Objects:

    _name_  = u'Remote-Operations-Information-Objects'
    _oid_   = [2, 4, 5, 0]
    
    _obj_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'Code',
        u'Priority',
        u'refuse',
        u'emptyBind',
        u'emptyUnbind',
        ]
    _type_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'Code',
        u'Priority',
        ]
    _set_ = [
        ]
    _val_ = [
        u'refuse',
        u'emptyBind',
        u'emptyUnbind',
        ]
    _class_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'refuse',
        u'emptyBind',
        u'emptyUnbind',
        ]
    _param_ = [
        ]
    
    #-----< OPERATION >-----#
    OPERATION = CLASS(name=u'OPERATION', mode=MODE_TYPE)
    _OPERATION_ArgumentType = OPEN(name=u'ArgumentType', mode=MODE_TYPE, opt=True)
    _OPERATION_argumentTypeOptional = BOOL(name=u'argumentTypeOptional', mode=MODE_VALUE, opt=True)
    _OPERATION_returnResult = BOOL(name=u'returnResult', mode=MODE_VALUE, default=True)
    _OPERATION_ResultType = OPEN(name=u'ResultType', mode=MODE_TYPE, opt=True)
    _OPERATION_resultTypeOptional = BOOL(name=u'resultTypeOptional', mode=MODE_VALUE, opt=True)
    _OPERATION_Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')), opt=True)
    _OPERATION_Linked = CLASS(name=u'Linked', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_synchronous = BOOL(name=u'synchronous', mode=MODE_VALUE, default=False)
    _OPERATION_alwaysReturns = BOOL(name=u'alwaysReturns', mode=MODE_VALUE, default=True)
    _OPERATION_InvokePriority = INT(name=u'InvokePriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _OPERATION_ResultPriority = INT(name=u'ResultPriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _OPERATION_operationCode = CHOICE(name=u'operationCode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')), opt=True, uniq=True)
    OPERATION._cont = ASN1Dict([
        (u'ArgumentType', _OPERATION_ArgumentType),
        (u'argumentTypeOptional', _OPERATION_argumentTypeOptional),
        (u'returnResult', _OPERATION_returnResult),
        (u'ResultType', _OPERATION_ResultType),
        (u'resultTypeOptional', _OPERATION_resultTypeOptional),
        (u'Errors', _OPERATION_Errors),
        (u'Linked', _OPERATION_Linked),
        (u'synchronous', _OPERATION_synchronous),
        (u'alwaysReturns', _OPERATION_alwaysReturns),
        (u'InvokePriority', _OPERATION_InvokePriority),
        (u'ResultPriority', _OPERATION_ResultPriority),
        (u'operationCode', _OPERATION_operationCode),
        ])
    
    #-----< ERROR >-----#
    ERROR = CLASS(name=u'ERROR', mode=MODE_TYPE)
    _ERROR_ParameterType = OPEN(name=u'ParameterType', mode=MODE_TYPE, opt=True)
    _ERROR_parameterTypeOptional = BOOL(name=u'parameterTypeOptional', mode=MODE_VALUE, opt=True)
    _ERROR_ErrorPriority = INT(name=u'ErrorPriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _ERROR_errorCode = CHOICE(name=u'errorCode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')), opt=True, uniq=True)
    ERROR._cont = ASN1Dict([
        (u'ParameterType', _ERROR_ParameterType),
        (u'parameterTypeOptional', _ERROR_parameterTypeOptional),
        (u'ErrorPriority', _ERROR_ErrorPriority),
        (u'errorCode', _ERROR_errorCode),
        ])
    
    #-----< OPERATION-PACKAGE >-----#
    OPERATION_PACKAGE = CLASS(name=u'OPERATION-PACKAGE', mode=MODE_TYPE)
    _OPERATION_PACKAGE_Both = CLASS(name=u'Both', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_Consumer = CLASS(name=u'Consumer', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_Supplier = CLASS(name=u'Supplier', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    OPERATION_PACKAGE._cont = ASN1Dict([
        (u'Both', _OPERATION_PACKAGE_Both),
        (u'Consumer', _OPERATION_PACKAGE_Consumer),
        (u'Supplier', _OPERATION_PACKAGE_Supplier),
        (u'id', _OPERATION_PACKAGE_id),
        ])
    
    #-----< CONNECTION-PACKAGE >-----#
    CONNECTION_PACKAGE = CLASS(name=u'CONNECTION-PACKAGE', mode=MODE_TYPE)
    _CONNECTION_PACKAGE_bind = CLASS(name=u'bind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), default=dict([(u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', -1))])], rr=[], ev=None, er=[])), (u'synchronous', True)]))
    _CONNECTION_PACKAGE_unbind = CLASS(name=u'unbind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), default=dict([(u'synchronous', True)]))
    _CONNECTION_PACKAGE_responderCanUnbind = BOOL(name=u'responderCanUnbind', mode=MODE_VALUE, default=False)
    _CONNECTION_PACKAGE_unbindCanFail = BOOL(name=u'unbindCanFail', mode=MODE_VALUE, default=False)
    _CONNECTION_PACKAGE_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    CONNECTION_PACKAGE._cont = ASN1Dict([
        (u'bind', _CONNECTION_PACKAGE_bind),
        (u'unbind', _CONNECTION_PACKAGE_unbind),
        (u'responderCanUnbind', _CONNECTION_PACKAGE_responderCanUnbind),
        (u'unbindCanFail', _CONNECTION_PACKAGE_unbindCanFail),
        (u'id', _CONNECTION_PACKAGE_id),
        ])
    
    #-----< CONTRACT >-----#
    CONTRACT = CLASS(name=u'CONTRACT', mode=MODE_TYPE)
    _CONTRACT_connection = CLASS(name=u'connection', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONNECTION-PACKAGE')), opt=True)
    _CONTRACT_OperationsOf = CLASS(name=u'OperationsOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_InitiatorConsumerOf = CLASS(name=u'InitiatorConsumerOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_InitiatorSupplierOf = CLASS(name=u'InitiatorSupplierOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    CONTRACT._cont = ASN1Dict([
        (u'connection', _CONTRACT_connection),
        (u'OperationsOf', _CONTRACT_OperationsOf),
        (u'InitiatorConsumerOf', _CONTRACT_InitiatorConsumerOf),
        (u'InitiatorSupplierOf', _CONTRACT_InitiatorSupplierOf),
        (u'id', _CONTRACT_id),
        ])
    
    #-----< ROS-OBJECT-CLASS >-----#
    ROS_OBJECT_CLASS = CLASS(name=u'ROS-OBJECT-CLASS', mode=MODE_TYPE)
    _ROS_OBJECT_CLASS_Is = CLASS(name=u'Is', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ROS-OBJECT-CLASS')), opt=True)
    _ROS_OBJECT_CLASS_Initiates = CLASS(name=u'Initiates', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_Responds = CLASS(name=u'Responds', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_InitiatesAndResponds = CLASS(name=u'InitiatesAndResponds', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    ROS_OBJECT_CLASS._cont = ASN1Dict([
        (u'Is', _ROS_OBJECT_CLASS_Is),
        (u'Initiates', _ROS_OBJECT_CLASS_Initiates),
        (u'Responds', _ROS_OBJECT_CLASS_Responds),
        (u'InitiatesAndResponds', _ROS_OBJECT_CLASS_InitiatesAndResponds),
        (u'id', _ROS_OBJECT_CLASS_id),
        ])
    
    #-----< Code >-----#
    Code = CHOICE(name=u'Code', mode=MODE_TYPE)
    _Code_local = INT(name=u'local', mode=MODE_TYPE)
    _Code_global_ = OID(name=u'global', mode=MODE_TYPE)
    Code._cont = ASN1Dict([
        (u'local', _Code_local),
        (u'global', _Code_global_),
        ])
    Code._ext = None
    
    #-----< Priority >-----#
    Priority = INT(name=u'Priority', mode=MODE_TYPE)
    Priority._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< refuse >-----#
    refuse = CLASS(name=u'refuse', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    refuse._val = dict([(u'errorCode', (u'local', -1))])
    
    #-----< emptyBind >-----#
    emptyBind = CLASS(name=u'emptyBind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    emptyBind._val = dict([(u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', -1))])], rr=[], ev=None, er=[])), (u'synchronous', True)])
    
    #-----< emptyUnbind >-----#
    emptyUnbind = CLASS(name=u'emptyUnbind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    emptyUnbind._val = dict([(u'synchronous', True)])
    
    _all_ = [
        _OPERATION_ArgumentType,
        _OPERATION_argumentTypeOptional,
        _OPERATION_returnResult,
        _OPERATION_ResultType,
        _OPERATION_resultTypeOptional,
        _OPERATION_Errors,
        _OPERATION_Linked,
        _OPERATION_synchronous,
        _OPERATION_alwaysReturns,
        _OPERATION_InvokePriority,
        _OPERATION_ResultPriority,
        _OPERATION_operationCode,
        OPERATION,
        _ERROR_ParameterType,
        _ERROR_parameterTypeOptional,
        _ERROR_ErrorPriority,
        _ERROR_errorCode,
        ERROR,
        _OPERATION_PACKAGE_Both,
        _OPERATION_PACKAGE_Consumer,
        _OPERATION_PACKAGE_Supplier,
        _OPERATION_PACKAGE_id,
        OPERATION_PACKAGE,
        _CONNECTION_PACKAGE_bind,
        _CONNECTION_PACKAGE_unbind,
        _CONNECTION_PACKAGE_responderCanUnbind,
        _CONNECTION_PACKAGE_unbindCanFail,
        _CONNECTION_PACKAGE_id,
        CONNECTION_PACKAGE,
        _CONTRACT_connection,
        _CONTRACT_OperationsOf,
        _CONTRACT_InitiatorConsumerOf,
        _CONTRACT_InitiatorSupplierOf,
        _CONTRACT_id,
        CONTRACT,
        _ROS_OBJECT_CLASS_Is,
        _ROS_OBJECT_CLASS_Initiates,
        _ROS_OBJECT_CLASS_Responds,
        _ROS_OBJECT_CLASS_InitiatesAndResponds,
        _ROS_OBJECT_CLASS_id,
        ROS_OBJECT_CLASS,
        _Code_local,
        _Code_global_,
        Code,
        Priority,
        refuse,
        emptyBind,
        emptyUnbind,
    ]

class TCAPMessages:

    _name_  = u'TCAPMessages'
    _oid_   = [0, 0, 17, 773, 2, 1, 3]
    
    _obj_ = [
        u'TCMessage',
        u'Unidirectional',
        u'Begin',
        u'End',
        u'Continue',
        u'Abort',
        u'DialoguePortion',
        u'OrigTransactionID',
        u'DestTransactionID',
        u'P-AbortCause',
        u'ComponentPortion',
        u'Component',
        u'TCInvokeIdSet',
        ]
    _type_ = [
        u'TCMessage',
        u'Unidirectional',
        u'Begin',
        u'End',
        u'Continue',
        u'Abort',
        u'DialoguePortion',
        u'OrigTransactionID',
        u'DestTransactionID',
        u'P-AbortCause',
        u'ComponentPortion',
        u'Component',
        ]
    _set_ = [
        u'TCInvokeIdSet',
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        u'TCMessage',
        u'Unidirectional',
        u'Begin',
        u'End',
        u'Continue',
        u'ComponentPortion',
        u'Component',
        ]
    
    #-----< TCMessage >-----#
    TCMessage = CHOICE(name=u'TCMessage', mode=MODE_TYPE, param=True)
    
    #-----< Unidirectional >-----#
    Unidirectional = SEQ(name=u'Unidirectional', mode=MODE_TYPE, param=True)
    
    #-----< Begin >-----#
    Begin = SEQ(name=u'Begin', mode=MODE_TYPE, param=True)
    
    #-----< End >-----#
    End = SEQ(name=u'End', mode=MODE_TYPE, param=True)
    
    #-----< Continue >-----#
    Continue = SEQ(name=u'Continue', mode=MODE_TYPE, param=True)
    
    #-----< Abort >-----#
    Abort = SEQ(name=u'Abort', mode=MODE_TYPE)
    _Abort_dtid = OCT_STR(name=u'dtid', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DestTransactionID')))
    _Abort_reason = CHOICE(name=u'reason', mode=MODE_TYPE, opt=True)
    __Abort_reason_p_abortCause = INT(name=u'p-abortCause', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'P-AbortCause')))
    __Abort_reason_u_abortCause = SEQ(name=u'u-abortCause', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DialoguePortion')))
    _Abort_reason._cont = ASN1Dict([
        (u'p-abortCause', __Abort_reason_p_abortCause),
        (u'u-abortCause', __Abort_reason_u_abortCause),
        ])
    _Abort_reason._ext = None
    Abort._cont = ASN1Dict([
        (u'dtid', _Abort_dtid),
        (u'reason', _Abort_reason),
        ])
    Abort._ext = None
    
    #-----< DialoguePortion >-----#
    DialoguePortion = SEQ(name=u'DialoguePortion', mode=MODE_TYPE, tag=(11, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TcapDialogueExternal')))
    
    #-----< OrigTransactionID >-----#
    OrigTransactionID = OCT_STR(name=u'OrigTransactionID', mode=MODE_TYPE, tag=(8, TAG_APPLICATION, TAG_IMPLICIT))
    OrigTransactionID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< DestTransactionID >-----#
    DestTransactionID = OCT_STR(name=u'DestTransactionID', mode=MODE_TYPE, tag=(9, TAG_APPLICATION, TAG_IMPLICIT))
    DestTransactionID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< P-AbortCause >-----#
    P_AbortCause = INT(name=u'P-AbortCause', mode=MODE_TYPE, tag=(10, TAG_APPLICATION, TAG_IMPLICIT))
    P_AbortCause._cont = ASN1Dict([(u'unrecognizedMessageType', 0), (u'unrecognizedTransactionID', 1), (u'badlyFormattedTransactionPortion', 2), (u'incorrectTransactionPortion', 3), (u'resourceLimitation', 4)])
    P_AbortCause._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    
    #-----< ComponentPortion >-----#
    ComponentPortion = SEQ_OF(name=u'ComponentPortion', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_IMPLICIT), param=True)
    
    #-----< Component >-----#
    Component = CHOICE(name=u'Component', mode=MODE_TYPE, param=True)
    
    #-----< TCInvokeIdSet >-----#
    TCInvokeIdSet = CHOICE(name=u'TCInvokeIdSet', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    TCInvokeIdSet._val = ASN1Set(rv=[(u'present', -128), (u'present', -127), (u'present', -126), (u'present', -125), (u'present', -124), (u'present', -123), (u'present', -122), (u'present', -121), (u'present', -120), (u'present', -119), (u'present', -118), (u'present', -117), (u'present', -116), (u'present', -115), (u'present', -114), (u'present', -113), (u'present', -112), (u'present', -111), (u'present', -110), (u'present', -109), (u'present', -108), (u'present', -107), (u'present', -106), (u'present', -105), (u'present', -104), (u'present', -103), (u'present', -102), (u'present', -101), (u'present', -100), (u'present', -99), (u'present', -98), (u'present', -97), (u'present', -96), (u'present', -95), (u'present', -94), (u'present', -93), (u'present', -92), (u'present', -91), (u'present', -90), (u'present', -89), (u'present', -88), (u'present', -87), (u'present', -86), (u'present', -85), (u'present', -84), (u'present', -83), (u'present', -82), (u'present', -81), (u'present', -80), (u'present', -79), (u'present', -78), (u'present', -77), (u'present', -76), (u'present', -75), (u'present', -74), (u'present', -73), (u'present', -72), (u'present', -71), (u'present', -70), (u'present', -69), (u'present', -68), (u'present', -67), (u'present', -66), (u'present', -65), (u'present', -64), (u'present', -63), (u'present', -62), (u'present', -61), (u'present', -60), (u'present', -59), (u'present', -58), (u'present', -57), (u'present', -56), (u'present', -55), (u'present', -54), (u'present', -53), (u'present', -52), (u'present', -51), (u'present', -50), (u'present', -49), (u'present', -48), (u'present', -47), (u'present', -46), (u'present', -45), (u'present', -44), (u'present', -43), (u'present', -42), (u'present', -41), (u'present', -40), (u'present', -39), (u'present', -38), (u'present', -37), (u'present', -36), (u'present', -35), (u'present', -34), (u'present', -33), (u'present', -32), (u'present', -31), (u'present', -30), (u'present', -29), (u'present', -28), (u'present', -27), (u'present', -26), (u'present', -25), (u'present', -24), (u'present', -23), (u'present', -22), (u'present', -21), (u'present', -20), (u'present', -19), (u'present', -18), (u'present', -17), (u'present', -16), (u'present', -15), (u'present', -14), (u'present', -13), (u'present', -12), (u'present', -11), (u'present', -10), (u'present', -9), (u'present', -8), (u'present', -7), (u'present', -6), (u'present', -5), (u'present', -4), (u'present', -3), (u'present', -2), (u'present', -1), (u'present', 0), (u'present', 1), (u'present', 2), (u'present', 3), (u'present', 4), (u'present', 5), (u'present', 6), (u'present', 7), (u'present', 8), (u'present', 9), (u'present', 10), (u'present', 11), (u'present', 12), (u'present', 13), (u'present', 14), (u'present', 15), (u'present', 16), (u'present', 17), (u'present', 18), (u'present', 19), (u'present', 20), (u'present', 21), (u'present', 22), (u'present', 23), (u'present', 24), (u'present', 25), (u'present', 26), (u'present', 27), (u'present', 28), (u'present', 29), (u'present', 30), (u'present', 31), (u'present', 32), (u'present', 33), (u'present', 34), (u'present', 35), (u'present', 36), (u'present', 37), (u'present', 38), (u'present', 39), (u'present', 40), (u'present', 41), (u'present', 42), (u'present', 43), (u'present', 44), (u'present', 45), (u'present', 46), (u'present', 47), (u'present', 48), (u'present', 49), (u'present', 50), (u'present', 51), (u'present', 52), (u'present', 53), (u'present', 54), (u'present', 55), (u'present', 56), (u'present', 57), (u'present', 58), (u'present', 59), (u'present', 60), (u'present', 61), (u'present', 62), (u'present', 63), (u'present', 64), (u'present', 65), (u'present', 66), (u'present', 67), (u'present', 68), (u'present', 69), (u'present', 70), (u'present', 71), (u'present', 72), (u'present', 73), (u'present', 74), (u'present', 75), (u'present', 76), (u'present', 77), (u'present', 78), (u'present', 79), (u'present', 80), (u'present', 81), (u'present', 82), (u'present', 83), (u'present', 84), (u'present', 85), (u'present', 86), (u'present', 87), (u'present', 88), (u'present', 89), (u'present', 90), (u'present', 91), (u'present', 92), (u'present', 93), (u'present', 94), (u'present', 95), (u'present', 96), (u'present', 97), (u'present', 98), (u'present', 99), (u'present', 100), (u'present', 101), (u'present', 102), (u'present', 103), (u'present', 104), (u'present', 105), (u'present', 106), (u'present', 107), (u'present', 108), (u'present', 109), (u'present', 110), (u'present', 111), (u'present', 112), (u'present', 113), (u'present', 114), (u'present', 115), (u'present', 116), (u'present', 117), (u'present', 118), (u'present', 119), (u'present', 120), (u'present', 121), (u'present', 122), (u'present', 123), (u'present', 124), (u'present', 125), (u'present', 126), (u'present', 127)], rr=[], ev=None, er=[])
    
    _all_ = [
        _Abort_dtid,
        __Abort_reason_p_abortCause,
        __Abort_reason_u_abortCause,
        _Abort_reason,
        Abort,
        DialoguePortion,
        OrigTransactionID,
        DestTransactionID,
        P_AbortCause,
        TCInvokeIdSet,
    ]

class Pycrate_TCAP_Dialogue:

    _name_  = u'Pycrate-TCAP-Dialogue'
    _oid_   = []
    
    _obj_ = [
        u'TCAP-DIALOGUE-ENCODING',
        u'Tcap-dialogue-encoding',
        u'TcapDialogueExternal',
        ]
    _type_ = [
        u'TCAP-DIALOGUE-ENCODING',
        u'TcapDialogueExternal',
        ]
    _set_ = [
        u'Tcap-dialogue-encoding',
        ]
    _val_ = [
        ]
    _class_ = [
        u'TCAP-DIALOGUE-ENCODING',
        u'Tcap-dialogue-encoding',
        ]
    _param_ = [
        ]
    
    #-----< TCAP-DIALOGUE-ENCODING >-----#
    TCAP_DIALOGUE_ENCODING = CLASS(name=u'TCAP-DIALOGUE-ENCODING', mode=MODE_TYPE)
    _TCAP_DIALOGUE_ENCODING_ref = OID(name=u'ref', mode=MODE_VALUE, uniq=True)
    _TCAP_DIALOGUE_ENCODING_Type = OPEN(name=u'Type', mode=MODE_TYPE)
    TCAP_DIALOGUE_ENCODING._cont = ASN1Dict([
        (u'ref', _TCAP_DIALOGUE_ENCODING_ref),
        (u'Type', _TCAP_DIALOGUE_ENCODING_Type),
        ])
    
    #-----< Tcap-dialogue-encoding >-----#
    Tcap_dialogue_encoding = CLASS(name=u'Tcap-dialogue-encoding', mode=MODE_SET, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TCAP-DIALOGUE-ENCODING')))
    _Tcap_dialogue_encoding_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'DialoguePDU')))
    _Tcap_dialogue_encoding_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('UnidialoguePDUs', 'UniDialoguePDU')))
    Tcap_dialogue_encoding._val = ASN1Set(rv=[dict([(u'ref', (0, 0, 17, 773, 1, 1, 1)), (u'Type', _Tcap_dialogue_encoding_val_Type_0)]), dict([(u'ref', (0, 0, 17, 773, 1, 2, 1)), (u'Type', _Tcap_dialogue_encoding_val_Type_1)])], rr=[], ev=[], er=[])
    
    #-----< TcapDialogueExternal >-----#
    TcapDialogueExternal = SEQ(name=u'TcapDialogueExternal', mode=MODE_TYPE, tag=(8, TAG_UNIVERSAL, TAG_IMPLICIT))
    _TcapDialogueExternal_direct_reference = OID(name=u'direct-reference', mode=MODE_TYPE, typeref=ASN1RefClassField(('Pycrate-TCAP-Dialogue', 'TCAP-DIALOGUE-ENCODING'), [u'ref']), opt=True)
    __TcapDialogueExternal_direct_reference_tab = CLASS(name='_tab_TCAP-DIALOGUE-ENCODING', mode=MODE_SET, typeref=ASN1RefType(('Pycrate-TCAP-Dialogue', 'TCAP-DIALOGUE-ENCODING')))
    ___TcapDialogueExternal_direct_reference_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'DialoguePDU')))
    ___TcapDialogueExternal_direct_reference_tab_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('UnidialoguePDUs', 'UniDialoguePDU')))
    __TcapDialogueExternal_direct_reference_tab._val = ASN1Set(rv=[dict([(u'ref', (0, 0, 17, 773, 1, 1, 1)), (u'Type', ___TcapDialogueExternal_direct_reference_tab_val_Type_0)]), dict([(u'ref', (0, 0, 17, 773, 1, 2, 1)), (u'Type', ___TcapDialogueExternal_direct_reference_tab_val_Type_1)])], rr=[], ev=None, er=[])
    _TcapDialogueExternal_direct_reference._const_tab = __TcapDialogueExternal_direct_reference_tab
    _TcapDialogueExternal_direct_reference._const_tab_at = None
    _TcapDialogueExternal_direct_reference._const_tab_id = u'ref'
    _TcapDialogueExternal_indirect_reference = INT(name=u'indirect-reference', mode=MODE_TYPE, opt=True)
    _TcapDialogueExternal_data_value_descriptor = OBJ_DESC(name=u'data-value-descriptor', mode=MODE_TYPE, opt=True)
    _TcapDialogueExternal_encoding = CHOICE(name=u'encoding', mode=MODE_TYPE)
    __TcapDialogueExternal_encoding_single_ASN1_type = OPEN(name=u'single-ASN1-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('Pycrate-TCAP-Dialogue', 'TCAP-DIALOGUE-ENCODING'), [u'Type']))
    __TcapDialogueExternal_encoding_single_ASN1_type._const_tab = __TcapDialogueExternal_direct_reference_tab
    __TcapDialogueExternal_encoding_single_ASN1_type._const_tab_at = ('..', '..', u'direct-reference')
    __TcapDialogueExternal_encoding_single_ASN1_type._const_tab_id = u'Type'
    __TcapDialogueExternal_encoding_octet_aligned = OCT_STR(name=u'octet-aligned', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TcapDialogueExternal_encoding_arbitrary = BIT_STR(name=u'arbitrary', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TcapDialogueExternal_encoding._cont = ASN1Dict([
        (u'single-ASN1-type', __TcapDialogueExternal_encoding_single_ASN1_type),
        (u'octet-aligned', __TcapDialogueExternal_encoding_octet_aligned),
        (u'arbitrary', __TcapDialogueExternal_encoding_arbitrary),
        ])
    _TcapDialogueExternal_encoding._ext = None
    TcapDialogueExternal._cont = ASN1Dict([
        (u'direct-reference', _TcapDialogueExternal_direct_reference),
        (u'indirect-reference', _TcapDialogueExternal_indirect_reference),
        (u'data-value-descriptor', _TcapDialogueExternal_data_value_descriptor),
        (u'encoding', _TcapDialogueExternal_encoding),
        ])
    TcapDialogueExternal._ext = None
    
    _all_ = [
        _TCAP_DIALOGUE_ENCODING_ref,
        _TCAP_DIALOGUE_ENCODING_Type,
        TCAP_DIALOGUE_ENCODING,
        Tcap_dialogue_encoding,
        _Tcap_dialogue_encoding_val_Type_0,
        _Tcap_dialogue_encoding_val_Type_1,
        __TcapDialogueExternal_direct_reference_tab,
        ___TcapDialogueExternal_direct_reference_tab_val_Type_0,
        ___TcapDialogueExternal_direct_reference_tab_val_Type_1,
        _TcapDialogueExternal_direct_reference,
        _TcapDialogueExternal_indirect_reference,
        _TcapDialogueExternal_data_value_descriptor,
        __TcapDialogueExternal_encoding_single_ASN1_type,
        __TcapDialogueExternal_encoding_octet_aligned,
        __TcapDialogueExternal_encoding_arbitrary,
        _TcapDialogueExternal_encoding,
        TcapDialogueExternal,
    ]

class TCAP_Messages:

    _name_  = u'TCAP-Messages'
    _oid_   = []
    
    _obj_ = [
        u'TCAP-Message',
        ]
    _type_ = [
        u'TCAP-Message',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< TCAP-Message >-----#
    TCAP_Message = CHOICE(name=u'TCAP-Message', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'TCMessage')))
    _TCAP_Message_unidirectional = SEQ(name=u'unidirectional', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'Unidirectional')))
    __TCAP_Message_unidirectional_dialoguePortion = SEQ(name=u'dialoguePortion', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DialoguePortion')), opt=True)
    __TCAP_Message_unidirectional_components = SEQ_OF(name=u'components', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'ComponentPortion')))
    ___TCAP_Message_unidirectional_components__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'Component')))
    ____TCAP_Message_unidirectional_components__item__basicROS = CHOICE(name=u'basicROS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')))
    _____TCAP_Message_unidirectional_components__item__basicROS_invoke = SEQ(name=u'invoke', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Invoke')))
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_invokeId._const_val = ASN1Set(rv=[(u'present', -128), (u'present', -127), (u'present', -126), (u'present', -125), (u'present', -124), (u'present', -123), (u'present', -122), (u'present', -121), (u'present', -120), (u'present', -119), (u'present', -118), (u'present', -117), (u'present', -116), (u'present', -115), (u'present', -114), (u'present', -113), (u'present', -112), (u'present', -111), (u'present', -110), (u'present', -109), (u'present', -108), (u'present', -107), (u'present', -106), (u'present', -105), (u'present', -104), (u'present', -103), (u'present', -102), (u'present', -101), (u'present', -100), (u'present', -99), (u'present', -98), (u'present', -97), (u'present', -96), (u'present', -95), (u'present', -94), (u'present', -93), (u'present', -92), (u'present', -91), (u'present', -90), (u'present', -89), (u'present', -88), (u'present', -87), (u'present', -86), (u'present', -85), (u'present', -84), (u'present', -83), (u'present', -82), (u'present', -81), (u'present', -80), (u'present', -79), (u'present', -78), (u'present', -77), (u'present', -76), (u'present', -75), (u'present', -74), (u'present', -73), (u'present', -72), (u'present', -71), (u'present', -70), (u'present', -69), (u'present', -68), (u'present', -67), (u'present', -66), (u'present', -65), (u'present', -64), (u'present', -63), (u'present', -62), (u'present', -61), (u'present', -60), (u'present', -59), (u'present', -58), (u'present', -57), (u'present', -56), (u'present', -55), (u'present', -54), (u'present', -53), (u'present', -52), (u'present', -51), (u'present', -50), (u'present', -49), (u'present', -48), (u'present', -47), (u'present', -46), (u'present', -45), (u'present', -44), (u'present', -43), (u'present', -42), (u'present', -41), (u'present', -40), (u'present', -39), (u'present', -38), (u'present', -37), (u'present', -36), (u'present', -35), (u'present', -34), (u'present', -33), (u'present', -32), (u'present', -31), (u'present', -30), (u'present', -29), (u'present', -28), (u'present', -27), (u'present', -26), (u'present', -25), (u'present', -24), (u'present', -23), (u'present', -22), (u'present', -21), (u'present', -20), (u'present', -19), (u'present', -18), (u'present', -17), (u'present', -16), (u'present', -15), (u'present', -14), (u'present', -13), (u'present', -12), (u'present', -11), (u'present', -10), (u'present', -9), (u'present', -8), (u'present', -7), (u'present', -6), (u'present', -5), (u'present', -4), (u'present', -3), (u'present', -2), (u'present', -1), (u'present', 0), (u'present', 1), (u'present', 2), (u'present', 3), (u'present', 4), (u'present', 5), (u'present', 6), (u'present', 7), (u'present', 8), (u'present', 9), (u'present', 10), (u'present', 11), (u'present', 12), (u'present', 13), (u'present', 14), (u'present', 15), (u'present', 16), (u'present', 17), (u'present', 18), (u'present', 19), (u'present', 20), (u'present', 21), (u'present', 22), (u'present', 23), (u'present', 24), (u'present', 25), (u'present', 26), (u'present', 27), (u'present', 28), (u'present', 29), (u'present', 30), (u'present', 31), (u'present', 32), (u'present', 33), (u'present', 34), (u'present', 35), (u'present', 36), (u'present', 37), (u'present', 38), (u'present', 39), (u'present', 40), (u'present', 41), (u'present', 42), (u'present', 43), (u'present', 44), (u'present', 45), (u'present', 46), (u'present', 47), (u'present', 48), (u'present', 49), (u'present', 50), (u'present', 51), (u'present', 52), (u'present', 53), (u'present', 54), (u'present', 55), (u'present', 56), (u'present', 57), (u'present', 58), (u'present', 59), (u'present', 60), (u'present', 61), (u'present', 62), (u'present', 63), (u'present', 64), (u'present', 65), (u'present', 66), (u'present', 67), (u'present', 68), (u'present', 69), (u'present', 70), (u'present', 71), (u'present', 72), (u'present', 73), (u'present', 74), (u'present', 75), (u'present', 76), (u'present', 77), (u'present', 78), (u'present', 79), (u'present', 80), (u'present', 81), (u'present', 82), (u'present', 83), (u'present', 84), (u'present', 85), (u'present', 86), (u'present', 87), (u'present', 88), (u'present', 89), (u'present', 90), (u'present', 91), (u'present', 92), (u'present', 93), (u'present', 94), (u'present', 95), (u'present', 96), (u'present', 97), (u'present', 98), (u'present', 99), (u'present', 100), (u'present', 101), (u'present', 102), (u'present', 103), (u'present', 104), (u'present', 105), (u'present', 106), (u'present', 107), (u'present', 108), (u'present', 109), (u'present', 110), (u'present', 111), (u'present', 112), (u'present', 113), (u'present', 114), (u'present', 115), (u'present', 116), (u'present', 117), (u'present', 118), (u'present', 119), (u'present', 120), (u'present', 121), (u'present', 122), (u'present', 123), (u'present', 124), (u'present', 125), (u'present', 126), (u'present', 127)], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId = CHOICE(name=u'linkedId', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId_present = INT(name=u'present', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId'), [u'present']))
    _______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId_absent = NULL(name=u'absent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId._cont = ASN1Dict([
        (u'present', _______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId_present),
        (u'absent', _______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId_absent),
        ])
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId._ext = None
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode._const_tab = _______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode_tab
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode._const_tab_at = None
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument = OPEN(name=u'argument', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ArgumentType']), opt=True)
    _______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument._const_tab = _______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument_tab
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument._const_tab_id = u'ArgumentType'
    _____TCAP_Message_unidirectional_components__item__basicROS_invoke._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_unidirectional_components__item__basicROS_invoke_invokeId),
        (u'linkedId', ______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId),
        (u'opcode', ______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode),
        (u'argument', ______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument),
        ])
    _____TCAP_Message_unidirectional_components__item__basicROS_invoke._ext = None
    _____TCAP_Message_unidirectional_components__item__basicROS_returnResult = SEQ(name=u'returnResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnResult')))
    ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode._const_tab = ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode_tab
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode._const_tab_at = None
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode._const_tab_id = u'operationCode'
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result._const_tab = ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result_tab
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result._const_tab_at = ('..', u'opcode')
    _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result._const_tab_id = u'ResultType'
    ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result._cont = ASN1Dict([
        (u'opcode', _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode),
        (u'result', _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result),
        ])
    ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result._ext = None
    _____TCAP_Message_unidirectional_components__item__basicROS_returnResult._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_invokeId),
        (u'result', ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result),
        ])
    _____TCAP_Message_unidirectional_components__item__basicROS_returnResult._ext = None
    _____TCAP_Message_unidirectional_components__item__basicROS_returnError = SEQ(name=u'returnError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnError')))
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode = CHOICE(name=u'errcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'errorCode']))
    _______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode._const_tab = _______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode_tab
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode._const_tab_at = None
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode._const_tab_id = u'errorCode'
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter = OPEN(name=u'parameter', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'ParameterType']), opt=True)
    _______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter._const_tab = _______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter_tab
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter._const_tab_at = ('..', u'errcode')
    ______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter._const_tab_id = u'ParameterType'
    _____TCAP_Message_unidirectional_components__item__basicROS_returnError._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_unidirectional_components__item__basicROS_returnError_invokeId),
        (u'errcode', ______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode),
        (u'parameter', ______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter),
        ])
    _____TCAP_Message_unidirectional_components__item__basicROS_returnError._ext = None
    _____TCAP_Message_unidirectional_components__item__basicROS_reject = SEQ(name=u'reject', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Reject')))
    ____TCAP_Message_unidirectional_components__item__basicROS._cont = ASN1Dict([
        (u'invoke', _____TCAP_Message_unidirectional_components__item__basicROS_invoke),
        (u'returnResult', _____TCAP_Message_unidirectional_components__item__basicROS_returnResult),
        (u'returnError', _____TCAP_Message_unidirectional_components__item__basicROS_returnError),
        (u'reject', _____TCAP_Message_unidirectional_components__item__basicROS_reject),
        ])
    ____TCAP_Message_unidirectional_components__item__basicROS._ext = None
    ____TCAP_Message_unidirectional_components__item__returnResultNotLast = SEQ(name=u'returnResultNotLast', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'ROS'), [u'returnResult']))
    _____TCAP_Message_unidirectional_components__item__returnResultNotLast_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    _____TCAP_Message_unidirectional_components__item__returnResultNotLast_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode._const_tab = _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode_tab
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode._const_tab_at = None
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result._const_tab = _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result_tab
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result._const_tab_id = u'ResultType'
    _____TCAP_Message_unidirectional_components__item__returnResultNotLast_result._cont = ASN1Dict([
        (u'opcode', ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode),
        (u'result', ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result),
        ])
    _____TCAP_Message_unidirectional_components__item__returnResultNotLast_result._ext = None
    ____TCAP_Message_unidirectional_components__item__returnResultNotLast._cont = ASN1Dict([
        (u'invokeId', _____TCAP_Message_unidirectional_components__item__returnResultNotLast_invokeId),
        (u'result', _____TCAP_Message_unidirectional_components__item__returnResultNotLast_result),
        ])
    ____TCAP_Message_unidirectional_components__item__returnResultNotLast._ext = None
    ___TCAP_Message_unidirectional_components__item_._cont = ASN1Dict([
        (u'basicROS', ____TCAP_Message_unidirectional_components__item__basicROS),
        (u'returnResultNotLast', ____TCAP_Message_unidirectional_components__item__returnResultNotLast),
        ])
    ___TCAP_Message_unidirectional_components__item_._ext = None
    __TCAP_Message_unidirectional_components._cont = ___TCAP_Message_unidirectional_components__item_
    __TCAP_Message_unidirectional_components._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TCAP_Message_unidirectional._cont = ASN1Dict([
        (u'dialoguePortion', __TCAP_Message_unidirectional_dialoguePortion),
        (u'components', __TCAP_Message_unidirectional_components),
        ])
    _TCAP_Message_unidirectional._ext = None
    _TCAP_Message_begin = SEQ(name=u'begin', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'Begin')))
    __TCAP_Message_begin_otid = OCT_STR(name=u'otid', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'OrigTransactionID')))
    __TCAP_Message_begin_dialoguePortion = SEQ(name=u'dialoguePortion', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DialoguePortion')), opt=True)
    __TCAP_Message_begin_components = SEQ_OF(name=u'components', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'ComponentPortion')), opt=True)
    ___TCAP_Message_begin_components__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'Component')))
    ____TCAP_Message_begin_components__item__basicROS = CHOICE(name=u'basicROS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')))
    _____TCAP_Message_begin_components__item__basicROS_invoke = SEQ(name=u'invoke', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Invoke')))
    ______TCAP_Message_begin_components__item__basicROS_invoke_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_begin_components__item__basicROS_invoke_invokeId._const_val = ASN1Set(rv=[(u'present', -128), (u'present', -127), (u'present', -126), (u'present', -125), (u'present', -124), (u'present', -123), (u'present', -122), (u'present', -121), (u'present', -120), (u'present', -119), (u'present', -118), (u'present', -117), (u'present', -116), (u'present', -115), (u'present', -114), (u'present', -113), (u'present', -112), (u'present', -111), (u'present', -110), (u'present', -109), (u'present', -108), (u'present', -107), (u'present', -106), (u'present', -105), (u'present', -104), (u'present', -103), (u'present', -102), (u'present', -101), (u'present', -100), (u'present', -99), (u'present', -98), (u'present', -97), (u'present', -96), (u'present', -95), (u'present', -94), (u'present', -93), (u'present', -92), (u'present', -91), (u'present', -90), (u'present', -89), (u'present', -88), (u'present', -87), (u'present', -86), (u'present', -85), (u'present', -84), (u'present', -83), (u'present', -82), (u'present', -81), (u'present', -80), (u'present', -79), (u'present', -78), (u'present', -77), (u'present', -76), (u'present', -75), (u'present', -74), (u'present', -73), (u'present', -72), (u'present', -71), (u'present', -70), (u'present', -69), (u'present', -68), (u'present', -67), (u'present', -66), (u'present', -65), (u'present', -64), (u'present', -63), (u'present', -62), (u'present', -61), (u'present', -60), (u'present', -59), (u'present', -58), (u'present', -57), (u'present', -56), (u'present', -55), (u'present', -54), (u'present', -53), (u'present', -52), (u'present', -51), (u'present', -50), (u'present', -49), (u'present', -48), (u'present', -47), (u'present', -46), (u'present', -45), (u'present', -44), (u'present', -43), (u'present', -42), (u'present', -41), (u'present', -40), (u'present', -39), (u'present', -38), (u'present', -37), (u'present', -36), (u'present', -35), (u'present', -34), (u'present', -33), (u'present', -32), (u'present', -31), (u'present', -30), (u'present', -29), (u'present', -28), (u'present', -27), (u'present', -26), (u'present', -25), (u'present', -24), (u'present', -23), (u'present', -22), (u'present', -21), (u'present', -20), (u'present', -19), (u'present', -18), (u'present', -17), (u'present', -16), (u'present', -15), (u'present', -14), (u'present', -13), (u'present', -12), (u'present', -11), (u'present', -10), (u'present', -9), (u'present', -8), (u'present', -7), (u'present', -6), (u'present', -5), (u'present', -4), (u'present', -3), (u'present', -2), (u'present', -1), (u'present', 0), (u'present', 1), (u'present', 2), (u'present', 3), (u'present', 4), (u'present', 5), (u'present', 6), (u'present', 7), (u'present', 8), (u'present', 9), (u'present', 10), (u'present', 11), (u'present', 12), (u'present', 13), (u'present', 14), (u'present', 15), (u'present', 16), (u'present', 17), (u'present', 18), (u'present', 19), (u'present', 20), (u'present', 21), (u'present', 22), (u'present', 23), (u'present', 24), (u'present', 25), (u'present', 26), (u'present', 27), (u'present', 28), (u'present', 29), (u'present', 30), (u'present', 31), (u'present', 32), (u'present', 33), (u'present', 34), (u'present', 35), (u'present', 36), (u'present', 37), (u'present', 38), (u'present', 39), (u'present', 40), (u'present', 41), (u'present', 42), (u'present', 43), (u'present', 44), (u'present', 45), (u'present', 46), (u'present', 47), (u'present', 48), (u'present', 49), (u'present', 50), (u'present', 51), (u'present', 52), (u'present', 53), (u'present', 54), (u'present', 55), (u'present', 56), (u'present', 57), (u'present', 58), (u'present', 59), (u'present', 60), (u'present', 61), (u'present', 62), (u'present', 63), (u'present', 64), (u'present', 65), (u'present', 66), (u'present', 67), (u'present', 68), (u'present', 69), (u'present', 70), (u'present', 71), (u'present', 72), (u'present', 73), (u'present', 74), (u'present', 75), (u'present', 76), (u'present', 77), (u'present', 78), (u'present', 79), (u'present', 80), (u'present', 81), (u'present', 82), (u'present', 83), (u'present', 84), (u'present', 85), (u'present', 86), (u'present', 87), (u'present', 88), (u'present', 89), (u'present', 90), (u'present', 91), (u'present', 92), (u'present', 93), (u'present', 94), (u'present', 95), (u'present', 96), (u'present', 97), (u'present', 98), (u'present', 99), (u'present', 100), (u'present', 101), (u'present', 102), (u'present', 103), (u'present', 104), (u'present', 105), (u'present', 106), (u'present', 107), (u'present', 108), (u'present', 109), (u'present', 110), (u'present', 111), (u'present', 112), (u'present', 113), (u'present', 114), (u'present', 115), (u'present', 116), (u'present', 117), (u'present', 118), (u'present', 119), (u'present', 120), (u'present', 121), (u'present', 122), (u'present', 123), (u'present', 124), (u'present', 125), (u'present', 126), (u'present', 127)], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__basicROS_invoke_linkedId = CHOICE(name=u'linkedId', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_begin_components__item__basicROS_invoke_linkedId_present = INT(name=u'present', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId'), [u'present']))
    _______TCAP_Message_begin_components__item__basicROS_invoke_linkedId_absent = NULL(name=u'absent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ______TCAP_Message_begin_components__item__basicROS_invoke_linkedId._cont = ASN1Dict([
        (u'present', _______TCAP_Message_begin_components__item__basicROS_invoke_linkedId_present),
        (u'absent', _______TCAP_Message_begin_components__item__basicROS_invoke_linkedId_absent),
        ])
    ______TCAP_Message_begin_components__item__basicROS_invoke_linkedId._ext = None
    ______TCAP_Message_begin_components__item__basicROS_invoke_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_begin_components__item__basicROS_invoke_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_begin_components__item__basicROS_invoke_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__basicROS_invoke_opcode._const_tab = _______TCAP_Message_begin_components__item__basicROS_invoke_opcode_tab
    ______TCAP_Message_begin_components__item__basicROS_invoke_opcode._const_tab_at = None
    ______TCAP_Message_begin_components__item__basicROS_invoke_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_begin_components__item__basicROS_invoke_argument = OPEN(name=u'argument', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ArgumentType']), opt=True)
    _______TCAP_Message_begin_components__item__basicROS_invoke_argument_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_begin_components__item__basicROS_invoke_argument_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__basicROS_invoke_argument._const_tab = _______TCAP_Message_begin_components__item__basicROS_invoke_argument_tab
    ______TCAP_Message_begin_components__item__basicROS_invoke_argument._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_begin_components__item__basicROS_invoke_argument._const_tab_id = u'ArgumentType'
    _____TCAP_Message_begin_components__item__basicROS_invoke._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_begin_components__item__basicROS_invoke_invokeId),
        (u'linkedId', ______TCAP_Message_begin_components__item__basicROS_invoke_linkedId),
        (u'opcode', ______TCAP_Message_begin_components__item__basicROS_invoke_opcode),
        (u'argument', ______TCAP_Message_begin_components__item__basicROS_invoke_argument),
        ])
    _____TCAP_Message_begin_components__item__basicROS_invoke._ext = None
    _____TCAP_Message_begin_components__item__basicROS_returnResult = SEQ(name=u'returnResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnResult')))
    ______TCAP_Message_begin_components__item__basicROS_returnResult_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_begin_components__item__basicROS_returnResult_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    ________TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode._const_tab = ________TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode_tab
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode._const_tab_at = None
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode._const_tab_id = u'operationCode'
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    ________TCAP_Message_begin_components__item__basicROS_returnResult_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_begin_components__item__basicROS_returnResult_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_result._const_tab = ________TCAP_Message_begin_components__item__basicROS_returnResult_result_result_tab
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_result._const_tab_at = ('..', u'opcode')
    _______TCAP_Message_begin_components__item__basicROS_returnResult_result_result._const_tab_id = u'ResultType'
    ______TCAP_Message_begin_components__item__basicROS_returnResult_result._cont = ASN1Dict([
        (u'opcode', _______TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode),
        (u'result', _______TCAP_Message_begin_components__item__basicROS_returnResult_result_result),
        ])
    ______TCAP_Message_begin_components__item__basicROS_returnResult_result._ext = None
    _____TCAP_Message_begin_components__item__basicROS_returnResult._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_begin_components__item__basicROS_returnResult_invokeId),
        (u'result', ______TCAP_Message_begin_components__item__basicROS_returnResult_result),
        ])
    _____TCAP_Message_begin_components__item__basicROS_returnResult._ext = None
    _____TCAP_Message_begin_components__item__basicROS_returnError = SEQ(name=u'returnError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnError')))
    ______TCAP_Message_begin_components__item__basicROS_returnError_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_begin_components__item__basicROS_returnError_errcode = CHOICE(name=u'errcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'errorCode']))
    _______TCAP_Message_begin_components__item__basicROS_returnError_errcode_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_begin_components__item__basicROS_returnError_errcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__basicROS_returnError_errcode._const_tab = _______TCAP_Message_begin_components__item__basicROS_returnError_errcode_tab
    ______TCAP_Message_begin_components__item__basicROS_returnError_errcode._const_tab_at = None
    ______TCAP_Message_begin_components__item__basicROS_returnError_errcode._const_tab_id = u'errorCode'
    ______TCAP_Message_begin_components__item__basicROS_returnError_parameter = OPEN(name=u'parameter', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'ParameterType']), opt=True)
    _______TCAP_Message_begin_components__item__basicROS_returnError_parameter_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_begin_components__item__basicROS_returnError_parameter_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__basicROS_returnError_parameter._const_tab = _______TCAP_Message_begin_components__item__basicROS_returnError_parameter_tab
    ______TCAP_Message_begin_components__item__basicROS_returnError_parameter._const_tab_at = ('..', u'errcode')
    ______TCAP_Message_begin_components__item__basicROS_returnError_parameter._const_tab_id = u'ParameterType'
    _____TCAP_Message_begin_components__item__basicROS_returnError._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_begin_components__item__basicROS_returnError_invokeId),
        (u'errcode', ______TCAP_Message_begin_components__item__basicROS_returnError_errcode),
        (u'parameter', ______TCAP_Message_begin_components__item__basicROS_returnError_parameter),
        ])
    _____TCAP_Message_begin_components__item__basicROS_returnError._ext = None
    _____TCAP_Message_begin_components__item__basicROS_reject = SEQ(name=u'reject', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Reject')))
    ____TCAP_Message_begin_components__item__basicROS._cont = ASN1Dict([
        (u'invoke', _____TCAP_Message_begin_components__item__basicROS_invoke),
        (u'returnResult', _____TCAP_Message_begin_components__item__basicROS_returnResult),
        (u'returnError', _____TCAP_Message_begin_components__item__basicROS_returnError),
        (u'reject', _____TCAP_Message_begin_components__item__basicROS_reject),
        ])
    ____TCAP_Message_begin_components__item__basicROS._ext = None
    ____TCAP_Message_begin_components__item__returnResultNotLast = SEQ(name=u'returnResultNotLast', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'ROS'), [u'returnResult']))
    _____TCAP_Message_begin_components__item__returnResultNotLast_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    _____TCAP_Message_begin_components__item__returnResultNotLast_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode._const_tab = _______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode_tab
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode._const_tab_at = None
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    _______TCAP_Message_begin_components__item__returnResultNotLast_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_begin_components__item__returnResultNotLast_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_result._const_tab = _______TCAP_Message_begin_components__item__returnResultNotLast_result_result_tab
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_result._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_begin_components__item__returnResultNotLast_result_result._const_tab_id = u'ResultType'
    _____TCAP_Message_begin_components__item__returnResultNotLast_result._cont = ASN1Dict([
        (u'opcode', ______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode),
        (u'result', ______TCAP_Message_begin_components__item__returnResultNotLast_result_result),
        ])
    _____TCAP_Message_begin_components__item__returnResultNotLast_result._ext = None
    ____TCAP_Message_begin_components__item__returnResultNotLast._cont = ASN1Dict([
        (u'invokeId', _____TCAP_Message_begin_components__item__returnResultNotLast_invokeId),
        (u'result', _____TCAP_Message_begin_components__item__returnResultNotLast_result),
        ])
    ____TCAP_Message_begin_components__item__returnResultNotLast._ext = None
    ___TCAP_Message_begin_components__item_._cont = ASN1Dict([
        (u'basicROS', ____TCAP_Message_begin_components__item__basicROS),
        (u'returnResultNotLast', ____TCAP_Message_begin_components__item__returnResultNotLast),
        ])
    ___TCAP_Message_begin_components__item_._ext = None
    __TCAP_Message_begin_components._cont = ___TCAP_Message_begin_components__item_
    __TCAP_Message_begin_components._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TCAP_Message_begin._cont = ASN1Dict([
        (u'otid', __TCAP_Message_begin_otid),
        (u'dialoguePortion', __TCAP_Message_begin_dialoguePortion),
        (u'components', __TCAP_Message_begin_components),
        ])
    _TCAP_Message_begin._ext = None
    _TCAP_Message_end = SEQ(name=u'end', mode=MODE_TYPE, tag=(4, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'End')))
    __TCAP_Message_end_dtid = OCT_STR(name=u'dtid', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DestTransactionID')))
    __TCAP_Message_end_dialoguePortion = SEQ(name=u'dialoguePortion', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DialoguePortion')), opt=True)
    __TCAP_Message_end_components = SEQ_OF(name=u'components', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'ComponentPortion')), opt=True)
    ___TCAP_Message_end_components__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'Component')))
    ____TCAP_Message_end_components__item__basicROS = CHOICE(name=u'basicROS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')))
    _____TCAP_Message_end_components__item__basicROS_invoke = SEQ(name=u'invoke', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Invoke')))
    ______TCAP_Message_end_components__item__basicROS_invoke_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_end_components__item__basicROS_invoke_invokeId._const_val = ASN1Set(rv=[(u'present', -128), (u'present', -127), (u'present', -126), (u'present', -125), (u'present', -124), (u'present', -123), (u'present', -122), (u'present', -121), (u'present', -120), (u'present', -119), (u'present', -118), (u'present', -117), (u'present', -116), (u'present', -115), (u'present', -114), (u'present', -113), (u'present', -112), (u'present', -111), (u'present', -110), (u'present', -109), (u'present', -108), (u'present', -107), (u'present', -106), (u'present', -105), (u'present', -104), (u'present', -103), (u'present', -102), (u'present', -101), (u'present', -100), (u'present', -99), (u'present', -98), (u'present', -97), (u'present', -96), (u'present', -95), (u'present', -94), (u'present', -93), (u'present', -92), (u'present', -91), (u'present', -90), (u'present', -89), (u'present', -88), (u'present', -87), (u'present', -86), (u'present', -85), (u'present', -84), (u'present', -83), (u'present', -82), (u'present', -81), (u'present', -80), (u'present', -79), (u'present', -78), (u'present', -77), (u'present', -76), (u'present', -75), (u'present', -74), (u'present', -73), (u'present', -72), (u'present', -71), (u'present', -70), (u'present', -69), (u'present', -68), (u'present', -67), (u'present', -66), (u'present', -65), (u'present', -64), (u'present', -63), (u'present', -62), (u'present', -61), (u'present', -60), (u'present', -59), (u'present', -58), (u'present', -57), (u'present', -56), (u'present', -55), (u'present', -54), (u'present', -53), (u'present', -52), (u'present', -51), (u'present', -50), (u'present', -49), (u'present', -48), (u'present', -47), (u'present', -46), (u'present', -45), (u'present', -44), (u'present', -43), (u'present', -42), (u'present', -41), (u'present', -40), (u'present', -39), (u'present', -38), (u'present', -37), (u'present', -36), (u'present', -35), (u'present', -34), (u'present', -33), (u'present', -32), (u'present', -31), (u'present', -30), (u'present', -29), (u'present', -28), (u'present', -27), (u'present', -26), (u'present', -25), (u'present', -24), (u'present', -23), (u'present', -22), (u'present', -21), (u'present', -20), (u'present', -19), (u'present', -18), (u'present', -17), (u'present', -16), (u'present', -15), (u'present', -14), (u'present', -13), (u'present', -12), (u'present', -11), (u'present', -10), (u'present', -9), (u'present', -8), (u'present', -7), (u'present', -6), (u'present', -5), (u'present', -4), (u'present', -3), (u'present', -2), (u'present', -1), (u'present', 0), (u'present', 1), (u'present', 2), (u'present', 3), (u'present', 4), (u'present', 5), (u'present', 6), (u'present', 7), (u'present', 8), (u'present', 9), (u'present', 10), (u'present', 11), (u'present', 12), (u'present', 13), (u'present', 14), (u'present', 15), (u'present', 16), (u'present', 17), (u'present', 18), (u'present', 19), (u'present', 20), (u'present', 21), (u'present', 22), (u'present', 23), (u'present', 24), (u'present', 25), (u'present', 26), (u'present', 27), (u'present', 28), (u'present', 29), (u'present', 30), (u'present', 31), (u'present', 32), (u'present', 33), (u'present', 34), (u'present', 35), (u'present', 36), (u'present', 37), (u'present', 38), (u'present', 39), (u'present', 40), (u'present', 41), (u'present', 42), (u'present', 43), (u'present', 44), (u'present', 45), (u'present', 46), (u'present', 47), (u'present', 48), (u'present', 49), (u'present', 50), (u'present', 51), (u'present', 52), (u'present', 53), (u'present', 54), (u'present', 55), (u'present', 56), (u'present', 57), (u'present', 58), (u'present', 59), (u'present', 60), (u'present', 61), (u'present', 62), (u'present', 63), (u'present', 64), (u'present', 65), (u'present', 66), (u'present', 67), (u'present', 68), (u'present', 69), (u'present', 70), (u'present', 71), (u'present', 72), (u'present', 73), (u'present', 74), (u'present', 75), (u'present', 76), (u'present', 77), (u'present', 78), (u'present', 79), (u'present', 80), (u'present', 81), (u'present', 82), (u'present', 83), (u'present', 84), (u'present', 85), (u'present', 86), (u'present', 87), (u'present', 88), (u'present', 89), (u'present', 90), (u'present', 91), (u'present', 92), (u'present', 93), (u'present', 94), (u'present', 95), (u'present', 96), (u'present', 97), (u'present', 98), (u'present', 99), (u'present', 100), (u'present', 101), (u'present', 102), (u'present', 103), (u'present', 104), (u'present', 105), (u'present', 106), (u'present', 107), (u'present', 108), (u'present', 109), (u'present', 110), (u'present', 111), (u'present', 112), (u'present', 113), (u'present', 114), (u'present', 115), (u'present', 116), (u'present', 117), (u'present', 118), (u'present', 119), (u'present', 120), (u'present', 121), (u'present', 122), (u'present', 123), (u'present', 124), (u'present', 125), (u'present', 126), (u'present', 127)], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__basicROS_invoke_linkedId = CHOICE(name=u'linkedId', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_end_components__item__basicROS_invoke_linkedId_present = INT(name=u'present', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId'), [u'present']))
    _______TCAP_Message_end_components__item__basicROS_invoke_linkedId_absent = NULL(name=u'absent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ______TCAP_Message_end_components__item__basicROS_invoke_linkedId._cont = ASN1Dict([
        (u'present', _______TCAP_Message_end_components__item__basicROS_invoke_linkedId_present),
        (u'absent', _______TCAP_Message_end_components__item__basicROS_invoke_linkedId_absent),
        ])
    ______TCAP_Message_end_components__item__basicROS_invoke_linkedId._ext = None
    ______TCAP_Message_end_components__item__basicROS_invoke_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_end_components__item__basicROS_invoke_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_end_components__item__basicROS_invoke_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__basicROS_invoke_opcode._const_tab = _______TCAP_Message_end_components__item__basicROS_invoke_opcode_tab
    ______TCAP_Message_end_components__item__basicROS_invoke_opcode._const_tab_at = None
    ______TCAP_Message_end_components__item__basicROS_invoke_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_end_components__item__basicROS_invoke_argument = OPEN(name=u'argument', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ArgumentType']), opt=True)
    _______TCAP_Message_end_components__item__basicROS_invoke_argument_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_end_components__item__basicROS_invoke_argument_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__basicROS_invoke_argument._const_tab = _______TCAP_Message_end_components__item__basicROS_invoke_argument_tab
    ______TCAP_Message_end_components__item__basicROS_invoke_argument._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_end_components__item__basicROS_invoke_argument._const_tab_id = u'ArgumentType'
    _____TCAP_Message_end_components__item__basicROS_invoke._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_end_components__item__basicROS_invoke_invokeId),
        (u'linkedId', ______TCAP_Message_end_components__item__basicROS_invoke_linkedId),
        (u'opcode', ______TCAP_Message_end_components__item__basicROS_invoke_opcode),
        (u'argument', ______TCAP_Message_end_components__item__basicROS_invoke_argument),
        ])
    _____TCAP_Message_end_components__item__basicROS_invoke._ext = None
    _____TCAP_Message_end_components__item__basicROS_returnResult = SEQ(name=u'returnResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnResult')))
    ______TCAP_Message_end_components__item__basicROS_returnResult_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_end_components__item__basicROS_returnResult_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    ________TCAP_Message_end_components__item__basicROS_returnResult_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_end_components__item__basicROS_returnResult_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_opcode._const_tab = ________TCAP_Message_end_components__item__basicROS_returnResult_result_opcode_tab
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_opcode._const_tab_at = None
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_opcode._const_tab_id = u'operationCode'
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    ________TCAP_Message_end_components__item__basicROS_returnResult_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_end_components__item__basicROS_returnResult_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_result._const_tab = ________TCAP_Message_end_components__item__basicROS_returnResult_result_result_tab
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_result._const_tab_at = ('..', u'opcode')
    _______TCAP_Message_end_components__item__basicROS_returnResult_result_result._const_tab_id = u'ResultType'
    ______TCAP_Message_end_components__item__basicROS_returnResult_result._cont = ASN1Dict([
        (u'opcode', _______TCAP_Message_end_components__item__basicROS_returnResult_result_opcode),
        (u'result', _______TCAP_Message_end_components__item__basicROS_returnResult_result_result),
        ])
    ______TCAP_Message_end_components__item__basicROS_returnResult_result._ext = None
    _____TCAP_Message_end_components__item__basicROS_returnResult._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_end_components__item__basicROS_returnResult_invokeId),
        (u'result', ______TCAP_Message_end_components__item__basicROS_returnResult_result),
        ])
    _____TCAP_Message_end_components__item__basicROS_returnResult._ext = None
    _____TCAP_Message_end_components__item__basicROS_returnError = SEQ(name=u'returnError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnError')))
    ______TCAP_Message_end_components__item__basicROS_returnError_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_end_components__item__basicROS_returnError_errcode = CHOICE(name=u'errcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'errorCode']))
    _______TCAP_Message_end_components__item__basicROS_returnError_errcode_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_end_components__item__basicROS_returnError_errcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__basicROS_returnError_errcode._const_tab = _______TCAP_Message_end_components__item__basicROS_returnError_errcode_tab
    ______TCAP_Message_end_components__item__basicROS_returnError_errcode._const_tab_at = None
    ______TCAP_Message_end_components__item__basicROS_returnError_errcode._const_tab_id = u'errorCode'
    ______TCAP_Message_end_components__item__basicROS_returnError_parameter = OPEN(name=u'parameter', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'ParameterType']), opt=True)
    _______TCAP_Message_end_components__item__basicROS_returnError_parameter_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_end_components__item__basicROS_returnError_parameter_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__basicROS_returnError_parameter._const_tab = _______TCAP_Message_end_components__item__basicROS_returnError_parameter_tab
    ______TCAP_Message_end_components__item__basicROS_returnError_parameter._const_tab_at = ('..', u'errcode')
    ______TCAP_Message_end_components__item__basicROS_returnError_parameter._const_tab_id = u'ParameterType'
    _____TCAP_Message_end_components__item__basicROS_returnError._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_end_components__item__basicROS_returnError_invokeId),
        (u'errcode', ______TCAP_Message_end_components__item__basicROS_returnError_errcode),
        (u'parameter', ______TCAP_Message_end_components__item__basicROS_returnError_parameter),
        ])
    _____TCAP_Message_end_components__item__basicROS_returnError._ext = None
    _____TCAP_Message_end_components__item__basicROS_reject = SEQ(name=u'reject', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Reject')))
    ____TCAP_Message_end_components__item__basicROS._cont = ASN1Dict([
        (u'invoke', _____TCAP_Message_end_components__item__basicROS_invoke),
        (u'returnResult', _____TCAP_Message_end_components__item__basicROS_returnResult),
        (u'returnError', _____TCAP_Message_end_components__item__basicROS_returnError),
        (u'reject', _____TCAP_Message_end_components__item__basicROS_reject),
        ])
    ____TCAP_Message_end_components__item__basicROS._ext = None
    ____TCAP_Message_end_components__item__returnResultNotLast = SEQ(name=u'returnResultNotLast', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'ROS'), [u'returnResult']))
    _____TCAP_Message_end_components__item__returnResultNotLast_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    _____TCAP_Message_end_components__item__returnResultNotLast_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    ______TCAP_Message_end_components__item__returnResultNotLast_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_end_components__item__returnResultNotLast_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_end_components__item__returnResultNotLast_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__returnResultNotLast_result_opcode._const_tab = _______TCAP_Message_end_components__item__returnResultNotLast_result_opcode_tab
    ______TCAP_Message_end_components__item__returnResultNotLast_result_opcode._const_tab_at = None
    ______TCAP_Message_end_components__item__returnResultNotLast_result_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_end_components__item__returnResultNotLast_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    _______TCAP_Message_end_components__item__returnResultNotLast_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_end_components__item__returnResultNotLast_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_end_components__item__returnResultNotLast_result_result._const_tab = _______TCAP_Message_end_components__item__returnResultNotLast_result_result_tab
    ______TCAP_Message_end_components__item__returnResultNotLast_result_result._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_end_components__item__returnResultNotLast_result_result._const_tab_id = u'ResultType'
    _____TCAP_Message_end_components__item__returnResultNotLast_result._cont = ASN1Dict([
        (u'opcode', ______TCAP_Message_end_components__item__returnResultNotLast_result_opcode),
        (u'result', ______TCAP_Message_end_components__item__returnResultNotLast_result_result),
        ])
    _____TCAP_Message_end_components__item__returnResultNotLast_result._ext = None
    ____TCAP_Message_end_components__item__returnResultNotLast._cont = ASN1Dict([
        (u'invokeId', _____TCAP_Message_end_components__item__returnResultNotLast_invokeId),
        (u'result', _____TCAP_Message_end_components__item__returnResultNotLast_result),
        ])
    ____TCAP_Message_end_components__item__returnResultNotLast._ext = None
    ___TCAP_Message_end_components__item_._cont = ASN1Dict([
        (u'basicROS', ____TCAP_Message_end_components__item__basicROS),
        (u'returnResultNotLast', ____TCAP_Message_end_components__item__returnResultNotLast),
        ])
    ___TCAP_Message_end_components__item_._ext = None
    __TCAP_Message_end_components._cont = ___TCAP_Message_end_components__item_
    __TCAP_Message_end_components._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TCAP_Message_end._cont = ASN1Dict([
        (u'dtid', __TCAP_Message_end_dtid),
        (u'dialoguePortion', __TCAP_Message_end_dialoguePortion),
        (u'components', __TCAP_Message_end_components),
        ])
    _TCAP_Message_end._ext = None
    _TCAP_Message_continue_ = SEQ(name=u'continue', mode=MODE_TYPE, tag=(5, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'Continue')))
    __TCAP_Message_continue__otid = OCT_STR(name=u'otid', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'OrigTransactionID')))
    __TCAP_Message_continue__dtid = OCT_STR(name=u'dtid', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DestTransactionID')))
    __TCAP_Message_continue__dialoguePortion = SEQ(name=u'dialoguePortion', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DialoguePortion')), opt=True)
    __TCAP_Message_continue__components = SEQ_OF(name=u'components', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'ComponentPortion')), opt=True)
    ___TCAP_Message_continue__components__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'Component')))
    ____TCAP_Message_continue__components__item__basicROS = CHOICE(name=u'basicROS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')))
    _____TCAP_Message_continue__components__item__basicROS_invoke = SEQ(name=u'invoke', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Invoke')))
    ______TCAP_Message_continue__components__item__basicROS_invoke_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_continue__components__item__basicROS_invoke_invokeId._const_val = ASN1Set(rv=[(u'present', -128), (u'present', -127), (u'present', -126), (u'present', -125), (u'present', -124), (u'present', -123), (u'present', -122), (u'present', -121), (u'present', -120), (u'present', -119), (u'present', -118), (u'present', -117), (u'present', -116), (u'present', -115), (u'present', -114), (u'present', -113), (u'present', -112), (u'present', -111), (u'present', -110), (u'present', -109), (u'present', -108), (u'present', -107), (u'present', -106), (u'present', -105), (u'present', -104), (u'present', -103), (u'present', -102), (u'present', -101), (u'present', -100), (u'present', -99), (u'present', -98), (u'present', -97), (u'present', -96), (u'present', -95), (u'present', -94), (u'present', -93), (u'present', -92), (u'present', -91), (u'present', -90), (u'present', -89), (u'present', -88), (u'present', -87), (u'present', -86), (u'present', -85), (u'present', -84), (u'present', -83), (u'present', -82), (u'present', -81), (u'present', -80), (u'present', -79), (u'present', -78), (u'present', -77), (u'present', -76), (u'present', -75), (u'present', -74), (u'present', -73), (u'present', -72), (u'present', -71), (u'present', -70), (u'present', -69), (u'present', -68), (u'present', -67), (u'present', -66), (u'present', -65), (u'present', -64), (u'present', -63), (u'present', -62), (u'present', -61), (u'present', -60), (u'present', -59), (u'present', -58), (u'present', -57), (u'present', -56), (u'present', -55), (u'present', -54), (u'present', -53), (u'present', -52), (u'present', -51), (u'present', -50), (u'present', -49), (u'present', -48), (u'present', -47), (u'present', -46), (u'present', -45), (u'present', -44), (u'present', -43), (u'present', -42), (u'present', -41), (u'present', -40), (u'present', -39), (u'present', -38), (u'present', -37), (u'present', -36), (u'present', -35), (u'present', -34), (u'present', -33), (u'present', -32), (u'present', -31), (u'present', -30), (u'present', -29), (u'present', -28), (u'present', -27), (u'present', -26), (u'present', -25), (u'present', -24), (u'present', -23), (u'present', -22), (u'present', -21), (u'present', -20), (u'present', -19), (u'present', -18), (u'present', -17), (u'present', -16), (u'present', -15), (u'present', -14), (u'present', -13), (u'present', -12), (u'present', -11), (u'present', -10), (u'present', -9), (u'present', -8), (u'present', -7), (u'present', -6), (u'present', -5), (u'present', -4), (u'present', -3), (u'present', -2), (u'present', -1), (u'present', 0), (u'present', 1), (u'present', 2), (u'present', 3), (u'present', 4), (u'present', 5), (u'present', 6), (u'present', 7), (u'present', 8), (u'present', 9), (u'present', 10), (u'present', 11), (u'present', 12), (u'present', 13), (u'present', 14), (u'present', 15), (u'present', 16), (u'present', 17), (u'present', 18), (u'present', 19), (u'present', 20), (u'present', 21), (u'present', 22), (u'present', 23), (u'present', 24), (u'present', 25), (u'present', 26), (u'present', 27), (u'present', 28), (u'present', 29), (u'present', 30), (u'present', 31), (u'present', 32), (u'present', 33), (u'present', 34), (u'present', 35), (u'present', 36), (u'present', 37), (u'present', 38), (u'present', 39), (u'present', 40), (u'present', 41), (u'present', 42), (u'present', 43), (u'present', 44), (u'present', 45), (u'present', 46), (u'present', 47), (u'present', 48), (u'present', 49), (u'present', 50), (u'present', 51), (u'present', 52), (u'present', 53), (u'present', 54), (u'present', 55), (u'present', 56), (u'present', 57), (u'present', 58), (u'present', 59), (u'present', 60), (u'present', 61), (u'present', 62), (u'present', 63), (u'present', 64), (u'present', 65), (u'present', 66), (u'present', 67), (u'present', 68), (u'present', 69), (u'present', 70), (u'present', 71), (u'present', 72), (u'present', 73), (u'present', 74), (u'present', 75), (u'present', 76), (u'present', 77), (u'present', 78), (u'present', 79), (u'present', 80), (u'present', 81), (u'present', 82), (u'present', 83), (u'present', 84), (u'present', 85), (u'present', 86), (u'present', 87), (u'present', 88), (u'present', 89), (u'present', 90), (u'present', 91), (u'present', 92), (u'present', 93), (u'present', 94), (u'present', 95), (u'present', 96), (u'present', 97), (u'present', 98), (u'present', 99), (u'present', 100), (u'present', 101), (u'present', 102), (u'present', 103), (u'present', 104), (u'present', 105), (u'present', 106), (u'present', 107), (u'present', 108), (u'present', 109), (u'present', 110), (u'present', 111), (u'present', 112), (u'present', 113), (u'present', 114), (u'present', 115), (u'present', 116), (u'present', 117), (u'present', 118), (u'present', 119), (u'present', 120), (u'present', 121), (u'present', 122), (u'present', 123), (u'present', 124), (u'present', 125), (u'present', 126), (u'present', 127)], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__basicROS_invoke_linkedId = CHOICE(name=u'linkedId', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_continue__components__item__basicROS_invoke_linkedId_present = INT(name=u'present', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId'), [u'present']))
    _______TCAP_Message_continue__components__item__basicROS_invoke_linkedId_absent = NULL(name=u'absent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ______TCAP_Message_continue__components__item__basicROS_invoke_linkedId._cont = ASN1Dict([
        (u'present', _______TCAP_Message_continue__components__item__basicROS_invoke_linkedId_present),
        (u'absent', _______TCAP_Message_continue__components__item__basicROS_invoke_linkedId_absent),
        ])
    ______TCAP_Message_continue__components__item__basicROS_invoke_linkedId._ext = None
    ______TCAP_Message_continue__components__item__basicROS_invoke_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_continue__components__item__basicROS_invoke_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_continue__components__item__basicROS_invoke_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__basicROS_invoke_opcode._const_tab = _______TCAP_Message_continue__components__item__basicROS_invoke_opcode_tab
    ______TCAP_Message_continue__components__item__basicROS_invoke_opcode._const_tab_at = None
    ______TCAP_Message_continue__components__item__basicROS_invoke_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_continue__components__item__basicROS_invoke_argument = OPEN(name=u'argument', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ArgumentType']), opt=True)
    _______TCAP_Message_continue__components__item__basicROS_invoke_argument_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_continue__components__item__basicROS_invoke_argument_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__basicROS_invoke_argument._const_tab = _______TCAP_Message_continue__components__item__basicROS_invoke_argument_tab
    ______TCAP_Message_continue__components__item__basicROS_invoke_argument._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_continue__components__item__basicROS_invoke_argument._const_tab_id = u'ArgumentType'
    _____TCAP_Message_continue__components__item__basicROS_invoke._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_continue__components__item__basicROS_invoke_invokeId),
        (u'linkedId', ______TCAP_Message_continue__components__item__basicROS_invoke_linkedId),
        (u'opcode', ______TCAP_Message_continue__components__item__basicROS_invoke_opcode),
        (u'argument', ______TCAP_Message_continue__components__item__basicROS_invoke_argument),
        ])
    _____TCAP_Message_continue__components__item__basicROS_invoke._ext = None
    _____TCAP_Message_continue__components__item__basicROS_returnResult = SEQ(name=u'returnResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnResult')))
    ______TCAP_Message_continue__components__item__basicROS_returnResult_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_continue__components__item__basicROS_returnResult_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    ________TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode._const_tab = ________TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode_tab
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode._const_tab_at = None
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode._const_tab_id = u'operationCode'
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    ________TCAP_Message_continue__components__item__basicROS_returnResult_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    ________TCAP_Message_continue__components__item__basicROS_returnResult_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_result._const_tab = ________TCAP_Message_continue__components__item__basicROS_returnResult_result_result_tab
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_result._const_tab_at = ('..', u'opcode')
    _______TCAP_Message_continue__components__item__basicROS_returnResult_result_result._const_tab_id = u'ResultType'
    ______TCAP_Message_continue__components__item__basicROS_returnResult_result._cont = ASN1Dict([
        (u'opcode', _______TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode),
        (u'result', _______TCAP_Message_continue__components__item__basicROS_returnResult_result_result),
        ])
    ______TCAP_Message_continue__components__item__basicROS_returnResult_result._ext = None
    _____TCAP_Message_continue__components__item__basicROS_returnResult._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_continue__components__item__basicROS_returnResult_invokeId),
        (u'result', ______TCAP_Message_continue__components__item__basicROS_returnResult_result),
        ])
    _____TCAP_Message_continue__components__item__basicROS_returnResult._ext = None
    _____TCAP_Message_continue__components__item__basicROS_returnError = SEQ(name=u'returnError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnError')))
    ______TCAP_Message_continue__components__item__basicROS_returnError_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    ______TCAP_Message_continue__components__item__basicROS_returnError_errcode = CHOICE(name=u'errcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'errorCode']))
    _______TCAP_Message_continue__components__item__basicROS_returnError_errcode_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_continue__components__item__basicROS_returnError_errcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__basicROS_returnError_errcode._const_tab = _______TCAP_Message_continue__components__item__basicROS_returnError_errcode_tab
    ______TCAP_Message_continue__components__item__basicROS_returnError_errcode._const_tab_at = None
    ______TCAP_Message_continue__components__item__basicROS_returnError_errcode._const_tab_id = u'errorCode'
    ______TCAP_Message_continue__components__item__basicROS_returnError_parameter = OPEN(name=u'parameter', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'ERROR'), [u'ParameterType']), opt=True)
    _______TCAP_Message_continue__components__item__basicROS_returnError_parameter_tab = CLASS(name='_tab_ERROR', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _______TCAP_Message_continue__components__item__basicROS_returnError_parameter_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__basicROS_returnError_parameter._const_tab = _______TCAP_Message_continue__components__item__basicROS_returnError_parameter_tab
    ______TCAP_Message_continue__components__item__basicROS_returnError_parameter._const_tab_at = ('..', u'errcode')
    ______TCAP_Message_continue__components__item__basicROS_returnError_parameter._const_tab_id = u'ParameterType'
    _____TCAP_Message_continue__components__item__basicROS_returnError._cont = ASN1Dict([
        (u'invokeId', ______TCAP_Message_continue__components__item__basicROS_returnError_invokeId),
        (u'errcode', ______TCAP_Message_continue__components__item__basicROS_returnError_errcode),
        (u'parameter', ______TCAP_Message_continue__components__item__basicROS_returnError_parameter),
        ])
    _____TCAP_Message_continue__components__item__basicROS_returnError._ext = None
    _____TCAP_Message_continue__components__item__basicROS_reject = SEQ(name=u'reject', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'Reject')))
    ____TCAP_Message_continue__components__item__basicROS._cont = ASN1Dict([
        (u'invoke', _____TCAP_Message_continue__components__item__basicROS_invoke),
        (u'returnResult', _____TCAP_Message_continue__components__item__basicROS_returnResult),
        (u'returnError', _____TCAP_Message_continue__components__item__basicROS_returnError),
        (u'reject', _____TCAP_Message_continue__components__item__basicROS_reject),
        ])
    ____TCAP_Message_continue__components__item__basicROS._ext = None
    ____TCAP_Message_continue__components__item__returnResultNotLast = SEQ(name=u'returnResultNotLast', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefChoiceComp(('Remote-Operations-Generic-ROS-PDUs', 'ROS'), [u'returnResult']))
    _____TCAP_Message_continue__components__item__returnResultNotLast_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    _____TCAP_Message_continue__components__item__returnResultNotLast_result = SEQ(name=u'result', mode=MODE_TYPE, opt=True)
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode = CHOICE(name=u'opcode', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'operationCode']))
    _______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode._const_tab = _______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode_tab
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode._const_tab_at = None
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode._const_tab_id = u'operationCode'
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_result = OPEN(name=u'result', mode=MODE_TYPE, typeref=ASN1RefClassField(('Remote-Operations-Information-Objects', 'OPERATION'), [u'ResultType']))
    _______TCAP_Message_continue__components__item__returnResultNotLast_result_result_tab = CLASS(name='_tab_OPERATION', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    _______TCAP_Message_continue__components__item__returnResultNotLast_result_result_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_result._const_tab = _______TCAP_Message_continue__components__item__returnResultNotLast_result_result_tab
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_result._const_tab_at = ('..', u'opcode')
    ______TCAP_Message_continue__components__item__returnResultNotLast_result_result._const_tab_id = u'ResultType'
    _____TCAP_Message_continue__components__item__returnResultNotLast_result._cont = ASN1Dict([
        (u'opcode', ______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode),
        (u'result', ______TCAP_Message_continue__components__item__returnResultNotLast_result_result),
        ])
    _____TCAP_Message_continue__components__item__returnResultNotLast_result._ext = None
    ____TCAP_Message_continue__components__item__returnResultNotLast._cont = ASN1Dict([
        (u'invokeId', _____TCAP_Message_continue__components__item__returnResultNotLast_invokeId),
        (u'result', _____TCAP_Message_continue__components__item__returnResultNotLast_result),
        ])
    ____TCAP_Message_continue__components__item__returnResultNotLast._ext = None
    ___TCAP_Message_continue__components__item_._cont = ASN1Dict([
        (u'basicROS', ____TCAP_Message_continue__components__item__basicROS),
        (u'returnResultNotLast', ____TCAP_Message_continue__components__item__returnResultNotLast),
        ])
    ___TCAP_Message_continue__components__item_._ext = None
    __TCAP_Message_continue__components._cont = ___TCAP_Message_continue__components__item_
    __TCAP_Message_continue__components._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TCAP_Message_continue_._cont = ASN1Dict([
        (u'otid', __TCAP_Message_continue__otid),
        (u'dtid', __TCAP_Message_continue__dtid),
        (u'dialoguePortion', __TCAP_Message_continue__dialoguePortion),
        (u'components', __TCAP_Message_continue__components),
        ])
    _TCAP_Message_continue_._ext = None
    _TCAP_Message_abort = SEQ(name=u'abort', mode=MODE_TYPE, tag=(7, TAG_APPLICATION, TAG_IMPLICIT), typeref=ASN1RefType(('TCAPMessages', 'Abort')))
    TCAP_Message._cont = ASN1Dict([
        (u'unidirectional', _TCAP_Message_unidirectional),
        (u'begin', _TCAP_Message_begin),
        (u'end', _TCAP_Message_end),
        (u'continue', _TCAP_Message_continue_),
        (u'abort', _TCAP_Message_abort),
        ])
    TCAP_Message._ext = None
    
    _all_ = [
        __TCAP_Message_unidirectional_dialoguePortion,
        ______TCAP_Message_unidirectional_components__item__basicROS_invoke_invokeId,
        _______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId_present,
        _______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId_absent,
        ______TCAP_Message_unidirectional_components__item__basicROS_invoke_linkedId,
        _______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode_tab,
        ______TCAP_Message_unidirectional_components__item__basicROS_invoke_opcode,
        _______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument_tab,
        ______TCAP_Message_unidirectional_components__item__basicROS_invoke_argument,
        _____TCAP_Message_unidirectional_components__item__basicROS_invoke,
        ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_invokeId,
        ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode_tab,
        _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_opcode,
        ________TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result_tab,
        _______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result_result,
        ______TCAP_Message_unidirectional_components__item__basicROS_returnResult_result,
        _____TCAP_Message_unidirectional_components__item__basicROS_returnResult,
        ______TCAP_Message_unidirectional_components__item__basicROS_returnError_invokeId,
        _______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode_tab,
        ______TCAP_Message_unidirectional_components__item__basicROS_returnError_errcode,
        _______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter_tab,
        ______TCAP_Message_unidirectional_components__item__basicROS_returnError_parameter,
        _____TCAP_Message_unidirectional_components__item__basicROS_returnError,
        _____TCAP_Message_unidirectional_components__item__basicROS_reject,
        ____TCAP_Message_unidirectional_components__item__basicROS,
        _____TCAP_Message_unidirectional_components__item__returnResultNotLast_invokeId,
        _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode_tab,
        ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_opcode,
        _______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result_tab,
        ______TCAP_Message_unidirectional_components__item__returnResultNotLast_result_result,
        _____TCAP_Message_unidirectional_components__item__returnResultNotLast_result,
        ____TCAP_Message_unidirectional_components__item__returnResultNotLast,
        ___TCAP_Message_unidirectional_components__item_,
        __TCAP_Message_unidirectional_components,
        _TCAP_Message_unidirectional,
        __TCAP_Message_begin_otid,
        __TCAP_Message_begin_dialoguePortion,
        ______TCAP_Message_begin_components__item__basicROS_invoke_invokeId,
        _______TCAP_Message_begin_components__item__basicROS_invoke_linkedId_present,
        _______TCAP_Message_begin_components__item__basicROS_invoke_linkedId_absent,
        ______TCAP_Message_begin_components__item__basicROS_invoke_linkedId,
        _______TCAP_Message_begin_components__item__basicROS_invoke_opcode_tab,
        ______TCAP_Message_begin_components__item__basicROS_invoke_opcode,
        _______TCAP_Message_begin_components__item__basicROS_invoke_argument_tab,
        ______TCAP_Message_begin_components__item__basicROS_invoke_argument,
        _____TCAP_Message_begin_components__item__basicROS_invoke,
        ______TCAP_Message_begin_components__item__basicROS_returnResult_invokeId,
        ________TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode_tab,
        _______TCAP_Message_begin_components__item__basicROS_returnResult_result_opcode,
        ________TCAP_Message_begin_components__item__basicROS_returnResult_result_result_tab,
        _______TCAP_Message_begin_components__item__basicROS_returnResult_result_result,
        ______TCAP_Message_begin_components__item__basicROS_returnResult_result,
        _____TCAP_Message_begin_components__item__basicROS_returnResult,
        ______TCAP_Message_begin_components__item__basicROS_returnError_invokeId,
        _______TCAP_Message_begin_components__item__basicROS_returnError_errcode_tab,
        ______TCAP_Message_begin_components__item__basicROS_returnError_errcode,
        _______TCAP_Message_begin_components__item__basicROS_returnError_parameter_tab,
        ______TCAP_Message_begin_components__item__basicROS_returnError_parameter,
        _____TCAP_Message_begin_components__item__basicROS_returnError,
        _____TCAP_Message_begin_components__item__basicROS_reject,
        ____TCAP_Message_begin_components__item__basicROS,
        _____TCAP_Message_begin_components__item__returnResultNotLast_invokeId,
        _______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode_tab,
        ______TCAP_Message_begin_components__item__returnResultNotLast_result_opcode,
        _______TCAP_Message_begin_components__item__returnResultNotLast_result_result_tab,
        ______TCAP_Message_begin_components__item__returnResultNotLast_result_result,
        _____TCAP_Message_begin_components__item__returnResultNotLast_result,
        ____TCAP_Message_begin_components__item__returnResultNotLast,
        ___TCAP_Message_begin_components__item_,
        __TCAP_Message_begin_components,
        _TCAP_Message_begin,
        __TCAP_Message_end_dtid,
        __TCAP_Message_end_dialoguePortion,
        ______TCAP_Message_end_components__item__basicROS_invoke_invokeId,
        _______TCAP_Message_end_components__item__basicROS_invoke_linkedId_present,
        _______TCAP_Message_end_components__item__basicROS_invoke_linkedId_absent,
        ______TCAP_Message_end_components__item__basicROS_invoke_linkedId,
        _______TCAP_Message_end_components__item__basicROS_invoke_opcode_tab,
        ______TCAP_Message_end_components__item__basicROS_invoke_opcode,
        _______TCAP_Message_end_components__item__basicROS_invoke_argument_tab,
        ______TCAP_Message_end_components__item__basicROS_invoke_argument,
        _____TCAP_Message_end_components__item__basicROS_invoke,
        ______TCAP_Message_end_components__item__basicROS_returnResult_invokeId,
        ________TCAP_Message_end_components__item__basicROS_returnResult_result_opcode_tab,
        _______TCAP_Message_end_components__item__basicROS_returnResult_result_opcode,
        ________TCAP_Message_end_components__item__basicROS_returnResult_result_result_tab,
        _______TCAP_Message_end_components__item__basicROS_returnResult_result_result,
        ______TCAP_Message_end_components__item__basicROS_returnResult_result,
        _____TCAP_Message_end_components__item__basicROS_returnResult,
        ______TCAP_Message_end_components__item__basicROS_returnError_invokeId,
        _______TCAP_Message_end_components__item__basicROS_returnError_errcode_tab,
        ______TCAP_Message_end_components__item__basicROS_returnError_errcode,
        _______TCAP_Message_end_components__item__basicROS_returnError_parameter_tab,
        ______TCAP_Message_end_components__item__basicROS_returnError_parameter,
        _____TCAP_Message_end_components__item__basicROS_returnError,
        _____TCAP_Message_end_components__item__basicROS_reject,
        ____TCAP_Message_end_components__item__basicROS,
        _____TCAP_Message_end_components__item__returnResultNotLast_invokeId,
        _______TCAP_Message_end_components__item__returnResultNotLast_result_opcode_tab,
        ______TCAP_Message_end_components__item__returnResultNotLast_result_opcode,
        _______TCAP_Message_end_components__item__returnResultNotLast_result_result_tab,
        ______TCAP_Message_end_components__item__returnResultNotLast_result_result,
        _____TCAP_Message_end_components__item__returnResultNotLast_result,
        ____TCAP_Message_end_components__item__returnResultNotLast,
        ___TCAP_Message_end_components__item_,
        __TCAP_Message_end_components,
        _TCAP_Message_end,
        __TCAP_Message_continue__otid,
        __TCAP_Message_continue__dtid,
        __TCAP_Message_continue__dialoguePortion,
        ______TCAP_Message_continue__components__item__basicROS_invoke_invokeId,
        _______TCAP_Message_continue__components__item__basicROS_invoke_linkedId_present,
        _______TCAP_Message_continue__components__item__basicROS_invoke_linkedId_absent,
        ______TCAP_Message_continue__components__item__basicROS_invoke_linkedId,
        _______TCAP_Message_continue__components__item__basicROS_invoke_opcode_tab,
        ______TCAP_Message_continue__components__item__basicROS_invoke_opcode,
        _______TCAP_Message_continue__components__item__basicROS_invoke_argument_tab,
        ______TCAP_Message_continue__components__item__basicROS_invoke_argument,
        _____TCAP_Message_continue__components__item__basicROS_invoke,
        ______TCAP_Message_continue__components__item__basicROS_returnResult_invokeId,
        ________TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode_tab,
        _______TCAP_Message_continue__components__item__basicROS_returnResult_result_opcode,
        ________TCAP_Message_continue__components__item__basicROS_returnResult_result_result_tab,
        _______TCAP_Message_continue__components__item__basicROS_returnResult_result_result,
        ______TCAP_Message_continue__components__item__basicROS_returnResult_result,
        _____TCAP_Message_continue__components__item__basicROS_returnResult,
        ______TCAP_Message_continue__components__item__basicROS_returnError_invokeId,
        _______TCAP_Message_continue__components__item__basicROS_returnError_errcode_tab,
        ______TCAP_Message_continue__components__item__basicROS_returnError_errcode,
        _______TCAP_Message_continue__components__item__basicROS_returnError_parameter_tab,
        ______TCAP_Message_continue__components__item__basicROS_returnError_parameter,
        _____TCAP_Message_continue__components__item__basicROS_returnError,
        _____TCAP_Message_continue__components__item__basicROS_reject,
        ____TCAP_Message_continue__components__item__basicROS,
        _____TCAP_Message_continue__components__item__returnResultNotLast_invokeId,
        _______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode_tab,
        ______TCAP_Message_continue__components__item__returnResultNotLast_result_opcode,
        _______TCAP_Message_continue__components__item__returnResultNotLast_result_result_tab,
        ______TCAP_Message_continue__components__item__returnResultNotLast_result_result,
        _____TCAP_Message_continue__components__item__returnResultNotLast_result,
        ____TCAP_Message_continue__components__item__returnResultNotLast,
        ___TCAP_Message_continue__components__item_,
        __TCAP_Message_continue__components,
        _TCAP_Message_continue_,
        _TCAP_Message_abort,
        TCAP_Message,
    ]

init_modules(DialoguePDUs, UnidialoguePDUs, Remote_Operations_Generic_ROS_PDUs, Remote_Operations_Information_Objects, TCAPMessages, Pycrate_TCAP_Dialogue, TCAP_Messages)
