# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class RNA_CommonDataTypes:

    _name_  = u'RNA-CommonDataTypes'
    _oid_   = [0, 4, 0, 0, 20, 3, 7, 1, 3]
    
    _obj_ = [
        u'maxPrivateIEs',
        u'maxProtocolExtensions',
        u'maxProtocolIEs',
        u'Criticality',
        u'Presence',
        u'PrivateIE-ID',
        u'ProcedureCode',
        u'ProtocolIE-ID',
        u'TriggeringMessage',
        ]
    _type_ = [
        u'Criticality',
        u'Presence',
        u'PrivateIE-ID',
        u'ProcedureCode',
        u'ProtocolIE-ID',
        u'TriggeringMessage',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxPrivateIEs',
        u'maxProtocolExtensions',
        u'maxProtocolIEs',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< maxPrivateIEs >-----#
    maxPrivateIEs = INT(name=u'maxPrivateIEs', mode=MODE_VALUE)
    maxPrivateIEs._val = 65535
    
    #-----< maxProtocolExtensions >-----#
    maxProtocolExtensions = INT(name=u'maxProtocolExtensions', mode=MODE_VALUE)
    maxProtocolExtensions._val = 65535
    
    #-----< maxProtocolIEs >-----#
    maxProtocolIEs = INT(name=u'maxProtocolIEs', mode=MODE_VALUE)
    maxProtocolIEs._val = 65535
    
    #-----< Criticality >-----#
    Criticality = ENUM(name=u'Criticality', mode=MODE_TYPE)
    Criticality._cont = ASN1Dict([(u'reject', 0), (u'ignore', 1), (u'notify', 2)])
    Criticality._ext = None
    
    #-----< Presence >-----#
    Presence = ENUM(name=u'Presence', mode=MODE_TYPE)
    Presence._cont = ASN1Dict([(u'optional', 0), (u'conditional', 1), (u'mandatory', 2)])
    Presence._ext = None
    
    #-----< PrivateIE-ID >-----#
    PrivateIE_ID = CHOICE(name=u'PrivateIE-ID', mode=MODE_TYPE)
    _PrivateIE_ID_local = INT(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrivateIE_ID_local._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _PrivateIE_ID_global_ = OID(name=u'global', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    PrivateIE_ID._cont = ASN1Dict([
        (u'local', _PrivateIE_ID_local),
        (u'global', _PrivateIE_ID_global_),
        ])
    PrivateIE_ID._ext = None
    
    #-----< ProcedureCode >-----#
    ProcedureCode = INT(name=u'ProcedureCode', mode=MODE_TYPE)
    ProcedureCode._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< ProtocolIE-ID >-----#
    ProtocolIE_ID = INT(name=u'ProtocolIE-ID', mode=MODE_TYPE)
    ProtocolIE_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    
    #-----< TriggeringMessage >-----#
    TriggeringMessage = ENUM(name=u'TriggeringMessage', mode=MODE_TYPE)
    TriggeringMessage._cont = ASN1Dict([(u'initiating-message', 0), (u'successful-outcome', 1), (u'unsuccessful-outcome', 2), (u'outcome', 3)])
    TriggeringMessage._ext = None
    
    _all_ = [
        maxPrivateIEs,
        maxProtocolExtensions,
        maxProtocolIEs,
        Criticality,
        Presence,
        _PrivateIE_ID_local,
        _PrivateIE_ID_global_,
        PrivateIE_ID,
        ProcedureCode,
        ProtocolIE_ID,
        TriggeringMessage,
    ]

class RNA_Constants:

    _name_  = u'RNA-Constants'
    _oid_   = [0, 4, 0, 0, 20, 3, 7, 1, 4]
    
    _obj_ = [
        u'id-IurhSetup',
        u'id-Connect',
        u'id-DirectTransfer',
        u'id-Disconnect',
        u'id-ConnectionlessTransfer',
        u'id-ErrorIndication',
        u'id-privateMessage',
        u'maxNrOfErrors',
        u'id-Cause',
        u'id-CriticalityDiagnostics',
        u'id-RNSAP-Message',
        u'id-BackoffTimer',
        u'id-Senders-HNB-RNL-ID',
        u'id-Receivers-HNB-RNL-ID',
        u'id-Iurh-Signalling-Context-ID',
        u'id-HNB-RNL-ID',
        u'id-HNB-Cell-Identifier',
        u'id-GlobalRNC-ID',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-IurhSetup',
        u'id-Connect',
        u'id-DirectTransfer',
        u'id-Disconnect',
        u'id-ConnectionlessTransfer',
        u'id-ErrorIndication',
        u'id-privateMessage',
        u'maxNrOfErrors',
        u'id-Cause',
        u'id-CriticalityDiagnostics',
        u'id-RNSAP-Message',
        u'id-BackoffTimer',
        u'id-Senders-HNB-RNL-ID',
        u'id-Receivers-HNB-RNL-ID',
        u'id-Iurh-Signalling-Context-ID',
        u'id-HNB-RNL-ID',
        u'id-HNB-Cell-Identifier',
        u'id-GlobalRNC-ID',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-IurhSetup >-----#
    id_IurhSetup = INT(name=u'id-IurhSetup', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_IurhSetup._val = 1
    
    #-----< id-Connect >-----#
    id_Connect = INT(name=u'id-Connect', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_Connect._val = 2
    
    #-----< id-DirectTransfer >-----#
    id_DirectTransfer = INT(name=u'id-DirectTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_DirectTransfer._val = 3
    
    #-----< id-Disconnect >-----#
    id_Disconnect = INT(name=u'id-Disconnect', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_Disconnect._val = 4
    
    #-----< id-ConnectionlessTransfer >-----#
    id_ConnectionlessTransfer = INT(name=u'id-ConnectionlessTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_ConnectionlessTransfer._val = 5
    
    #-----< id-ErrorIndication >-----#
    id_ErrorIndication = INT(name=u'id-ErrorIndication', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_ErrorIndication._val = 6
    
    #-----< id-privateMessage >-----#
    id_privateMessage = INT(name=u'id-privateMessage', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')))
    id_privateMessage._val = 7
    
    #-----< maxNrOfErrors >-----#
    maxNrOfErrors = INT(name=u'maxNrOfErrors', mode=MODE_VALUE)
    maxNrOfErrors._val = 256
    
    #-----< id-Cause >-----#
    id_Cause = INT(name=u'id-Cause', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Cause._val = 1
    
    #-----< id-CriticalityDiagnostics >-----#
    id_CriticalityDiagnostics = INT(name=u'id-CriticalityDiagnostics', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_CriticalityDiagnostics._val = 2
    
    #-----< id-RNSAP-Message >-----#
    id_RNSAP_Message = INT(name=u'id-RNSAP-Message', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_RNSAP_Message._val = 3
    
    #-----< id-BackoffTimer >-----#
    id_BackoffTimer = INT(name=u'id-BackoffTimer', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_BackoffTimer._val = 4
    
    #-----< id-Senders-HNB-RNL-ID >-----#
    id_Senders_HNB_RNL_ID = INT(name=u'id-Senders-HNB-RNL-ID', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Senders_HNB_RNL_ID._val = 5
    
    #-----< id-Receivers-HNB-RNL-ID >-----#
    id_Receivers_HNB_RNL_ID = INT(name=u'id-Receivers-HNB-RNL-ID', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Receivers_HNB_RNL_ID._val = 6
    
    #-----< id-Iurh-Signalling-Context-ID >-----#
    id_Iurh_Signalling_Context_ID = INT(name=u'id-Iurh-Signalling-Context-ID', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_Iurh_Signalling_Context_ID._val = 7
    
    #-----< id-HNB-RNL-ID >-----#
    id_HNB_RNL_ID = INT(name=u'id-HNB-RNL-ID', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_HNB_RNL_ID._val = 8
    
    #-----< id-HNB-Cell-Identifier >-----#
    id_HNB_Cell_Identifier = INT(name=u'id-HNB-Cell-Identifier', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_HNB_Cell_Identifier._val = 9
    
    #-----< id-GlobalRNC-ID >-----#
    id_GlobalRNC_ID = INT(name=u'id-GlobalRNC-ID', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    id_GlobalRNC_ID._val = 10
    
    _all_ = [
        id_IurhSetup,
        id_Connect,
        id_DirectTransfer,
        id_Disconnect,
        id_ConnectionlessTransfer,
        id_ErrorIndication,
        id_privateMessage,
        maxNrOfErrors,
        id_Cause,
        id_CriticalityDiagnostics,
        id_RNSAP_Message,
        id_BackoffTimer,
        id_Senders_HNB_RNL_ID,
        id_Receivers_HNB_RNL_ID,
        id_Iurh_Signalling_Context_ID,
        id_HNB_RNL_ID,
        id_HNB_Cell_Identifier,
        id_GlobalRNC_ID,
    ]

class RNA_Containers:

    _name_  = u'RNA-Containers'
    _oid_   = [0, 4, 0, 0, 20, 3, 7, 1, 5]
    
    _obj_ = [
        u'RNA-PROTOCOL-IES',
        u'RNA-PROTOCOL-EXTENSION',
        u'RNA-PRIVATE-IES',
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    _type_ = [
        u'RNA-PROTOCOL-IES',
        u'RNA-PROTOCOL-EXTENSION',
        u'RNA-PRIVATE-IES',
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'RNA-PROTOCOL-IES',
        u'RNA-PROTOCOL-EXTENSION',
        u'RNA-PRIVATE-IES',
        ]
    _param_ = [
        u'ProtocolIE-Container',
        u'ProtocolIE-Single-Container',
        u'ProtocolIE-Field',
        u'ProtocolIE-ContainerList',
        u'ProtocolExtensionContainer',
        u'ProtocolExtensionField',
        u'PrivateIE-Container',
        u'PrivateIE-Field',
        ]
    
    #-----< RNA-PROTOCOL-IES >-----#
    RNA_PROTOCOL_IES = CLASS(name=u'RNA-PROTOCOL-IES', mode=MODE_TYPE)
    _RNA_PROTOCOL_IES_id = INT(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')), uniq=True)
    _RNA_PROTOCOL_IES_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Criticality')))
    _RNA_PROTOCOL_IES_Value = OPEN(name=u'Value', mode=MODE_TYPE)
    _RNA_PROTOCOL_IES_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Presence')))
    RNA_PROTOCOL_IES._cont = ASN1Dict([
        (u'id', _RNA_PROTOCOL_IES_id),
        (u'criticality', _RNA_PROTOCOL_IES_criticality),
        (u'Value', _RNA_PROTOCOL_IES_Value),
        (u'presence', _RNA_PROTOCOL_IES_presence),
        ])
    
    #-----< RNA-PROTOCOL-EXTENSION >-----#
    RNA_PROTOCOL_EXTENSION = CLASS(name=u'RNA-PROTOCOL-EXTENSION', mode=MODE_TYPE)
    _RNA_PROTOCOL_EXTENSION_id = INT(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')), uniq=True)
    _RNA_PROTOCOL_EXTENSION_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Criticality')))
    _RNA_PROTOCOL_EXTENSION_Extension = OPEN(name=u'Extension', mode=MODE_TYPE)
    _RNA_PROTOCOL_EXTENSION_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Presence')))
    RNA_PROTOCOL_EXTENSION._cont = ASN1Dict([
        (u'id', _RNA_PROTOCOL_EXTENSION_id),
        (u'criticality', _RNA_PROTOCOL_EXTENSION_criticality),
        (u'Extension', _RNA_PROTOCOL_EXTENSION_Extension),
        (u'presence', _RNA_PROTOCOL_EXTENSION_presence),
        ])
    
    #-----< RNA-PRIVATE-IES >-----#
    RNA_PRIVATE_IES = CLASS(name=u'RNA-PRIVATE-IES', mode=MODE_TYPE)
    _RNA_PRIVATE_IES_id = CHOICE(name=u'id', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'PrivateIE-ID')))
    _RNA_PRIVATE_IES_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Criticality')))
    _RNA_PRIVATE_IES_Value = OPEN(name=u'Value', mode=MODE_TYPE)
    _RNA_PRIVATE_IES_presence = ENUM(name=u'presence', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Presence')))
    RNA_PRIVATE_IES._cont = ASN1Dict([
        (u'id', _RNA_PRIVATE_IES_id),
        (u'criticality', _RNA_PRIVATE_IES_criticality),
        (u'Value', _RNA_PRIVATE_IES_Value),
        (u'presence', _RNA_PRIVATE_IES_presence),
        ])
    
    #-----< ProtocolIE-Container >-----#
    ProtocolIE_Container = SEQ_OF(name=u'ProtocolIE-Container', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolIE-Single-Container >-----#
    ProtocolIE_Single_Container = SEQ(name=u'ProtocolIE-Single-Container', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')), param=True)
    
    #-----< ProtocolIE-Field >-----#
    ProtocolIE_Field = SEQ(name=u'ProtocolIE-Field', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolIE-ContainerList >-----#
    ProtocolIE_ContainerList = SEQ_OF(name=u'ProtocolIE-ContainerList', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolExtensionContainer >-----#
    ProtocolExtensionContainer = SEQ_OF(name=u'ProtocolExtensionContainer', mode=MODE_TYPE, param=True)
    
    #-----< ProtocolExtensionField >-----#
    ProtocolExtensionField = SEQ(name=u'ProtocolExtensionField', mode=MODE_TYPE, param=True)
    
    #-----< PrivateIE-Container >-----#
    PrivateIE_Container = SEQ_OF(name=u'PrivateIE-Container', mode=MODE_TYPE, param=True)
    
    #-----< PrivateIE-Field >-----#
    PrivateIE_Field = SEQ(name=u'PrivateIE-Field', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _RNA_PROTOCOL_IES_id,
        _RNA_PROTOCOL_IES_criticality,
        _RNA_PROTOCOL_IES_Value,
        _RNA_PROTOCOL_IES_presence,
        RNA_PROTOCOL_IES,
        _RNA_PROTOCOL_EXTENSION_id,
        _RNA_PROTOCOL_EXTENSION_criticality,
        _RNA_PROTOCOL_EXTENSION_Extension,
        _RNA_PROTOCOL_EXTENSION_presence,
        RNA_PROTOCOL_EXTENSION,
        _RNA_PRIVATE_IES_id,
        _RNA_PRIVATE_IES_criticality,
        _RNA_PRIVATE_IES_Value,
        _RNA_PRIVATE_IES_presence,
        RNA_PRIVATE_IES,
    ]

class RNA_IEs:

    _name_  = u'RNA-IEs'
    _oid_   = [0, 4, 0, 0, 20, 3, 7, 1, 2]
    
    _obj_ = [
        u'BackoffTimer',
        u'Cause',
        u'CauseRadioNetwork',
        u'CauseTransport',
        u'CauseProtocol',
        u'CauseMisc',
        u'CellIdentity',
        u'CriticalityDiagnostics',
        u'CriticalityDiagnostics-IE-List',
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'HNB-RNL-ID',
        u'Extension-HNB-RNL-ID',
        u'Extension-HNB-RNL-ID-IE',
        u'HNB-Cell-Identifier',
        u'HNB-Cell-Identifier-ExtIEs',
        u'Iurh-Signalling-Context-ID',
        u'PLMN-ID',
        u'GlobalRNC-ID',
        u'GlobalRNC-ID-ExtIEs',
        u'RNSAP-Message',
        u'TypeOfError',
        ]
    _type_ = [
        u'BackoffTimer',
        u'Cause',
        u'CauseRadioNetwork',
        u'CauseTransport',
        u'CauseProtocol',
        u'CauseMisc',
        u'CellIdentity',
        u'CriticalityDiagnostics',
        u'CriticalityDiagnostics-IE-List',
        u'HNB-RNL-ID',
        u'Extension-HNB-RNL-ID',
        u'HNB-Cell-Identifier',
        u'Iurh-Signalling-Context-ID',
        u'PLMN-ID',
        u'GlobalRNC-ID',
        u'RNSAP-Message',
        u'TypeOfError',
        ]
    _set_ = [
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'Extension-HNB-RNL-ID-IE',
        u'HNB-Cell-Identifier-ExtIEs',
        u'GlobalRNC-ID-ExtIEs',
        ]
    _val_ = [
        ]
    _class_ = [
        u'CriticalityDiagnostics-IE-List-ExtIEs',
        u'CriticalityDiagnostics-ExtIEs',
        u'Extension-HNB-RNL-ID-IE',
        u'HNB-Cell-Identifier-ExtIEs',
        u'GlobalRNC-ID-ExtIEs',
        ]
    _param_ = [
        ]
    
    #-----< BackoffTimer >-----#
    BackoffTimer = INT(name=u'BackoffTimer', mode=MODE_TYPE)
    BackoffTimer._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3600)], ev=None, er=[])
    
    #-----< Cause >-----#
    Cause = CHOICE(name=u'Cause', mode=MODE_TYPE)
    _Cause_radioNetwork = ENUM(name=u'radioNetwork', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'CauseRadioNetwork')))
    _Cause_transport = ENUM(name=u'transport', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'CauseTransport')))
    _Cause_protocol = ENUM(name=u'protocol', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'CauseProtocol')))
    _Cause_misc = ENUM(name=u'misc', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'CauseMisc')))
    Cause._cont = ASN1Dict([
        (u'radioNetwork', _Cause_radioNetwork),
        (u'transport', _Cause_transport),
        (u'protocol', _Cause_protocol),
        (u'misc', _Cause_misc),
        ])
    Cause._ext = []
    
    #-----< CauseRadioNetwork >-----#
    CauseRadioNetwork = ENUM(name=u'CauseRadioNetwork', mode=MODE_TYPE)
    CauseRadioNetwork._cont = ASN1Dict([(u'normal', 0), (u'connect-failed', 1), (u'network-release', 2), (u'unknown-or-already-allocated-Iurh-Context-ID', 3), (u'unspecificed', 4), (u'peer-RNC-not-available', 5)])
    CauseRadioNetwork._ext = [u'peer-RNC-not-available']
    
    #-----< CauseTransport >-----#
    CauseTransport = ENUM(name=u'CauseTransport', mode=MODE_TYPE)
    CauseTransport._cont = ASN1Dict([(u'transport-resource-unavailable', 0), (u'unspecified', 1)])
    CauseTransport._ext = []
    
    #-----< CauseProtocol >-----#
    CauseProtocol = ENUM(name=u'CauseProtocol', mode=MODE_TYPE)
    CauseProtocol._cont = ASN1Dict([(u'transfer-syntax-error', 0), (u'abstract-syntax-error-reject', 1), (u'abstract-syntax-error-ignore-and-notify', 2), (u'message-not-compatible-with-receiver-state', 3), (u'semantic-error', 4), (u'unspecified', 5), (u'abstract-syntax-error-falsely-constructed-message', 6)])
    CauseProtocol._ext = []
    
    #-----< CauseMisc >-----#
    CauseMisc = ENUM(name=u'CauseMisc', mode=MODE_TYPE)
    CauseMisc._cont = ASN1Dict([(u'processing-overload', 0), (u'hardware-failure', 1), (u'o-and-m-intervention', 2), (u'unspecified', 3)])
    CauseMisc._ext = []
    
    #-----< CellIdentity >-----#
    CellIdentity = BIT_STR(name=u'CellIdentity', mode=MODE_TYPE)
    CellIdentity._const_sz = ASN1Set(rv=[28], rr=[], ev=None, er=[])
    
    #-----< CriticalityDiagnostics >-----#
    CriticalityDiagnostics = SEQ(name=u'CriticalityDiagnostics', mode=MODE_TYPE)
    _CriticalityDiagnostics_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')), opt=True)
    _CriticalityDiagnostics_triggeringMessage = ENUM(name=u'triggeringMessage', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-CommonDataTypes', 'TriggeringMessage')), opt=True)
    _CriticalityDiagnostics_procedureCriticality = ENUM(name=u'procedureCriticality', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-CommonDataTypes', 'Criticality')), opt=True)
    _CriticalityDiagnostics_iEsCriticalityDiagnostics = SEQ_OF(name=u'iEsCriticalityDiagnostics', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'CriticalityDiagnostics-IE-List')), opt=True)
    _CriticalityDiagnostics_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __CriticalityDiagnostics_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___CriticalityDiagnostics_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____CriticalityDiagnostics_iE_Extensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__id_tab
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab_at = None
    ___CriticalityDiagnostics_iE_Extensions__item__id._const_tab_id = u'id'
    ___CriticalityDiagnostics_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___CriticalityDiagnostics_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab = ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___CriticalityDiagnostics_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __CriticalityDiagnostics_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___CriticalityDiagnostics_iE_Extensions__item__id),
        (u'criticality', ___CriticalityDiagnostics_iE_Extensions__item__criticality),
        (u'extensionValue', ___CriticalityDiagnostics_iE_Extensions__item__extensionValue),
        ])
    __CriticalityDiagnostics_iE_Extensions__item_._ext = None
    _CriticalityDiagnostics_iE_Extensions._cont = __CriticalityDiagnostics_iE_Extensions__item_
    _CriticalityDiagnostics_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    CriticalityDiagnostics._cont = ASN1Dict([
        (u'procedureCode', _CriticalityDiagnostics_procedureCode),
        (u'triggeringMessage', _CriticalityDiagnostics_triggeringMessage),
        (u'procedureCriticality', _CriticalityDiagnostics_procedureCriticality),
        (u'iEsCriticalityDiagnostics', _CriticalityDiagnostics_iEsCriticalityDiagnostics),
        (u'iE-Extensions', _CriticalityDiagnostics_iE_Extensions),
        ])
    CriticalityDiagnostics._ext = []
    
    #-----< CriticalityDiagnostics-IE-List >-----#
    CriticalityDiagnostics_IE_List = SEQ_OF(name=u'CriticalityDiagnostics-IE-List', mode=MODE_TYPE)
    _CriticalityDiagnostics_IE_List__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __CriticalityDiagnostics_IE_List__item__iECriticality = ENUM(name=u'iECriticality', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-CommonDataTypes', 'Criticality')))
    __CriticalityDiagnostics_IE_List__item__iE_ID = INT(name=u'iE-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProtocolIE-ID')))
    __CriticalityDiagnostics_IE_List__item__typeOfError = ENUM(name=u'typeOfError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'TypeOfError')))
    __CriticalityDiagnostics_IE_List__item__iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab_at = None
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id._const_tab_id = u'id'
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab = _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id),
        (u'criticality', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality),
        (u'extensionValue', ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue),
        ])
    ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_._ext = None
    __CriticalityDiagnostics_IE_List__item__iE_Extensions._cont = ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_
    __CriticalityDiagnostics_IE_List__item__iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    _CriticalityDiagnostics_IE_List__item_._cont = ASN1Dict([
        (u'iECriticality', __CriticalityDiagnostics_IE_List__item__iECriticality),
        (u'iE-ID', __CriticalityDiagnostics_IE_List__item__iE_ID),
        (u'typeOfError', __CriticalityDiagnostics_IE_List__item__typeOfError),
        (u'iE-Extensions', __CriticalityDiagnostics_IE_List__item__iE_Extensions),
        ])
    _CriticalityDiagnostics_IE_List__item_._ext = []
    CriticalityDiagnostics_IE_List._cont = _CriticalityDiagnostics_IE_List__item_
    CriticalityDiagnostics_IE_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< CriticalityDiagnostics-IE-List-ExtIEs >-----#
    CriticalityDiagnostics_IE_List_ExtIEs = CLASS(name=u'CriticalityDiagnostics-IE-List-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    CriticalityDiagnostics_IE_List_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CriticalityDiagnostics-ExtIEs >-----#
    CriticalityDiagnostics_ExtIEs = CLASS(name=u'CriticalityDiagnostics-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    CriticalityDiagnostics_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< HNB-RNL-ID >-----#
    HNB_RNL_ID = CHOICE(name=u'HNB-RNL-ID', mode=MODE_TYPE)
    _HNB_RNL_ID_hNB_Identity_as_Global_Cell_Identifier = SEQ(name=u'hNB-Identity-as-Global-Cell-Identifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'HNB-Cell-Identifier')))
    _HNB_RNL_ID_extension_HNB_RNL_ID = SEQ(name=u'extension-HNB-RNL-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'Extension-HNB-RNL-ID')))
    HNB_RNL_ID._cont = ASN1Dict([
        (u'hNB-Identity-as-Global-Cell-Identifier', _HNB_RNL_ID_hNB_Identity_as_Global_Cell_Identifier),
        (u'extension-HNB-RNL-ID', _HNB_RNL_ID_extension_HNB_RNL_ID),
        ])
    HNB_RNL_ID._ext = [u'extension-HNB-RNL-ID']
    
    #-----< Extension-HNB-RNL-ID >-----#
    Extension_HNB_RNL_ID = SEQ(name=u'Extension-HNB-RNL-ID', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Single-Container')))
    _Extension_HNB_RNL_ID_id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    __Extension_HNB_RNL_ID_id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    ___Extension_HNB_RNL_ID_id_tab_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'GlobalRNC-ID')))
    __Extension_HNB_RNL_ID_id_tab._val = ASN1Set(rv=[dict([(u'id', 10), (u'criticality', u'reject'), (u'Value', ___Extension_HNB_RNL_ID_id_tab_val_Value_0), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    _Extension_HNB_RNL_ID_id._const_tab = __Extension_HNB_RNL_ID_id_tab
    _Extension_HNB_RNL_ID_id._const_tab_at = None
    _Extension_HNB_RNL_ID_id._const_tab_id = u'id'
    _Extension_HNB_RNL_ID_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    _Extension_HNB_RNL_ID_criticality._const_tab = __Extension_HNB_RNL_ID_id_tab
    _Extension_HNB_RNL_ID_criticality._const_tab_at = ('..', u'id')
    _Extension_HNB_RNL_ID_criticality._const_tab_id = u'criticality'
    _Extension_HNB_RNL_ID_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    _Extension_HNB_RNL_ID_value._const_tab = __Extension_HNB_RNL_ID_id_tab
    _Extension_HNB_RNL_ID_value._const_tab_at = ('..', u'id')
    _Extension_HNB_RNL_ID_value._const_tab_id = u'Value'
    Extension_HNB_RNL_ID._cont = ASN1Dict([
        (u'id', _Extension_HNB_RNL_ID_id),
        (u'criticality', _Extension_HNB_RNL_ID_criticality),
        (u'value', _Extension_HNB_RNL_ID_value),
        ])
    Extension_HNB_RNL_ID._ext = None
    
    #-----< Extension-HNB-RNL-ID-IE >-----#
    Extension_HNB_RNL_ID_IE = CLASS(name=u'Extension-HNB-RNL-ID-IE', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _Extension_HNB_RNL_ID_IE_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'GlobalRNC-ID')))
    Extension_HNB_RNL_ID_IE._val = ASN1Set(rv=[dict([(u'id', 10), (u'criticality', u'reject'), (u'Value', _Extension_HNB_RNL_ID_IE_val_Value_0), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< HNB-Cell-Identifier >-----#
    HNB_Cell_Identifier = SEQ(name=u'HNB-Cell-Identifier', mode=MODE_TYPE)
    _HNB_Cell_Identifier_pLMN_ID = OCT_STR(name=u'pLMN-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'PLMN-ID')))
    _HNB_Cell_Identifier_cell_ID = BIT_STR(name=u'cell-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'CellIdentity')))
    _HNB_Cell_Identifier_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __HNB_Cell_Identifier_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___HNB_Cell_Identifier_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____HNB_Cell_Identifier_iE_Extensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____HNB_Cell_Identifier_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___HNB_Cell_Identifier_iE_Extensions__item__id._const_tab = ____HNB_Cell_Identifier_iE_Extensions__item__id_tab
    ___HNB_Cell_Identifier_iE_Extensions__item__id._const_tab_at = None
    ___HNB_Cell_Identifier_iE_Extensions__item__id._const_tab_id = u'id'
    ___HNB_Cell_Identifier_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____HNB_Cell_Identifier_iE_Extensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____HNB_Cell_Identifier_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___HNB_Cell_Identifier_iE_Extensions__item__criticality._const_tab = ____HNB_Cell_Identifier_iE_Extensions__item__criticality_tab
    ___HNB_Cell_Identifier_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___HNB_Cell_Identifier_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___HNB_Cell_Identifier_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____HNB_Cell_Identifier_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____HNB_Cell_Identifier_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___HNB_Cell_Identifier_iE_Extensions__item__extensionValue._const_tab = ____HNB_Cell_Identifier_iE_Extensions__item__extensionValue_tab
    ___HNB_Cell_Identifier_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___HNB_Cell_Identifier_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __HNB_Cell_Identifier_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___HNB_Cell_Identifier_iE_Extensions__item__id),
        (u'criticality', ___HNB_Cell_Identifier_iE_Extensions__item__criticality),
        (u'extensionValue', ___HNB_Cell_Identifier_iE_Extensions__item__extensionValue),
        ])
    __HNB_Cell_Identifier_iE_Extensions__item_._ext = None
    _HNB_Cell_Identifier_iE_Extensions._cont = __HNB_Cell_Identifier_iE_Extensions__item_
    _HNB_Cell_Identifier_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    HNB_Cell_Identifier._cont = ASN1Dict([
        (u'pLMN-ID', _HNB_Cell_Identifier_pLMN_ID),
        (u'cell-ID', _HNB_Cell_Identifier_cell_ID),
        (u'iE-Extensions', _HNB_Cell_Identifier_iE_Extensions),
        ])
    HNB_Cell_Identifier._ext = []
    
    #-----< HNB-Cell-Identifier-ExtIEs >-----#
    HNB_Cell_Identifier_ExtIEs = CLASS(name=u'HNB-Cell-Identifier-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    HNB_Cell_Identifier_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Iurh-Signalling-Context-ID >-----#
    Iurh_Signalling_Context_ID = BIT_STR(name=u'Iurh-Signalling-Context-ID', mode=MODE_TYPE)
    Iurh_Signalling_Context_ID._const_sz = ASN1Set(rv=[24], rr=[], ev=None, er=[])
    
    #-----< PLMN-ID >-----#
    PLMN_ID = OCT_STR(name=u'PLMN-ID', mode=MODE_TYPE)
    PLMN_ID._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< GlobalRNC-ID >-----#
    GlobalRNC_ID = SEQ(name=u'GlobalRNC-ID', mode=MODE_TYPE)
    _GlobalRNC_ID_pLMN_ID = OCT_STR(name=u'pLMN-ID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-IEs', 'PLMN-ID')))
    _GlobalRNC_ID_rnc_ID = INT(name=u'rnc-ID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GlobalRNC_ID_rnc_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _GlobalRNC_ID_iE_Extensions = SEQ_OF(name=u'iE-Extensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __GlobalRNC_ID_iE_Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___GlobalRNC_ID_iE_Extensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____GlobalRNC_ID_iE_Extensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____GlobalRNC_ID_iE_Extensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GlobalRNC_ID_iE_Extensions__item__id._const_tab = ____GlobalRNC_ID_iE_Extensions__item__id_tab
    ___GlobalRNC_ID_iE_Extensions__item__id._const_tab_at = None
    ___GlobalRNC_ID_iE_Extensions__item__id._const_tab_id = u'id'
    ___GlobalRNC_ID_iE_Extensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____GlobalRNC_ID_iE_Extensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____GlobalRNC_ID_iE_Extensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GlobalRNC_ID_iE_Extensions__item__criticality._const_tab = ____GlobalRNC_ID_iE_Extensions__item__criticality_tab
    ___GlobalRNC_ID_iE_Extensions__item__criticality._const_tab_at = ('..', u'id')
    ___GlobalRNC_ID_iE_Extensions__item__criticality._const_tab_id = u'criticality'
    ___GlobalRNC_ID_iE_Extensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____GlobalRNC_ID_iE_Extensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____GlobalRNC_ID_iE_Extensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___GlobalRNC_ID_iE_Extensions__item__extensionValue._const_tab = ____GlobalRNC_ID_iE_Extensions__item__extensionValue_tab
    ___GlobalRNC_ID_iE_Extensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___GlobalRNC_ID_iE_Extensions__item__extensionValue._const_tab_id = u'Extension'
    __GlobalRNC_ID_iE_Extensions__item_._cont = ASN1Dict([
        (u'id', ___GlobalRNC_ID_iE_Extensions__item__id),
        (u'criticality', ___GlobalRNC_ID_iE_Extensions__item__criticality),
        (u'extensionValue', ___GlobalRNC_ID_iE_Extensions__item__extensionValue),
        ])
    __GlobalRNC_ID_iE_Extensions__item_._ext = None
    _GlobalRNC_ID_iE_Extensions._cont = __GlobalRNC_ID_iE_Extensions__item_
    _GlobalRNC_ID_iE_Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    GlobalRNC_ID._cont = ASN1Dict([
        (u'pLMN-ID', _GlobalRNC_ID_pLMN_ID),
        (u'rnc-ID', _GlobalRNC_ID_rnc_ID),
        (u'iE-Extensions', _GlobalRNC_ID_iE_Extensions),
        ])
    GlobalRNC_ID._ext = []
    
    #-----< GlobalRNC-ID-ExtIEs >-----#
    GlobalRNC_ID_ExtIEs = CLASS(name=u'GlobalRNC-ID-ExtIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    GlobalRNC_ID_ExtIEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RNSAP-Message >-----#
    RNSAP_Message = OCT_STR(name=u'RNSAP-Message', mode=MODE_TYPE)
    
    #-----< TypeOfError >-----#
    TypeOfError = ENUM(name=u'TypeOfError', mode=MODE_TYPE)
    TypeOfError._cont = ASN1Dict([(u'not-understood', 0), (u'missing', 1)])
    TypeOfError._ext = []
    
    _all_ = [
        BackoffTimer,
        _Cause_radioNetwork,
        _Cause_transport,
        _Cause_protocol,
        _Cause_misc,
        Cause,
        CauseRadioNetwork,
        CauseTransport,
        CauseProtocol,
        CauseMisc,
        CellIdentity,
        _CriticalityDiagnostics_procedureCode,
        _CriticalityDiagnostics_triggeringMessage,
        _CriticalityDiagnostics_procedureCriticality,
        _CriticalityDiagnostics_iEsCriticalityDiagnostics,
        ____CriticalityDiagnostics_iE_Extensions__item__id_tab,
        ___CriticalityDiagnostics_iE_Extensions__item__id,
        ____CriticalityDiagnostics_iE_Extensions__item__criticality_tab,
        ___CriticalityDiagnostics_iE_Extensions__item__criticality,
        ____CriticalityDiagnostics_iE_Extensions__item__extensionValue_tab,
        ___CriticalityDiagnostics_iE_Extensions__item__extensionValue,
        __CriticalityDiagnostics_iE_Extensions__item_,
        _CriticalityDiagnostics_iE_Extensions,
        CriticalityDiagnostics,
        __CriticalityDiagnostics_IE_List__item__iECriticality,
        __CriticalityDiagnostics_IE_List__item__iE_ID,
        __CriticalityDiagnostics_IE_List__item__typeOfError,
        _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id_tab,
        ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__id,
        _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality_tab,
        ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__criticality,
        _____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue_tab,
        ____CriticalityDiagnostics_IE_List__item__iE_Extensions__item__extensionValue,
        ___CriticalityDiagnostics_IE_List__item__iE_Extensions__item_,
        __CriticalityDiagnostics_IE_List__item__iE_Extensions,
        _CriticalityDiagnostics_IE_List__item_,
        CriticalityDiagnostics_IE_List,
        CriticalityDiagnostics_IE_List_ExtIEs,
        CriticalityDiagnostics_ExtIEs,
        _HNB_RNL_ID_hNB_Identity_as_Global_Cell_Identifier,
        _HNB_RNL_ID_extension_HNB_RNL_ID,
        HNB_RNL_ID,
        __Extension_HNB_RNL_ID_id_tab,
        ___Extension_HNB_RNL_ID_id_tab_val_Value_0,
        _Extension_HNB_RNL_ID_id,
        _Extension_HNB_RNL_ID_criticality,
        _Extension_HNB_RNL_ID_value,
        Extension_HNB_RNL_ID,
        Extension_HNB_RNL_ID_IE,
        _Extension_HNB_RNL_ID_IE_val_Value_0,
        _HNB_Cell_Identifier_pLMN_ID,
        _HNB_Cell_Identifier_cell_ID,
        ____HNB_Cell_Identifier_iE_Extensions__item__id_tab,
        ___HNB_Cell_Identifier_iE_Extensions__item__id,
        ____HNB_Cell_Identifier_iE_Extensions__item__criticality_tab,
        ___HNB_Cell_Identifier_iE_Extensions__item__criticality,
        ____HNB_Cell_Identifier_iE_Extensions__item__extensionValue_tab,
        ___HNB_Cell_Identifier_iE_Extensions__item__extensionValue,
        __HNB_Cell_Identifier_iE_Extensions__item_,
        _HNB_Cell_Identifier_iE_Extensions,
        HNB_Cell_Identifier,
        HNB_Cell_Identifier_ExtIEs,
        Iurh_Signalling_Context_ID,
        PLMN_ID,
        _GlobalRNC_ID_pLMN_ID,
        _GlobalRNC_ID_rnc_ID,
        ____GlobalRNC_ID_iE_Extensions__item__id_tab,
        ___GlobalRNC_ID_iE_Extensions__item__id,
        ____GlobalRNC_ID_iE_Extensions__item__criticality_tab,
        ___GlobalRNC_ID_iE_Extensions__item__criticality,
        ____GlobalRNC_ID_iE_Extensions__item__extensionValue_tab,
        ___GlobalRNC_ID_iE_Extensions__item__extensionValue,
        __GlobalRNC_ID_iE_Extensions__item_,
        _GlobalRNC_ID_iE_Extensions,
        GlobalRNC_ID,
        GlobalRNC_ID_ExtIEs,
        RNSAP_Message,
        TypeOfError,
    ]

class RNA_PDU_Contents:

    _name_  = u'RNA-PDU-Contents'
    _oid_   = [0, 4, 0, 0, 20, 3, 7, 1, 1]
    
    _obj_ = [
        u'IurhSetupRequest',
        u'IurhSetupRequestIEs',
        u'IurhSetupRequestExtensions',
        u'IurhSetupResponse',
        u'IurhSetupResponseIEs',
        u'IurhSetupResponseExtensions',
        u'IurhSetupFailure',
        u'IurhSetupFailureIEs',
        u'IurhSetupFailureExtensions',
        u'Connect',
        u'ConnectIEs',
        u'ConnectExtensions',
        u'DirectTransfer',
        u'DirectTransferIEs',
        u'DirectTransferExtensions',
        u'Disconnect',
        u'DisconnectIEs',
        u'DisconnectExtensions',
        u'ConnectionlessTransfer',
        u'ConnectionlessTransferIEs',
        u'ConnectionlessTransferExtensions',
        u'ErrorIndication',
        u'ErrorIndicationIEs',
        u'ErrorIndicationExtensions',
        u'PrivateMessage',
        u'PrivateMessage-IEs',
        ]
    _type_ = [
        u'IurhSetupRequest',
        u'IurhSetupResponse',
        u'IurhSetupFailure',
        u'Connect',
        u'DirectTransfer',
        u'Disconnect',
        u'ConnectionlessTransfer',
        u'ErrorIndication',
        u'PrivateMessage',
        ]
    _set_ = [
        u'IurhSetupRequestIEs',
        u'IurhSetupRequestExtensions',
        u'IurhSetupResponseIEs',
        u'IurhSetupResponseExtensions',
        u'IurhSetupFailureIEs',
        u'IurhSetupFailureExtensions',
        u'ConnectIEs',
        u'ConnectExtensions',
        u'DirectTransferIEs',
        u'DirectTransferExtensions',
        u'DisconnectIEs',
        u'DisconnectExtensions',
        u'ConnectionlessTransferIEs',
        u'ConnectionlessTransferExtensions',
        u'ErrorIndicationIEs',
        u'ErrorIndicationExtensions',
        u'PrivateMessage-IEs',
        ]
    _val_ = [
        ]
    _class_ = [
        u'IurhSetupRequestIEs',
        u'IurhSetupRequestExtensions',
        u'IurhSetupResponseIEs',
        u'IurhSetupResponseExtensions',
        u'IurhSetupFailureIEs',
        u'IurhSetupFailureExtensions',
        u'ConnectIEs',
        u'ConnectExtensions',
        u'DirectTransferIEs',
        u'DirectTransferExtensions',
        u'DisconnectIEs',
        u'DisconnectExtensions',
        u'ConnectionlessTransferIEs',
        u'ConnectionlessTransferExtensions',
        u'ErrorIndicationIEs',
        u'ErrorIndicationExtensions',
        u'PrivateMessage-IEs',
        ]
    _param_ = [
        ]
    
    #-----< IurhSetupRequest >-----#
    IurhSetupRequest = SEQ(name=u'IurhSetupRequest', mode=MODE_TYPE)
    _IurhSetupRequest_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __IurhSetupRequest_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___IurhSetupRequest_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____IurhSetupRequest_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____IurhSetupRequest_protocolIEs__item__id_tab_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _____IurhSetupRequest_protocolIEs__item__id_tab_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____IurhSetupRequest_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _____IurhSetupRequest_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____IurhSetupRequest_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___IurhSetupRequest_protocolIEs__item__id._const_tab = ____IurhSetupRequest_protocolIEs__item__id_tab
    ___IurhSetupRequest_protocolIEs__item__id._const_tab_at = None
    ___IurhSetupRequest_protocolIEs__item__id._const_tab_id = u'id'
    ___IurhSetupRequest_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___IurhSetupRequest_protocolIEs__item__criticality._const_tab = ____IurhSetupRequest_protocolIEs__item__id_tab
    ___IurhSetupRequest_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___IurhSetupRequest_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___IurhSetupRequest_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___IurhSetupRequest_protocolIEs__item__value._const_tab = ____IurhSetupRequest_protocolIEs__item__id_tab
    ___IurhSetupRequest_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___IurhSetupRequest_protocolIEs__item__value._const_tab_id = u'Value'
    __IurhSetupRequest_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___IurhSetupRequest_protocolIEs__item__id),
        (u'criticality', ___IurhSetupRequest_protocolIEs__item__criticality),
        (u'value', ___IurhSetupRequest_protocolIEs__item__value),
        ])
    __IurhSetupRequest_protocolIEs__item_._ext = None
    _IurhSetupRequest_protocolIEs._cont = __IurhSetupRequest_protocolIEs__item_
    _IurhSetupRequest_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _IurhSetupRequest_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __IurhSetupRequest_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___IurhSetupRequest_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____IurhSetupRequest_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupRequest_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupRequest_protocolExtensions__item__id._const_tab = ____IurhSetupRequest_protocolExtensions__item__id_tab
    ___IurhSetupRequest_protocolExtensions__item__id._const_tab_at = None
    ___IurhSetupRequest_protocolExtensions__item__id._const_tab_id = u'id'
    ___IurhSetupRequest_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____IurhSetupRequest_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupRequest_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupRequest_protocolExtensions__item__criticality._const_tab = ____IurhSetupRequest_protocolExtensions__item__criticality_tab
    ___IurhSetupRequest_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___IurhSetupRequest_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___IurhSetupRequest_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____IurhSetupRequest_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupRequest_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupRequest_protocolExtensions__item__extensionValue._const_tab = ____IurhSetupRequest_protocolExtensions__item__extensionValue_tab
    ___IurhSetupRequest_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___IurhSetupRequest_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __IurhSetupRequest_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___IurhSetupRequest_protocolExtensions__item__id),
        (u'criticality', ___IurhSetupRequest_protocolExtensions__item__criticality),
        (u'extensionValue', ___IurhSetupRequest_protocolExtensions__item__extensionValue),
        ])
    __IurhSetupRequest_protocolExtensions__item_._ext = None
    _IurhSetupRequest_protocolExtensions._cont = __IurhSetupRequest_protocolExtensions__item_
    _IurhSetupRequest_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    IurhSetupRequest._cont = ASN1Dict([
        (u'protocolIEs', _IurhSetupRequest_protocolIEs),
        (u'protocolExtensions', _IurhSetupRequest_protocolExtensions),
        ])
    IurhSetupRequest._ext = []
    
    #-----< IurhSetupRequestIEs >-----#
    IurhSetupRequestIEs = CLASS(name=u'IurhSetupRequestIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _IurhSetupRequestIEs_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _IurhSetupRequestIEs_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    IurhSetupRequestIEs._val = ASN1Set(rv=[dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _IurhSetupRequestIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _IurhSetupRequestIEs_val_Value_1), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< IurhSetupRequestExtensions >-----#
    IurhSetupRequestExtensions = CLASS(name=u'IurhSetupRequestExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    IurhSetupRequestExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< IurhSetupResponse >-----#
    IurhSetupResponse = SEQ(name=u'IurhSetupResponse', mode=MODE_TYPE)
    _IurhSetupResponse_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __IurhSetupResponse_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___IurhSetupResponse_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____IurhSetupResponse_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____IurhSetupResponse_protocolIEs__item__id_tab_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _____IurhSetupResponse_protocolIEs__item__id_tab_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____IurhSetupResponse_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _____IurhSetupResponse_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____IurhSetupResponse_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___IurhSetupResponse_protocolIEs__item__id._const_tab = ____IurhSetupResponse_protocolIEs__item__id_tab
    ___IurhSetupResponse_protocolIEs__item__id._const_tab_at = None
    ___IurhSetupResponse_protocolIEs__item__id._const_tab_id = u'id'
    ___IurhSetupResponse_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___IurhSetupResponse_protocolIEs__item__criticality._const_tab = ____IurhSetupResponse_protocolIEs__item__id_tab
    ___IurhSetupResponse_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___IurhSetupResponse_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___IurhSetupResponse_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___IurhSetupResponse_protocolIEs__item__value._const_tab = ____IurhSetupResponse_protocolIEs__item__id_tab
    ___IurhSetupResponse_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___IurhSetupResponse_protocolIEs__item__value._const_tab_id = u'Value'
    __IurhSetupResponse_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___IurhSetupResponse_protocolIEs__item__id),
        (u'criticality', ___IurhSetupResponse_protocolIEs__item__criticality),
        (u'value', ___IurhSetupResponse_protocolIEs__item__value),
        ])
    __IurhSetupResponse_protocolIEs__item_._ext = None
    _IurhSetupResponse_protocolIEs._cont = __IurhSetupResponse_protocolIEs__item_
    _IurhSetupResponse_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _IurhSetupResponse_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __IurhSetupResponse_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___IurhSetupResponse_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____IurhSetupResponse_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupResponse_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupResponse_protocolExtensions__item__id._const_tab = ____IurhSetupResponse_protocolExtensions__item__id_tab
    ___IurhSetupResponse_protocolExtensions__item__id._const_tab_at = None
    ___IurhSetupResponse_protocolExtensions__item__id._const_tab_id = u'id'
    ___IurhSetupResponse_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____IurhSetupResponse_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupResponse_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupResponse_protocolExtensions__item__criticality._const_tab = ____IurhSetupResponse_protocolExtensions__item__criticality_tab
    ___IurhSetupResponse_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___IurhSetupResponse_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___IurhSetupResponse_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____IurhSetupResponse_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupResponse_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupResponse_protocolExtensions__item__extensionValue._const_tab = ____IurhSetupResponse_protocolExtensions__item__extensionValue_tab
    ___IurhSetupResponse_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___IurhSetupResponse_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __IurhSetupResponse_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___IurhSetupResponse_protocolExtensions__item__id),
        (u'criticality', ___IurhSetupResponse_protocolExtensions__item__criticality),
        (u'extensionValue', ___IurhSetupResponse_protocolExtensions__item__extensionValue),
        ])
    __IurhSetupResponse_protocolExtensions__item_._ext = None
    _IurhSetupResponse_protocolExtensions._cont = __IurhSetupResponse_protocolExtensions__item_
    _IurhSetupResponse_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    IurhSetupResponse._cont = ASN1Dict([
        (u'protocolIEs', _IurhSetupResponse_protocolIEs),
        (u'protocolExtensions', _IurhSetupResponse_protocolExtensions),
        ])
    IurhSetupResponse._ext = []
    
    #-----< IurhSetupResponseIEs >-----#
    IurhSetupResponseIEs = CLASS(name=u'IurhSetupResponseIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _IurhSetupResponseIEs_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _IurhSetupResponseIEs_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    IurhSetupResponseIEs._val = ASN1Set(rv=[dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _IurhSetupResponseIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _IurhSetupResponseIEs_val_Value_1), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< IurhSetupResponseExtensions >-----#
    IurhSetupResponseExtensions = CLASS(name=u'IurhSetupResponseExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    IurhSetupResponseExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< IurhSetupFailure >-----#
    IurhSetupFailure = SEQ(name=u'IurhSetupFailure', mode=MODE_TYPE)
    _IurhSetupFailure_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __IurhSetupFailure_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___IurhSetupFailure_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____IurhSetupFailure_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Cause')))
    _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_1 = INT(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'BackoffTimer')))
    _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_2 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'CriticalityDiagnostics')))
    _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_4 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____IurhSetupFailure_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 1), (u'criticality', u'ignore'), (u'Value', _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'ignore'), (u'Value', _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'optional')]), dict([(u'id', 2), (u'criticality', u'ignore'), (u'Value', _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_3), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_4), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___IurhSetupFailure_protocolIEs__item__id._const_tab = ____IurhSetupFailure_protocolIEs__item__id_tab
    ___IurhSetupFailure_protocolIEs__item__id._const_tab_at = None
    ___IurhSetupFailure_protocolIEs__item__id._const_tab_id = u'id'
    ___IurhSetupFailure_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___IurhSetupFailure_protocolIEs__item__criticality._const_tab = ____IurhSetupFailure_protocolIEs__item__id_tab
    ___IurhSetupFailure_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___IurhSetupFailure_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___IurhSetupFailure_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___IurhSetupFailure_protocolIEs__item__value._const_tab = ____IurhSetupFailure_protocolIEs__item__id_tab
    ___IurhSetupFailure_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___IurhSetupFailure_protocolIEs__item__value._const_tab_id = u'Value'
    __IurhSetupFailure_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___IurhSetupFailure_protocolIEs__item__id),
        (u'criticality', ___IurhSetupFailure_protocolIEs__item__criticality),
        (u'value', ___IurhSetupFailure_protocolIEs__item__value),
        ])
    __IurhSetupFailure_protocolIEs__item_._ext = None
    _IurhSetupFailure_protocolIEs._cont = __IurhSetupFailure_protocolIEs__item_
    _IurhSetupFailure_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _IurhSetupFailure_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __IurhSetupFailure_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___IurhSetupFailure_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____IurhSetupFailure_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupFailure_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupFailure_protocolExtensions__item__id._const_tab = ____IurhSetupFailure_protocolExtensions__item__id_tab
    ___IurhSetupFailure_protocolExtensions__item__id._const_tab_at = None
    ___IurhSetupFailure_protocolExtensions__item__id._const_tab_id = u'id'
    ___IurhSetupFailure_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____IurhSetupFailure_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupFailure_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupFailure_protocolExtensions__item__criticality._const_tab = ____IurhSetupFailure_protocolExtensions__item__criticality_tab
    ___IurhSetupFailure_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___IurhSetupFailure_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___IurhSetupFailure_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____IurhSetupFailure_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____IurhSetupFailure_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___IurhSetupFailure_protocolExtensions__item__extensionValue._const_tab = ____IurhSetupFailure_protocolExtensions__item__extensionValue_tab
    ___IurhSetupFailure_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___IurhSetupFailure_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __IurhSetupFailure_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___IurhSetupFailure_protocolExtensions__item__id),
        (u'criticality', ___IurhSetupFailure_protocolExtensions__item__criticality),
        (u'extensionValue', ___IurhSetupFailure_protocolExtensions__item__extensionValue),
        ])
    __IurhSetupFailure_protocolExtensions__item_._ext = None
    _IurhSetupFailure_protocolExtensions._cont = __IurhSetupFailure_protocolExtensions__item_
    _IurhSetupFailure_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    IurhSetupFailure._cont = ASN1Dict([
        (u'protocolIEs', _IurhSetupFailure_protocolIEs),
        (u'protocolExtensions', _IurhSetupFailure_protocolExtensions),
        ])
    IurhSetupFailure._ext = []
    
    #-----< IurhSetupFailureIEs >-----#
    IurhSetupFailureIEs = CLASS(name=u'IurhSetupFailureIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _IurhSetupFailureIEs_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Cause')))
    _IurhSetupFailureIEs_val_Value_1 = INT(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'BackoffTimer')))
    _IurhSetupFailureIEs_val_Value_2 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'CriticalityDiagnostics')))
    _IurhSetupFailureIEs_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _IurhSetupFailureIEs_val_Value_4 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    IurhSetupFailureIEs._val = ASN1Set(rv=[dict([(u'id', 1), (u'criticality', u'ignore'), (u'Value', _IurhSetupFailureIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 4), (u'criticality', u'ignore'), (u'Value', _IurhSetupFailureIEs_val_Value_1), (u'presence', u'optional')]), dict([(u'id', 2), (u'criticality', u'ignore'), (u'Value', _IurhSetupFailureIEs_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _IurhSetupFailureIEs_val_Value_3), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _IurhSetupFailureIEs_val_Value_4), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< IurhSetupFailureExtensions >-----#
    IurhSetupFailureExtensions = CLASS(name=u'IurhSetupFailureExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    IurhSetupFailureExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Connect >-----#
    Connect = SEQ(name=u'Connect', mode=MODE_TYPE)
    _Connect_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __Connect_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___Connect_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____Connect_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____Connect_protocolIEs__item__id_tab_val_Value_0 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _____Connect_protocolIEs__item__id_tab_val_Value_1 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _____Connect_protocolIEs__item__id_tab_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _____Connect_protocolIEs__item__id_tab_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____Connect_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'optional')]), dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____Connect_protocolIEs__item__id_tab_val_Value_3), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___Connect_protocolIEs__item__id._const_tab = ____Connect_protocolIEs__item__id_tab
    ___Connect_protocolIEs__item__id._const_tab_at = None
    ___Connect_protocolIEs__item__id._const_tab_id = u'id'
    ___Connect_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___Connect_protocolIEs__item__criticality._const_tab = ____Connect_protocolIEs__item__id_tab
    ___Connect_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___Connect_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___Connect_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___Connect_protocolIEs__item__value._const_tab = ____Connect_protocolIEs__item__id_tab
    ___Connect_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___Connect_protocolIEs__item__value._const_tab_id = u'Value'
    __Connect_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___Connect_protocolIEs__item__id),
        (u'criticality', ___Connect_protocolIEs__item__criticality),
        (u'value', ___Connect_protocolIEs__item__value),
        ])
    __Connect_protocolIEs__item_._ext = None
    _Connect_protocolIEs._cont = __Connect_protocolIEs__item_
    _Connect_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _Connect_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __Connect_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___Connect_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____Connect_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____Connect_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Connect_protocolExtensions__item__id._const_tab = ____Connect_protocolExtensions__item__id_tab
    ___Connect_protocolExtensions__item__id._const_tab_at = None
    ___Connect_protocolExtensions__item__id._const_tab_id = u'id'
    ___Connect_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____Connect_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____Connect_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Connect_protocolExtensions__item__criticality._const_tab = ____Connect_protocolExtensions__item__criticality_tab
    ___Connect_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___Connect_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___Connect_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____Connect_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____Connect_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Connect_protocolExtensions__item__extensionValue._const_tab = ____Connect_protocolExtensions__item__extensionValue_tab
    ___Connect_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___Connect_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __Connect_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___Connect_protocolExtensions__item__id),
        (u'criticality', ___Connect_protocolExtensions__item__criticality),
        (u'extensionValue', ___Connect_protocolExtensions__item__extensionValue),
        ])
    __Connect_protocolExtensions__item_._ext = None
    _Connect_protocolExtensions._cont = __Connect_protocolExtensions__item_
    _Connect_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Connect._cont = ASN1Dict([
        (u'protocolIEs', _Connect_protocolIEs),
        (u'protocolExtensions', _Connect_protocolExtensions),
        ])
    Connect._ext = []
    
    #-----< ConnectIEs >-----#
    ConnectIEs = CLASS(name=u'ConnectIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _ConnectIEs_val_Value_0 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _ConnectIEs_val_Value_1 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _ConnectIEs_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _ConnectIEs_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ConnectIEs._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_1), (u'presence', u'optional')]), dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_2), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _ConnectIEs_val_Value_3), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< ConnectExtensions >-----#
    ConnectExtensions = CLASS(name=u'ConnectExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ConnectExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DirectTransfer >-----#
    DirectTransfer = SEQ(name=u'DirectTransfer', mode=MODE_TYPE)
    _DirectTransfer_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __DirectTransfer_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___DirectTransfer_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____DirectTransfer_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____DirectTransfer_protocolIEs__item__id_tab_val_Value_0 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _____DirectTransfer_protocolIEs__item__id_tab_val_Value_1 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _____DirectTransfer_protocolIEs__item__id_tab_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____DirectTransfer_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _____DirectTransfer_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____DirectTransfer_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____DirectTransfer_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolIEs__item__id._const_tab = ____DirectTransfer_protocolIEs__item__id_tab
    ___DirectTransfer_protocolIEs__item__id._const_tab_at = None
    ___DirectTransfer_protocolIEs__item__id._const_tab_id = u'id'
    ___DirectTransfer_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___DirectTransfer_protocolIEs__item__criticality._const_tab = ____DirectTransfer_protocolIEs__item__id_tab
    ___DirectTransfer_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___DirectTransfer_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___DirectTransfer_protocolIEs__item__value._const_tab = ____DirectTransfer_protocolIEs__item__id_tab
    ___DirectTransfer_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolIEs__item__value._const_tab_id = u'Value'
    __DirectTransfer_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___DirectTransfer_protocolIEs__item__id),
        (u'criticality', ___DirectTransfer_protocolIEs__item__criticality),
        (u'value', ___DirectTransfer_protocolIEs__item__value),
        ])
    __DirectTransfer_protocolIEs__item_._ext = None
    _DirectTransfer_protocolIEs._cont = __DirectTransfer_protocolIEs__item_
    _DirectTransfer_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _DirectTransfer_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __DirectTransfer_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___DirectTransfer_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____DirectTransfer_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____DirectTransfer_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolExtensions__item__id._const_tab = ____DirectTransfer_protocolExtensions__item__id_tab
    ___DirectTransfer_protocolExtensions__item__id._const_tab_at = None
    ___DirectTransfer_protocolExtensions__item__id._const_tab_id = u'id'
    ___DirectTransfer_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____DirectTransfer_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____DirectTransfer_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolExtensions__item__criticality._const_tab = ____DirectTransfer_protocolExtensions__item__criticality_tab
    ___DirectTransfer_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___DirectTransfer_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____DirectTransfer_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____DirectTransfer_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___DirectTransfer_protocolExtensions__item__extensionValue._const_tab = ____DirectTransfer_protocolExtensions__item__extensionValue_tab
    ___DirectTransfer_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___DirectTransfer_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __DirectTransfer_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___DirectTransfer_protocolExtensions__item__id),
        (u'criticality', ___DirectTransfer_protocolExtensions__item__criticality),
        (u'extensionValue', ___DirectTransfer_protocolExtensions__item__extensionValue),
        ])
    __DirectTransfer_protocolExtensions__item_._ext = None
    _DirectTransfer_protocolExtensions._cont = __DirectTransfer_protocolExtensions__item_
    _DirectTransfer_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    DirectTransfer._cont = ASN1Dict([
        (u'protocolIEs', _DirectTransfer_protocolIEs),
        (u'protocolExtensions', _DirectTransfer_protocolExtensions),
        ])
    DirectTransfer._ext = []
    
    #-----< DirectTransferIEs >-----#
    DirectTransferIEs = CLASS(name=u'DirectTransferIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _DirectTransferIEs_val_Value_0 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _DirectTransferIEs_val_Value_1 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _DirectTransferIEs_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    DirectTransferIEs._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _DirectTransferIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _DirectTransferIEs_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _DirectTransferIEs_val_Value_2), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< DirectTransferExtensions >-----#
    DirectTransferExtensions = CLASS(name=u'DirectTransferExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    DirectTransferExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Disconnect >-----#
    Disconnect = SEQ(name=u'Disconnect', mode=MODE_TYPE)
    _Disconnect_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __Disconnect_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___Disconnect_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____Disconnect_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_0 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Cause')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_2 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _____Disconnect_protocolIEs__item__id_tab_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____Disconnect_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 1), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____Disconnect_protocolIEs__item__id_tab_val_Value_3), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___Disconnect_protocolIEs__item__id._const_tab = ____Disconnect_protocolIEs__item__id_tab
    ___Disconnect_protocolIEs__item__id._const_tab_at = None
    ___Disconnect_protocolIEs__item__id._const_tab_id = u'id'
    ___Disconnect_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___Disconnect_protocolIEs__item__criticality._const_tab = ____Disconnect_protocolIEs__item__id_tab
    ___Disconnect_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___Disconnect_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___Disconnect_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___Disconnect_protocolIEs__item__value._const_tab = ____Disconnect_protocolIEs__item__id_tab
    ___Disconnect_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___Disconnect_protocolIEs__item__value._const_tab_id = u'Value'
    __Disconnect_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___Disconnect_protocolIEs__item__id),
        (u'criticality', ___Disconnect_protocolIEs__item__criticality),
        (u'value', ___Disconnect_protocolIEs__item__value),
        ])
    __Disconnect_protocolIEs__item_._ext = None
    _Disconnect_protocolIEs._cont = __Disconnect_protocolIEs__item_
    _Disconnect_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _Disconnect_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __Disconnect_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___Disconnect_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____Disconnect_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____Disconnect_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Disconnect_protocolExtensions__item__id._const_tab = ____Disconnect_protocolExtensions__item__id_tab
    ___Disconnect_protocolExtensions__item__id._const_tab_at = None
    ___Disconnect_protocolExtensions__item__id._const_tab_id = u'id'
    ___Disconnect_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____Disconnect_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____Disconnect_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Disconnect_protocolExtensions__item__criticality._const_tab = ____Disconnect_protocolExtensions__item__criticality_tab
    ___Disconnect_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___Disconnect_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___Disconnect_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____Disconnect_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____Disconnect_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Disconnect_protocolExtensions__item__extensionValue._const_tab = ____Disconnect_protocolExtensions__item__extensionValue_tab
    ___Disconnect_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___Disconnect_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __Disconnect_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___Disconnect_protocolExtensions__item__id),
        (u'criticality', ___Disconnect_protocolExtensions__item__criticality),
        (u'extensionValue', ___Disconnect_protocolExtensions__item__extensionValue),
        ])
    __Disconnect_protocolExtensions__item_._ext = None
    _Disconnect_protocolExtensions._cont = __Disconnect_protocolExtensions__item_
    _Disconnect_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    Disconnect._cont = ASN1Dict([
        (u'protocolIEs', _Disconnect_protocolIEs),
        (u'protocolExtensions', _Disconnect_protocolExtensions),
        ])
    Disconnect._ext = []
    
    #-----< DisconnectIEs >-----#
    DisconnectIEs = CLASS(name=u'DisconnectIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _DisconnectIEs_val_Value_0 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _DisconnectIEs_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Cause')))
    _DisconnectIEs_val_Value_2 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _DisconnectIEs_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    DisconnectIEs._val = ASN1Set(rv=[dict([(u'id', 7), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 1), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _DisconnectIEs_val_Value_3), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< DisconnectExtensions >-----#
    DisconnectExtensions = CLASS(name=u'DisconnectExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    DisconnectExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ConnectionlessTransfer >-----#
    ConnectionlessTransfer = SEQ(name=u'ConnectionlessTransfer', mode=MODE_TYPE)
    _ConnectionlessTransfer_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __ConnectionlessTransfer_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___ConnectionlessTransfer_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____ConnectionlessTransfer_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_0 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____ConnectionlessTransfer_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolIEs__item__id._const_tab = ____ConnectionlessTransfer_protocolIEs__item__id_tab
    ___ConnectionlessTransfer_protocolIEs__item__id._const_tab_at = None
    ___ConnectionlessTransfer_protocolIEs__item__id._const_tab_id = u'id'
    ___ConnectionlessTransfer_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___ConnectionlessTransfer_protocolIEs__item__criticality._const_tab = ____ConnectionlessTransfer_protocolIEs__item__id_tab
    ___ConnectionlessTransfer_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___ConnectionlessTransfer_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___ConnectionlessTransfer_protocolIEs__item__value._const_tab = ____ConnectionlessTransfer_protocolIEs__item__id_tab
    ___ConnectionlessTransfer_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolIEs__item__value._const_tab_id = u'Value'
    __ConnectionlessTransfer_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___ConnectionlessTransfer_protocolIEs__item__id),
        (u'criticality', ___ConnectionlessTransfer_protocolIEs__item__criticality),
        (u'value', ___ConnectionlessTransfer_protocolIEs__item__value),
        ])
    __ConnectionlessTransfer_protocolIEs__item_._ext = None
    _ConnectionlessTransfer_protocolIEs._cont = __ConnectionlessTransfer_protocolIEs__item_
    _ConnectionlessTransfer_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ConnectionlessTransfer_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __ConnectionlessTransfer_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___ConnectionlessTransfer_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____ConnectionlessTransfer_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____ConnectionlessTransfer_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolExtensions__item__id._const_tab = ____ConnectionlessTransfer_protocolExtensions__item__id_tab
    ___ConnectionlessTransfer_protocolExtensions__item__id._const_tab_at = None
    ___ConnectionlessTransfer_protocolExtensions__item__id._const_tab_id = u'id'
    ___ConnectionlessTransfer_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolExtensions__item__criticality._const_tab = ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab
    ___ConnectionlessTransfer_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue._const_tab = ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___ConnectionlessTransfer_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __ConnectionlessTransfer_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___ConnectionlessTransfer_protocolExtensions__item__id),
        (u'criticality', ___ConnectionlessTransfer_protocolExtensions__item__criticality),
        (u'extensionValue', ___ConnectionlessTransfer_protocolExtensions__item__extensionValue),
        ])
    __ConnectionlessTransfer_protocolExtensions__item_._ext = None
    _ConnectionlessTransfer_protocolExtensions._cont = __ConnectionlessTransfer_protocolExtensions__item_
    _ConnectionlessTransfer_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ConnectionlessTransfer._cont = ASN1Dict([
        (u'protocolIEs', _ConnectionlessTransfer_protocolIEs),
        (u'protocolExtensions', _ConnectionlessTransfer_protocolExtensions),
        ])
    ConnectionlessTransfer._ext = []
    
    #-----< ConnectionlessTransferIEs >-----#
    ConnectionlessTransferIEs = CLASS(name=u'ConnectionlessTransferIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _ConnectionlessTransferIEs_val_Value_0 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'RNSAP-Message')))
    _ConnectionlessTransferIEs_val_Value_1 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    _ConnectionlessTransferIEs_val_Value_2 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ConnectionlessTransferIEs._val = ASN1Set(rv=[dict([(u'id', 3), (u'criticality', u'reject'), (u'Value', _ConnectionlessTransferIEs_val_Value_0), (u'presence', u'mandatory')]), dict([(u'id', 5), (u'criticality', u'reject'), (u'Value', _ConnectionlessTransferIEs_val_Value_1), (u'presence', u'mandatory')]), dict([(u'id', 6), (u'criticality', u'reject'), (u'Value', _ConnectionlessTransferIEs_val_Value_2), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< ConnectionlessTransferExtensions >-----#
    ConnectionlessTransferExtensions = CLASS(name=u'ConnectionlessTransferExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ConnectionlessTransferExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ErrorIndication >-----#
    ErrorIndication = SEQ(name=u'ErrorIndication', mode=MODE_TYPE)
    _ErrorIndication_protocolIEs = SEQ_OF(name=u'protocolIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Container')))
    __ErrorIndication_protocolIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolIE-Field')))
    ___ErrorIndication_protocolIEs__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'id']))
    ____ErrorIndication_protocolIEs__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _____ErrorIndication_protocolIEs__item__id_tab_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Cause')))
    _____ErrorIndication_protocolIEs__item__id_tab_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'CriticalityDiagnostics')))
    _____ErrorIndication_protocolIEs__item__id_tab_val_Value_2 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _____ErrorIndication_protocolIEs__item__id_tab_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ____ErrorIndication_protocolIEs__item__id_tab._val = ASN1Set(rv=[dict([(u'id', 1), (u'criticality', u'ignore'), (u'Value', _____ErrorIndication_protocolIEs__item__id_tab_val_Value_0), (u'presence', u'optional')]), dict([(u'id', 2), (u'criticality', u'ignore'), (u'Value', _____ErrorIndication_protocolIEs__item__id_tab_val_Value_1), (u'presence', u'optional')]), dict([(u'id', 7), (u'criticality', u'ignore'), (u'Value', _____ErrorIndication_protocolIEs__item__id_tab_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 6), (u'criticality', u'ignore'), (u'Value', _____ErrorIndication_protocolIEs__item__id_tab_val_Value_3), (u'presence', u'mandatory')])], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolIEs__item__id._const_tab = ____ErrorIndication_protocolIEs__item__id_tab
    ___ErrorIndication_protocolIEs__item__id._const_tab_at = None
    ___ErrorIndication_protocolIEs__item__id._const_tab_id = u'id'
    ___ErrorIndication_protocolIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'criticality']))
    ___ErrorIndication_protocolIEs__item__criticality._const_tab = ____ErrorIndication_protocolIEs__item__id_tab
    ___ErrorIndication_protocolIEs__item__criticality._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolIEs__item__criticality._const_tab_id = u'criticality'
    ___ErrorIndication_protocolIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-IES'), [u'Value']))
    ___ErrorIndication_protocolIEs__item__value._const_tab = ____ErrorIndication_protocolIEs__item__id_tab
    ___ErrorIndication_protocolIEs__item__value._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolIEs__item__value._const_tab_id = u'Value'
    __ErrorIndication_protocolIEs__item_._cont = ASN1Dict([
        (u'id', ___ErrorIndication_protocolIEs__item__id),
        (u'criticality', ___ErrorIndication_protocolIEs__item__criticality),
        (u'value', ___ErrorIndication_protocolIEs__item__value),
        ])
    __ErrorIndication_protocolIEs__item_._ext = None
    _ErrorIndication_protocolIEs._cont = __ErrorIndication_protocolIEs__item_
    _ErrorIndication_protocolIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=65535)], ev=None, er=[])
    _ErrorIndication_protocolExtensions = SEQ_OF(name=u'protocolExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionContainer')), opt=True)
    __ErrorIndication_protocolExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'ProtocolExtensionField')))
    ___ErrorIndication_protocolExtensions__item__id = INT(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'id']))
    ____ErrorIndication_protocolExtensions__item__id_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____ErrorIndication_protocolExtensions__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolExtensions__item__id._const_tab = ____ErrorIndication_protocolExtensions__item__id_tab
    ___ErrorIndication_protocolExtensions__item__id._const_tab_at = None
    ___ErrorIndication_protocolExtensions__item__id._const_tab_id = u'id'
    ___ErrorIndication_protocolExtensions__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'criticality']))
    ____ErrorIndication_protocolExtensions__item__criticality_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____ErrorIndication_protocolExtensions__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolExtensions__item__criticality._const_tab = ____ErrorIndication_protocolExtensions__item__criticality_tab
    ___ErrorIndication_protocolExtensions__item__criticality._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolExtensions__item__criticality._const_tab_id = u'criticality'
    ___ErrorIndication_protocolExtensions__item__extensionValue = OPEN(name=u'extensionValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION'), [u'Extension']))
    ____ErrorIndication_protocolExtensions__item__extensionValue_tab = CLASS(name='_tab_RNA-PROTOCOL-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ____ErrorIndication_protocolExtensions__item__extensionValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ErrorIndication_protocolExtensions__item__extensionValue._const_tab = ____ErrorIndication_protocolExtensions__item__extensionValue_tab
    ___ErrorIndication_protocolExtensions__item__extensionValue._const_tab_at = ('..', u'id')
    ___ErrorIndication_protocolExtensions__item__extensionValue._const_tab_id = u'Extension'
    __ErrorIndication_protocolExtensions__item_._cont = ASN1Dict([
        (u'id', ___ErrorIndication_protocolExtensions__item__id),
        (u'criticality', ___ErrorIndication_protocolExtensions__item__criticality),
        (u'extensionValue', ___ErrorIndication_protocolExtensions__item__extensionValue),
        ])
    __ErrorIndication_protocolExtensions__item_._ext = None
    _ErrorIndication_protocolExtensions._cont = __ErrorIndication_protocolExtensions__item_
    _ErrorIndication_protocolExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    ErrorIndication._cont = ASN1Dict([
        (u'protocolIEs', _ErrorIndication_protocolIEs),
        (u'protocolExtensions', _ErrorIndication_protocolExtensions),
        ])
    ErrorIndication._ext = []
    
    #-----< ErrorIndicationIEs >-----#
    ErrorIndicationIEs = CLASS(name=u'ErrorIndicationIEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-IES')))
    _ErrorIndicationIEs_val_Value_0 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Cause')))
    _ErrorIndicationIEs_val_Value_1 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'CriticalityDiagnostics')))
    _ErrorIndicationIEs_val_Value_2 = BIT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'Iurh-Signalling-Context-ID')))
    _ErrorIndicationIEs_val_Value_3 = CHOICE(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-IEs', 'HNB-RNL-ID')))
    ErrorIndicationIEs._val = ASN1Set(rv=[dict([(u'id', 1), (u'criticality', u'ignore'), (u'Value', _ErrorIndicationIEs_val_Value_0), (u'presence', u'optional')]), dict([(u'id', 2), (u'criticality', u'ignore'), (u'Value', _ErrorIndicationIEs_val_Value_1), (u'presence', u'optional')]), dict([(u'id', 7), (u'criticality', u'ignore'), (u'Value', _ErrorIndicationIEs_val_Value_2), (u'presence', u'optional')]), dict([(u'id', 6), (u'criticality', u'ignore'), (u'Value', _ErrorIndicationIEs_val_Value_3), (u'presence', u'mandatory')])], rr=[], ev=[], er=[])
    
    #-----< ErrorIndicationExtensions >-----#
    ErrorIndicationExtensions = CLASS(name=u'ErrorIndicationExtensions', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PROTOCOL-EXTENSION')))
    ErrorIndicationExtensions._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PrivateMessage >-----#
    PrivateMessage = SEQ(name=u'PrivateMessage', mode=MODE_TYPE)
    _PrivateMessage_privateIEs = SEQ_OF(name=u'privateIEs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-Containers', 'PrivateIE-Container')))
    __PrivateMessage_privateIEs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-Containers', 'PrivateIE-Field')))
    ___PrivateMessage_privateIEs__item__id = CHOICE(name=u'id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PRIVATE-IES'), [u'id']))
    ____PrivateMessage_privateIEs__item__id_tab = CLASS(name='_tab_RNA-PRIVATE-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PRIVATE-IES')))
    ____PrivateMessage_privateIEs__item__id_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PrivateMessage_privateIEs__item__id._const_tab = ____PrivateMessage_privateIEs__item__id_tab
    ___PrivateMessage_privateIEs__item__id._const_tab_at = None
    ___PrivateMessage_privateIEs__item__id._const_tab_id = u'id'
    ___PrivateMessage_privateIEs__item__criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PRIVATE-IES'), [u'criticality']))
    ____PrivateMessage_privateIEs__item__criticality_tab = CLASS(name='_tab_RNA-PRIVATE-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PRIVATE-IES')))
    ____PrivateMessage_privateIEs__item__criticality_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PrivateMessage_privateIEs__item__criticality._const_tab = ____PrivateMessage_privateIEs__item__criticality_tab
    ___PrivateMessage_privateIEs__item__criticality._const_tab_at = ('..', u'id')
    ___PrivateMessage_privateIEs__item__criticality._const_tab_id = u'criticality'
    ___PrivateMessage_privateIEs__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-Containers', 'RNA-PRIVATE-IES'), [u'Value']))
    ____PrivateMessage_privateIEs__item__value_tab = CLASS(name='_tab_RNA-PRIVATE-IES', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PRIVATE-IES')))
    ____PrivateMessage_privateIEs__item__value_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___PrivateMessage_privateIEs__item__value._const_tab = ____PrivateMessage_privateIEs__item__value_tab
    ___PrivateMessage_privateIEs__item__value._const_tab_at = ('..', u'id')
    ___PrivateMessage_privateIEs__item__value._const_tab_id = u'Value'
    __PrivateMessage_privateIEs__item_._cont = ASN1Dict([
        (u'id', ___PrivateMessage_privateIEs__item__id),
        (u'criticality', ___PrivateMessage_privateIEs__item__criticality),
        (u'value', ___PrivateMessage_privateIEs__item__value),
        ])
    __PrivateMessage_privateIEs__item_._ext = None
    _PrivateMessage_privateIEs._cont = __PrivateMessage_privateIEs__item_
    _PrivateMessage_privateIEs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=65535)], ev=None, er=[])
    PrivateMessage._cont = ASN1Dict([
        (u'privateIEs', _PrivateMessage_privateIEs),
        ])
    PrivateMessage._ext = []
    
    #-----< PrivateMessage-IEs >-----#
    PrivateMessage_IEs = CLASS(name=u'PrivateMessage-IEs', mode=MODE_SET, typeref=ASN1RefType(('RNA-Containers', 'RNA-PRIVATE-IES')))
    PrivateMessage_IEs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    _all_ = [
        ____IurhSetupRequest_protocolIEs__item__id_tab,
        _____IurhSetupRequest_protocolIEs__item__id_tab_val_Value_0,
        _____IurhSetupRequest_protocolIEs__item__id_tab_val_Value_1,
        ___IurhSetupRequest_protocolIEs__item__id,
        ___IurhSetupRequest_protocolIEs__item__criticality,
        ___IurhSetupRequest_protocolIEs__item__value,
        __IurhSetupRequest_protocolIEs__item_,
        _IurhSetupRequest_protocolIEs,
        ____IurhSetupRequest_protocolExtensions__item__id_tab,
        ___IurhSetupRequest_protocolExtensions__item__id,
        ____IurhSetupRequest_protocolExtensions__item__criticality_tab,
        ___IurhSetupRequest_protocolExtensions__item__criticality,
        ____IurhSetupRequest_protocolExtensions__item__extensionValue_tab,
        ___IurhSetupRequest_protocolExtensions__item__extensionValue,
        __IurhSetupRequest_protocolExtensions__item_,
        _IurhSetupRequest_protocolExtensions,
        IurhSetupRequest,
        IurhSetupRequestIEs,
        _IurhSetupRequestIEs_val_Value_0,
        _IurhSetupRequestIEs_val_Value_1,
        IurhSetupRequestExtensions,
        ____IurhSetupResponse_protocolIEs__item__id_tab,
        _____IurhSetupResponse_protocolIEs__item__id_tab_val_Value_0,
        _____IurhSetupResponse_protocolIEs__item__id_tab_val_Value_1,
        ___IurhSetupResponse_protocolIEs__item__id,
        ___IurhSetupResponse_protocolIEs__item__criticality,
        ___IurhSetupResponse_protocolIEs__item__value,
        __IurhSetupResponse_protocolIEs__item_,
        _IurhSetupResponse_protocolIEs,
        ____IurhSetupResponse_protocolExtensions__item__id_tab,
        ___IurhSetupResponse_protocolExtensions__item__id,
        ____IurhSetupResponse_protocolExtensions__item__criticality_tab,
        ___IurhSetupResponse_protocolExtensions__item__criticality,
        ____IurhSetupResponse_protocolExtensions__item__extensionValue_tab,
        ___IurhSetupResponse_protocolExtensions__item__extensionValue,
        __IurhSetupResponse_protocolExtensions__item_,
        _IurhSetupResponse_protocolExtensions,
        IurhSetupResponse,
        IurhSetupResponseIEs,
        _IurhSetupResponseIEs_val_Value_0,
        _IurhSetupResponseIEs_val_Value_1,
        IurhSetupResponseExtensions,
        ____IurhSetupFailure_protocolIEs__item__id_tab,
        _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_0,
        _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_1,
        _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_2,
        _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_3,
        _____IurhSetupFailure_protocolIEs__item__id_tab_val_Value_4,
        ___IurhSetupFailure_protocolIEs__item__id,
        ___IurhSetupFailure_protocolIEs__item__criticality,
        ___IurhSetupFailure_protocolIEs__item__value,
        __IurhSetupFailure_protocolIEs__item_,
        _IurhSetupFailure_protocolIEs,
        ____IurhSetupFailure_protocolExtensions__item__id_tab,
        ___IurhSetupFailure_protocolExtensions__item__id,
        ____IurhSetupFailure_protocolExtensions__item__criticality_tab,
        ___IurhSetupFailure_protocolExtensions__item__criticality,
        ____IurhSetupFailure_protocolExtensions__item__extensionValue_tab,
        ___IurhSetupFailure_protocolExtensions__item__extensionValue,
        __IurhSetupFailure_protocolExtensions__item_,
        _IurhSetupFailure_protocolExtensions,
        IurhSetupFailure,
        IurhSetupFailureIEs,
        _IurhSetupFailureIEs_val_Value_0,
        _IurhSetupFailureIEs_val_Value_1,
        _IurhSetupFailureIEs_val_Value_2,
        _IurhSetupFailureIEs_val_Value_3,
        _IurhSetupFailureIEs_val_Value_4,
        IurhSetupFailureExtensions,
        ____Connect_protocolIEs__item__id_tab,
        _____Connect_protocolIEs__item__id_tab_val_Value_0,
        _____Connect_protocolIEs__item__id_tab_val_Value_1,
        _____Connect_protocolIEs__item__id_tab_val_Value_2,
        _____Connect_protocolIEs__item__id_tab_val_Value_3,
        ___Connect_protocolIEs__item__id,
        ___Connect_protocolIEs__item__criticality,
        ___Connect_protocolIEs__item__value,
        __Connect_protocolIEs__item_,
        _Connect_protocolIEs,
        ____Connect_protocolExtensions__item__id_tab,
        ___Connect_protocolExtensions__item__id,
        ____Connect_protocolExtensions__item__criticality_tab,
        ___Connect_protocolExtensions__item__criticality,
        ____Connect_protocolExtensions__item__extensionValue_tab,
        ___Connect_protocolExtensions__item__extensionValue,
        __Connect_protocolExtensions__item_,
        _Connect_protocolExtensions,
        Connect,
        ConnectIEs,
        _ConnectIEs_val_Value_0,
        _ConnectIEs_val_Value_1,
        _ConnectIEs_val_Value_2,
        _ConnectIEs_val_Value_3,
        ConnectExtensions,
        ____DirectTransfer_protocolIEs__item__id_tab,
        _____DirectTransfer_protocolIEs__item__id_tab_val_Value_0,
        _____DirectTransfer_protocolIEs__item__id_tab_val_Value_1,
        _____DirectTransfer_protocolIEs__item__id_tab_val_Value_2,
        ___DirectTransfer_protocolIEs__item__id,
        ___DirectTransfer_protocolIEs__item__criticality,
        ___DirectTransfer_protocolIEs__item__value,
        __DirectTransfer_protocolIEs__item_,
        _DirectTransfer_protocolIEs,
        ____DirectTransfer_protocolExtensions__item__id_tab,
        ___DirectTransfer_protocolExtensions__item__id,
        ____DirectTransfer_protocolExtensions__item__criticality_tab,
        ___DirectTransfer_protocolExtensions__item__criticality,
        ____DirectTransfer_protocolExtensions__item__extensionValue_tab,
        ___DirectTransfer_protocolExtensions__item__extensionValue,
        __DirectTransfer_protocolExtensions__item_,
        _DirectTransfer_protocolExtensions,
        DirectTransfer,
        DirectTransferIEs,
        _DirectTransferIEs_val_Value_0,
        _DirectTransferIEs_val_Value_1,
        _DirectTransferIEs_val_Value_2,
        DirectTransferExtensions,
        ____Disconnect_protocolIEs__item__id_tab,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_0,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_1,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_2,
        _____Disconnect_protocolIEs__item__id_tab_val_Value_3,
        ___Disconnect_protocolIEs__item__id,
        ___Disconnect_protocolIEs__item__criticality,
        ___Disconnect_protocolIEs__item__value,
        __Disconnect_protocolIEs__item_,
        _Disconnect_protocolIEs,
        ____Disconnect_protocolExtensions__item__id_tab,
        ___Disconnect_protocolExtensions__item__id,
        ____Disconnect_protocolExtensions__item__criticality_tab,
        ___Disconnect_protocolExtensions__item__criticality,
        ____Disconnect_protocolExtensions__item__extensionValue_tab,
        ___Disconnect_protocolExtensions__item__extensionValue,
        __Disconnect_protocolExtensions__item_,
        _Disconnect_protocolExtensions,
        Disconnect,
        DisconnectIEs,
        _DisconnectIEs_val_Value_0,
        _DisconnectIEs_val_Value_1,
        _DisconnectIEs_val_Value_2,
        _DisconnectIEs_val_Value_3,
        DisconnectExtensions,
        ____ConnectionlessTransfer_protocolIEs__item__id_tab,
        _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_0,
        _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_1,
        _____ConnectionlessTransfer_protocolIEs__item__id_tab_val_Value_2,
        ___ConnectionlessTransfer_protocolIEs__item__id,
        ___ConnectionlessTransfer_protocolIEs__item__criticality,
        ___ConnectionlessTransfer_protocolIEs__item__value,
        __ConnectionlessTransfer_protocolIEs__item_,
        _ConnectionlessTransfer_protocolIEs,
        ____ConnectionlessTransfer_protocolExtensions__item__id_tab,
        ___ConnectionlessTransfer_protocolExtensions__item__id,
        ____ConnectionlessTransfer_protocolExtensions__item__criticality_tab,
        ___ConnectionlessTransfer_protocolExtensions__item__criticality,
        ____ConnectionlessTransfer_protocolExtensions__item__extensionValue_tab,
        ___ConnectionlessTransfer_protocolExtensions__item__extensionValue,
        __ConnectionlessTransfer_protocolExtensions__item_,
        _ConnectionlessTransfer_protocolExtensions,
        ConnectionlessTransfer,
        ConnectionlessTransferIEs,
        _ConnectionlessTransferIEs_val_Value_0,
        _ConnectionlessTransferIEs_val_Value_1,
        _ConnectionlessTransferIEs_val_Value_2,
        ConnectionlessTransferExtensions,
        ____ErrorIndication_protocolIEs__item__id_tab,
        _____ErrorIndication_protocolIEs__item__id_tab_val_Value_0,
        _____ErrorIndication_protocolIEs__item__id_tab_val_Value_1,
        _____ErrorIndication_protocolIEs__item__id_tab_val_Value_2,
        _____ErrorIndication_protocolIEs__item__id_tab_val_Value_3,
        ___ErrorIndication_protocolIEs__item__id,
        ___ErrorIndication_protocolIEs__item__criticality,
        ___ErrorIndication_protocolIEs__item__value,
        __ErrorIndication_protocolIEs__item_,
        _ErrorIndication_protocolIEs,
        ____ErrorIndication_protocolExtensions__item__id_tab,
        ___ErrorIndication_protocolExtensions__item__id,
        ____ErrorIndication_protocolExtensions__item__criticality_tab,
        ___ErrorIndication_protocolExtensions__item__criticality,
        ____ErrorIndication_protocolExtensions__item__extensionValue_tab,
        ___ErrorIndication_protocolExtensions__item__extensionValue,
        __ErrorIndication_protocolExtensions__item_,
        _ErrorIndication_protocolExtensions,
        ErrorIndication,
        ErrorIndicationIEs,
        _ErrorIndicationIEs_val_Value_0,
        _ErrorIndicationIEs_val_Value_1,
        _ErrorIndicationIEs_val_Value_2,
        _ErrorIndicationIEs_val_Value_3,
        ErrorIndicationExtensions,
        ____PrivateMessage_privateIEs__item__id_tab,
        ___PrivateMessage_privateIEs__item__id,
        ____PrivateMessage_privateIEs__item__criticality_tab,
        ___PrivateMessage_privateIEs__item__criticality,
        ____PrivateMessage_privateIEs__item__value_tab,
        ___PrivateMessage_privateIEs__item__value,
        __PrivateMessage_privateIEs__item_,
        _PrivateMessage_privateIEs,
        PrivateMessage,
        PrivateMessage_IEs,
    ]

class RNA_PDU_Descriptions:

    _name_  = u'RNA-PDU-Descriptions'
    _oid_   = [0, 4, 0, 0, 20, 3, 7, 1, 0]
    
    _obj_ = [
        u'RNA-ELEMENTARY-PROCEDURE',
        u'RNA-PDU',
        u'InitiatingMessage',
        u'SuccessfulOutcome',
        u'UnsuccessfulOutcome',
        u'RNA-ELEMENTARY-PROCEDURES',
        u'RNA-ELEMENTARY-PROCEDURES-CLASS-1',
        u'RNA-ELEMENTARY-PROCEDURES-CLASS-2',
        u'iurhsetup',
        u'connect',
        u'directTransfer',
        u'disconnect',
        u'connectionlessTransfer',
        u'errorIndication',
        u'privateMessage',
        ]
    _type_ = [
        u'RNA-ELEMENTARY-PROCEDURE',
        u'RNA-PDU',
        u'InitiatingMessage',
        u'SuccessfulOutcome',
        u'UnsuccessfulOutcome',
        ]
    _set_ = [
        u'RNA-ELEMENTARY-PROCEDURES',
        u'RNA-ELEMENTARY-PROCEDURES-CLASS-1',
        u'RNA-ELEMENTARY-PROCEDURES-CLASS-2',
        ]
    _val_ = [
        u'iurhsetup',
        u'connect',
        u'directTransfer',
        u'disconnect',
        u'connectionlessTransfer',
        u'errorIndication',
        u'privateMessage',
        ]
    _class_ = [
        u'RNA-ELEMENTARY-PROCEDURE',
        u'RNA-ELEMENTARY-PROCEDURES',
        u'RNA-ELEMENTARY-PROCEDURES-CLASS-1',
        u'RNA-ELEMENTARY-PROCEDURES-CLASS-2',
        u'iurhsetup',
        u'connect',
        u'directTransfer',
        u'disconnect',
        u'connectionlessTransfer',
        u'errorIndication',
        u'privateMessage',
        ]
    _param_ = [
        ]
    
    #-----< RNA-ELEMENTARY-PROCEDURE >-----#
    RNA_ELEMENTARY_PROCEDURE = CLASS(name=u'RNA-ELEMENTARY-PROCEDURE', mode=MODE_TYPE)
    _RNA_ELEMENTARY_PROCEDURE_InitiatingMessage = OPEN(name=u'InitiatingMessage', mode=MODE_TYPE)
    _RNA_ELEMENTARY_PROCEDURE_SuccessfulOutcome = OPEN(name=u'SuccessfulOutcome', mode=MODE_TYPE, opt=True)
    _RNA_ELEMENTARY_PROCEDURE_UnsuccessfulOutcome = OPEN(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, opt=True)
    _RNA_ELEMENTARY_PROCEDURE_procedureCode = INT(name=u'procedureCode', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'ProcedureCode')), uniq=True)
    _RNA_ELEMENTARY_PROCEDURE_criticality = ENUM(name=u'criticality', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-CommonDataTypes', 'Criticality')), default=u'ignore')
    RNA_ELEMENTARY_PROCEDURE._cont = ASN1Dict([
        (u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURE_InitiatingMessage),
        (u'SuccessfulOutcome', _RNA_ELEMENTARY_PROCEDURE_SuccessfulOutcome),
        (u'UnsuccessfulOutcome', _RNA_ELEMENTARY_PROCEDURE_UnsuccessfulOutcome),
        (u'procedureCode', _RNA_ELEMENTARY_PROCEDURE_procedureCode),
        (u'criticality', _RNA_ELEMENTARY_PROCEDURE_criticality),
        ])
    
    #-----< RNA-PDU >-----#
    RNA_PDU = CHOICE(name=u'RNA-PDU', mode=MODE_TYPE)
    _RNA_PDU_initiatingMessage = SEQ(name=u'initiatingMessage', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-PDU-Descriptions', 'InitiatingMessage')))
    _RNA_PDU_successfulOutcome = SEQ(name=u'successfulOutcome', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-PDU-Descriptions', 'SuccessfulOutcome')))
    _RNA_PDU_unsuccessfulOutcome = SEQ(name=u'unsuccessfulOutcome', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RNA-PDU-Descriptions', 'UnsuccessfulOutcome')))
    RNA_PDU._cont = ASN1Dict([
        (u'initiatingMessage', _RNA_PDU_initiatingMessage),
        (u'successfulOutcome', _RNA_PDU_successfulOutcome),
        (u'unsuccessfulOutcome', _RNA_PDU_unsuccessfulOutcome),
        ])
    RNA_PDU._ext = []
    
    #-----< InitiatingMessage >-----#
    InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE)
    _InitiatingMessage_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'procedureCode']))
    __InitiatingMessage_procedureCode_tab = CLASS(name='_tab_RNA-ELEMENTARY-PROCEDURE', mode=MODE_SET, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupRequest')))
    ___InitiatingMessage_procedureCode_tab_val_SuccessfulOutcome_0 = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupResponse')))
    ___InitiatingMessage_procedureCode_tab_val_UnsuccessfulOutcome_0 = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupFailure')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Connect')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'DirectTransfer')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Disconnect')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ConnectionlessTransfer')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ErrorIndication')))
    ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_6 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'PrivateMessage')))
    __InitiatingMessage_procedureCode_tab._val = ASN1Set(rv=[dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_0), (u'SuccessfulOutcome', ___InitiatingMessage_procedureCode_tab_val_SuccessfulOutcome_0), (u'UnsuccessfulOutcome', ___InitiatingMessage_procedureCode_tab_val_UnsuccessfulOutcome_0), (u'procedureCode', 1), (u'criticality', u'reject')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_6), (u'procedureCode', 7), (u'criticality', u'ignore')])], rr=[], ev=None, er=[])
    _InitiatingMessage_procedureCode._const_tab = __InitiatingMessage_procedureCode_tab
    _InitiatingMessage_procedureCode._const_tab_at = None
    _InitiatingMessage_procedureCode._const_tab_id = u'procedureCode'
    _InitiatingMessage_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'criticality']))
    _InitiatingMessage_criticality._const_tab = __InitiatingMessage_procedureCode_tab
    _InitiatingMessage_criticality._const_tab_at = ('..', u'procedureCode')
    _InitiatingMessage_criticality._const_tab_id = u'criticality'
    _InitiatingMessage_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'InitiatingMessage']))
    _InitiatingMessage_value._const_tab = __InitiatingMessage_procedureCode_tab
    _InitiatingMessage_value._const_tab_at = ('..', u'procedureCode')
    _InitiatingMessage_value._const_tab_id = u'InitiatingMessage'
    InitiatingMessage._cont = ASN1Dict([
        (u'procedureCode', _InitiatingMessage_procedureCode),
        (u'criticality', _InitiatingMessage_criticality),
        (u'value', _InitiatingMessage_value),
        ])
    InitiatingMessage._ext = None
    
    #-----< SuccessfulOutcome >-----#
    SuccessfulOutcome = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE)
    _SuccessfulOutcome_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'procedureCode']))
    __SuccessfulOutcome_procedureCode_tab = CLASS(name='_tab_RNA-ELEMENTARY-PROCEDURE', mode=MODE_SET, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupRequest')))
    ___SuccessfulOutcome_procedureCode_tab_val_SuccessfulOutcome_0 = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupResponse')))
    ___SuccessfulOutcome_procedureCode_tab_val_UnsuccessfulOutcome_0 = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupFailure')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Connect')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'DirectTransfer')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Disconnect')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ConnectionlessTransfer')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ErrorIndication')))
    ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_6 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'PrivateMessage')))
    __SuccessfulOutcome_procedureCode_tab._val = ASN1Set(rv=[dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0), (u'SuccessfulOutcome', ___SuccessfulOutcome_procedureCode_tab_val_SuccessfulOutcome_0), (u'UnsuccessfulOutcome', ___SuccessfulOutcome_procedureCode_tab_val_UnsuccessfulOutcome_0), (u'procedureCode', 1), (u'criticality', u'reject')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_6), (u'procedureCode', 7), (u'criticality', u'ignore')])], rr=[], ev=None, er=[])
    _SuccessfulOutcome_procedureCode._const_tab = __SuccessfulOutcome_procedureCode_tab
    _SuccessfulOutcome_procedureCode._const_tab_at = None
    _SuccessfulOutcome_procedureCode._const_tab_id = u'procedureCode'
    _SuccessfulOutcome_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'criticality']))
    _SuccessfulOutcome_criticality._const_tab = __SuccessfulOutcome_procedureCode_tab
    _SuccessfulOutcome_criticality._const_tab_at = ('..', u'procedureCode')
    _SuccessfulOutcome_criticality._const_tab_id = u'criticality'
    _SuccessfulOutcome_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'SuccessfulOutcome']))
    _SuccessfulOutcome_value._const_tab = __SuccessfulOutcome_procedureCode_tab
    _SuccessfulOutcome_value._const_tab_at = ('..', u'procedureCode')
    _SuccessfulOutcome_value._const_tab_id = u'SuccessfulOutcome'
    SuccessfulOutcome._cont = ASN1Dict([
        (u'procedureCode', _SuccessfulOutcome_procedureCode),
        (u'criticality', _SuccessfulOutcome_criticality),
        (u'value', _SuccessfulOutcome_value),
        ])
    SuccessfulOutcome._ext = None
    
    #-----< UnsuccessfulOutcome >-----#
    UnsuccessfulOutcome = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE)
    _UnsuccessfulOutcome_procedureCode = INT(name=u'procedureCode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'procedureCode']))
    __UnsuccessfulOutcome_procedureCode_tab = CLASS(name='_tab_RNA-ELEMENTARY-PROCEDURE', mode=MODE_SET, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupRequest')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_SuccessfulOutcome_0 = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupResponse')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_UnsuccessfulOutcome_0 = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupFailure')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Connect')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'DirectTransfer')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Disconnect')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ConnectionlessTransfer')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ErrorIndication')))
    ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_6 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'PrivateMessage')))
    __UnsuccessfulOutcome_procedureCode_tab._val = ASN1Set(rv=[dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0), (u'SuccessfulOutcome', ___UnsuccessfulOutcome_procedureCode_tab_val_SuccessfulOutcome_0), (u'UnsuccessfulOutcome', ___UnsuccessfulOutcome_procedureCode_tab_val_UnsuccessfulOutcome_0), (u'procedureCode', 1), (u'criticality', u'reject')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_6), (u'procedureCode', 7), (u'criticality', u'ignore')])], rr=[], ev=None, er=[])
    _UnsuccessfulOutcome_procedureCode._const_tab = __UnsuccessfulOutcome_procedureCode_tab
    _UnsuccessfulOutcome_procedureCode._const_tab_at = None
    _UnsuccessfulOutcome_procedureCode._const_tab_id = u'procedureCode'
    _UnsuccessfulOutcome_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'criticality']))
    _UnsuccessfulOutcome_criticality._const_tab = __UnsuccessfulOutcome_procedureCode_tab
    _UnsuccessfulOutcome_criticality._const_tab_at = ('..', u'procedureCode')
    _UnsuccessfulOutcome_criticality._const_tab_id = u'criticality'
    _UnsuccessfulOutcome_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE'), [u'UnsuccessfulOutcome']))
    _UnsuccessfulOutcome_value._const_tab = __UnsuccessfulOutcome_procedureCode_tab
    _UnsuccessfulOutcome_value._const_tab_at = ('..', u'procedureCode')
    _UnsuccessfulOutcome_value._const_tab_id = u'UnsuccessfulOutcome'
    UnsuccessfulOutcome._cont = ASN1Dict([
        (u'procedureCode', _UnsuccessfulOutcome_procedureCode),
        (u'criticality', _UnsuccessfulOutcome_criticality),
        (u'value', _UnsuccessfulOutcome_value),
        ])
    UnsuccessfulOutcome._ext = None
    
    #-----< RNA-ELEMENTARY-PROCEDURES >-----#
    RNA_ELEMENTARY_PROCEDURES = CLASS(name=u'RNA-ELEMENTARY-PROCEDURES', mode=MODE_SET, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupRequest')))
    _RNA_ELEMENTARY_PROCEDURES_val_SuccessfulOutcome_0 = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupResponse')))
    _RNA_ELEMENTARY_PROCEDURES_val_UnsuccessfulOutcome_0 = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupFailure')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Connect')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'DirectTransfer')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Disconnect')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ConnectionlessTransfer')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ErrorIndication')))
    _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_6 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'PrivateMessage')))
    RNA_ELEMENTARY_PROCEDURES._val = ASN1Set(rv=[dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_0), (u'SuccessfulOutcome', _RNA_ELEMENTARY_PROCEDURES_val_SuccessfulOutcome_0), (u'UnsuccessfulOutcome', _RNA_ELEMENTARY_PROCEDURES_val_UnsuccessfulOutcome_0), (u'procedureCode', 1), (u'criticality', u'reject')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_1), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_2), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_3), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_4), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_5), (u'procedureCode', 6), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_6), (u'procedureCode', 7), (u'criticality', u'ignore')])], rr=[], ev=[], er=[])
    
    #-----< RNA-ELEMENTARY-PROCEDURES-CLASS-1 >-----#
    RNA_ELEMENTARY_PROCEDURES_CLASS_1 = CLASS(name=u'RNA-ELEMENTARY-PROCEDURES-CLASS-1', mode=MODE_SET, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupRequest')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_SuccessfulOutcome_0 = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupResponse')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_UnsuccessfulOutcome_0 = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupFailure')))
    RNA_ELEMENTARY_PROCEDURES_CLASS_1._val = ASN1Set(rv=[dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_InitiatingMessage_0), (u'SuccessfulOutcome', _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_SuccessfulOutcome_0), (u'UnsuccessfulOutcome', _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_UnsuccessfulOutcome_0), (u'procedureCode', 1), (u'criticality', u'reject')])], rr=[], ev=[], er=[])
    
    #-----< RNA-ELEMENTARY-PROCEDURES-CLASS-2 >-----#
    RNA_ELEMENTARY_PROCEDURES_CLASS_2 = CLASS(name=u'RNA-ELEMENTARY-PROCEDURES-CLASS-2', mode=MODE_SET, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_0 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Connect')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_1 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'DirectTransfer')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_2 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Disconnect')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_3 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ConnectionlessTransfer')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_4 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ErrorIndication')))
    _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_5 = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'PrivateMessage')))
    RNA_ELEMENTARY_PROCEDURES_CLASS_2._val = ASN1Set(rv=[dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_0), (u'procedureCode', 2), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_1), (u'procedureCode', 3), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_2), (u'procedureCode', 4), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_3), (u'procedureCode', 5), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_4), (u'procedureCode', 6), (u'criticality', u'ignore')]), dict([(u'InitiatingMessage', _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_5), (u'procedureCode', 7), (u'criticality', u'ignore')])], rr=[], ev=[], er=[])
    
    #-----< iurhsetup >-----#
    iurhsetup = CLASS(name=u'iurhsetup', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _iurhsetup_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupRequest')))
    _iurhsetup_val_SuccessfulOutcome = SEQ(name=u'SuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupResponse')))
    _iurhsetup_val_UnsuccessfulOutcome = SEQ(name=u'UnsuccessfulOutcome', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'IurhSetupFailure')))
    iurhsetup._val = dict([(u'InitiatingMessage', _iurhsetup_val_InitiatingMessage), (u'SuccessfulOutcome', _iurhsetup_val_SuccessfulOutcome), (u'UnsuccessfulOutcome', _iurhsetup_val_UnsuccessfulOutcome), (u'procedureCode', 1), (u'criticality', u'reject')])
    
    #-----< connect >-----#
    connect = CLASS(name=u'connect', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _connect_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Connect')))
    connect._val = dict([(u'InitiatingMessage', _connect_val_InitiatingMessage), (u'procedureCode', 2), (u'criticality', u'ignore')])
    
    #-----< directTransfer >-----#
    directTransfer = CLASS(name=u'directTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _directTransfer_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'DirectTransfer')))
    directTransfer._val = dict([(u'InitiatingMessage', _directTransfer_val_InitiatingMessage), (u'procedureCode', 3), (u'criticality', u'ignore')])
    
    #-----< disconnect >-----#
    disconnect = CLASS(name=u'disconnect', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _disconnect_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'Disconnect')))
    disconnect._val = dict([(u'InitiatingMessage', _disconnect_val_InitiatingMessage), (u'procedureCode', 4), (u'criticality', u'ignore')])
    
    #-----< connectionlessTransfer >-----#
    connectionlessTransfer = CLASS(name=u'connectionlessTransfer', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _connectionlessTransfer_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ConnectionlessTransfer')))
    connectionlessTransfer._val = dict([(u'InitiatingMessage', _connectionlessTransfer_val_InitiatingMessage), (u'procedureCode', 5), (u'criticality', u'ignore')])
    
    #-----< errorIndication >-----#
    errorIndication = CLASS(name=u'errorIndication', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _errorIndication_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'ErrorIndication')))
    errorIndication._val = dict([(u'InitiatingMessage', _errorIndication_val_InitiatingMessage), (u'procedureCode', 6), (u'criticality', u'ignore')])
    
    #-----< privateMessage >-----#
    privateMessage = CLASS(name=u'privateMessage', mode=MODE_VALUE, typeref=ASN1RefType(('RNA-PDU-Descriptions', 'RNA-ELEMENTARY-PROCEDURE')))
    _privateMessage_val_InitiatingMessage = SEQ(name=u'InitiatingMessage', mode=MODE_TYPE, typeref=ASN1RefType(('RNA-PDU-Contents', 'PrivateMessage')))
    privateMessage._val = dict([(u'InitiatingMessage', _privateMessage_val_InitiatingMessage), (u'procedureCode', 7), (u'criticality', u'ignore')])
    
    _all_ = [
        _RNA_ELEMENTARY_PROCEDURE_InitiatingMessage,
        _RNA_ELEMENTARY_PROCEDURE_SuccessfulOutcome,
        _RNA_ELEMENTARY_PROCEDURE_UnsuccessfulOutcome,
        _RNA_ELEMENTARY_PROCEDURE_procedureCode,
        _RNA_ELEMENTARY_PROCEDURE_criticality,
        RNA_ELEMENTARY_PROCEDURE,
        _RNA_PDU_initiatingMessage,
        _RNA_PDU_successfulOutcome,
        _RNA_PDU_unsuccessfulOutcome,
        RNA_PDU,
        __InitiatingMessage_procedureCode_tab,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_0,
        ___InitiatingMessage_procedureCode_tab_val_SuccessfulOutcome_0,
        ___InitiatingMessage_procedureCode_tab_val_UnsuccessfulOutcome_0,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_1,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_2,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_3,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_4,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_5,
        ___InitiatingMessage_procedureCode_tab_val_InitiatingMessage_6,
        _InitiatingMessage_procedureCode,
        _InitiatingMessage_criticality,
        _InitiatingMessage_value,
        InitiatingMessage,
        __SuccessfulOutcome_procedureCode_tab,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0,
        ___SuccessfulOutcome_procedureCode_tab_val_SuccessfulOutcome_0,
        ___SuccessfulOutcome_procedureCode_tab_val_UnsuccessfulOutcome_0,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5,
        ___SuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_6,
        _SuccessfulOutcome_procedureCode,
        _SuccessfulOutcome_criticality,
        _SuccessfulOutcome_value,
        SuccessfulOutcome,
        __UnsuccessfulOutcome_procedureCode_tab,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_0,
        ___UnsuccessfulOutcome_procedureCode_tab_val_SuccessfulOutcome_0,
        ___UnsuccessfulOutcome_procedureCode_tab_val_UnsuccessfulOutcome_0,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_1,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_2,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_3,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_4,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_5,
        ___UnsuccessfulOutcome_procedureCode_tab_val_InitiatingMessage_6,
        _UnsuccessfulOutcome_procedureCode,
        _UnsuccessfulOutcome_criticality,
        _UnsuccessfulOutcome_value,
        UnsuccessfulOutcome,
        RNA_ELEMENTARY_PROCEDURES,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_0,
        _RNA_ELEMENTARY_PROCEDURES_val_SuccessfulOutcome_0,
        _RNA_ELEMENTARY_PROCEDURES_val_UnsuccessfulOutcome_0,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_1,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_2,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_3,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_4,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_5,
        _RNA_ELEMENTARY_PROCEDURES_val_InitiatingMessage_6,
        RNA_ELEMENTARY_PROCEDURES_CLASS_1,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_InitiatingMessage_0,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_SuccessfulOutcome_0,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_1_val_UnsuccessfulOutcome_0,
        RNA_ELEMENTARY_PROCEDURES_CLASS_2,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_0,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_1,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_2,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_3,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_4,
        _RNA_ELEMENTARY_PROCEDURES_CLASS_2_val_InitiatingMessage_5,
        iurhsetup,
        _iurhsetup_val_InitiatingMessage,
        _iurhsetup_val_SuccessfulOutcome,
        _iurhsetup_val_UnsuccessfulOutcome,
        connect,
        _connect_val_InitiatingMessage,
        directTransfer,
        _directTransfer_val_InitiatingMessage,
        disconnect,
        _disconnect_val_InitiatingMessage,
        connectionlessTransfer,
        _connectionlessTransfer_val_InitiatingMessage,
        errorIndication,
        _errorIndication_val_InitiatingMessage,
        privateMessage,
        _privateMessage_val_InitiatingMessage,
    ]

init_modules(RNA_CommonDataTypes, RNA_Constants, RNA_Containers, RNA_IEs, RNA_PDU_Contents, RNA_PDU_Descriptions)
