# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class KerberosV5Spec2:

    _name_  = u'KerberosV5Spec2'
    _oid_   = [1, 3, 6, 1, 5, 2, 4, 2]
    
    _obj_ = [
        u'id-krb5',
        u'Int32',
        u'UInt32',
        u'Microseconds',
        u'KerberosString',
        u'Realm',
        u'PrincipalName',
        u'KerberosTime',
        u'HostAddress',
        u'HostAddresses',
        u'AuthorizationData',
        u'PA-DATA',
        u'KerberosFlags',
        u'EncryptedData',
        u'EncryptionKey',
        u'Checksum',
        u'Ticket',
        u'EncTicketPart',
        u'TransitedEncoding',
        u'TicketFlags',
        u'AS-REQ',
        u'TGS-REQ',
        u'KDC-REQ',
        u'KDC-REQ-BODY',
        u'KDCOptions',
        u'AS-REP',
        u'TGS-REP',
        u'KDC-REP',
        u'EncASRepPart',
        u'EncTGSRepPart',
        u'EncKDCRepPart',
        u'LastReq',
        u'AP-REQ',
        u'APOptions',
        u'Authenticator',
        u'AP-REP',
        u'EncAPRepPart',
        u'KRB-SAFE',
        u'KRB-SAFE-BODY',
        u'KRB-PRIV',
        u'EncKrbPrivPart',
        u'KRB-CRED',
        u'EncKrbCredPart',
        u'KrbCredInfo',
        u'KRB-ERROR',
        u'METHOD-DATA',
        u'TYPED-DATA',
        u'PA-ENC-TIMESTAMP',
        u'PA-ENC-TS-ENC',
        u'ETYPE-INFO-ENTRY',
        u'ETYPE-INFO',
        u'ETYPE-INFO2-ENTRY',
        u'ETYPE-INFO2',
        u'AD-IF-RELEVANT',
        u'AD-KDCIssued',
        u'AD-AND-OR',
        u'AD-MANDATORY-FOR-KDC',
        ]
    _type_ = [
        u'Int32',
        u'UInt32',
        u'Microseconds',
        u'KerberosString',
        u'Realm',
        u'PrincipalName',
        u'KerberosTime',
        u'HostAddress',
        u'HostAddresses',
        u'AuthorizationData',
        u'PA-DATA',
        u'KerberosFlags',
        u'EncryptedData',
        u'EncryptionKey',
        u'Checksum',
        u'Ticket',
        u'EncTicketPart',
        u'TransitedEncoding',
        u'TicketFlags',
        u'AS-REQ',
        u'TGS-REQ',
        u'KDC-REQ',
        u'KDC-REQ-BODY',
        u'KDCOptions',
        u'AS-REP',
        u'TGS-REP',
        u'KDC-REP',
        u'EncASRepPart',
        u'EncTGSRepPart',
        u'EncKDCRepPart',
        u'LastReq',
        u'AP-REQ',
        u'APOptions',
        u'Authenticator',
        u'AP-REP',
        u'EncAPRepPart',
        u'KRB-SAFE',
        u'KRB-SAFE-BODY',
        u'KRB-PRIV',
        u'EncKrbPrivPart',
        u'KRB-CRED',
        u'EncKrbCredPart',
        u'KrbCredInfo',
        u'KRB-ERROR',
        u'METHOD-DATA',
        u'TYPED-DATA',
        u'PA-ENC-TIMESTAMP',
        u'PA-ENC-TS-ENC',
        u'ETYPE-INFO-ENTRY',
        u'ETYPE-INFO',
        u'ETYPE-INFO2-ENTRY',
        u'ETYPE-INFO2',
        u'AD-IF-RELEVANT',
        u'AD-KDCIssued',
        u'AD-AND-OR',
        u'AD-MANDATORY-FOR-KDC',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-krb5',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< id-krb5 >-----#
    id_krb5 = OID(name=u'id-krb5', mode=MODE_VALUE)
    id_krb5._val = (1, 3, 6, 1, 5, 2)
    
    #-----< Int32 >-----#
    Int32 = INT(name=u'Int32', mode=MODE_TYPE)
    Int32._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2147483648, ub=2147483647)], ev=None, er=[])
    
    #-----< UInt32 >-----#
    UInt32 = INT(name=u'UInt32', mode=MODE_TYPE)
    UInt32._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< Microseconds >-----#
    Microseconds = INT(name=u'Microseconds', mode=MODE_TYPE)
    Microseconds._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=999999)], ev=None, er=[])
    
    #-----< KerberosString >-----#
    KerberosString = STR_GENE(name=u'KerberosString', mode=MODE_TYPE)
    KerberosString._const_val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    
    #-----< Realm >-----#
    Realm = STR_GENE(name=u'Realm', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosString')))
    
    #-----< PrincipalName >-----#
    PrincipalName = SEQ(name=u'PrincipalName', mode=MODE_TYPE)
    _PrincipalName_name_type = INT(name=u'name-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _PrincipalName_name_string = SEQ_OF(name=u'name-string', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PrincipalName_name_string__item_ = STR_GENE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosString')))
    _PrincipalName_name_string._cont = __PrincipalName_name_string__item_
    PrincipalName._cont = ASN1Dict([
        (u'name-type', _PrincipalName_name_type),
        (u'name-string', _PrincipalName_name_string),
        ])
    PrincipalName._ext = None
    
    #-----< KerberosTime >-----#
    KerberosTime = TIME_GEN(name=u'KerberosTime', mode=MODE_TYPE)
    
    #-----< HostAddress >-----#
    HostAddress = SEQ(name=u'HostAddress', mode=MODE_TYPE)
    _HostAddress_addr_type = INT(name=u'addr-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _HostAddress_address = OCT_STR(name=u'address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    HostAddress._cont = ASN1Dict([
        (u'addr-type', _HostAddress_addr_type),
        (u'address', _HostAddress_address),
        ])
    HostAddress._ext = None
    
    #-----< HostAddresses >-----#
    HostAddresses = SEQ_OF(name=u'HostAddresses', mode=MODE_TYPE)
    _HostAddresses__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')))
    HostAddresses._cont = _HostAddresses__item_
    
    #-----< AuthorizationData >-----#
    AuthorizationData = SEQ_OF(name=u'AuthorizationData', mode=MODE_TYPE)
    _AuthorizationData__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __AuthorizationData__item__ad_type = INT(name=u'ad-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    __AuthorizationData__item__ad_data = OCT_STR(name=u'ad-data', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AuthorizationData__item_._cont = ASN1Dict([
        (u'ad-type', __AuthorizationData__item__ad_type),
        (u'ad-data', __AuthorizationData__item__ad_data),
        ])
    _AuthorizationData__item_._ext = None
    AuthorizationData._cont = _AuthorizationData__item_
    
    #-----< PA-DATA >-----#
    PA_DATA = SEQ(name=u'PA-DATA', mode=MODE_TYPE)
    _PA_DATA_padata_type = INT(name=u'padata-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _PA_DATA_padata_value = OCT_STR(name=u'padata-value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    PA_DATA._cont = ASN1Dict([
        (u'padata-type', _PA_DATA_padata_type),
        (u'padata-value', _PA_DATA_padata_value),
        ])
    PA_DATA._ext = None
    
    #-----< KerberosFlags >-----#
    KerberosFlags = BIT_STR(name=u'KerberosFlags', mode=MODE_TYPE)
    KerberosFlags._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=32, ub=None)], ev=None, er=[])
    
    #-----< EncryptedData >-----#
    EncryptedData = SEQ(name=u'EncryptedData', mode=MODE_TYPE)
    _EncryptedData_etype = INT(name=u'etype', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _EncryptedData_kvno = INT(name=u'kvno', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')), opt=True)
    _EncryptedData_cipher = OCT_STR(name=u'cipher', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    EncryptedData._cont = ASN1Dict([
        (u'etype', _EncryptedData_etype),
        (u'kvno', _EncryptedData_kvno),
        (u'cipher', _EncryptedData_cipher),
        ])
    EncryptedData._ext = None
    
    #-----< EncryptionKey >-----#
    EncryptionKey = SEQ(name=u'EncryptionKey', mode=MODE_TYPE)
    _EncryptionKey_keytype = INT(name=u'keytype', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _EncryptionKey_keyvalue = OCT_STR(name=u'keyvalue', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    EncryptionKey._cont = ASN1Dict([
        (u'keytype', _EncryptionKey_keytype),
        (u'keyvalue', _EncryptionKey_keyvalue),
        ])
    EncryptionKey._ext = None
    
    #-----< Checksum >-----#
    Checksum = SEQ(name=u'Checksum', mode=MODE_TYPE)
    _Checksum_cksumtype = INT(name=u'cksumtype', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _Checksum_checksum = OCT_STR(name=u'checksum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    Checksum._cont = ASN1Dict([
        (u'cksumtype', _Checksum_cksumtype),
        (u'checksum', _Checksum_checksum),
        ])
    Checksum._ext = None
    
    #-----< Ticket >-----#
    Ticket = SEQ(name=u'Ticket', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_EXPLICIT))
    _Ticket_tkt_vno = INT(name=u'tkt-vno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _Ticket_tkt_vno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _Ticket_realm = STR_GENE(name=u'realm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _Ticket_sname = SEQ(name=u'sname', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')))
    _Ticket_enc_part = SEQ(name=u'enc-part', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    Ticket._cont = ASN1Dict([
        (u'tkt-vno', _Ticket_tkt_vno),
        (u'realm', _Ticket_realm),
        (u'sname', _Ticket_sname),
        (u'enc-part', _Ticket_enc_part),
        ])
    Ticket._ext = None
    
    #-----< EncTicketPart >-----#
    EncTicketPart = SEQ(name=u'EncTicketPart', mode=MODE_TYPE, tag=(3, TAG_APPLICATION, TAG_EXPLICIT))
    _EncTicketPart_flags = BIT_STR(name=u'flags', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'TicketFlags')))
    _EncTicketPart_key = SEQ(name=u'key', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptionKey')))
    _EncTicketPart_crealm = STR_GENE(name=u'crealm', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _EncTicketPart_cname = SEQ(name=u'cname', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')))
    _EncTicketPart_transited = SEQ(name=u'transited', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'TransitedEncoding')))
    _EncTicketPart_authtime = TIME_GEN(name=u'authtime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _EncTicketPart_starttime = TIME_GEN(name=u'starttime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncTicketPart_endtime = TIME_GEN(name=u'endtime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _EncTicketPart_renew_till = TIME_GEN(name=u'renew-till', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncTicketPart_caddr = SEQ_OF(name=u'caddr', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddresses')), opt=True)
    _EncTicketPart_authorization_data = SEQ_OF(name=u'authorization-data', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'AuthorizationData')), opt=True)
    EncTicketPart._cont = ASN1Dict([
        (u'flags', _EncTicketPart_flags),
        (u'key', _EncTicketPart_key),
        (u'crealm', _EncTicketPart_crealm),
        (u'cname', _EncTicketPart_cname),
        (u'transited', _EncTicketPart_transited),
        (u'authtime', _EncTicketPart_authtime),
        (u'starttime', _EncTicketPart_starttime),
        (u'endtime', _EncTicketPart_endtime),
        (u'renew-till', _EncTicketPart_renew_till),
        (u'caddr', _EncTicketPart_caddr),
        (u'authorization-data', _EncTicketPart_authorization_data),
        ])
    EncTicketPart._ext = None
    
    #-----< TransitedEncoding >-----#
    TransitedEncoding = SEQ(name=u'TransitedEncoding', mode=MODE_TYPE)
    _TransitedEncoding_tr_type = INT(name=u'tr-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _TransitedEncoding_contents = OCT_STR(name=u'contents', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    TransitedEncoding._cont = ASN1Dict([
        (u'tr-type', _TransitedEncoding_tr_type),
        (u'contents', _TransitedEncoding_contents),
        ])
    TransitedEncoding._ext = None
    
    #-----< TicketFlags >-----#
    TicketFlags = BIT_STR(name=u'TicketFlags', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosFlags')))
    
    #-----< AS-REQ >-----#
    AS_REQ = SEQ(name=u'AS-REQ', mode=MODE_TYPE, tag=(10, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KDC-REQ')))
    
    #-----< TGS-REQ >-----#
    TGS_REQ = SEQ(name=u'TGS-REQ', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KDC-REQ')))
    
    #-----< KDC-REQ >-----#
    KDC_REQ = SEQ(name=u'KDC-REQ', mode=MODE_TYPE)
    _KDC_REQ_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KDC_REQ_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _KDC_REQ_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KDC_REQ_msg_type._const_val = ASN1Set(rv=[10, 12], rr=[], ev=None, er=[])
    _KDC_REQ_padata = SEQ_OF(name=u'padata', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __KDC_REQ_padata__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'PA-DATA')))
    _KDC_REQ_padata._cont = __KDC_REQ_padata__item_
    _KDC_REQ_req_body = SEQ(name=u'req-body', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KDC-REQ-BODY')))
    KDC_REQ._cont = ASN1Dict([
        (u'pvno', _KDC_REQ_pvno),
        (u'msg-type', _KDC_REQ_msg_type),
        (u'padata', _KDC_REQ_padata),
        (u'req-body', _KDC_REQ_req_body),
        ])
    KDC_REQ._ext = None
    
    #-----< KDC-REQ-BODY >-----#
    KDC_REQ_BODY = SEQ(name=u'KDC-REQ-BODY', mode=MODE_TYPE)
    _KDC_REQ_BODY_kdc_options = BIT_STR(name=u'kdc-options', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KDCOptions')))
    _KDC_REQ_BODY_cname = SEQ(name=u'cname', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')), opt=True)
    _KDC_REQ_BODY_realm = STR_GENE(name=u'realm', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _KDC_REQ_BODY_sname = SEQ(name=u'sname', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')), opt=True)
    _KDC_REQ_BODY_from_ = TIME_GEN(name=u'from', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KDC_REQ_BODY_till = TIME_GEN(name=u'till', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _KDC_REQ_BODY_rtime = TIME_GEN(name=u'rtime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KDC_REQ_BODY_nonce = INT(name=u'nonce', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')))
    _KDC_REQ_BODY_etype = SEQ_OF(name=u'etype', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __KDC_REQ_BODY_etype__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _KDC_REQ_BODY_etype._cont = __KDC_REQ_BODY_etype__item_
    _KDC_REQ_BODY_addresses = SEQ_OF(name=u'addresses', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddresses')), opt=True)
    _KDC_REQ_BODY_enc_authorization_data = SEQ(name=u'enc-authorization-data', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')), opt=True)
    _KDC_REQ_BODY_additional_tickets = SEQ_OF(name=u'additional-tickets', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __KDC_REQ_BODY_additional_tickets__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'Ticket')))
    _KDC_REQ_BODY_additional_tickets._cont = __KDC_REQ_BODY_additional_tickets__item_
    KDC_REQ_BODY._cont = ASN1Dict([
        (u'kdc-options', _KDC_REQ_BODY_kdc_options),
        (u'cname', _KDC_REQ_BODY_cname),
        (u'realm', _KDC_REQ_BODY_realm),
        (u'sname', _KDC_REQ_BODY_sname),
        (u'from', _KDC_REQ_BODY_from_),
        (u'till', _KDC_REQ_BODY_till),
        (u'rtime', _KDC_REQ_BODY_rtime),
        (u'nonce', _KDC_REQ_BODY_nonce),
        (u'etype', _KDC_REQ_BODY_etype),
        (u'addresses', _KDC_REQ_BODY_addresses),
        (u'enc-authorization-data', _KDC_REQ_BODY_enc_authorization_data),
        (u'additional-tickets', _KDC_REQ_BODY_additional_tickets),
        ])
    KDC_REQ_BODY._ext = None
    
    #-----< KDCOptions >-----#
    KDCOptions = BIT_STR(name=u'KDCOptions', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosFlags')))
    
    #-----< AS-REP >-----#
    AS_REP = SEQ(name=u'AS-REP', mode=MODE_TYPE, tag=(11, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KDC-REP')))
    
    #-----< TGS-REP >-----#
    TGS_REP = SEQ(name=u'TGS-REP', mode=MODE_TYPE, tag=(13, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KDC-REP')))
    
    #-----< KDC-REP >-----#
    KDC_REP = SEQ(name=u'KDC-REP', mode=MODE_TYPE)
    _KDC_REP_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KDC_REP_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _KDC_REP_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KDC_REP_msg_type._const_val = ASN1Set(rv=[11, 13], rr=[], ev=None, er=[])
    _KDC_REP_padata = SEQ_OF(name=u'padata', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __KDC_REP_padata__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'PA-DATA')))
    _KDC_REP_padata._cont = __KDC_REP_padata__item_
    _KDC_REP_crealm = STR_GENE(name=u'crealm', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _KDC_REP_cname = SEQ(name=u'cname', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')))
    _KDC_REP_ticket = SEQ(name=u'ticket', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Ticket')))
    _KDC_REP_enc_part = SEQ(name=u'enc-part', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    KDC_REP._cont = ASN1Dict([
        (u'pvno', _KDC_REP_pvno),
        (u'msg-type', _KDC_REP_msg_type),
        (u'padata', _KDC_REP_padata),
        (u'crealm', _KDC_REP_crealm),
        (u'cname', _KDC_REP_cname),
        (u'ticket', _KDC_REP_ticket),
        (u'enc-part', _KDC_REP_enc_part),
        ])
    KDC_REP._ext = None
    
    #-----< EncASRepPart >-----#
    EncASRepPart = SEQ(name=u'EncASRepPart', mode=MODE_TYPE, tag=(25, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncKDCRepPart')))
    
    #-----< EncTGSRepPart >-----#
    EncTGSRepPart = SEQ(name=u'EncTGSRepPart', mode=MODE_TYPE, tag=(26, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncKDCRepPart')))
    
    #-----< EncKDCRepPart >-----#
    EncKDCRepPart = SEQ(name=u'EncKDCRepPart', mode=MODE_TYPE)
    _EncKDCRepPart_key = SEQ(name=u'key', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptionKey')))
    _EncKDCRepPart_last_req = SEQ_OF(name=u'last-req', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'LastReq')))
    _EncKDCRepPart_nonce = INT(name=u'nonce', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')))
    _EncKDCRepPart_key_expiration = TIME_GEN(name=u'key-expiration', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncKDCRepPart_flags = BIT_STR(name=u'flags', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'TicketFlags')))
    _EncKDCRepPart_authtime = TIME_GEN(name=u'authtime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _EncKDCRepPart_starttime = TIME_GEN(name=u'starttime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncKDCRepPart_endtime = TIME_GEN(name=u'endtime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _EncKDCRepPart_renew_till = TIME_GEN(name=u'renew-till', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncKDCRepPart_srealm = STR_GENE(name=u'srealm', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _EncKDCRepPart_sname = SEQ(name=u'sname', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')))
    _EncKDCRepPart_caddr = SEQ_OF(name=u'caddr', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddresses')), opt=True)
    EncKDCRepPart._cont = ASN1Dict([
        (u'key', _EncKDCRepPart_key),
        (u'last-req', _EncKDCRepPart_last_req),
        (u'nonce', _EncKDCRepPart_nonce),
        (u'key-expiration', _EncKDCRepPart_key_expiration),
        (u'flags', _EncKDCRepPart_flags),
        (u'authtime', _EncKDCRepPart_authtime),
        (u'starttime', _EncKDCRepPart_starttime),
        (u'endtime', _EncKDCRepPart_endtime),
        (u'renew-till', _EncKDCRepPart_renew_till),
        (u'srealm', _EncKDCRepPart_srealm),
        (u'sname', _EncKDCRepPart_sname),
        (u'caddr', _EncKDCRepPart_caddr),
        ])
    EncKDCRepPart._ext = None
    
    #-----< LastReq >-----#
    LastReq = SEQ_OF(name=u'LastReq', mode=MODE_TYPE)
    _LastReq__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __LastReq__item__lr_type = INT(name=u'lr-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    __LastReq__item__lr_value = TIME_GEN(name=u'lr-value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _LastReq__item_._cont = ASN1Dict([
        (u'lr-type', __LastReq__item__lr_type),
        (u'lr-value', __LastReq__item__lr_value),
        ])
    _LastReq__item_._ext = None
    LastReq._cont = _LastReq__item_
    
    #-----< AP-REQ >-----#
    AP_REQ = SEQ(name=u'AP-REQ', mode=MODE_TYPE, tag=(14, TAG_APPLICATION, TAG_EXPLICIT))
    _AP_REQ_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AP_REQ_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _AP_REQ_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AP_REQ_msg_type._const_val = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    _AP_REQ_ap_options = BIT_STR(name=u'ap-options', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'APOptions')))
    _AP_REQ_ticket = SEQ(name=u'ticket', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Ticket')))
    _AP_REQ_authenticator = SEQ(name=u'authenticator', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    AP_REQ._cont = ASN1Dict([
        (u'pvno', _AP_REQ_pvno),
        (u'msg-type', _AP_REQ_msg_type),
        (u'ap-options', _AP_REQ_ap_options),
        (u'ticket', _AP_REQ_ticket),
        (u'authenticator', _AP_REQ_authenticator),
        ])
    AP_REQ._ext = None
    
    #-----< APOptions >-----#
    APOptions = BIT_STR(name=u'APOptions', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosFlags')))
    
    #-----< Authenticator >-----#
    Authenticator = SEQ(name=u'Authenticator', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_EXPLICIT))
    _Authenticator_authenticator_vno = INT(name=u'authenticator-vno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _Authenticator_authenticator_vno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _Authenticator_crealm = STR_GENE(name=u'crealm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _Authenticator_cname = SEQ(name=u'cname', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')))
    _Authenticator_cksum = SEQ(name=u'cksum', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Checksum')), opt=True)
    _Authenticator_cusec = INT(name=u'cusec', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')))
    _Authenticator_ctime = TIME_GEN(name=u'ctime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _Authenticator_subkey = SEQ(name=u'subkey', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptionKey')), opt=True)
    _Authenticator_seq_number = INT(name=u'seq-number', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')), opt=True)
    _Authenticator_authorization_data = SEQ_OF(name=u'authorization-data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'AuthorizationData')), opt=True)
    Authenticator._cont = ASN1Dict([
        (u'authenticator-vno', _Authenticator_authenticator_vno),
        (u'crealm', _Authenticator_crealm),
        (u'cname', _Authenticator_cname),
        (u'cksum', _Authenticator_cksum),
        (u'cusec', _Authenticator_cusec),
        (u'ctime', _Authenticator_ctime),
        (u'subkey', _Authenticator_subkey),
        (u'seq-number', _Authenticator_seq_number),
        (u'authorization-data', _Authenticator_authorization_data),
        ])
    Authenticator._ext = None
    
    #-----< AP-REP >-----#
    AP_REP = SEQ(name=u'AP-REP', mode=MODE_TYPE, tag=(15, TAG_APPLICATION, TAG_EXPLICIT))
    _AP_REP_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AP_REP_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _AP_REP_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AP_REP_msg_type._const_val = ASN1Set(rv=[15], rr=[], ev=None, er=[])
    _AP_REP_enc_part = SEQ(name=u'enc-part', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    AP_REP._cont = ASN1Dict([
        (u'pvno', _AP_REP_pvno),
        (u'msg-type', _AP_REP_msg_type),
        (u'enc-part', _AP_REP_enc_part),
        ])
    AP_REP._ext = None
    
    #-----< EncAPRepPart >-----#
    EncAPRepPart = SEQ(name=u'EncAPRepPart', mode=MODE_TYPE, tag=(27, TAG_APPLICATION, TAG_EXPLICIT))
    _EncAPRepPart_ctime = TIME_GEN(name=u'ctime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _EncAPRepPart_cusec = INT(name=u'cusec', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')))
    _EncAPRepPart_subkey = SEQ(name=u'subkey', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptionKey')), opt=True)
    _EncAPRepPart_seq_number = INT(name=u'seq-number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')), opt=True)
    EncAPRepPart._cont = ASN1Dict([
        (u'ctime', _EncAPRepPart_ctime),
        (u'cusec', _EncAPRepPart_cusec),
        (u'subkey', _EncAPRepPart_subkey),
        (u'seq-number', _EncAPRepPart_seq_number),
        ])
    EncAPRepPart._ext = None
    
    #-----< KRB-SAFE >-----#
    KRB_SAFE = SEQ(name=u'KRB-SAFE', mode=MODE_TYPE, tag=(20, TAG_APPLICATION, TAG_EXPLICIT))
    _KRB_SAFE_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_SAFE_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _KRB_SAFE_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_SAFE_msg_type._const_val = ASN1Set(rv=[20], rr=[], ev=None, er=[])
    _KRB_SAFE_safe_body = SEQ(name=u'safe-body', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KRB-SAFE-BODY')))
    _KRB_SAFE_cksum = SEQ(name=u'cksum', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Checksum')))
    KRB_SAFE._cont = ASN1Dict([
        (u'pvno', _KRB_SAFE_pvno),
        (u'msg-type', _KRB_SAFE_msg_type),
        (u'safe-body', _KRB_SAFE_safe_body),
        (u'cksum', _KRB_SAFE_cksum),
        ])
    KRB_SAFE._ext = None
    
    #-----< KRB-SAFE-BODY >-----#
    KRB_SAFE_BODY = SEQ(name=u'KRB-SAFE-BODY', mode=MODE_TYPE)
    _KRB_SAFE_BODY_user_data = OCT_STR(name=u'user-data', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_SAFE_BODY_timestamp = TIME_GEN(name=u'timestamp', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KRB_SAFE_BODY_usec = INT(name=u'usec', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')), opt=True)
    _KRB_SAFE_BODY_seq_number = INT(name=u'seq-number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')), opt=True)
    _KRB_SAFE_BODY_s_address = SEQ(name=u's-address', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')))
    _KRB_SAFE_BODY_r_address = SEQ(name=u'r-address', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')), opt=True)
    KRB_SAFE_BODY._cont = ASN1Dict([
        (u'user-data', _KRB_SAFE_BODY_user_data),
        (u'timestamp', _KRB_SAFE_BODY_timestamp),
        (u'usec', _KRB_SAFE_BODY_usec),
        (u'seq-number', _KRB_SAFE_BODY_seq_number),
        (u's-address', _KRB_SAFE_BODY_s_address),
        (u'r-address', _KRB_SAFE_BODY_r_address),
        ])
    KRB_SAFE_BODY._ext = None
    
    #-----< KRB-PRIV >-----#
    KRB_PRIV = SEQ(name=u'KRB-PRIV', mode=MODE_TYPE, tag=(21, TAG_APPLICATION, TAG_EXPLICIT))
    _KRB_PRIV_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_PRIV_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _KRB_PRIV_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_PRIV_msg_type._const_val = ASN1Set(rv=[21], rr=[], ev=None, er=[])
    _KRB_PRIV_enc_part = SEQ(name=u'enc-part', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    KRB_PRIV._cont = ASN1Dict([
        (u'pvno', _KRB_PRIV_pvno),
        (u'msg-type', _KRB_PRIV_msg_type),
        (u'enc-part', _KRB_PRIV_enc_part),
        ])
    KRB_PRIV._ext = None
    
    #-----< EncKrbPrivPart >-----#
    EncKrbPrivPart = SEQ(name=u'EncKrbPrivPart', mode=MODE_TYPE, tag=(28, TAG_APPLICATION, TAG_EXPLICIT))
    _EncKrbPrivPart_user_data = OCT_STR(name=u'user-data', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _EncKrbPrivPart_timestamp = TIME_GEN(name=u'timestamp', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncKrbPrivPart_usec = INT(name=u'usec', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')), opt=True)
    _EncKrbPrivPart_seq_number = INT(name=u'seq-number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')), opt=True)
    _EncKrbPrivPart_s_address = SEQ(name=u's-address', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')))
    _EncKrbPrivPart_r_address = SEQ(name=u'r-address', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')), opt=True)
    EncKrbPrivPart._cont = ASN1Dict([
        (u'user-data', _EncKrbPrivPart_user_data),
        (u'timestamp', _EncKrbPrivPart_timestamp),
        (u'usec', _EncKrbPrivPart_usec),
        (u'seq-number', _EncKrbPrivPart_seq_number),
        (u's-address', _EncKrbPrivPart_s_address),
        (u'r-address', _EncKrbPrivPart_r_address),
        ])
    EncKrbPrivPart._ext = None
    
    #-----< KRB-CRED >-----#
    KRB_CRED = SEQ(name=u'KRB-CRED', mode=MODE_TYPE, tag=(22, TAG_APPLICATION, TAG_EXPLICIT))
    _KRB_CRED_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_CRED_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _KRB_CRED_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_CRED_msg_type._const_val = ASN1Set(rv=[22], rr=[], ev=None, er=[])
    _KRB_CRED_tickets = SEQ_OF(name=u'tickets', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __KRB_CRED_tickets__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'Ticket')))
    _KRB_CRED_tickets._cont = __KRB_CRED_tickets__item_
    _KRB_CRED_enc_part = SEQ(name=u'enc-part', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    KRB_CRED._cont = ASN1Dict([
        (u'pvno', _KRB_CRED_pvno),
        (u'msg-type', _KRB_CRED_msg_type),
        (u'tickets', _KRB_CRED_tickets),
        (u'enc-part', _KRB_CRED_enc_part),
        ])
    KRB_CRED._ext = None
    
    #-----< EncKrbCredPart >-----#
    EncKrbCredPart = SEQ(name=u'EncKrbCredPart', mode=MODE_TYPE, tag=(29, TAG_APPLICATION, TAG_EXPLICIT))
    _EncKrbCredPart_ticket_info = SEQ_OF(name=u'ticket-info', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EncKrbCredPart_ticket_info__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'KrbCredInfo')))
    _EncKrbCredPart_ticket_info._cont = __EncKrbCredPart_ticket_info__item_
    _EncKrbCredPart_nonce = INT(name=u'nonce', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'UInt32')), opt=True)
    _EncKrbCredPart_timestamp = TIME_GEN(name=u'timestamp', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _EncKrbCredPart_usec = INT(name=u'usec', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')), opt=True)
    _EncKrbCredPart_s_address = SEQ(name=u's-address', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')), opt=True)
    _EncKrbCredPart_r_address = SEQ(name=u'r-address', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddress')), opt=True)
    EncKrbCredPart._cont = ASN1Dict([
        (u'ticket-info', _EncKrbCredPart_ticket_info),
        (u'nonce', _EncKrbCredPart_nonce),
        (u'timestamp', _EncKrbCredPart_timestamp),
        (u'usec', _EncKrbCredPart_usec),
        (u's-address', _EncKrbCredPart_s_address),
        (u'r-address', _EncKrbCredPart_r_address),
        ])
    EncKrbCredPart._ext = None
    
    #-----< KrbCredInfo >-----#
    KrbCredInfo = SEQ(name=u'KrbCredInfo', mode=MODE_TYPE)
    _KrbCredInfo_key = SEQ(name=u'key', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptionKey')))
    _KrbCredInfo_prealm = STR_GENE(name=u'prealm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')), opt=True)
    _KrbCredInfo_pname = SEQ(name=u'pname', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')), opt=True)
    _KrbCredInfo_flags = BIT_STR(name=u'flags', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'TicketFlags')), opt=True)
    _KrbCredInfo_authtime = TIME_GEN(name=u'authtime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KrbCredInfo_starttime = TIME_GEN(name=u'starttime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KrbCredInfo_endtime = TIME_GEN(name=u'endtime', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KrbCredInfo_renew_till = TIME_GEN(name=u'renew-till', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KrbCredInfo_srealm = STR_GENE(name=u'srealm', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')), opt=True)
    _KrbCredInfo_sname = SEQ(name=u'sname', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')), opt=True)
    _KrbCredInfo_caddr = SEQ_OF(name=u'caddr', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'HostAddresses')), opt=True)
    KrbCredInfo._cont = ASN1Dict([
        (u'key', _KrbCredInfo_key),
        (u'prealm', _KrbCredInfo_prealm),
        (u'pname', _KrbCredInfo_pname),
        (u'flags', _KrbCredInfo_flags),
        (u'authtime', _KrbCredInfo_authtime),
        (u'starttime', _KrbCredInfo_starttime),
        (u'endtime', _KrbCredInfo_endtime),
        (u'renew-till', _KrbCredInfo_renew_till),
        (u'srealm', _KrbCredInfo_srealm),
        (u'sname', _KrbCredInfo_sname),
        (u'caddr', _KrbCredInfo_caddr),
        ])
    KrbCredInfo._ext = None
    
    #-----< KRB-ERROR >-----#
    KRB_ERROR = SEQ(name=u'KRB-ERROR', mode=MODE_TYPE, tag=(30, TAG_APPLICATION, TAG_EXPLICIT))
    _KRB_ERROR_pvno = INT(name=u'pvno', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_ERROR_pvno._const_val = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    _KRB_ERROR_msg_type = INT(name=u'msg-type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _KRB_ERROR_msg_type._const_val = ASN1Set(rv=[30], rr=[], ev=None, er=[])
    _KRB_ERROR_ctime = TIME_GEN(name=u'ctime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')), opt=True)
    _KRB_ERROR_cusec = INT(name=u'cusec', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')), opt=True)
    _KRB_ERROR_stime = TIME_GEN(name=u'stime', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _KRB_ERROR_susec = INT(name=u'susec', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')))
    _KRB_ERROR_error_code = INT(name=u'error-code', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _KRB_ERROR_crealm = STR_GENE(name=u'crealm', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')), opt=True)
    _KRB_ERROR_cname = SEQ(name=u'cname', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')), opt=True)
    _KRB_ERROR_realm = STR_GENE(name=u'realm', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')))
    _KRB_ERROR_sname = SEQ(name=u'sname', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')))
    _KRB_ERROR_e_text = STR_GENE(name=u'e-text', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosString')), opt=True)
    _KRB_ERROR_e_data = OCT_STR(name=u'e-data', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    KRB_ERROR._cont = ASN1Dict([
        (u'pvno', _KRB_ERROR_pvno),
        (u'msg-type', _KRB_ERROR_msg_type),
        (u'ctime', _KRB_ERROR_ctime),
        (u'cusec', _KRB_ERROR_cusec),
        (u'stime', _KRB_ERROR_stime),
        (u'susec', _KRB_ERROR_susec),
        (u'error-code', _KRB_ERROR_error_code),
        (u'crealm', _KRB_ERROR_crealm),
        (u'cname', _KRB_ERROR_cname),
        (u'realm', _KRB_ERROR_realm),
        (u'sname', _KRB_ERROR_sname),
        (u'e-text', _KRB_ERROR_e_text),
        (u'e-data', _KRB_ERROR_e_data),
        ])
    KRB_ERROR._ext = None
    
    #-----< METHOD-DATA >-----#
    METHOD_DATA = SEQ_OF(name=u'METHOD-DATA', mode=MODE_TYPE)
    _METHOD_DATA__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'PA-DATA')))
    METHOD_DATA._cont = _METHOD_DATA__item_
    
    #-----< TYPED-DATA >-----#
    TYPED_DATA = SEQ_OF(name=u'TYPED-DATA', mode=MODE_TYPE)
    _TYPED_DATA__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __TYPED_DATA__item__data_type = INT(name=u'data-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    __TYPED_DATA__item__data_value = OCT_STR(name=u'data-value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _TYPED_DATA__item_._cont = ASN1Dict([
        (u'data-type', __TYPED_DATA__item__data_type),
        (u'data-value', __TYPED_DATA__item__data_value),
        ])
    _TYPED_DATA__item_._ext = None
    TYPED_DATA._cont = _TYPED_DATA__item_
    TYPED_DATA._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PA-ENC-TIMESTAMP >-----#
    PA_ENC_TIMESTAMP = SEQ(name=u'PA-ENC-TIMESTAMP', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'EncryptedData')))
    
    #-----< PA-ENC-TS-ENC >-----#
    PA_ENC_TS_ENC = SEQ(name=u'PA-ENC-TS-ENC', mode=MODE_TYPE)
    _PA_ENC_TS_ENC_patimestamp = TIME_GEN(name=u'patimestamp', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosTime')))
    _PA_ENC_TS_ENC_pausec = INT(name=u'pausec', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Microseconds')), opt=True)
    PA_ENC_TS_ENC._cont = ASN1Dict([
        (u'patimestamp', _PA_ENC_TS_ENC_patimestamp),
        (u'pausec', _PA_ENC_TS_ENC_pausec),
        ])
    PA_ENC_TS_ENC._ext = None
    
    #-----< ETYPE-INFO-ENTRY >-----#
    ETYPE_INFO_ENTRY = SEQ(name=u'ETYPE-INFO-ENTRY', mode=MODE_TYPE)
    _ETYPE_INFO_ENTRY_etype = INT(name=u'etype', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _ETYPE_INFO_ENTRY_salt = OCT_STR(name=u'salt', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ETYPE_INFO_ENTRY._cont = ASN1Dict([
        (u'etype', _ETYPE_INFO_ENTRY_etype),
        (u'salt', _ETYPE_INFO_ENTRY_salt),
        ])
    ETYPE_INFO_ENTRY._ext = None
    
    #-----< ETYPE-INFO >-----#
    ETYPE_INFO = SEQ_OF(name=u'ETYPE-INFO', mode=MODE_TYPE)
    _ETYPE_INFO__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'ETYPE-INFO-ENTRY')))
    ETYPE_INFO._cont = _ETYPE_INFO__item_
    
    #-----< ETYPE-INFO2-ENTRY >-----#
    ETYPE_INFO2_ENTRY = SEQ(name=u'ETYPE-INFO2-ENTRY', mode=MODE_TYPE)
    _ETYPE_INFO2_ENTRY_etype = INT(name=u'etype', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _ETYPE_INFO2_ENTRY_salt = STR_GENE(name=u'salt', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'KerberosString')), opt=True)
    _ETYPE_INFO2_ENTRY_s2kparams = OCT_STR(name=u's2kparams', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ETYPE_INFO2_ENTRY._cont = ASN1Dict([
        (u'etype', _ETYPE_INFO2_ENTRY_etype),
        (u'salt', _ETYPE_INFO2_ENTRY_salt),
        (u's2kparams', _ETYPE_INFO2_ENTRY_s2kparams),
        ])
    ETYPE_INFO2_ENTRY._ext = None
    
    #-----< ETYPE-INFO2 >-----#
    ETYPE_INFO2 = SEQ_OF(name=u'ETYPE-INFO2', mode=MODE_TYPE)
    _ETYPE_INFO2__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'ETYPE-INFO2-ENTRY')))
    ETYPE_INFO2._cont = _ETYPE_INFO2__item_
    ETYPE_INFO2._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AD-IF-RELEVANT >-----#
    AD_IF_RELEVANT = SEQ_OF(name=u'AD-IF-RELEVANT', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'AuthorizationData')))
    
    #-----< AD-KDCIssued >-----#
    AD_KDCIssued = SEQ(name=u'AD-KDCIssued', mode=MODE_TYPE)
    _AD_KDCIssued_ad_checksum = SEQ(name=u'ad-checksum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Checksum')))
    _AD_KDCIssued_i_realm = STR_GENE(name=u'i-realm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Realm')), opt=True)
    _AD_KDCIssued_i_sname = SEQ(name=u'i-sname', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'PrincipalName')), opt=True)
    _AD_KDCIssued_elements = SEQ_OF(name=u'elements', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'AuthorizationData')))
    AD_KDCIssued._cont = ASN1Dict([
        (u'ad-checksum', _AD_KDCIssued_ad_checksum),
        (u'i-realm', _AD_KDCIssued_i_realm),
        (u'i-sname', _AD_KDCIssued_i_sname),
        (u'elements', _AD_KDCIssued_elements),
        ])
    AD_KDCIssued._ext = None
    
    #-----< AD-AND-OR >-----#
    AD_AND_OR = SEQ(name=u'AD-AND-OR', mode=MODE_TYPE)
    _AD_AND_OR_condition_count = INT(name=u'condition-count', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'Int32')))
    _AD_AND_OR_elements = SEQ_OF(name=u'elements', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('KerberosV5Spec2', 'AuthorizationData')))
    AD_AND_OR._cont = ASN1Dict([
        (u'condition-count', _AD_AND_OR_condition_count),
        (u'elements', _AD_AND_OR_elements),
        ])
    AD_AND_OR._ext = None
    
    #-----< AD-MANDATORY-FOR-KDC >-----#
    AD_MANDATORY_FOR_KDC = SEQ_OF(name=u'AD-MANDATORY-FOR-KDC', mode=MODE_TYPE, typeref=ASN1RefType(('KerberosV5Spec2', 'AuthorizationData')))
    
    _all_ = [
        id_krb5,
        Int32,
        UInt32,
        Microseconds,
        KerberosString,
        Realm,
        _PrincipalName_name_type,
        __PrincipalName_name_string__item_,
        _PrincipalName_name_string,
        PrincipalName,
        KerberosTime,
        _HostAddress_addr_type,
        _HostAddress_address,
        HostAddress,
        _HostAddresses__item_,
        HostAddresses,
        __AuthorizationData__item__ad_type,
        __AuthorizationData__item__ad_data,
        _AuthorizationData__item_,
        AuthorizationData,
        _PA_DATA_padata_type,
        _PA_DATA_padata_value,
        PA_DATA,
        KerberosFlags,
        _EncryptedData_etype,
        _EncryptedData_kvno,
        _EncryptedData_cipher,
        EncryptedData,
        _EncryptionKey_keytype,
        _EncryptionKey_keyvalue,
        EncryptionKey,
        _Checksum_cksumtype,
        _Checksum_checksum,
        Checksum,
        _Ticket_tkt_vno,
        _Ticket_realm,
        _Ticket_sname,
        _Ticket_enc_part,
        Ticket,
        _EncTicketPart_flags,
        _EncTicketPart_key,
        _EncTicketPart_crealm,
        _EncTicketPart_cname,
        _EncTicketPart_transited,
        _EncTicketPart_authtime,
        _EncTicketPart_starttime,
        _EncTicketPart_endtime,
        _EncTicketPart_renew_till,
        _EncTicketPart_caddr,
        _EncTicketPart_authorization_data,
        EncTicketPart,
        _TransitedEncoding_tr_type,
        _TransitedEncoding_contents,
        TransitedEncoding,
        TicketFlags,
        AS_REQ,
        TGS_REQ,
        _KDC_REQ_pvno,
        _KDC_REQ_msg_type,
        __KDC_REQ_padata__item_,
        _KDC_REQ_padata,
        _KDC_REQ_req_body,
        KDC_REQ,
        _KDC_REQ_BODY_kdc_options,
        _KDC_REQ_BODY_cname,
        _KDC_REQ_BODY_realm,
        _KDC_REQ_BODY_sname,
        _KDC_REQ_BODY_from_,
        _KDC_REQ_BODY_till,
        _KDC_REQ_BODY_rtime,
        _KDC_REQ_BODY_nonce,
        __KDC_REQ_BODY_etype__item_,
        _KDC_REQ_BODY_etype,
        _KDC_REQ_BODY_addresses,
        _KDC_REQ_BODY_enc_authorization_data,
        __KDC_REQ_BODY_additional_tickets__item_,
        _KDC_REQ_BODY_additional_tickets,
        KDC_REQ_BODY,
        KDCOptions,
        AS_REP,
        TGS_REP,
        _KDC_REP_pvno,
        _KDC_REP_msg_type,
        __KDC_REP_padata__item_,
        _KDC_REP_padata,
        _KDC_REP_crealm,
        _KDC_REP_cname,
        _KDC_REP_ticket,
        _KDC_REP_enc_part,
        KDC_REP,
        EncASRepPart,
        EncTGSRepPart,
        _EncKDCRepPart_key,
        _EncKDCRepPart_last_req,
        _EncKDCRepPart_nonce,
        _EncKDCRepPart_key_expiration,
        _EncKDCRepPart_flags,
        _EncKDCRepPart_authtime,
        _EncKDCRepPart_starttime,
        _EncKDCRepPart_endtime,
        _EncKDCRepPart_renew_till,
        _EncKDCRepPart_srealm,
        _EncKDCRepPart_sname,
        _EncKDCRepPart_caddr,
        EncKDCRepPart,
        __LastReq__item__lr_type,
        __LastReq__item__lr_value,
        _LastReq__item_,
        LastReq,
        _AP_REQ_pvno,
        _AP_REQ_msg_type,
        _AP_REQ_ap_options,
        _AP_REQ_ticket,
        _AP_REQ_authenticator,
        AP_REQ,
        APOptions,
        _Authenticator_authenticator_vno,
        _Authenticator_crealm,
        _Authenticator_cname,
        _Authenticator_cksum,
        _Authenticator_cusec,
        _Authenticator_ctime,
        _Authenticator_subkey,
        _Authenticator_seq_number,
        _Authenticator_authorization_data,
        Authenticator,
        _AP_REP_pvno,
        _AP_REP_msg_type,
        _AP_REP_enc_part,
        AP_REP,
        _EncAPRepPart_ctime,
        _EncAPRepPart_cusec,
        _EncAPRepPart_subkey,
        _EncAPRepPart_seq_number,
        EncAPRepPart,
        _KRB_SAFE_pvno,
        _KRB_SAFE_msg_type,
        _KRB_SAFE_safe_body,
        _KRB_SAFE_cksum,
        KRB_SAFE,
        _KRB_SAFE_BODY_user_data,
        _KRB_SAFE_BODY_timestamp,
        _KRB_SAFE_BODY_usec,
        _KRB_SAFE_BODY_seq_number,
        _KRB_SAFE_BODY_s_address,
        _KRB_SAFE_BODY_r_address,
        KRB_SAFE_BODY,
        _KRB_PRIV_pvno,
        _KRB_PRIV_msg_type,
        _KRB_PRIV_enc_part,
        KRB_PRIV,
        _EncKrbPrivPart_user_data,
        _EncKrbPrivPart_timestamp,
        _EncKrbPrivPart_usec,
        _EncKrbPrivPart_seq_number,
        _EncKrbPrivPart_s_address,
        _EncKrbPrivPart_r_address,
        EncKrbPrivPart,
        _KRB_CRED_pvno,
        _KRB_CRED_msg_type,
        __KRB_CRED_tickets__item_,
        _KRB_CRED_tickets,
        _KRB_CRED_enc_part,
        KRB_CRED,
        __EncKrbCredPart_ticket_info__item_,
        _EncKrbCredPart_ticket_info,
        _EncKrbCredPart_nonce,
        _EncKrbCredPart_timestamp,
        _EncKrbCredPart_usec,
        _EncKrbCredPart_s_address,
        _EncKrbCredPart_r_address,
        EncKrbCredPart,
        _KrbCredInfo_key,
        _KrbCredInfo_prealm,
        _KrbCredInfo_pname,
        _KrbCredInfo_flags,
        _KrbCredInfo_authtime,
        _KrbCredInfo_starttime,
        _KrbCredInfo_endtime,
        _KrbCredInfo_renew_till,
        _KrbCredInfo_srealm,
        _KrbCredInfo_sname,
        _KrbCredInfo_caddr,
        KrbCredInfo,
        _KRB_ERROR_pvno,
        _KRB_ERROR_msg_type,
        _KRB_ERROR_ctime,
        _KRB_ERROR_cusec,
        _KRB_ERROR_stime,
        _KRB_ERROR_susec,
        _KRB_ERROR_error_code,
        _KRB_ERROR_crealm,
        _KRB_ERROR_cname,
        _KRB_ERROR_realm,
        _KRB_ERROR_sname,
        _KRB_ERROR_e_text,
        _KRB_ERROR_e_data,
        KRB_ERROR,
        _METHOD_DATA__item_,
        METHOD_DATA,
        __TYPED_DATA__item__data_type,
        __TYPED_DATA__item__data_value,
        _TYPED_DATA__item_,
        TYPED_DATA,
        PA_ENC_TIMESTAMP,
        _PA_ENC_TS_ENC_patimestamp,
        _PA_ENC_TS_ENC_pausec,
        PA_ENC_TS_ENC,
        _ETYPE_INFO_ENTRY_etype,
        _ETYPE_INFO_ENTRY_salt,
        ETYPE_INFO_ENTRY,
        _ETYPE_INFO__item_,
        ETYPE_INFO,
        _ETYPE_INFO2_ENTRY_etype,
        _ETYPE_INFO2_ENTRY_salt,
        _ETYPE_INFO2_ENTRY_s2kparams,
        ETYPE_INFO2_ENTRY,
        _ETYPE_INFO2__item_,
        ETYPE_INFO2,
        AD_IF_RELEVANT,
        _AD_KDCIssued_ad_checksum,
        _AD_KDCIssued_i_realm,
        _AD_KDCIssued_i_sname,
        _AD_KDCIssued_elements,
        AD_KDCIssued,
        _AD_AND_OR_condition_count,
        _AD_AND_OR_elements,
        AD_AND_OR,
        AD_MANDATORY_FOR_KDC,
    ]

init_modules(KerberosV5Spec2)
