local test_data = {}

test_data.wireless = {
  mesh0 = {
    external = true,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 7445,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 97,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 2367514,
      rx_errors = 0,
      tx_bytes = 564745121,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  mesh1 = {
    external = true,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    xqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 24917085991,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 94311062,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 138182411,
      rx_errors = 0,
      tx_bytes = 151599685066,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  wan = {
    external = false,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    ["link-advertising"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    ["link-partner-advertising"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    ["link-supported"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    speed = "1000F",
    autoneg = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 143754196868,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 138808630,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 94997043,
      rx_errors = 0,
      tx_bytes = 25110735945,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  wlan0 = {
    external = true,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 25967,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 198,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 2367747,
      rx_errors = 0,
      tx_bytes = 531641723,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  wlan1 = {
    external = true,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 0,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 0,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 2367515,
      rx_errors = 0,
      tx_bytes = 531596854,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  }
}

test_data.devices = {
  ["br-lan"] = {
    external = false,
    present = true,
    type = "bridge",
    up = true,
    carrier = true,
    ["bridge-members"] = {"lan1", "lan2", "mesh0", "mesh1", "wan", "wlan0", "wlan1"},
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = true,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 2130506,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 608294869,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 2988694,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 688324,
      rx_errors = 0,
      tx_bytes = 194322964,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  eth0 = {
    external = false,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    ["link-advertising"] = {"1000baseT-F"},
    ["link-partner-advertising"] = {},
    ["link-supported"] = {"1000baseT-F"},
    speed = "1000F",
    autoneg = true,
    mtu = 1504,
    mtu6 = 1504,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = true,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 146274315993,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 138825694,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 95269376,
      rx_errors = 0,
      tx_bytes = 25943790384,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  lan1 = {
    external = false,
    present = false,
    type = "Network device",
    up = true,
    carrier = false,
    ["link-advertising"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    ["link-partner-advertising"] = {},
    ["link-supported"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    speed = "-1F",
    autoneg = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 84054,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 1108,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 263386,
      rx_errors = 0,
      tx_bytes = 60746152,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  lan2 = {
    external = false,
    present = true,
    type = "Network device",
    up = true,
    carrier = false,
    ["link-advertising"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    ["link-partner-advertising"] = {},
    ["link-supported"] = {
      "10baseT-H", "10baseT-F", "100baseT-H", "100baseT-F", "1000baseT-F"
    },
    speed = "-1F",
    autoneg = true,
    mtu = 1500,
    mtu6 = 1500,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = false,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = true,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 0,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 0,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 0,
      rx_errors = 0,
      tx_bytes = 0,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  },
  lo = {
    external = false,
    present = true,
    type = "Network device",
    up = true,
    carrier = true,
    mtu = 65536,
    mtu6 = 65536,
    macaddr = "00:00:00:00:00:00",
    txqueuelen = 1000,
    ipv6 = true,
    promisc = false,
    rpfilter = 0,
    acceptlocal = false,
    igmpversion = 0,
    mldversion = 0,
    neigh4reachabletime = 30000,
    neigh6reachabletime = 30000,
    neigh4gcstaletime = 60,
    neigh6gcstaletime = 60,
    neigh4locktime = 100,
    dadtransmits = 1,
    multicast = false,
    sendredirects = true,
    statistics = {
      collisions = 0,
      rx_frame_errors = 0,
      tx_compressed = 0,
      multicast = 0,
      rx_length_errors = 0,
      tx_dropped = 0,
      rx_bytes = 17830347,
      rx_missed_errors = 0,
      tx_errors = 0,
      rx_compressed = 0,
      rx_over_errors = 0,
      tx_fifo_errors = 0,
      rx_crc_errors = 0,
      rx_packets = 181937,
      tx_heartbeat_errors = 0,
      rx_dropped = 0,
      tx_aborted_errors = 0,
      tx_packets = 181937,
      rx_errors = 0,
      tx_bytes = 17830347,
      tx_window_errors = 0,
      rx_fifo_errors = 0,
      tx_carrier_errors = 0
    }
  }
}

test_data.wlan1_stats = {
  collisions = 0,
  rx_frame_errors = 0,
  tx_compressed = 0,
  multicast = 0,
  rx_length_errors = 0,
  tx_dropped = 0,
  rx_bytes = 0,
  rx_missed_errors = 0,
  tx_errors = 0,
  rx_compressed = 0,
  rx_over_errors = 0,
  tx_fifo_errors = 0,
  rx_crc_errors = 0,
  rx_packets = 0,
  tx_heartbeat_errors = 0,
  rx_dropped = 0,
  tx_aborted_errors = 0,
  tx_packets = 2367515,
  rx_errors = 0,
  tx_bytes = 531596854,
  tx_window_errors = 0,
  rx_fifo_errors = 0,
  tx_carrier_errors = 0
}

return test_data
