--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "coldplay"
version: 18
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Siteimprove' => 'Ad site.',
          'Battle.net site' => 'Website for Battle.net.',
          'Intralinks' => 'A secure collaboration site.',
          'Citrix Online' => 'Citrix Online services, including GoToMyPC, GoToMeeting, GoToWebinar, and GoToTraining.',
          'CCP Games' => 'Video game developer and publisher.',
          'WeChat' => 'Mobile text and voice messaging application.',
          'Yahoo!' => 'Yahoo! and it\'s online services.',
          'Hola' => 'An open source VPN.',
          'SugarCRM' => 'Customer relationship management software company.',
          'Sharepoint Online' => 'Traffic generated by web access for sharepoint Online.',
          'Twitter' => 'Social networking and microblogging site.',
          'Conviva' => 'Ad site.',
          'Net2Phone' => 'A VoIP service.',
          'Plista' => 'Marketing analytics site.',
          'Playstation Games' => 'Playstation game traffic.',
          '050plus' => 'VoIP smartphone app.',
          'Myspace Videos' => 'Videos sharing service by Myspace.',
          'Marketo' => 'Ad site.',
          'YiXin' => 'Instant messaging for chat, file transfer service.',
          'TwitPic' => 'Site for posting and sharing photos and videos on twitter.',
          'GG' => 'Gadu Gadu, a polish instant messaging app.',
          'Demandbase' => 'Advertising and marketing site.',
          'F-Prot' => 'F-Prot Antivirus/Security software download and updates.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_backstreetboys",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

--detectorType(0-> Web, 1->Client),  AppId, SSLPattern
gSSLHostPatternList = {
    --Sharepoint Online
    { 0, 2813, 'sharepoint.microsoftonline.com'},
    { 0, 2813, 'sharepoint.microsoft.com' },
    { 0, 2813, 'sharepoint.com' },
    { 0, 2813, 'sharepointmktgv6.microsoft.com' },
    { 0, 2813, 'sharepointonline.com' },
    { 0, 2813, 'ajax.aspnetcdn.com' },
    { 0, 2813, 'spoprod-a.akamaihd.net' },
    { 0, 2813, 'onenote.com' },
    --Net2Phone
    { 0, 3806, 'net2phone.com'},
    --Playstation Games
    { 0, 3795, 'playstation.net'},
    --050plus
    { 0, 2325, '050plus.com'},
    --GG
    { 0, 3706, 'gg.pl'},
    { 0, 3706, 'gadu-gadu.pl'},
    --YiXin
    { 0, 2914, 'yixin.im'},
    --F-Prot
    { 0, 162, 'f-prot.com'},
    --Demandbase
    { 0, 3890, 'demandbase.com'},
    --Intralinks
    { 0, 3891, 'intralinks.com'},
    --Marketo
    { 0, 3940, 'marketo.com'},
    { 0, 3940, 'marketo.net'},
    --Conviva
    { 0, 3931, 'conviva.com'},
    --Siteimprove
    { 0, 3943, 'siteimprove.com'},
    --Plista
    { 0, 3897, 'plista.com'},
    --Battle.net site
    { 0, 3749, 'battle.net'},
    --Citrix Online
    { 0, 87, 'citrix.com'},
    { 0, 87, 'citrixonline.com'},
    { 0, 87, 'citrixonlinecdn.com'},
    { 0, 87, 'expertcity.com'},
    --WeChat
    { 0, 2618, 'wechat.com'},
    { 0, 2618, 'weixin.qq.com'},
    { 0, 2618, 'qbwup.imtt.qq.com'},
    --Livemeeting
  --  { 0, 265, 'livemeeting.com'},
    --CCP Games
    { 0, 4005, 'ccpgames.com'},
    { 0, 4005, 'ccpgamescdn.com'},
    --Yahoo!
    { 0, 524, 'yahoo.com'},
    { 0, 524, 'yimg.com'},
    --DeNA Comm
    -- { 0, 2945, 'ssl.co-mm.com'},
    --Twitter
    { 0, 882, 'twitter.com'},
    { 0, 882, 'ads-twitter.com'},
    { 0, 882, 'twttr.com'},
    -- TwitPic
    { 0, 1063, 'twimg.com'},
    --Myspace Videos
    { 0, 2833, 'videos.myspacecdn.com'},
    { 0, 2883, 'a1-videos.myspacecdn.com'},
    { 0, 2883, 'a2-videos.myspacecdn.com'},
    { 0, 2883, 'a3-videos.myspacecdn.com'},
    { 0, 2883, 'a4-videos.myspacecdn.com'},
    { 0, 2883, 'l-videos.myspacecdn.com'},
    { 0, 2883, 'l1-videos.myspacecdn.com'},
    { 0, 2883, 'l2-videos.myspacecdn.com'},
    { 0, 2883, 'l3-videos.myspacecdn.com'},
    { 0, 2883, 'l4-videos.myspacecdn.com'},
    --Hola
    { 0, 4041, 'hola.org'},
    { 0, 4041, 'www-holanetworksltd.netdna-ssl.com'},
    { 0, 4041, 'client1-holanetworksltd.netdna-ssl.com'},
    { 0, 4041, 'client2-holanetworksltd.netdna-ssl.com'},
    { 0, 4041, 'client3-holanetworksltd.netdna-ssl.com'},
    { 0, 4041, 'h-cdn.com'},
    { 0, 4041, 'h-infra.com'},
    { 0, 4041, 'h-local.org'},
    { 0, 4041, 'h-vpn.org'},
    { 0, 4041, 'hola-vpn.com'},
    { 0, 4041, 'holacdn.com'},
    { 0, 4041, 'holaspark.com'},
    { 0, 4041, 'holavpn.net'},
    { 0, 4041, 'hypernet.net'},
    { 0, 4041, 'l-cdn.com'},
    { 0, 4041, 'lum-api.io'},
    { 0, 4041, 'lum-bext.com'},
    { 0, 4041, 'lum-cn.co'},
    { 0, 4041, 'lum-cn.io'},
    { 0, 4041, 'lum-ext.io'},
    { 0, 4041, 'lum-infra.com'},
    { 0, 4041, 'lum-int.io'},
    { 0, 4041, 'lum-lpm.com'},
    { 0, 4041, 'lum-sdk.io'},
    { 0, 4041, 'lum-superproxy.io'},
    { 0, 4041, 'luminati-china-mail.co'},
    { 0, 4041, 'luminati-china.biz'},
    { 0, 4041, 'luminati-china.co'},
    { 0, 4041, 'luminati-china.io'},
    { 0, 4041, 'luminati-cn.com'},
    { 0, 4041, 'luminati-gsuit.org'},
    { 0, 4041, 'luminati-io-china.com'},
    { 0, 4041, 'luminati-io-cn.com'},
    { 0, 4041, 'luminatinet.com'},
    { 0, 4041, 'lumtest.com'},
    { 0, 4041, 'scd-cdn.com'},
    { 0, 4041, 'smv-cdn.com'},
    { 0, 4041, 'sparkweb.co'},
    { 0, 4041, 'sparkweb.org'},
    { 0, 4041, 'svd-cdn.com'},
    { 0, 4041, 'testmyproxy.com'},
    { 0, 4041, 'thecodeil.com'},
    { 0, 4041, 'topvpn.io'},
    { 0, 4041, 'whatismyippro.com'},
    { 0, 4041, 'zon-networks.com'},

}
function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end

    return gDetector;
end

function DetectorClean()
end

