--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: iRODS
version: 2
description: Integrated Rule Oriented Data System aiming at flexible data management.
bundle_description: $VAR1 = {
          'iRODS' => 'Integrated Rule Oriented Data System aiming at flexible data management.'
        };

--]]

require "DetectorCommon"



local DC = DetectorCommon
local FT = flowTrackerModule

gServiceId = 20168
gServiceName = 'iRODS'
gDetector = nil

DetectorPackageInfo = {
    name =  "iRODS",
    proto =  DC.ipproto.tcp,
    server = {
        init =  'DetectorInit',
        validate =  'DetectorValidator',
    }
}


gSfAppIdiRODS = 2748

gPatterns = {
	tcpPkt1 = {"\000\000\000\139", 0, gSfAppIdiRODS},
}

gFastPatterns = {
	{DC.ipproto.tcp, gPatterns.tcpPkt1 },
}
--port based detection 
gPorts = {
    {DC.ipproto.tcp, 1247},
}


gAppRegistry = {
	--AppIdValue          Extracts Info
	---------------------------------------
	{gSfAppIdiRODS,		         0}
}

function serviceInProcess(context)

    local flowFlag = context.detectorFlow:getFlowFlag(DC.flowFlags.serviceDetected)

    if ((not flowFlag) or (flowFlag == 0)) then
        gDetector:inProcessService()
    end

    DC.printf('%s: Inprocess, packetCount: %d\n', gServiceName, context.packetCount);
    return DC.serviceStatus.inProcess
end

function serviceSuccess(context)
    local flowFlag = context.detectorFlow:getFlowFlag(DC.flowFlags.serviceDetected)

    if ((not flowFlag) or (flowFlag == 0)) then
        gDetector:addService(gServiceId, "", "", gSfAppIdiRODS)
    end

    DC.printf('%s: Detected, packetCount: %d\n', gServiceName, context.packetCount);
    return DC.serviceStatus.success
end

function serviceFail(context)
    local flowFlag = context.detectorFlow:getFlowFlag(DC.flowFlags.serviceDetected)

    if ((not flowFlag) or (flowFlag == 0)) then
        gDetector:failService()
    end

    context.detectorFlow:clearFlowFlag(DC.flowFlags.continue)
    DC.printf('%s: Failed, packetCount: %d\n', gServiceName, context.packetCount);
    return DC.serviceStatus.nomatch
end

function registerPortsPatterns()

     --register port based detection
    for i,v in ipairs(gPorts) do
        gDetector:addPort(v[1], v[2])
    end

    --register pattern based detection
    for i,v in ipairs(gFastPatterns) do
        if ( gDetector:registerPattern(v[1], v[2][1], #v[2][1], v[2][2], v[2][3]) ~= 0) then
            DC.printf ('%s: register pattern failed for %s\n', gServiceName,v[2][1])
        else
            DC.printf ('%s: register pattern successful for %s\n', gServiceName,v[2][1])
        end
    end

	for i,v in ipairs(gAppRegistry) do
		pcall(function () gDetector:registerAppId(v[1],v[2]) end)
	end

end

function DetectorInit( detectorInstance)

    gDetector = detectorInstance
    DC.printf ('%s:DetectorInit()\n', gServiceName);
    gDetector:init(gServiceName, 'DetectorValidator', 'DetectorFini')
    registerPortsPatterns()

    return gDetector
end

function DetectorValidator()
    local context = {}
    context.detectorFlow = gDetector:getFlow()
    context.packetDataLen = gDetector:getPacketSize()
    context.packetDir = gDetector:getPacketDir()
    context.srcIp = gDetector:getPktSrcAddr()
    context.dstIp = gDetector:getPktDstAddr()
    context.srcPort = gDetector:getPktSrcPort()
    context.dstPort = gDetector:getPktDstPort()
    context.flowKey = context.detectorFlow:getFlowKey()
    context.packetCount = gDetector:getPktCount()
    local size = context.packetDataLen
    local dir = context.packetDir
    local srcPort = context.srcPort
    local dstPort = context.dstPort
    local flowKey = context.flowKey

    DC.printf ('%s:DetectorValidator(): packetCount %d, dir %d, size %d\n', gServiceName,
               context.packetCount, dir, size);

    local rft = FT.getFlowTracker(flowKey)
    if (not rft) then
            rft = FT.addFlowTracker(flowKey, {servicecount=0 })
    end
  
	if (size == 0) then
        return serviceInProcess(context)
    end

	--handling downloading (caught by port only)
	if ((dir == 1) and
		(size >= 4)) then 
        DC.printf ('%s:DetectorValidator(): Inside the dir==1 condition \n', gServiceName);
        if (gDetector:memcmp(gPatterns.tcpPkt1[1], #gPatterns.tcpPkt1[1], gPatterns.tcpPkt1[2]) == 0)	then
            rft.servicecount=1
            DC.printf ('%s:DetectorValidator(): Inside 1st matchingn \n', gServiceName);
            return serviceInProcess(context)
        elseif(rft.servicecount==1 and gDetector:memcmp("<MsgHeader_PI>.<type>RODS_", 25, 0)) then
--        elseif(rft.servicecount==1 and (gDetector:memcmp(gPatterns.tcpPkt2[1], #gPatterns.tcpPkt2[1], gPatterns.tcpPkt2[2]) == 0)) then 
            rft.servicecount=2
            DC.printf ('%s:DetectorValidator(): Inside 2nd matchingn \n', gServiceName);
            return serviceSuccess(context)
        end
    else
       return serviceInProcess(context)
	end

     FT.delFlowTracker(flowKey)
    return serviceFail(context)
end

--[[Required DetectorFini function
--]]
function DetectorFini()
    --print (gServiceName .. ': DetectorFini()')
end

