/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.proxy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.olsr.v1.info.proxy.OlsrdInfoReaderState;

public class OlsrdInfoReader {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String EOL = "\n";
    public static final Pattern PATTERN_HTTP_HEADER = Pattern.compile("^\\s*(HTTP/1.[01]\\s+)(\\d+)\\s+(.+)\\s*$");

    public static int send(Socket socket, String command, int connectionTimeout, int timeout, InetSocketAddress address, List<String> resultList, StringBuilder resultBuilder) throws IOException {
        assert (socket != null);
        assert (command != null);
        assert (!command.isEmpty());
        assert (connectionTimeout >= 0);
        assert (timeout >= 0);
        assert (address != null);
        assert (resultList != null || resultBuilder != null);
        assert (resultList == null || resultBuilder == null);
        if (resultList != null) {
            resultList.clear();
        } else {
            resultBuilder.setLength(0);
        }
        socket.setSoTimeout(timeout);
        try {
            socket.connect(address, connectionTimeout);
        }
        catch (IOException e) {
            return 503;
        }
        int status = 200;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), CHARSET));
             BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), CHARSET));){
            String line;
            writer.write(command);
            writer.newLine();
            writer.flush();
            OlsrdInfoReaderState state = OlsrdInfoReaderState.INIT;
            block35: while ((line = reader.readLine()) != null) {
                switch (state) {
                    case INIT: {
                        if (line.trim().isEmpty()) continue block35;
                        Matcher m = PATTERN_HTTP_HEADER.matcher(line);
                        if (m.matches()) {
                            try {
                                status = Integer.parseInt(m.group(2));
                            }
                            catch (NumberFormatException e) {
                                status = 500;
                            }
                            switch (status) {
                                case 200: {
                                    break;
                                }
                                default: {
                                    if (resultList != null) {
                                        resultList.clear();
                                    } else {
                                        resultBuilder.setLength(0);
                                    }
                                    int n = status;
                                    return n;
                                }
                            }
                            state = OlsrdInfoReaderState.IN_HEADER;
                            continue block35;
                        }
                        state = OlsrdInfoReaderState.IN_CONTENT;
                        break;
                    }
                    case IN_HEADER: {
                        if (!line.trim().isEmpty()) continue block35;
                        state = OlsrdInfoReaderState.IN_CONTENT;
                        continue block35;
                    }
                }
                if (resultList != null) {
                    resultList.add(line);
                    continue;
                }
                resultBuilder.append(line);
                resultBuilder.append(EOL);
            }
        }
        return status;
    }
}

