/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.osgi.impl.bundle.obr.resource.StringSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterImpl {
    final char WILDCARD = (char)65535;
    final int EQ = 0;
    final int LE = 1;
    final int GE = 2;
    final int APPROX = 3;
    final int LESS = 4;
    final int GREATER = 5;
    final int SUBSET = 6;
    final int SUPERSET = 7;
    private String filter;

    public FilterImpl(String filter) throws IllegalArgumentException {
        this.filter = filter;
        if (filter == null || filter.length() == 0) {
            throw new IllegalArgumentException("Null query");
        }
    }

    public boolean match(Map<String, Object> dict) {
        try {
            return new DictQuery(dict).match();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof FilterImpl && this.filter.equals(((FilterImpl)obj).filter);
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    boolean compareString(String s1, int op, String s2) {
        switch (op) {
            case 0: {
                return this.patSubstr(s1, s2);
            }
            case 3: {
                return this.patSubstr(this.fixupString(s1), this.fixupString(s2));
            }
        }
        return this.compareSign(op, s2.compareTo(s1));
    }

    boolean compareSign(int op, int cmp) {
        switch (op) {
            case 1: {
                return cmp >= 0;
            }
            case 2: {
                return cmp <= 0;
            }
            case 0: {
                return cmp == 0;
            }
        }
        return cmp == 0;
    }

    String fixupString(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        boolean isStart = true;
        boolean isWhite = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                isWhite = true;
                continue;
            }
            if (!isStart && isWhite) {
                sb.append(' ');
            }
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
            isStart = false;
            isWhite = false;
        }
        return sb.toString();
    }

    boolean patSubstr(String s, String pat) {
        if (s == null) {
            return false;
        }
        if (pat.length() == 0) {
            return s.length() == 0;
        }
        if (pat.charAt(0) == '\uffff') {
            pat = pat.substring(1);
            while (true) {
                if (this.patSubstr(s, pat)) {
                    return true;
                }
                if (s.length() == 0) {
                    return false;
                }
                s = s.substring(1);
            }
        }
        if (s.length() == 0 || s.charAt(0) != pat.charAt(0)) {
            return false;
        }
        return this.patSubstr(s.substring(1), pat.substring(1));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DictQuery
    extends Query {
        private Map<String, Object> dict;

        DictQuery(Map<String, Object> dict) {
            this.dict = dict;
        }

        @Override
        Object getProp(String key) {
            return this.dict.get(key);
        }
    }

    abstract class Query {
        static final String GARBAGE = "Trailing garbage";
        static final String MALFORMED = "Malformed query";
        static final String EMPTY = "Empty list";
        static final String SUBEXPR = "No subexpression";
        static final String OPERATOR = "Undefined operator";
        static final String TRUNCATED = "Truncated expression";
        static final String EQUALITY = "Only equality supported";
        private String tail;

        Query() {
        }

        boolean match() throws IllegalArgumentException {
            this.tail = FilterImpl.this.filter;
            boolean val = this.doQuery();
            if (this.tail.length() > 0) {
                this.error(GARBAGE);
            }
            return val;
        }

        private boolean doQuery() throws IllegalArgumentException {
            boolean val;
            if (this.tail.length() < 3 || !this.prefix("(")) {
                this.error(MALFORMED);
            }
            switch (this.tail.charAt(0)) {
                case '&': {
                    val = this.doAnd();
                    break;
                }
                case '|': {
                    val = this.doOr();
                    break;
                }
                case '!': {
                    val = this.doNot();
                    break;
                }
                default: {
                    val = this.doSimple();
                }
            }
            if (!this.prefix(")")) {
                this.error(MALFORMED);
            }
            return val;
        }

        private boolean doAnd() throws IllegalArgumentException {
            this.tail = this.tail.substring(1);
            boolean val = true;
            if (!this.tail.startsWith("(")) {
                this.error(EMPTY);
            }
            do {
                if (this.doQuery()) continue;
                val = false;
            } while (this.tail.startsWith("("));
            return val;
        }

        private boolean doOr() throws IllegalArgumentException {
            this.tail = this.tail.substring(1);
            boolean val = false;
            if (!this.tail.startsWith("(")) {
                this.error(EMPTY);
            }
            do {
                if (!this.doQuery()) continue;
                val = true;
            } while (this.tail.startsWith("("));
            return val;
        }

        private boolean doNot() throws IllegalArgumentException {
            this.tail = this.tail.substring(1);
            if (!this.tail.startsWith("(")) {
                this.error(SUBEXPR);
            }
            return !this.doQuery();
        }

        private boolean doSimple() throws IllegalArgumentException {
            int op = 0;
            Object attr = this.getAttr();
            if (this.prefix("=")) {
                op = 0;
            } else if (this.prefix("<=")) {
                op = 1;
            } else if (this.prefix(">=")) {
                op = 2;
            } else if (this.prefix("~=")) {
                op = 3;
            } else if (this.prefix("*>")) {
                op = 7;
            } else if (this.prefix("<*")) {
                op = 6;
            } else if (this.prefix("<")) {
                op = 4;
            } else if (this.prefix(">")) {
                op = 5;
            } else {
                this.error(OPERATOR);
            }
            return this.compare(attr, op, this.getValue());
        }

        private boolean prefix(String pre) {
            if (!this.tail.startsWith(pre)) {
                return false;
            }
            this.tail = this.tail.substring(pre.length());
            return true;
        }

        private Object getAttr() {
            int ix;
            int len = this.tail.length();
            block3: for (ix = 0; ix < len; ++ix) {
                switch (this.tail.charAt(ix)) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': 
                    case '{': 
                    case '}': 
                    case '~': {
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            String attr = this.tail.substring(0, ix).toLowerCase();
            this.tail = this.tail.substring(ix);
            return this.getProp(attr);
        }

        abstract Object getProp(String var1);

        private String getValue() {
            int ix;
            StringBuffer sb = new StringBuffer();
            int len = this.tail.length();
            block5: for (ix = 0; ix < len; ++ix) {
                char c = this.tail.charAt(ix);
                switch (c) {
                    case '(': 
                    case ')': {
                        break block5;
                    }
                    case '*': {
                        sb.append('\uffff');
                        continue block5;
                    }
                    case '\\': {
                        if (ix == len - 1) break block5;
                        sb.append(this.tail.charAt(++ix));
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            this.tail = this.tail.substring(ix);
            return sb.toString();
        }

        private void error(String m) throws IllegalArgumentException {
            throw new IllegalArgumentException(m + " " + this.tail);
        }

        private boolean compare(Object obj, int op, String s) {
            block33: {
                if (obj == null) {
                    if (op == 6) {
                        return true;
                    }
                    if (op == 7) {
                        return s.trim().length() == 0;
                    }
                    return false;
                }
                try {
                    Class<?> numClass = obj.getClass();
                    if (numClass == String.class) {
                        return FilterImpl.this.compareString((String)obj, op, s);
                    }
                    if (numClass == Character.class) {
                        return FilterImpl.this.compareString(obj.toString(), op, s);
                    }
                    if (numClass == Long.class) {
                        return FilterImpl.this.compareSign(op, Long.valueOf(s).compareTo((Long)obj));
                    }
                    if (numClass == Integer.class) {
                        return FilterImpl.this.compareSign(op, Integer.valueOf(s).compareTo((Integer)obj));
                    }
                    if (numClass == Short.class) {
                        return FilterImpl.this.compareSign(op, Short.valueOf(s).compareTo((Short)obj));
                    }
                    if (numClass == Byte.class) {
                        return FilterImpl.this.compareSign(op, Byte.valueOf(s).compareTo((Byte)obj));
                    }
                    if (numClass == Double.class) {
                        return FilterImpl.this.compareSign(op, Double.valueOf(s).compareTo((Double)obj));
                    }
                    if (numClass == Float.class) {
                        return FilterImpl.this.compareSign(op, Float.valueOf(s).compareTo((Float)obj));
                    }
                    if (numClass == Boolean.class) {
                        if (op != 0) {
                            return false;
                        }
                        int a = Boolean.valueOf(s) != false ? 1 : 0;
                        int b = (Boolean)obj != false ? 1 : 0;
                        return FilterImpl.this.compareSign(op, a - b);
                    }
                    if (numClass == BigInteger.class) {
                        return FilterImpl.this.compareSign(op, new BigInteger(s).compareTo((BigInteger)obj));
                    }
                    if (obj instanceof Collection) {
                        if (op == 6 || op == 7) {
                            StringSet set = new StringSet(s);
                            if (op == 6) {
                                return set.containsAll((Collection)obj);
                            }
                            return ((Collection)obj).containsAll(set);
                        }
                        for (Object element : (Collection)obj) {
                            if (!this.compare(element, op, s)) continue;
                            return true;
                        }
                        break block33;
                    }
                    if (numClass.isArray()) {
                        int len = Array.getLength(obj);
                        for (int i = 0; i < len; ++i) {
                            if (!this.compare(Array.get(obj, i), op, s)) continue;
                            return true;
                        }
                        break block33;
                    }
                    try {
                        if (op == 7 || op == 6) {
                            StringSet set = new StringSet(s);
                            if (op == 7) {
                                return set.contains(obj);
                            }
                            return set.size() == 0 || set.size() == 1 && ((String)set.iterator().next()).equals(obj);
                        }
                        Constructor<?> constructor = numClass.getConstructor(String.class);
                        Object instance = constructor.newInstance(s);
                        switch (op) {
                            case 0: {
                                return obj.equals(instance);
                            }
                            case 4: {
                                return ((Comparable)obj).compareTo(instance) < 0;
                            }
                            case 5: {
                                return ((Comparable)obj).compareTo(instance) > 0;
                            }
                            case 1: {
                                return ((Comparable)obj).compareTo(instance) <= 0;
                            }
                            case 2: {
                                return ((Comparable)obj).compareTo(instance) >= 0;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

