/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImplComparator;
import org.osgi.impl.bundle.obr.resource.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexer {
    private String repositoryName = "Untitled";
    private boolean verbose = false;
    private String urlTemplate = null;
    private URL licenseURL = null;
    private String stylesheet = "http://www.osgi.org/www/obr2html.xsl";
    private URL rootURL = null;
    private RepositoryImpl repository = null;
    private File repositoryFile = null;

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public void setLicenseURL(String licenseURL) throws MalformedURLException {
        this.licenseURL = new URL(licenseURL);
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setRootURL(URL rootURL) {
        this.rootURL = rootURL;
    }

    public void setRootURL(String rootURL) throws MalformedURLException {
        this.rootURL = new URL(rootURL);
    }

    public URL getRootURL() {
        return this.rootURL;
    }

    public void setRepository(RepositoryImpl repository) {
        this.repository = repository;
    }

    public void setRepositoryFile(File repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public Tag doIndex(Collection<ResourceImpl> resources) {
        Tag repository = new Tag("repository");
        repository.addAttribute("lastmodified", new Date());
        repository.addAttribute("name", this.repositoryName);
        for (ResourceImpl resource : resources) {
            repository.addContent(resource.toXML());
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(List<File> fileList) throws Exception {
        Tag tag;
        block15: {
            if (this.repositoryFile == null && !this.verbose) {
                return;
            }
            HashSet<ResourceImpl> resources = new HashSet<ResourceImpl>();
            if (this.rootURL == null) {
                this.rootURL = new File("").getAbsoluteFile().toURI().toURL();
            }
            this.repository = new RepositoryImpl(this.rootURL);
            for (File file : fileList) {
                this.recurse(resources, file);
            }
            ArrayList<ResourceImpl> sorted = new ArrayList<ResourceImpl>(resources);
            Collections.sort(sorted, new ResourceImplComparator());
            tag = this.doIndex(sorted);
            if (this.repositoryFile != null) {
                ByteArrayOutputStream out = null;
                PrintWriter pw = null;
                FileOutputStream fout = null;
                try {
                    out = new ByteArrayOutputStream();
                    pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    this.printXmlHeader(pw);
                    tag.print(0, pw);
                    pw.print("\n");
                    pw.close();
                    byte[] buffer = out.toByteArray();
                    fout = new FileOutputStream(this.repositoryFile);
                    if (this.repositoryFile.getName().endsWith(".zip")) {
                        ZipOutputStream zip = new ZipOutputStream(fout);
                        try {
                            this.addToZip(zip, "repository.xml", buffer);
                            break block15;
                        }
                        finally {
                            zip.close();
                        }
                    }
                    fout.write(buffer);
                }
                finally {
                    if (fout != null) {
                        fout.close();
                    }
                    if (pw != null) {
                        pw.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
        if (this.verbose) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
            this.printXmlHeader(pw);
            tag.print(0, pw);
            pw.print("\n");
            pw.close();
        }
    }

    public void printXmlHeader(PrintWriter pw) {
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.println("<?xml-stylesheet type='text/xsl' href='" + this.stylesheet + "'?>");
        if (this.licenseURL != null) {
            pw.println("<!--\n  License: " + ((Object)this.licenseURL).toString() + "\n-->");
        }
    }

    public void recurse(Set<ResourceImpl> resources, File path) throws Exception {
        if (path.isDirectory()) {
            for (String pathEntry : path.list()) {
                this.recurse(resources, new File(path, pathEntry));
            }
        } else {
            BundleInfo info = null;
            try {
                info = new BundleInfo(this.repository, path);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (info != null) {
                ResourceImpl resource = info.build();
                if (this.urlTemplate != null) {
                    this.doTemplate(path, resource);
                } else {
                    resource.setURL(path.toURI().toURL());
                }
                resources.add(resource);
            }
        }
    }

    public void printCopyright(PrintStream out) {
        out.println("Bundle Indexer | v3.0");
        out.println("(c) 2007 OSGi, All Rights Reserved");
    }

    private void doTemplate(File path, ResourceImpl resource) throws MalformedURLException {
        String dir = ((Object)path.getParentFile().getAbsoluteFile().toURI().toURL()).toString();
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir.startsWith(((Object)this.rootURL).toString())) {
            dir = dir.substring(((Object)this.rootURL).toString().length());
        }
        String url = this.urlTemplate.replaceAll("%v", "" + resource.getVersion());
        url = url.replaceAll("%s", resource.getSymbolicName());
        url = url.replaceAll("%f", path.getName());
        url = url.replaceAll("%p", dir);
        resource.setURL(new URL(url));
    }

    private void addToZip(ZipOutputStream zip, String name, byte[] buffer) throws IOException {
        CRC32 checksum = new CRC32();
        checksum.update(buffer);
        ZipEntry ze = new ZipEntry(name);
        ze.setSize(buffer.length);
        ze.setCrc(checksum.getValue());
        zip.putNextEntry(ze);
        zip.write(buffer, 0, buffer.length);
        zip.closeEntry();
    }
}

