/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoConfigLinkQuality
implements Comparable<JsonInfoConfigLinkQuality> {
    private int level = 0;
    private boolean fishEye = false;
    private double aging = 0.0;
    private String algorithm = "";

    public int getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    public void setLevel(int level) {
        this.level = level;
    }

    public boolean getFishEye() {
        return this.fishEye;
    }

    @JsonProperty(value="fishEye")
    public void setFishEye(boolean fishEye) {
        this.fishEye = fishEye;
    }

    public double getAging() {
        return this.aging;
    }

    @JsonProperty(value="aging")
    public void setAging(double aging) {
        this.aging = aging;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm == null ? "" : algorithm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.level;
        result = 31 * result + (this.fishEye ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.aging);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.algorithm.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoConfigLinkQuality)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoConfigLinkQuality other) {
        if (other == null) {
            return -1;
        }
        int result = this.algorithm.compareTo(other.algorithm);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Integer.compare(this.level, other.level);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.aging, other.aging);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.fishEye, other.fishEye);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoConfigLinkQuality [level=");
        builder.append(this.level);
        builder.append(", fishEye=");
        builder.append(this.fishEye);
        builder.append(", aging=");
        builder.append(this.aging);
        builder.append(", algorithm=");
        builder.append(this.algorithm);
        builder.append("]");
        return builder.toString();
    }
}

