#!/usr/bin/env python
# Author: Jon Trulson <jtrulson@ics.com>
# Copyright (c) 2015 Intel Corporation.
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

from __future__ import print_function
import time, sys, signal, atexit
from upm import pyupm_sm130 as sensorObj

def main():
    # Instantiate a UART based SM130 RFID Module using defaults
    sensor = sensorObj.SM130()

    ## Exit handlers ##
    # This stops python from printing a stacktrace when you hit control-C
    def SIGINTHandler(signum, frame):
        raise SystemExit

    # This function lets you run code on exit
    def exitHandler():
        print("Exiting")
        sys.exit(0)

    # Register exit handlers
    atexit.register(exitHandler)
    signal.signal(signal.SIGINT, SIGINTHandler)

    # Set the baud rate, 19200 baud is the default.
    if (sensor.setBaudRate(19200)):
        print("Failed to set baud rate")
        sys.exit(0)

    print("Resetting...")
    sensor.reset()

    print("Firmware revision: " + sensor.getFirmwareVersion())

    print("Waiting up to 5 seconds for a tag...")

    if (sensor.waitForTag(5000)):
        print("Found tag, UID:", end=' ')
        print(sensor.string2HexString(sensor.getUID()))
        print("Tag Type:", end=' ')
        print(sensor.tag2String(sensor.getTagType()))
    else:
        # error
        print("waitForTag failed: " + sensor.getLastErrorString())

if __name__ == '__main__':
    main()
