/*
 * Author: Stefan Andritoiu <stefan.andritoiu@intel.com>
 * Copyright (c) 2015 Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

public class OTP538U_Example {
	private static final float OTP538U_AREF = 5;

	public static void main(String[] args) throws InterruptedException {
		// ! [Interesting]
		// Instantiate a OTP538U on analog pins A0 and A1
		// A0 is used for the Ambient Temperature and A1 is used for the Object
		// temperature.
		upm_otp538u.OTP538U temps = new upm_otp538u.OTP538U(0, 1, OTP538U_AREF);

		while (true) {
			System.out.println("Ambient temp: " + temps.ambientTemperature() + " C");
			System.out.println("Object temp: " + temps.objectTemperature() + " C");

			Thread.sleep(1000);
		}
		// ! [Interesting]
	}
}