/*   FILE: state.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 01 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

abstract class State : GLib.Object {
	protected unowned LCDPlayer player;

	// Print selected item.
	public abstract void print_selected ();

	// Stop playback.
	public void stop () {
		if (player.stateStack.peek() is StatePlay) {
			player.stateStack.pop();
		}
		player.stop();
		player.stateStack.peek ().print_selected ();
	}

	// Toggle between playing and paused.
	public void pauseplay () {
		player.pauseplay();
	}

	// Seek backwards.
	public abstract void seekback ();

	// Seek forward.
	public abstract void seekforward ();

	// Select next menu item.
	public abstract void next ();

	// Select previous menu item.
	public abstract void previous ();

	// Transition to next state, based on current selection.
	public abstract State transition ();
}
