/* state-play.c generated by valac 0.38.7, the Vala compiler
 * generated from state-play.vala, do not modify */

/*   FILE: state-play.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 01 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * stop:        stop currently playing, clear playlist, and pop state.
 * pauseplay:   pause if playing else transition from paused to playing.
 * seekback:    move one track back on the playlist.
 * seekforward: move one track forward on the playlist.
 * next:        scan forward in currently playing song.
 * previous:    scan back in currently playing song.
 * transition:  no operation.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <grilo.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
typedef struct _StatePrivate StatePrivate;

#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;

#define TYPE_STATE_PLAY (state_play_get_type ())
#define STATE_PLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_PLAY, StatePlay))
#define STATE_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_PLAY, StatePlayClass))
#define IS_STATE_PLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_PLAY))
#define IS_STATE_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_PLAY))
#define STATE_PLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_PLAY, StatePlayClass))

typedef struct _StatePlay StatePlay;
typedef struct _StatePlayClass StatePlayClass;
typedef struct _StatePlayPrivate StatePlayPrivate;
enum  {
	STATE_PLAY_0_PROPERTY,
	STATE_PLAY_NUM_PROPERTIES
};
static GParamSpec* state_play_properties[STATE_PLAY_NUM_PROPERTIES];
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

#define TYPE_INPUT_OUTPUT (input_output_get_type ())
#define INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_OUTPUT, InputOutput))
#define INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_OUTPUT, InputOutputClass))
#define IS_INPUT_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_OUTPUT))
#define IS_INPUT_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_OUTPUT))
#define INPUT_OUTPUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_OUTPUT, InputOutputClass))

typedef struct _InputOutput InputOutput;
typedef struct _InputOutputClass InputOutputClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _State {
	GObject parent_instance;
	StatePrivate * priv;
	LCDPlayer* player;
};

struct _StateClass {
	GObjectClass parent_class;
	void (*print_selected) (State* self);
	void (*seekback) (State* self);
	void (*seekforward) (State* self);
	void (*next) (State* self);
	void (*previous) (State* self);
	State* (*transition) (State* self);
};

struct _StatePlay {
	State parent_instance;
	StatePlayPrivate * priv;
};

struct _StatePlayClass {
	StateClass parent_class;
};

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
	GeeArrayList* playlist;
	InputOutput* io;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};


static gpointer state_play_parent_class = NULL;

#define SCAN_JUMP_SECONDS ((gint64) 5)
#define FORWARD TRUE
#define BACKWARD FALSE
GType state_get_type (void) G_GNUC_CONST;
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType state_play_get_type (void) G_GNUC_CONST;
StatePlay* state_play_new (LCDPlayer* player);
StatePlay* state_play_construct (GType object_type, LCDPlayer* player);
State* state_construct (GType object_type);
gboolean lcd_player_play (LCDPlayer* self);
static gboolean _lcd_player_play_gsource_func (gpointer self);
static void state_play_real_print_selected (State* base);
GType input_output_get_type (void) G_GNUC_CONST;
void input_output_output (InputOutput* self, const gchar* str);
gchar* lcd_player_current_title (LCDPlayer* self);
static void state_play_real_seekback (State* base);
void lcd_player_backward (LCDPlayer* self);
static void state_play_real_seekforward (State* base);
void lcd_player_forward (LCDPlayer* self);
static void state_play_real_next (State* base);
static gint64 state_play_seek (StatePlay* self, gboolean forward);
static void state_play_real_previous (State* base);
static State* state_play_real_transition (State* base);
gint64 lcd_player_seek (LCDPlayer* self, gboolean forward);


static gboolean _lcd_player_play_gsource_func (gpointer self) {
	gboolean result;
	result = lcd_player_play ((LCDPlayer*) self);
	return result;
}


StatePlay* state_play_construct (GType object_type, LCDPlayer* player) {
	StatePlay * self = NULL;
	LCDPlayer* _tmp0_;
	LCDPlayer* _tmp1_;
	g_return_val_if_fail (player != NULL, NULL);
	self = (StatePlay*) state_construct (object_type);
	_tmp0_ = player;
	((State*) self)->player = _tmp0_;
	_tmp1_ = player;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _lcd_player_play_gsource_func, lcd_player_ref (_tmp1_), lcd_player_unref);
	return self;
}


StatePlay* state_play_new (LCDPlayer* player) {
	return state_play_construct (TYPE_STATE_PLAY, player);
}


static void state_play_real_print_selected (State* base) {
	StatePlay * self;
	LCDPlayer* _tmp0_;
	InputOutput* _tmp1_;
	LCDPlayer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = (StatePlay*) base;
	_tmp0_ = ((State*) self)->player;
	_tmp1_ = _tmp0_->io;
	_tmp2_ = ((State*) self)->player;
	_tmp3_ = lcd_player_current_title (_tmp2_);
	_tmp4_ = _tmp3_;
	input_output_output (_tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


static void state_play_real_seekback (State* base) {
	StatePlay * self;
	LCDPlayer* _tmp0_;
	LCDPlayer* _tmp1_;
	LCDPlayer* _tmp2_;
	InputOutput* _tmp3_;
	LCDPlayer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (StatePlay*) base;
	_tmp0_ = ((State*) self)->player;
	lcd_player_backward (_tmp0_);
	_tmp1_ = ((State*) self)->player;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _lcd_player_play_gsource_func, lcd_player_ref (_tmp1_), lcd_player_unref);
	_tmp2_ = ((State*) self)->player;
	_tmp3_ = _tmp2_->io;
	_tmp4_ = ((State*) self)->player;
	_tmp5_ = lcd_player_current_title (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("Playing ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	input_output_output (_tmp3_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void state_play_real_seekforward (State* base) {
	StatePlay * self;
	LCDPlayer* _tmp0_;
	LCDPlayer* _tmp1_;
	LCDPlayer* _tmp2_;
	InputOutput* _tmp3_;
	LCDPlayer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (StatePlay*) base;
	_tmp0_ = ((State*) self)->player;
	lcd_player_forward (_tmp0_);
	_tmp1_ = ((State*) self)->player;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _lcd_player_play_gsource_func, lcd_player_ref (_tmp1_), lcd_player_unref);
	_tmp2_ = ((State*) self)->player;
	_tmp3_ = _tmp2_->io;
	_tmp4_ = ((State*) self)->player;
	_tmp5_ = lcd_player_current_title (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("Playing ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	input_output_output (_tmp3_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void state_play_real_next (State* base) {
	StatePlay * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gint64 position = 0LL;
	gint64 _tmp1_;
	LCDPlayer* _tmp2_;
	InputOutput* _tmp3_;
	const gchar* _tmp4_;
	self = (StatePlay*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = state_play_seek (self, FORWARD);
	position = _tmp1_;
	g_string_printf (builder, "%" G_GINT64_FORMAT ":%.2" G_GINT64_FORMAT, position / (GST_SECOND * 60), (position / GST_SECOND) % 60);
	_tmp2_ = ((State*) self)->player;
	_tmp3_ = _tmp2_->io;
	_tmp4_ = builder->str;
	input_output_output (_tmp3_, _tmp4_);
	_g_string_free0 (builder);
}


static void state_play_real_previous (State* base) {
	StatePlay * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gint64 position = 0LL;
	gint64 _tmp1_;
	LCDPlayer* _tmp2_;
	InputOutput* _tmp3_;
	const gchar* _tmp4_;
	self = (StatePlay*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = state_play_seek (self, BACKWARD);
	position = _tmp1_;
	g_string_printf (builder, "%" G_GINT64_FORMAT ":%.2" G_GINT64_FORMAT, position / (GST_SECOND * 60), (position / GST_SECOND) % 60);
	_tmp2_ = ((State*) self)->player;
	_tmp3_ = _tmp2_->io;
	_tmp4_ = builder->str;
	input_output_output (_tmp3_, _tmp4_);
	_g_string_free0 (builder);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static State* state_play_real_transition (State* base) {
	StatePlay * self;
	State* result = NULL;
	LCDPlayer* _tmp0_;
	State* _tmp1_;
	self = (StatePlay*) base;
	_tmp0_ = ((State*) self)->player;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _lcd_player_play_gsource_func, lcd_player_ref (_tmp0_), lcd_player_unref);
	_tmp1_ = _g_object_ref0 ((State*) self);
	result = _tmp1_;
	return result;
}


static gint64 state_play_seek (StatePlay* self, gboolean forward) {
	gint64 result = 0LL;
	LCDPlayer* _tmp0_;
	gboolean _tmp1_;
	gint64 _tmp2_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = ((State*) self)->player;
	_tmp1_ = forward;
	_tmp2_ = lcd_player_seek (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void state_play_class_init (StatePlayClass * klass) {
	state_play_parent_class = g_type_class_peek_parent (klass);
	((StateClass *) klass)->print_selected = (void (*) (State *)) state_play_real_print_selected;
	((StateClass *) klass)->seekback = (void (*) (State *)) state_play_real_seekback;
	((StateClass *) klass)->seekforward = (void (*) (State *)) state_play_real_seekforward;
	((StateClass *) klass)->next = (void (*) (State *)) state_play_real_next;
	((StateClass *) klass)->previous = (void (*) (State *)) state_play_real_previous;
	((StateClass *) klass)->transition = (State* (*) (State *)) state_play_real_transition;
}


static void state_play_instance_init (StatePlay * self) {
}


GType state_play_get_type (void) {
	static volatile gsize state_play_type_id__volatile = 0;
	if (g_once_init_enter (&state_play_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatePlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_play_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatePlay), 0, (GInstanceInitFunc) state_play_instance_init, NULL };
		GType state_play_type_id;
		state_play_type_id = g_type_register_static (TYPE_STATE, "StatePlay", &g_define_type_info, 0);
		g_once_init_leave (&state_play_type_id__volatile, state_play_type_id);
	}
	return state_play_type_id__volatile;
}



